/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.AirspaceRenderer;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AirspaceLayer
extends AbstractLayer {
    private final Collection<Airspace> airspaces = new ConcurrentLinkedQueue<Airspace>();
    private Iterable<Airspace> airspacesOverride;
    private AirspaceRenderer airspaceRenderer = new AirspaceRenderer();

    public void addAirspace(Airspace airspace) {
        if (airspace == null) {
            String string = "nullValue.AirspaceIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.airspacesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.airspaces.add(airspace);
    }

    public void addAirspaces(Iterable<Airspace> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.airspacesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        for (Airspace airspace : iterable) {
            if (airspace == null) continue;
            this.airspaces.add(airspace);
        }
    }

    public void removeAirspace(Airspace airspace) {
        if (airspace == null) {
            String string = "nullValue.AirspaceIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.airspacesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.airspaces.remove(airspace);
    }

    public void removeAllAirspaces() {
        if (this.airspacesOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.clearAirspaces();
    }

    private void clearAirspaces() {
        if (this.airspaces != null && this.airspaces.size() > 0) {
            this.airspaces.clear();
        }
    }

    public Iterable<Airspace> getAirspaces() {
        if (this.airspacesOverride != null) {
            return this.airspacesOverride;
        }
        return Collections.unmodifiableCollection(this.airspaces);
    }

    private Iterable<Airspace> getActiveAirspaces() {
        if (this.airspacesOverride != null) {
            return this.airspacesOverride;
        }
        return this.airspaces;
    }

    public void setAirspaces(Iterable<Airspace> iterable) {
        this.airspacesOverride = iterable;
        this.clearAirspaces();
    }

    public boolean isEnableBlending() {
        return this.airspaceRenderer.isEnableBlending();
    }

    public void setEnableBlending(boolean bl) {
        this.airspaceRenderer.setEnableBlending(bl);
    }

    public boolean isEnableLighting() {
        return this.airspaceRenderer.isEnableLighting();
    }

    public void setEnableLighting(boolean bl) {
        this.airspaceRenderer.setEnableLighting(bl);
    }

    public boolean isDrawExtents() {
        return this.airspaceRenderer.isDrawExtents();
    }

    public void setDrawExtents(boolean bl) {
        this.airspaceRenderer.setDrawExtents(bl);
    }

    public boolean isDrawWireframe() {
        return this.airspaceRenderer.isDrawWireframe();
    }

    public void setDrawWireframe(boolean bl) {
        this.airspaceRenderer.setDrawWireframe(bl);
    }

    public Material getLightMaterial() {
        return this.airspaceRenderer.getLightMaterial();
    }

    public void setLightMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.airspaceRenderer.setLightMaterial(material);
    }

    public Vec4 getLightDirection() {
        return this.airspaceRenderer.getLightDirection();
    }

    public void setLightDirection(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.DirectionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.airspaceRenderer.setLightDirection(vec4);
    }

    protected AirspaceRenderer getRenderer() {
        return this.airspaceRenderer;
    }

    @Override
    protected void doPick(DrawContext drawContext, Point point) {
        this.airspaceRenderer.pick(drawContext, this.getActiveAirspaces(), point, this);
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        this.airspaceRenderer.render(drawContext, this.getActiveAirspaces());
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.AirspaceLayer.Name");
    }
}

