/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationRenderer;
import gov.nasa.worldwind.render.BasicAnnotationRenderer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationLayer
extends AbstractLayer {
    private final Collection<Annotation> annotations = new ConcurrentLinkedQueue<Annotation>();
    private Iterable<Annotation> annotationsOverride;
    private AnnotationRenderer annotationRenderer = new BasicAnnotationRenderer();

    public void addAnnotation(Annotation annotation) {
        if (annotation == null) {
            String string = Logging.getMessage("nullValue.AnnotationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.annotationsOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.annotations.add(annotation);
    }

    public void addAnnotations(Iterable<Annotation> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.annotationsOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        for (Annotation annotation : iterable) {
            if (annotation == null) continue;
            this.annotations.add(annotation);
        }
    }

    public void removeAnnotation(Annotation annotation) {
        if (annotation == null) {
            String string = Logging.getMessage("nullValue.IconIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.annotationsOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.annotations.remove(annotation);
    }

    public void removeAllAnnotations() {
        if (this.annotationsOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.clearAnnotations();
    }

    private void clearAnnotations() {
        if (this.annotations != null && this.annotations.size() > 0) {
            this.annotations.clear();
        }
    }

    public Iterable<Annotation> getAnnotations() {
        return this.getActiveAnnotations();
    }

    private Iterable<Annotation> getActiveAnnotations() {
        if (this.annotationsOverride != null) {
            return this.annotationsOverride;
        }
        return Collections.unmodifiableCollection(this.annotations);
    }

    public void setAnnotations(Iterable<Annotation> iterable) {
        this.annotationsOverride = iterable;
        this.clearAnnotations();
    }

    @Override
    public void setOpacity(double d) {
        super.setOpacity(d);
    }

    @Override
    public double getOpacity() {
        return super.getOpacity();
    }

    public AnnotationRenderer getAnnotationRenderer() {
        return this.annotationRenderer;
    }

    public void setAnnotationRenderer(AnnotationRenderer annotationRenderer) {
        if (annotationRenderer == null) {
            String string = Logging.getMessage("nullValue.AnnotationRendererIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.annotationRenderer = annotationRenderer;
    }

    @Override
    protected void doPick(DrawContext drawContext, Point point) {
        this.annotationRenderer.pick(drawContext, this.getActiveAnnotations(), point, this);
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        this.annotationRenderer.render(drawContext, this.getActiveAnnotations());
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.AnnotationLayer.Name");
    }
}

