/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.formats.dds.DDSCompressor;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.TextureTile;
import gov.nasa.worldwind.layers.TiledImageLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.retrieve.BulkRetrievable;
import gov.nasa.worldwind.retrieve.BulkRetrievalThread;
import gov.nasa.worldwind.retrieve.HTTPRetriever;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.RetrievalService;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.retrieve.URLRetriever;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTiledImageLayer
extends TiledImageLayer
implements BulkRetrievable {
    private final Object fileLock = new Object();
    private AVList creationParams;
    private long averageTileSize = -1L;

    public BasicTiledImageLayer(LevelSet levelSet) {
        super(levelSet);
    }

    public BasicTiledImageLayer(AVList aVList) {
        this(new LevelSet(aVList));
        this.setValue("gov.nasa.worldwind.avkey.ConstructionParameters", aVList);
        this.creationParams = aVList.copy();
    }

    public BasicTiledImageLayer(String string) {
        this(BasicTiledImageLayer.xmlStateToParams(string));
        RestorableSupport.StateObject[] stateObjectArray;
        RestorableSupport.StateObject stateObject;
        String string2;
        Double d;
        RestorableSupport restorableSupport;
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        Boolean bl = restorableSupport.getStateValueAsBoolean("Layer.Enabled");
        if (bl != null) {
            this.setEnabled(bl);
        }
        if ((d = restorableSupport.getStateValueAsDouble("Layer.Opacity")) != null) {
            this.setOpacity(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble("Layer.MinActiveAltitude")) != null) {
            this.setMinActiveAltitude(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble("Layer.MaxActiveAltitude")) != null) {
            this.setMaxActiveAltitude(d);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean("Layer.NetworkRetrievalEnabled")) != null) {
            this.setNetworkRetrievalEnabled(bl);
        }
        if ((string2 = restorableSupport.getStateValueAsString("Layer.Name")) != null) {
            this.setName(string2);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean("TiledImageLayer.UseMipMaps")) != null) {
            this.setUseMipMaps(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean("TiledImageLayer.UseTransparentTextures")) != null) {
            this.setUseTransparentTextures(bl);
        }
        if ((stateObject = restorableSupport.getStateObject("avlist")) != null && (stateObjectArray = restorableSupport.getAllStateObjects(stateObject, "")) != null) {
            for (RestorableSupport.StateObject stateObject2 : stateObjectArray) {
                if (stateObject2 == null) continue;
                this.setValue(stateObject2.getName(), stateObject2.getValue());
            }
        }
    }

    protected static AVList xmlStateToParams(String string) {
        Sector sector;
        LatLon latLon;
        Long l;
        Integer n;
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        AVListImpl aVListImpl = new AVListImpl();
        String string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.DataCacheNameKey");
        if (string4 != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.ServiceURLKey")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.DatasetNameKey")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.FormatSuffixKey")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", string4);
        }
        if ((n = restorableSupport.getStateValueAsInteger("gov.nasa.worldwind.avkey.NumEmptyLevels")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger("gov.nasa.worldwind.avkey.NumLevels")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger("gov.nasa.worldwind.avkey.TileWidthKey")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger("gov.nasa.worldwind.avkey.TileHeightKey")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", n);
        }
        if ((l = restorableSupport.getStateValueAsLong("gov.nasa.worldwind.avkey.ExpiryTime")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.ExpiryTime", l);
        }
        if ((latLon = restorableSupport.getStateValueAsLatLon("gov.nasa.worldwind.avkey.LevelZeroTileDelta")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", latLon);
        }
        if ((latLon = restorableSupport.getStateValueAsLatLon("gov.nasa.worldwind.avkey.TileOrigin")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.TileOrigin", latLon);
        }
        if ((sector = restorableSupport.getStateValueAsSector("gov.nasa.worldwind.avKey.Sector")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        }
        return aVListImpl;
    }

    private RestorableSupport makeRestorableState(AVList aVList) {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        if (restorableSupport == null) {
            return null;
        }
        for (Map.Entry<String, Object> entry : aVList.getEntries()) {
            if (entry.getValue() == null) continue;
            if (entry.getValue() instanceof LatLon) {
                restorableSupport.addStateValueAsLatLon(entry.getKey(), (LatLon)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Sector) {
                restorableSupport.addStateValueAsSector(entry.getKey(), (Sector)entry.getValue());
                continue;
            }
            restorableSupport.addStateValueAsString(entry.getKey(), entry.getValue().toString());
        }
        restorableSupport.addStateValueAsBoolean("Layer.Enabled", this.isEnabled());
        restorableSupport.addStateValueAsDouble("Layer.Opacity", this.getOpacity());
        restorableSupport.addStateValueAsDouble("Layer.MinActiveAltitude", this.getMinActiveAltitude());
        restorableSupport.addStateValueAsDouble("Layer.MaxActiveAltitude", this.getMaxActiveAltitude());
        restorableSupport.addStateValueAsBoolean("Layer.NetworkRetrievalEnabled", this.isNetworkRetrievalEnabled());
        restorableSupport.addStateValueAsString("Layer.Name", this.getName());
        restorableSupport.addStateValueAsBoolean("TiledImageLayer.UseMipMaps", this.isUseMipMaps());
        restorableSupport.addStateValueAsBoolean("TiledImageLayer.UseTransparentTextures", this.isUseTransparentTextures());
        RestorableSupport.StateObject stateObject = restorableSupport.addStateObject("avlist");
        for (Map.Entry entry : this.getEntries()) {
            if (entry.getValue() == null || ((String)entry.getKey()).equals("gov.nasa.worldwind.avkey.ConstructionParameters")) continue;
            restorableSupport.addStateValueAsString(stateObject, (String)entry.getKey(), entry.getValue().toString());
        }
        return restorableSupport;
    }

    @Override
    public String getRestorableState() {
        if (this.creationParams == null) {
            return null;
        }
        return this.makeRestorableState(this.creationParams).getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        String string2 = Logging.getMessage("RestorableSupport.RestoreRequiresConstructor");
        Logging.logger().severe(string2);
        throw new UnsupportedOperationException(string2);
    }

    @Override
    protected void forceTextureLoad(TextureTile textureTile) {
        URL uRL = WorldWind.getDataFileStore().findFile(textureTile.getPath(), true);
        if (uRL != null && !this.isTextureExpired(textureTile, uRL)) {
            this.loadTexture(textureTile, uRL);
        }
    }

    @Override
    protected void requestTexture(DrawContext drawContext, TextureTile textureTile) {
        Vec4 vec4 = textureTile.getCentroidPoint(drawContext.getGlobe());
        if (this.getReferencePoint() != null) {
            textureTile.setPriority(vec4.distanceTo3(this.getReferencePoint()));
        }
        RequestTask requestTask = new RequestTask(textureTile, this);
        this.getRequestQ().add(requestTask);
    }

    private boolean isTextureExpired(TextureTile textureTile, URL uRL) {
        if (!WWIO.isFileOutOfDate(uRL, textureTile.getLevel().getExpiryTime())) {
            return false;
        }
        WorldWind.getDataFileStore().removeFile(uRL);
        String string = Logging.getMessage("generic.DataFileExpired", uRL);
        Logging.logger().fine(string);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadTexture(TextureTile textureTile, URL uRL) {
        TextureData textureData;
        Object object = this.fileLock;
        synchronized (object) {
            textureData = BasicTiledImageLayer.readTexture(uRL, this.isUseMipMaps());
        }
        if (textureData == null) {
            return false;
        }
        textureTile.setTextureData(textureData);
        if (textureTile.getLevelNumber() != 0 || !this.isRetainLevelZeroTiles()) {
            this.addTileToCache(textureTile);
        }
        return true;
    }

    private static TextureData readTexture(URL uRL, boolean bl) {
        try {
            return TextureIO.newTextureData(uRL, bl, null);
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, "layers.TextureLayer.ExceptionAttemptingToReadTextureFile", exception);
            return null;
        }
    }

    private void addTileToCache(TextureTile textureTile) {
        TextureTile.getMemoryCache().add(textureTile.getTileKey(), textureTile);
    }

    @Override
    public BulkRetrievalThread makeLocal(Sector sector, double d) {
        BulkTileDownloadThread bulkTileDownloadThread = new BulkTileDownloadThread(this, sector, d);
        bulkTileDownloadThread.setDaemon(true);
        bulkTileDownloadThread.start();
        return bulkTileDownloadThread;
    }

    @Override
    public long getEstimatedMissingDataSize(Sector sector, double d) {
        int n = this.computeLevelForResolution(sector, d);
        int n2 = 0;
        for (int i = 0; i <= n; ++i) {
            if (this.getLevels().isLevelEmpty(i)) continue;
            n2 += this.countImagesInSector(sector, i);
        }
        Sector[] sectorArray = this.computeRegions(sector, n, 36);
        int n3 = 6;
        int n4 = 0;
        int n5 = 0;
        try {
            if (sectorArray.length <= n3) {
                n5 = this.countImagesInSector(sector, n);
                n4 = this.getMissingTilesInSector(sector, n).size();
            } else {
                Random random = new Random();
                while (n3 > 0) {
                    int n6 = random.nextInt(sectorArray.length);
                    Sector sector2 = sectorArray[n6];
                    if (sector2 == null) continue;
                    n5 += this.countImagesInSector(sector2, n);
                    n4 += this.getMissingTilesInSector(sector2, n).size();
                    sectorArray[n6] = null;
                    --n3;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            return 0L;
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionDuringDataSizeEstimate", this.getName());
            Logging.logger().severe(string);
            throw new RuntimeException(string);
        }
        int n7 = n2 * n4 / n5;
        long l = this.estimateAverageTileSize();
        return (long)n7 * l;
    }

    private long estimateAverageTileSize() {
        if (this.averageTileSize != -1L) {
            return this.averageTileSize;
        }
        long l = 0L;
        int n = 0;
        gov.nasa.worldwind.util.Level level = this.getLevels().getFirstLevel();
        while (level.isEmpty() && !level.equals(this.getLevels().getLastLevel())) {
            level = this.getLevels().getLevel(level.getLevelNumber() + 1);
        }
        File file = new File(WorldWind.getDataFileStore().getWriteLocation(), level.getPath());
        if (file.exists()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            })) {
                long l2 = BasicTiledImageLayer.computeAverageTileSize(file2);
                if (l2 > 0L) {
                    l += l2;
                    ++n;
                }
                if (n >= 2) break;
            }
        }
        this.averageTileSize = n > 0 ? l / (long)n : 0L;
        return this.averageTileSize;
    }

    private static long computeAverageTileSize(File file) {
        File[] fileArray;
        long l = 0L;
        int n = 0;
        for (File file2 : fileArray = file.listFiles()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                l += (long)fileInputStream.available();
                fileInputStream.close();
                ++n;
            }
            catch (IOException iOException) {
                n += 0;
            }
        }
        return n > 0 ? l / (long)n : 0L;
    }

    private ArrayList<TextureTile> getMissingTilesInSector(Sector sector, int n) throws InterruptedException {
        TextureTile[][] textureTileArray;
        ArrayList<TextureTile> arrayList = new ArrayList<TextureTile>();
        TextureTile[][] textureTileArray2 = textureTileArray = this.getTilesInSector(sector, n);
        int n2 = textureTileArray2.length;
        for (int i = 0; i < n2; ++i) {
            TextureTile[] textureTileArray3;
            for (TextureTile textureTile : textureTileArray3 = textureTileArray2[i]) {
                Thread.sleep(1L);
                if (textureTile == null || this.isTileLocalOrAbsent(textureTile)) continue;
                arrayList.add(textureTile);
            }
        }
        return arrayList;
    }

    private Sector[] computeRegions(Sector sector, int n, int n2) {
        int n3 = this.countImagesInSector(sector, n);
        if (n3 <= n2) {
            return new Sector[]{sector};
        }
        int n4 = (int)Math.ceil(Math.sqrt((float)n3 / (float)n2));
        return sector.subdivide(n4);
    }

    private boolean isTileLocalOrAbsent(TextureTile textureTile) {
        if (this.getLevels().isResourceAbsent(textureTile)) {
            return true;
        }
        URL uRL = WorldWind.getDataFileStore().findFile(textureTile.getPath(), false);
        return uRL != null;
    }

    protected void downloadTexture(TextureTile textureTile) {
        this.downloadTexture(textureTile, null);
    }

    protected void downloadTexture(TextureTile textureTile, DownloadPostProcessor downloadPostProcessor) {
        Integer n;
        Integer n2;
        URL uRL;
        if (!this.isNetworkRetrievalEnabled()) {
            this.getLevels().markResourceAbsent(textureTile);
            return;
        }
        if (!WorldWind.getRetrievalService().isAvailable()) {
            return;
        }
        try {
            uRL = textureTile.getResourceURL();
            if (uRL == null) {
                return;
            }
            if (WorldWind.getNetworkStatus().isHostUnavailable(uRL)) {
                this.getLevels().markResourceAbsent(textureTile);
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("layers.TextureLayer.ExceptionCreatingTextureUrl", textureTile), malformedURLException);
            return;
        }
        if ("http".equalsIgnoreCase(uRL.getProtocol()) || "https".equalsIgnoreCase(uRL.getProtocol())) {
            if (downloadPostProcessor == null) {
                downloadPostProcessor = new DownloadPostProcessor(textureTile, this);
            }
        } else {
            Logging.logger().severe(Logging.getMessage("layers.TextureLayer.UnknownRetrievalProtocol", uRL.toString()));
            return;
        }
        HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, downloadPostProcessor);
        Integer n3 = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.URLConnectTimeout");
        if (n3 != null && n3 > 0) {
            hTTPRetriever.setConnectTimeout(n3);
        }
        if ((n2 = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.URLReadTimeout")) != null && n2 > 0) {
            hTTPRetriever.setReadTimeout(n2);
        }
        if ((n = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit")) != null && n > 0) {
            hTTPRetriever.setStaleRequestLimit(n);
        }
        WorldWind.getRetrievalService().runRetriever(hTTPRetriever, textureTile.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBuffer(ByteBuffer byteBuffer, File file) throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            WWIO.saveBuffer(byteBuffer, file);
        }
    }

    private static class DownloadPostProcessor
    implements RetrievalPostProcessor {
        protected final TextureTile tile;
        protected final BasicTiledImageLayer layer;

        public DownloadPostProcessor(TextureTile textureTile, BasicTiledImageLayer basicTiledImageLayer) {
            this.tile = textureTile;
            this.layer = basicTiledImageLayer;
        }

        public ByteBuffer run(Retriever retriever) {
            if (retriever == null) {
                String string = Logging.getMessage("nullValue.RetrieverIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            try {
                Object object;
                if (!retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                    if (retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusError")) {
                        this.layer.getLevels().markResourceAbsent(this.tile);
                    }
                    return null;
                }
                URLRetriever uRLRetriever = (URLRetriever)retriever;
                ByteBuffer byteBuffer = uRLRetriever.getBuffer();
                if (retriever instanceof HTTPRetriever) {
                    object = (HTTPRetriever)retriever;
                    if (((HTTPRetriever)object).getResponseCode() == 204) {
                        this.layer.getLevels().markResourceAbsent(this.tile);
                        return null;
                    }
                    if (((HTTPRetriever)object).getResponseCode() != 200) {
                        this.layer.getLevels().markResourceAbsent(this.tile);
                        return null;
                    }
                }
                if ((object = WorldWind.getDataFileStore().newFile(this.tile.getPath())) == null) {
                    return null;
                }
                if (((File)object).exists()) {
                    return byteBuffer;
                }
                if (byteBuffer != null) {
                    String string = uRLRetriever.getContentType();
                    if (string == null) {
                        return null;
                    }
                    if (string.contains("xml") || string.contains("html") || string.contains("text")) {
                        this.layer.getLevels().markResourceAbsent(this.tile);
                        StringBuffer stringBuffer = new StringBuffer();
                        while (byteBuffer.hasRemaining()) {
                            stringBuffer.append((char)byteBuffer.get());
                        }
                        Logging.logger().severe(stringBuffer.toString());
                        return null;
                    }
                    if (string.contains("dds")) {
                        this.layer.saveBuffer(byteBuffer, (File)object);
                    } else if (string.contains("zip")) {
                        this.layer.saveBuffer(byteBuffer, (File)object);
                    } else if (((File)object).getName().endsWith(".dds")) {
                        if ((byteBuffer = DDSCompressor.compressImageBuffer(byteBuffer)) != null) {
                            this.layer.saveBuffer(byteBuffer, (File)object);
                        }
                    } else if (string.contains("image")) {
                        this.layer.saveBuffer(byteBuffer, (File)object);
                    }
                    if (byteBuffer != null) {
                        this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                    }
                    return byteBuffer;
                }
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                Logging.logger().log(Level.FINE, Logging.getMessage("generic.OperationCancelled", "tiled image retrieval"), closedByInterruptException);
            }
            catch (IOException iOException) {
                this.layer.getLevels().markResourceAbsent(this.tile);
                Logging.logger().log(Level.SEVERE, Logging.getMessage("layers.TextureLayer.ExceptionSavingRetrievedTextureFile", this.tile.getPath()), iOException);
            }
            return null;
        }
    }

    private class BulkTileDownloadThread
    extends BulkRetrievalThread {
        private int MAX_TILE_COUNT_PER_REGION;
        private final BasicTiledImageLayer layer;
        private final int level;
        private ArrayList<TextureTile> missingTiles;

        public BulkTileDownloadThread(BasicTiledImageLayer basicTiledImageLayer2, Sector sector, double d) {
            super(basicTiledImageLayer2, sector, d);
            this.MAX_TILE_COUNT_PER_REGION = 200;
            this.layer = basicTiledImageLayer2;
            this.level = BasicTiledImageLayer.this.computeLevelForResolution(sector, d);
        }

        public void run() {
            try {
                this.progress.setTotalCount(this.countMissingTiles());
                this.progress.setTotalSize((long)this.progress.getTotalCount() * BasicTiledImageLayer.this.estimateAverageTileSize());
                for (int i = 0; i <= this.level; ++i) {
                    Sector[] sectorArray;
                    if (this.layer.getLevels().isLevelEmpty(i)) continue;
                    for (Sector sector : sectorArray = BasicTiledImageLayer.this.computeRegions(this.sector, i, this.MAX_TILE_COUNT_PER_REGION)) {
                        this.missingTiles = BasicTiledImageLayer.this.getMissingTilesInSector(sector, i);
                        while (this.missingTiles.size() > 0) {
                            this.submitMissingTilesRequests();
                            if (this.missingTiles.size() <= 0) continue;
                            Thread.sleep(this.RETRIEVAL_SERVICE_POLL_DELAY);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                String string = Logging.getMessage("generic.BulkRetrievalInterrupted", this.layer.getName());
                Logging.logger().log(Level.WARNING, string, interruptedException);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionDuringBulkRetrieval", this.layer.getName());
                Logging.logger().severe(string);
                throw new RuntimeException(string);
            }
        }

        private int countMissingTiles() throws InterruptedException {
            int n = 0;
            for (int i = 0; i <= this.level; ++i) {
                if (this.layer.getLevels().isLevelEmpty(i)) continue;
                n += BasicTiledImageLayer.this.getMissingTilesInSector(this.sector, i).size();
            }
            return n;
        }

        private synchronized void submitMissingTilesRequests() throws InterruptedException {
            RetrievalService retrievalService = WorldWind.getRetrievalService();
            int n = 0;
            while (this.missingTiles.size() > n && retrievalService.isAvailable()) {
                Thread.sleep(1L);
                TextureTile textureTile = this.missingTiles.get(n);
                if (BasicTiledImageLayer.this.getLevels().isResourceAbsent(textureTile)) {
                    this.removeAbsentTile(textureTile);
                    continue;
                }
                URL uRL = WorldWind.getDataFileStore().findFile(textureTile.getPath(), false);
                if (uRL != null) {
                    this.removeRetrievedTile(textureTile);
                    continue;
                }
                BasicTiledImageLayer.this.downloadTexture(textureTile, new BulkDownloadPostProcessor(textureTile, this.layer));
                ++n;
            }
        }

        private synchronized void removeRetrievedTile(TextureTile textureTile) {
            this.missingTiles.remove(textureTile);
            this.progress.setCurrentCount(this.progress.getCurrentCount() + 1);
            this.progress.setCurrentSize(this.progress.getCurrentSize() + BasicTiledImageLayer.this.estimateAverageTileSize());
            this.progress.setLastUpdateTime(System.currentTimeMillis());
        }

        private synchronized void removeAbsentTile(TextureTile textureTile) {
            this.missingTiles.remove(textureTile);
            this.progress.setTotalCount(this.progress.getTotalCount() - 1);
            this.progress.setTotalSize(this.progress.getTotalSize() - BasicTiledImageLayer.this.estimateAverageTileSize());
            this.progress.setLastUpdateTime(System.currentTimeMillis());
        }

        private class BulkDownloadPostProcessor
        extends DownloadPostProcessor {
            public BulkDownloadPostProcessor(TextureTile textureTile, BasicTiledImageLayer basicTiledImageLayer) {
                super(textureTile, basicTiledImageLayer);
            }

            public ByteBuffer run(Retriever retriever) {
                ByteBuffer byteBuffer = super.run(retriever);
                if (byteBuffer != null) {
                    BulkTileDownloadThread.this.removeRetrievedTile(this.tile);
                }
                return byteBuffer;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestTask
    implements Runnable,
    Comparable<RequestTask> {
        private final BasicTiledImageLayer layer;
        private final TextureTile tile;

        private RequestTask(TextureTile textureTile, BasicTiledImageLayer basicTiledImageLayer) {
            this.layer = basicTiledImageLayer;
            this.tile = textureTile;
        }

        @Override
        public void run() {
            URL uRL = WorldWind.getDataFileStore().findFile(this.tile.getPath(), false);
            if (uRL != null && !this.layer.isTextureExpired(this.tile, uRL)) {
                if (this.layer.loadTexture(this.tile, uRL)) {
                    this.layer.getLevels().unmarkResourceAbsent(this.tile);
                    this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                    return;
                }
                WorldWind.getDataFileStore().removeFile(uRL);
                this.layer.getLevels().markResourceAbsent(this.tile);
                String string = Logging.getMessage("generic.DeletedCorruptDataFile", uRL);
                Logging.logger().info(string);
            }
            this.layer.downloadTexture(this.tile);
        }

        @Override
        public int compareTo(RequestTask requestTask) {
            if (requestTask == null) {
                String string = Logging.getMessage("nullValue.RequestTaskIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.tile.getPriority() == requestTask.tile.getPriority() ? 0 : (this.tile.getPriority() < requestTask.tile.getPriority() ? -1 : 1);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            return !(this.tile == null ? requestTask.tile != null : !this.tile.equals(requestTask.tile));
        }

        public int hashCode() {
            return this.tile != null ? this.tile.hashCode() : 0;
        }

        public String toString() {
            return this.tile.toString();
        }
    }
}

