/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.placename.PlaceNameLayer;
import gov.nasa.worldwind.layers.placename.PlaceNameService;
import gov.nasa.worldwind.layers.placename.PlaceNameServiceSet;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Font;
import java.util.GregorianCalendar;

public class EarthNASAPlaceNameLayer
extends PlaceNameLayer {
    public EarthNASAPlaceNameLayer() {
        super(EarthNASAPlaceNameLayer.makePlaceNameServiceSet());
    }

    private static PlaceNameServiceSet makePlaceNameServiceSet() {
        PlaceNameServiceSet placeNameServiceSet = new PlaceNameServiceSet();
        placeNameServiceSet.setExpiryTime(new GregorianCalendar(2008, 1, 11).getTimeInMillis());
        PlaceNameService placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_oceans", "Earth/PlaceNames/EarthPlaceNames", Sector.FULL_SPHERE, GRID_1x1, Font.decode("Arial-BOLDITALIC-12"), false);
        placeNameService.setColor(new Color(200, 200, 200));
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(3.3554432E7);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_continents", "Earth/PlaceNames/EarthPlaceNames", Sector.FULL_SPHERE, GRID_1x1, Font.decode("Arial-BOLD-12"), false);
        placeNameService.setColor(new Color(255, 255, 240));
        placeNameService.setMinDisplayDistance(524288.0);
        placeNameService.setMaxDisplayDistance(3.3554432E7);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_waterbodies", "Earth/PlaceNames/EarthPlaceNames", Sector.FULL_SPHERE, GRID_4x8, Font.decode("Arial-ITALIC-10"), false);
        placeNameService.setColor(Color.cyan);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(1.6777216E7);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_trenchesridges", "Earth/PlaceNames/EarthPlaceNames", Sector.FULL_SPHERE, GRID_4x8, Font.decode("Arial-BOLDITALIC-10"), false);
        placeNameService.setColor(Color.cyan);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(1.6777216E7);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_desertsplains", "Earth/PlaceNames/EarthPlaceNames", Sector.FULL_SPHERE, GRID_4x8, Font.decode("Arial-BOLDITALIC-10"), false);
        placeNameService.setColor(Color.orange);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(1.6777216E7);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_lakesrivers", "Earth/PlaceNames/EarthPlaceNames", Sector.FULL_SPHERE, GRID_8x16, Font.decode("Arial-ITALIC-10"), false);
        placeNameService.setColor(Color.cyan);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(8388608.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_mountainsvalleys", "Earth/PlaceNames/EarthPlaceNames", Sector.FULL_SPHERE, GRID_8x16, Font.decode("Arial-BOLDITALIC-10"), false);
        placeNameService.setColor(Color.orange);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(8388608.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:countries", "Earth/PlaceNames/EarthPlaceNames", Sector.FULL_SPHERE, GRID_4x8, Font.decode("Arial-BOLD-10"), false);
        placeNameService.setColor(Color.white);
        placeNameService.setMinDisplayDistance(524288.0);
        placeNameService.setMaxDisplayDistance(4194304.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_geonet_p_pplc", "Earth/PlaceNames/EarthPlaceNames", Sector.FULL_SPHERE, GRID_8x16, Font.decode("Arial-BOLD-10"), false);
        placeNameService.setColor(Color.yellow);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(4194304.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_uscitiesover500k", "Earth/PlaceNames/EarthPlaceNames", Sector.FULL_SPHERE, GRID_8x16, Font.decode("Arial-BOLD-10"), false);
        placeNameService.setColor(Color.yellow);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(4194304.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_uscitiesover100k", "Earth/PlaceNames/EarthPlaceNames", Sector.FULL_SPHERE, GRID_8x16, Font.decode("Arial-PLAIN-10"), false);
        placeNameService.setColor(Color.yellow);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(1048576.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_uscitiesover50k", "Earth/PlaceNames/EarthPlaceNames", Sector.FULL_SPHERE, GRID_8x16, Font.decode("Arial-PLAIN-10"), false);
        placeNameService.setColor(Color.yellow);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(131072.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_uscitiesover10k", "Earth/PlaceNames/EarthPlaceNames", Sector.FULL_SPHERE, GRID_8x16, Font.decode("Arial-PLAIN-10"), false);
        placeNameService.setColor(Color.yellow);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(65536.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_uscitiesover1k", "Earth/PlaceNames/EarthPlaceNames", Sector.FULL_SPHERE, GRID_16x32, Font.decode("Arial-PLAIN-10"), false);
        placeNameService.setColor(Color.yellow);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(32768.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_uscitiesover0", "Earth/PlaceNames/EarthPlaceNames", Sector.FULL_SPHERE, GRID_16x32, Font.decode("Arial-PLAIN-10"), false);
        placeNameService.setColor(Color.yellow);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(16384.0);
        placeNameServiceSet.addService(placeNameService, false);
        placeNameService = new PlaceNameService("http://worldwind25.arc.nasa.gov/geoservercache/geoservercache.aspx", "topp:wpl_uscities0", "Earth/PlaceNames/EarthPlaceNames", Sector.FULL_SPHERE, GRID_288x576, Font.decode("Arial-PLAIN-10"), false);
        placeNameService.setColor(Color.yellow);
        placeNameService.setMinDisplayDistance(0.0);
        placeNameService.setMaxDisplayDistance(8192.0);
        placeNameServiceSet.addService(placeNameService, false);
        return placeNameServiceSet;
    }

    public String toString() {
        return Logging.getMessage("layers.Earth.PlaceName.Name");
    }
}

