/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.geom.coords.MGRSCoord;
import gov.nasa.worldwind.geom.coords.UPSCoord;
import gov.nasa.worldwind.geom.coords.UTMCoord;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Earth.GraticuleRenderingParams;
import gov.nasa.worldwind.layers.Earth.UTMGraticuleLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.UserFacingText;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MGRSGraticuleLayer
extends UTMGraticuleLayer {
    public static final String GRATICULE_UTM_GRID = "Graticule.UTM.Grid";
    public static final String GRATICULE_100000M = "Graticule.100000m";
    public static final String GRATICULE_10000M = "Graticule.10000m";
    public static final String GRATICULE_1000M = "Graticule.1000m";
    public static final String GRATICULE_100M = "Graticule.100m";
    public static final String GRATICULE_10M = "Graticule.10m";
    public static final String GRATICULE_1M = "Graticule.1m";
    private GridZone[][] gridZones = new GridZone[20][60];
    private GridZone[] poleZones = new GridZone[4];
    private double zoneMaxAltitude = 5000000.0;
    private double squareMaxAltitude = 3000000.0;
    private MetricScaleSupport metricScaleSupport = new MetricScaleSupport();
    private int renderablesCount = 0;
    private int visibleCellsCount = 0;
    private long frameCount = 0L;
    private double polylineTerrainConformance = 50.0;
    private Frustum viewFrustum;
    private Vec4 lastEyePoint;
    private double lastViewHeading = 0.0;
    private double lastViewPitch = 0.0;
    private double lastViewFOV = 0.0;
    private double lastVerticalExaggeration = 1.0;
    private Globe globe;

    public MGRSGraticuleLayer() {
        this.initRenderingParams();
        this.setName(Logging.getMessage("layers.Earth.MGRSGraticule.Name"));
    }

    public String getMaximumGraticuleResolution() {
        String[] stringArray;
        String string = null;
        for (String string2 : stringArray = this.getOrderedTypes()) {
            GraticuleRenderingParams graticuleRenderingParams = this.getRenderingParams(string2);
            if (!graticuleRenderingParams.isDrawLines()) continue;
            string = string2;
        }
        return string;
    }

    public void setMaximumGraticuleResolution(String string) {
        String[] stringArray;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        boolean bl = false;
        for (String string3 : stringArray = this.getOrderedTypes()) {
            GraticuleRenderingParams graticuleRenderingParams = this.getRenderingParams(string3);
            graticuleRenderingParams.setDrawLines(!bl);
            graticuleRenderingParams.setDrawLabels(!bl);
            if (bl || !string3.equals(string)) continue;
            bl = true;
        }
    }

    public Color getGraticuleLineColor(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).getLineColor();
    }

    public void setGraticuleLineColor(Color color, String string) {
        if (color == null) {
            String string2 = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.getRenderingParams(string).setLineColor(color);
    }

    public void setGraticuleLineColor(Color color, Iterable<String> iterable) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : iterable) {
            this.setGraticuleLineColor(color, string);
        }
    }

    @Override
    public void setGraticuleLineColor(Color color) {
        String[] stringArray;
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : stringArray = this.getOrderedTypes()) {
            this.setGraticuleLineColor(color, string);
        }
    }

    public double getGraticuleLineWidth(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).getLineWidth();
    }

    public void setGraticuleLineWidth(double d, String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.getRenderingParams(string).setLineWidth(d);
    }

    public void setGraticuleLineWidth(double d, Iterable<String> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : iterable) {
            this.setGraticuleLineWidth(d, string);
        }
    }

    @Override
    public void setGraticuleLineWidth(double d) {
        String[] stringArray;
        for (String string : stringArray = this.getOrderedTypes()) {
            this.setGraticuleLineWidth(d, string);
        }
    }

    public String getGraticuleLineStyle(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).getLineStyle();
    }

    public void setGraticuleLineStyle(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.getRenderingParams(string2).setLineStyle(string);
    }

    public void setGraticuleLineStyle(String string, Iterable<String> iterable) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (iterable == null) {
            String string3 = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        for (String string4 : iterable) {
            this.setGraticuleLineStyle(string, string4);
        }
    }

    @Override
    public void setGraticuleLineStyle(String string) {
        String[] stringArray;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        for (String string3 : stringArray = this.getOrderedTypes()) {
            this.setGraticuleLineStyle(string, string3);
        }
    }

    public boolean isDrawLabels(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).isDrawLabels();
    }

    public void setDrawLabels(boolean bl, String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.getRenderingParams(string).setDrawLabels(bl);
    }

    public void setDrawLabels(boolean bl, Iterable<String> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : iterable) {
            this.setDrawLabels(bl, string);
        }
    }

    @Override
    public void setDrawLabels(boolean bl) {
        String[] stringArray;
        for (String string : stringArray = this.getOrderedTypes()) {
            this.setDrawLabels(bl, string);
        }
    }

    public Color getLabelColor(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).getLabelColor();
    }

    public void setLabelColor(Color color, String string) {
        if (color == null) {
            String string2 = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.getRenderingParams(string).setLabelColor(color);
    }

    public void setLabelColor(Color color, Iterable<String> iterable) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : iterable) {
            this.setLabelColor(color, string);
        }
    }

    @Override
    public void setLabelColor(Color color) {
        String[] stringArray;
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : stringArray = this.getOrderedTypes()) {
            this.setLabelColor(color, string);
        }
    }

    public Font getLabelFont(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.getRenderingParams(string).getLabelFont();
    }

    public void setLabelFont(Font font, String string) {
        if (font == null) {
            String string2 = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.getRenderingParams(string).setLabelFont(font);
    }

    public void setLabelFont(Font font, Iterable<String> iterable) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : iterable) {
            this.setLabelFont(font, string);
        }
    }

    @Override
    public void setLabelFont(Font font) {
        String[] stringArray;
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : stringArray = this.getOrderedTypes()) {
            this.setLabelFont(font, string);
        }
    }

    private void initRenderingParams() {
        GraticuleRenderingParams graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", Color.YELLOW);
        graticuleRenderingParams.setValue("LabelColor", Color.YELLOW);
        graticuleRenderingParams.setValue("LabelFont", Font.decode("Arial-Bold-16"));
        this.setRenderingParams(GRATICULE_UTM_GRID, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", Color.GREEN);
        graticuleRenderingParams.setValue("LabelColor", Color.GREEN);
        graticuleRenderingParams.setValue("LabelFont", Font.decode("Arial-Bold-14"));
        this.setRenderingParams(GRATICULE_100000M, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(0, 102, 255));
        graticuleRenderingParams.setValue("LabelColor", new Color(0, 102, 255));
        this.setRenderingParams(GRATICULE_10000M, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", Color.CYAN);
        graticuleRenderingParams.setValue("LabelColor", Color.CYAN);
        this.setRenderingParams(GRATICULE_1000M, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(0, 153, 153));
        graticuleRenderingParams.setValue("LabelColor", new Color(0, 153, 153));
        this.setRenderingParams(GRATICULE_100M, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(102, 255, 204));
        graticuleRenderingParams.setValue("LabelColor", new Color(102, 255, 204));
        this.setRenderingParams(GRATICULE_10M, graticuleRenderingParams);
        graticuleRenderingParams = new GraticuleRenderingParams();
        graticuleRenderingParams.setValue("GraticuleLineColor", new Color(153, 153, 255));
        graticuleRenderingParams.setValue("LabelColor", new Color(153, 153, 255));
        this.setRenderingParams(GRATICULE_1M, graticuleRenderingParams);
    }

    private String[] getOrderedTypes() {
        return new String[]{GRATICULE_UTM_GRID, GRATICULE_100000M, GRATICULE_10000M, GRATICULE_1000M, GRATICULE_100M, GRATICULE_10M, GRATICULE_1M};
    }

    private String getTypeFor(int n) {
        String string = null;
        switch (n) {
            case 100000: {
                string = GRATICULE_100000M;
                break;
            }
            case 10000: {
                string = GRATICULE_10000M;
                break;
            }
            case 1000: {
                string = GRATICULE_1000M;
                break;
            }
            case 100: {
                string = GRATICULE_100M;
                break;
            }
            case 10: {
                string = GRATICULE_10M;
                break;
            }
            case 1: {
                string = GRATICULE_1M;
            }
        }
        return string;
    }

    @Override
    public void doRender(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.needsToUpdate(drawContext)) {
            this.clear(drawContext);
            Sector sector = this.computeVisibleSector(drawContext);
            if (drawContext.getView().getEyePosition().getElevation() <= this.zoneMaxAltitude) {
                this.selectMGRSRenderables(drawContext, sector);
                this.metricScaleSupport.selectRenderables(drawContext);
            } else {
                super.selectUTMRenderables(drawContext);
            }
        }
        super.renderGraticule(drawContext);
    }

    protected boolean needsToUpdate(DrawContext drawContext) {
        if (this.lastEyePoint == null) {
            return true;
        }
        View view = drawContext.getView();
        double d = this.computeAltitudeAboveGround(drawContext);
        if (view.getEyePoint().distanceTo3(this.lastEyePoint) > d / 100.0) {
            return true;
        }
        if (this.lastVerticalExaggeration != drawContext.getVerticalExaggeration()) {
            return true;
        }
        if (view instanceof OrbitView) {
            if (Math.abs(this.lastViewHeading - ((OrbitView)view).getHeading().degrees) > 1.0) {
                return true;
            }
            if (Math.abs(this.lastViewPitch - ((OrbitView)view).getPitch().degrees) > 1.0) {
                return true;
            }
        }
        return Math.abs(this.lastViewFOV - view.getFieldOfView().degrees) > 1.0;
    }

    protected void clear(DrawContext drawContext) {
        this.removeAllRenderables();
        this.renderablesCount = 0;
        this.visibleCellsCount = 0;
        ++this.frameCount;
        this.polylineTerrainConformance = this.computeTerrainConformance(drawContext);
        this.applyTerrainConformance();
        this.viewFrustum = drawContext.getView().getFrustumInModelCoordinates();
        this.lastEyePoint = drawContext.getView().getEyePoint();
        this.lastViewFOV = drawContext.getView().getFieldOfView().degrees;
        if (drawContext.getView() instanceof OrbitView) {
            this.lastViewHeading = ((OrbitView)drawContext.getView()).getHeading().degrees;
            this.lastViewPitch = ((OrbitView)drawContext.getView()).getPitch().degrees;
        }
        this.lastVerticalExaggeration = drawContext.getVerticalExaggeration();
        this.globe = drawContext.getGlobe();
        this.metricScaleSupport.clear();
        this.metricScaleSupport.computeZone(drawContext);
    }

    private void applyTerrainConformance() {
        String[] stringArray;
        for (String string : stringArray = this.getOrderedTypes()) {
            this.getRenderingParams(string).setValue("GraticuleLineConformance", this.polylineTerrainConformance);
        }
    }

    protected double computeTerrainConformance(DrawContext drawContext) {
        int n = 100;
        double d = drawContext.getView().getEyePosition().getElevation();
        if (d < 10000.0) {
            n = 20;
        } else if (d < 50000.0) {
            n = 30;
        } else if (d < 100000.0) {
            n = 40;
        } else if (d < 1000000.0) {
            n = 60;
        }
        return n;
    }

    protected Sector computeVisibleSector(DrawContext drawContext) {
        return drawContext.getVisibleSector();
    }

    protected void selectMGRSRenderables(DrawContext drawContext, Sector sector) {
        ArrayList<GridZone> arrayList = this.getVisibleZones(drawContext);
        if (arrayList.size() > 0) {
            for (GridZone gridZone : arrayList) {
                gridZone.selectRenderables(drawContext, sector, this);
            }
        }
    }

    private ArrayList<GridZone> getVisibleZones(DrawContext drawContext) {
        ArrayList<GridZone> arrayList = new ArrayList<GridZone>();
        Sector sector = drawContext.getVisibleSector();
        if (sector != null) {
            Rectangle2D rectangle2D = this.getGridRectangleForSector(sector);
            if (rectangle2D != null) {
                int n = (int)rectangle2D.getY();
                while ((double)n <= rectangle2D.getY() + rectangle2D.getHeight()) {
                    int n2 = (int)rectangle2D.getX();
                    while ((double)n2 <= rectangle2D.getX() + rectangle2D.getWidth()) {
                        if (n != 19 || n2 != 31 && n2 != 33 && n2 != 35) {
                            if (this.gridZones[n][n2] == null) {
                                this.gridZones[n][n2] = new GridZone(this.getGridSector(n, n2));
                            }
                            if (this.gridZones[n][n2].isInView(drawContext)) {
                                arrayList.add(this.gridZones[n][n2]);
                            } else {
                                this.gridZones[n][n2].clearRenderables();
                            }
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            if (sector.getMaxLatitude().degrees > 84.0) {
                if (this.poleZones[2] == null) {
                    this.poleZones[2] = new GridZone(Sector.fromDegrees(84.0, 90.0, -180.0, 0.0));
                }
                if (this.poleZones[3] == null) {
                    this.poleZones[3] = new GridZone(Sector.fromDegrees(84.0, 90.0, 0.0, 180.0));
                }
                arrayList.add(this.poleZones[2]);
                arrayList.add(this.poleZones[3]);
            }
            if (sector.getMinLatitude().degrees < -80.0) {
                if (this.poleZones[0] == null) {
                    this.poleZones[0] = new GridZone(Sector.fromDegrees(-90.0, -80.0, -180.0, 0.0));
                }
                if (this.poleZones[1] == null) {
                    this.poleZones[1] = new GridZone(Sector.fromDegrees(-90.0, -80.0, 0.0, 180.0));
                }
                arrayList.add(this.poleZones[0]);
                arrayList.add(this.poleZones[1]);
            }
        }
        return arrayList;
    }

    private Rectangle2D getGridRectangleForSector(Sector sector) {
        Rectangle rectangle = null;
        if (sector.getMinLatitude().degrees < 84.0 && sector.getMaxLatitude().degrees > -80.0) {
            Sector sector2 = Sector.fromDegrees(Math.max(sector.getMinLatitude().degrees, -80.0), Math.min(sector.getMaxLatitude().degrees, 84.0), sector.getMinLongitude().degrees, sector.getMaxLongitude().degrees);
            int n = this.getGridColumn(sector2.getMinLongitude().degrees);
            int n2 = this.getGridColumn(sector2.getMaxLongitude().degrees);
            int n3 = this.getGridRow(sector2.getMinLatitude().degrees);
            int n4 = this.getGridRow(sector2.getMaxLatitude().degrees);
            if (n3 <= 17 && n4 >= 17 && n2 == 30) {
                n2 = 31;
            }
            if (n3 <= 19 && n4 >= 19) {
                if (n == 31) {
                    n = 30;
                }
                if (n2 == 31) {
                    n2 = 32;
                }
                if (n == 33) {
                    n = 32;
                }
                if (n2 == 33) {
                    n2 = 34;
                }
                if (n == 35) {
                    n = 34;
                }
                if (n2 == 35) {
                    n2 = 36;
                }
            }
            rectangle = new Rectangle(n, n3, n2 - n, n4 - n3);
        }
        return rectangle;
    }

    private int getGridColumn(Double d) {
        int n = (int)Math.floor((d + 180.0) / 6.0);
        return Math.min(n, 59);
    }

    private int getGridRow(Double d) {
        int n = (int)Math.floor((d + 80.0) / 8.0);
        return Math.min(n, 19);
    }

    private Sector getGridSector(int n, int n2) {
        int n3;
        int n4 = n3 + ((n3 = -80 + n * 8) != 72 ? 8 : 12);
        int n5 = -180 + n2 * 6;
        int n6 = n5 + 6;
        if (n == 17 && n2 == 30) {
            n6 -= 3;
        } else if (n == 17 && n2 == 31) {
            n5 -= 3;
        } else if (n == 19 && n2 == 30) {
            n6 += 3;
        } else if (n == 19 && n2 == 31) {
            n5 += 3;
            n6 -= 3;
        } else if (n == 19 && n2 == 32) {
            n5 -= 3;
            n6 += 3;
        } else if (n == 19 && n2 == 33) {
            n5 += 3;
            n6 -= 3;
        } else if (n == 19 && n2 == 34) {
            n5 -= 3;
            n6 += 3;
        } else if (n == 19 && n2 == 35) {
            n5 += 3;
            n6 -= 3;
        } else if (n == 19 && n2 == 36) {
            n5 -= 3;
        }
        return Sector.fromDegrees(n3, n4, n5, n6);
    }

    private boolean isNorthNeighborInView(GridZone gridZone, DrawContext drawContext) {
        if (gridZone.isUPS) {
            return true;
        }
        int n = this.getGridRow(((GridZone)gridZone).sector.getCentroid().getLatitude().degrees);
        int n2 = this.getGridColumn(((GridZone)gridZone).sector.getCentroid().getLongitude().degrees);
        GridZone gridZone2 = n + 1 <= 19 ? this.gridZones[n + 1][n2] : null;
        return gridZone2 != null && gridZone2.isInView(drawContext);
    }

    private boolean isEastNeighborInView(GridZone gridZone, DrawContext drawContext) {
        if (gridZone.isUPS) {
            return true;
        }
        int n = this.getGridRow(((GridZone)gridZone).sector.getCentroid().getLatitude().degrees);
        int n2 = this.getGridColumn(((GridZone)gridZone).sector.getCentroid().getLongitude().degrees);
        GridZone gridZone2 = n2 + 1 <= 59 ? this.gridZones[n][n2 + 1] : null;
        return gridZone2 != null && gridZone2.isInView(drawContext);
    }

    private Vec4 getSurfacePoint(DrawContext drawContext, Angle angle, Angle angle2) {
        Vec4 vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(angle, angle2);
        if (vec4 == null) {
            vec4 = drawContext.getGlobe().computePointFromPosition(new Position(angle, angle2, drawContext.getGlobe().getElevation(angle, angle2)));
        }
        return vec4;
    }

    private double computeAltitudeAboveGround(DrawContext drawContext) {
        View view = drawContext.getView();
        Position position = view.getEyePosition();
        Vec4 vec4 = this.getSurfacePoint(drawContext, position.getLatitude(), position.getLongitude());
        return view.getEyePoint().distanceTo3(vec4);
    }

    public Position computePosition(int n, char c, double d, double d2) {
        return n > 0 ? this.computePositionFromUTM(n, c, d, d2) : this.computePositionFromUPS(c, d, d2);
    }

    public Position computePositionFromUTM(int n, char c, double d, double d2) {
        try {
            UTMCoord uTMCoord = UTMCoord.fromUTM(n, c, d, d2, this.globe);
            return new Position(Angle.fromRadiansLatitude(uTMCoord.getLatitude().radians), Angle.fromRadiansLongitude(uTMCoord.getLongitude().radians), 10000.0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public Position computePositionFromUPS(char c, double d, double d2) {
        try {
            UPSCoord uPSCoord = UPSCoord.fromUPS(c, d, d2, this.globe);
            return new Position(Angle.fromRadiansLatitude(uPSCoord.getLatitude().radians), Angle.fromRadiansLongitude(uPSCoord.getLongitude().radians), 10000.0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private class SquareGrid
    extends SquareSector {
        private ArrayList<UTMGraticuleLayer.GridElement> gridElements;
        private ArrayList<SquareGrid> subGrids;

        public SquareGrid(GridZone gridZone, double d, double d2, double d3) {
            super(gridZone, d, d2, d3);
        }

        public boolean isInView(DrawContext drawContext) {
            if (!MGRSGraticuleLayer.this.viewFrustum.intersects(this.getExtent(drawContext.getGlobe(), drawContext.getVerticalExaggeration()))) {
                return false;
            }
            return !(this.getSizeInPixels(drawContext) <= 200.0);
        }

        public void selectRenderables(DrawContext drawContext, Sector sector, MGRSGraticuleLayer mGRSGraticuleLayer) {
            if (this.gridElements == null) {
                this.createRenderables(drawContext);
            }
            int n = (int)this.size / 10;
            boolean bl = this.getSizeInPixels(drawContext) > 340.0;
            String string = MGRSGraticuleLayer.this.getTypeFor(n);
            for (UTMGraticuleLayer.GridElement object : this.gridElements) {
                if (!object.isInView(drawContext, sector)) continue;
                if (bl) {
                    MGRSGraticuleLayer.this.metricScaleSupport.computeMetricScaleExtremes(this.gridZone, object, this.size);
                }
                mGRSGraticuleLayer.addRenderable(object.renderable, string);
                MGRSGraticuleLayer.this.renderablesCount++;
            }
            if (this.getSizeInPixels(drawContext) <= 400.0) {
                return;
            }
            if (this.subGrids == null) {
                this.createSubGrids();
            }
            for (SquareGrid squareGrid : this.subGrids) {
                if (squareGrid.isInView(drawContext)) {
                    squareGrid.selectRenderables(drawContext, sector, mGRSGraticuleLayer);
                    MGRSGraticuleLayer.this.visibleCellsCount++;
                    continue;
                }
                squareGrid.clearRenderables();
            }
        }

        public void clearRenderables() {
            if (this.gridElements != null) {
                this.gridElements.clear();
                this.gridElements = null;
            }
            if (this.subGrids != null) {
                for (SquareGrid squareGrid : this.subGrids) {
                    squareGrid.clearRenderables();
                }
                this.subGrids.clear();
                this.subGrids = null;
            }
        }

        public void createSubGrids() {
            this.subGrids = new ArrayList();
            double d = this.size / 10.0;
            for (int i = 0; i < 10; ++i) {
                double d2 = this.SWEasting + d * (double)i;
                for (int j = 0; j < 10; ++j) {
                    double d3 = this.SWNorthing + d * (double)j;
                    SquareGrid squareGrid = new SquareGrid(this.gridZone, d2, d3, d);
                    if (squareGrid.isOutsideGridZone()) continue;
                    this.subGrids.add(squareGrid);
                }
            }
        }

        public void createRenderables(DrawContext drawContext) {
            UTMGraticuleLayer.GridElement gridElement;
            Sector sector;
            Polyline polyline;
            Position position;
            Position position2;
            double d;
            int n;
            this.gridElements = new ArrayList();
            double d2 = this.size / 10.0;
            ArrayList<Position> arrayList = new ArrayList<Position>();
            for (n = 1; n <= 9; ++n) {
                d = this.SWEasting + d2 * (double)n;
                arrayList.clear();
                position2 = MGRSGraticuleLayer.this.computePosition(this.gridZone.UTMZone, this.gridZone.hemisphere, d, this.SWNorthing);
                position = MGRSGraticuleLayer.this.computePosition(this.gridZone.UTMZone, this.gridZone.hemisphere, d, this.SWNorthing + this.size);
                if (this.isTruncated) {
                    this.computeTruncatedSegment(position2, position, arrayList);
                } else {
                    arrayList.add(position2);
                    arrayList.add(position);
                }
                if (arrayList.size() <= 0) continue;
                position2 = arrayList.get(0);
                position = arrayList.get(1);
                polyline = new Polyline(arrayList);
                polyline.setPathType(0);
                polyline.setFollowTerrain(true);
                sector = Sector.boundingSector(position2, position);
                gridElement = new UTMGraticuleLayer.GridElement(MGRSGraticuleLayer.this, sector, polyline, "GridElement_LineEasting");
                gridElement.setValue(d);
                this.gridElements.add(gridElement);
            }
            for (n = 1; n <= 9; ++n) {
                d = this.SWNorthing + d2 * (double)n;
                arrayList.clear();
                position2 = MGRSGraticuleLayer.this.computePosition(this.gridZone.UTMZone, this.gridZone.hemisphere, this.SWEasting, d);
                position = MGRSGraticuleLayer.this.computePosition(this.gridZone.UTMZone, this.gridZone.hemisphere, this.SWEasting + this.size, d);
                if (this.isTruncated) {
                    this.computeTruncatedSegment(position2, position, arrayList);
                } else {
                    arrayList.add(position2);
                    arrayList.add(position);
                }
                if (arrayList.size() <= 0) continue;
                position2 = arrayList.get(0);
                position = arrayList.get(1);
                polyline = new Polyline(arrayList);
                polyline.setPathType(0);
                polyline.setFollowTerrain(true);
                sector = Sector.boundingSector(position2, position);
                gridElement = new UTMGraticuleLayer.GridElement(MGRSGraticuleLayer.this, sector, polyline, "GridElement_LineNorthing");
                gridElement.setValue(d);
                this.gridElements.add(gridElement);
            }
        }
    }

    private class SquareZone
    extends SquareSector {
        protected String name;
        protected SquareGrid squareGrid;
        protected ArrayList<UTMGraticuleLayer.GridElement> gridElements;
        private SquareZone northNeighbor;
        private SquareZone eastNeighbor;

        public SquareZone(GridZone gridZone, double d, double d2, double d3) {
            super(gridZone, d, d2, d3);
            double d4 = 1.567855942887398E-6;
            try {
                MGRSCoord mGRSCoord = null;
                if (this.centroid != null && this.gridZone.isPositionInside(new Position(this.centroid, 0.0))) {
                    mGRSCoord = MGRSCoord.fromLatLon(this.centroid.latitude, this.centroid.longitude, MGRSGraticuleLayer.this.globe);
                } else if (this.gridZone.isPositionInside(this.sw)) {
                    mGRSCoord = MGRSCoord.fromLatLon(Angle.fromRadiansLatitude(this.sw.getLatitude().radians + d4), Angle.fromRadiansLongitude(this.sw.getLongitude().radians + d4), MGRSGraticuleLayer.this.globe);
                } else if (this.gridZone.isPositionInside(this.se)) {
                    mGRSCoord = MGRSCoord.fromLatLon(Angle.fromRadiansLatitude(this.se.getLatitude().radians + d4), Angle.fromRadiansLongitude(this.se.getLongitude().radians - d4), MGRSGraticuleLayer.this.globe);
                } else if (this.gridZone.isPositionInside(this.nw)) {
                    mGRSCoord = MGRSCoord.fromLatLon(Angle.fromRadiansLatitude(this.nw.getLatitude().radians - d4), Angle.fromRadiansLongitude(this.nw.getLongitude().radians + d4), MGRSGraticuleLayer.this.globe);
                } else if (this.gridZone.isPositionInside(this.ne)) {
                    mGRSCoord = MGRSCoord.fromLatLon(Angle.fromRadiansLatitude(this.ne.getLatitude().radians - d4), Angle.fromRadiansLongitude(this.ne.getLongitude().radians - d4), MGRSGraticuleLayer.this.globe);
                }
                if (mGRSCoord != null) {
                    this.name = mGRSCoord.toString().substring(3, 5);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.name = "";
            }
        }

        public void setNorthNeighbor(SquareZone squareZone) {
            this.northNeighbor = squareZone;
        }

        public void setEastNeighbor(SquareZone squareZone) {
            this.eastNeighbor = squareZone;
        }

        public void selectRenderables(DrawContext drawContext, Sector sector, MGRSGraticuleLayer mGRSGraticuleLayer) {
            if (this.gridElements == null) {
                this.createRenderables(drawContext);
            }
            boolean bl = this.getSizeInPixels(drawContext) > 340.0;
            for (UTMGraticuleLayer.GridElement gridElement : this.gridElements) {
                if (!gridElement.isInView(drawContext, sector) || gridElement.type.equals("GridElement_LineNorth") && this.isNorthNeighborInView(drawContext) || gridElement.type.equals("GridElement_LineEast") && this.isEastNeighborInView(drawContext)) continue;
                if (bl) {
                    MGRSGraticuleLayer.this.metricScaleSupport.computeMetricScaleExtremes(this.gridZone, gridElement, this.size);
                }
                mGRSGraticuleLayer.addRenderable(gridElement.renderable, MGRSGraticuleLayer.GRATICULE_100000M);
                MGRSGraticuleLayer.this.renderablesCount++;
            }
            if (this.getSizeInPixels(drawContext) <= 100.0) {
                return;
            }
            if (this.squareGrid == null) {
                this.squareGrid = new SquareGrid(this.gridZone, this.SWEasting, this.SWNorthing, this.size);
            }
            if (this.squareGrid.isInView(drawContext)) {
                this.squareGrid.selectRenderables(drawContext, sector, mGRSGraticuleLayer);
                MGRSGraticuleLayer.this.visibleCellsCount++;
            } else {
                this.squareGrid.clearRenderables();
            }
        }

        private boolean isNorthNeighborInView(DrawContext drawContext) {
            return this.northNeighbor != null && this.northNeighbor.isInView(drawContext);
        }

        private boolean isEastNeighborInView(DrawContext drawContext) {
            return this.eastNeighbor != null && this.eastNeighbor.isInView(drawContext);
        }

        public void clearRenderables() {
            if (this.gridElements != null) {
                this.gridElements.clear();
                this.gridElements = null;
            }
            if (this.squareGrid != null) {
                this.squareGrid.clearRenderables();
                this.squareGrid = null;
            }
        }

        public void createRenderables(DrawContext drawContext) {
            Object object;
            Sector sector;
            Polyline polyline;
            Position position;
            Position position2;
            this.gridElements = new ArrayList();
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.clear();
            if (this.isTruncated) {
                this.computeTruncatedSegment(this.sw, this.nw, arrayList);
            } else {
                arrayList.add(this.sw);
                arrayList.add(this.nw);
            }
            if (arrayList.size() > 0) {
                position2 = arrayList.get(0);
                position = arrayList.get(1);
                polyline = new Polyline(arrayList);
                polyline.setPathType(0);
                polyline.setFollowTerrain(true);
                sector = Sector.boundingSector(position2, position);
                object = new UTMGraticuleLayer.GridElement(MGRSGraticuleLayer.this, sector, polyline, "GridElement_LineWest");
                ((UTMGraticuleLayer.GridElement)object).setValue(this.SWEasting);
                this.gridElements.add((UTMGraticuleLayer.GridElement)object);
            }
            arrayList.clear();
            if (this.isTruncated) {
                this.computeTruncatedSegment(this.se, this.ne, arrayList);
            } else {
                arrayList.add(this.se);
                arrayList.add(this.ne);
            }
            if (arrayList.size() > 0) {
                position2 = arrayList.get(0);
                position = arrayList.get(1);
                polyline = new Polyline(arrayList);
                polyline.setPathType(0);
                polyline.setFollowTerrain(true);
                sector = Sector.boundingSector(position2, position);
                object = new UTMGraticuleLayer.GridElement(MGRSGraticuleLayer.this, sector, polyline, "GridElement_LineEast");
                ((UTMGraticuleLayer.GridElement)object).setValue(this.SWEasting + this.size);
                this.gridElements.add((UTMGraticuleLayer.GridElement)object);
            }
            arrayList.clear();
            if (this.isTruncated) {
                this.computeTruncatedSegment(this.sw, this.se, arrayList);
            } else {
                arrayList.add(this.sw);
                arrayList.add(this.se);
            }
            if (arrayList.size() > 0) {
                position2 = arrayList.get(0);
                position = arrayList.get(1);
                polyline = new Polyline(arrayList);
                polyline.setPathType(0);
                polyline.setFollowTerrain(true);
                sector = Sector.boundingSector(position2, position);
                object = new UTMGraticuleLayer.GridElement(MGRSGraticuleLayer.this, sector, polyline, "GridElement_LineSouth");
                ((UTMGraticuleLayer.GridElement)object).setValue(this.SWNorthing);
                this.gridElements.add((UTMGraticuleLayer.GridElement)object);
            }
            arrayList.clear();
            if (this.isTruncated) {
                this.computeTruncatedSegment(this.nw, this.ne, arrayList);
            } else {
                arrayList.add(this.nw);
                arrayList.add(this.ne);
            }
            if (arrayList.size() > 0) {
                position2 = arrayList.get(0);
                position = arrayList.get(1);
                polyline = new Polyline(arrayList);
                polyline.setPathType(0);
                polyline.setFollowTerrain(true);
                sector = Sector.boundingSector(position2, position);
                object = new UTMGraticuleLayer.GridElement(MGRSGraticuleLayer.this, sector, polyline, "GridElement_LineNorth");
                ((UTMGraticuleLayer.GridElement)object).setValue(this.SWNorthing + this.size);
                this.gridElements.add((UTMGraticuleLayer.GridElement)object);
            }
            if (this.gridZone.isPositionInside(new Position(this.squareCenter, 0.0))) {
                object = new UserFacingText(this.name, new Position(this.squareCenter, 0.0));
                this.gridElements.add(new UTMGraticuleLayer.GridElement(MGRSGraticuleLayer.this, this.boundingSector, object, "GridElement_GridZoneLabel"));
            } else if (this.squareCenter.getLatitude().degrees <= ((GridZone)this.gridZone).sector.getMaxLatitude().degrees && this.squareCenter.getLatitude().degrees >= ((GridZone)this.gridZone).sector.getMinLatitude().degrees && this.boundingSector.getDeltaLon().degrees * Math.cos(this.centroid.getLatitude().radians) > 0.3) {
                object = new UserFacingText(this.name, new Position(this.centroid, 0.0));
                this.gridElements.add(new UTMGraticuleLayer.GridElement(MGRSGraticuleLayer.this, this.boundingSector, object, "GridElement_GridZoneLabel"));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SquareSector {
        public static final int MIN_CELL_SIZE_PIXELS = 50;
        protected GridZone gridZone;
        protected double SWEasting;
        protected double SWNorthing;
        protected double size;
        protected Position sw;
        protected Position se;
        protected Position nw;
        protected Position ne;
        protected Sector boundingSector;
        protected LatLon centroid;
        protected LatLon squareCenter;
        protected Vec4 centerPoint;
        private Extent extent;
        private double extentVerticalExaggeration = 1.0;
        protected boolean isTruncated = false;

        public SquareSector(GridZone gridZone, double d, double d2, double d3) {
            this.gridZone = gridZone;
            this.SWEasting = d;
            this.SWNorthing = d2;
            this.size = d3;
            this.sw = MGRSGraticuleLayer.this.computePosition(gridZone.UTMZone, gridZone.hemisphere, d, d2);
            this.se = MGRSGraticuleLayer.this.computePosition(gridZone.UTMZone, gridZone.hemisphere, d + d3, d2);
            this.nw = MGRSGraticuleLayer.this.computePosition(gridZone.UTMZone, gridZone.hemisphere, d, d2 + d3);
            this.ne = MGRSGraticuleLayer.this.computePosition(gridZone.UTMZone, gridZone.hemisphere, d + d3, d2 + d3);
            this.squareCenter = MGRSGraticuleLayer.this.computePosition(gridZone.UTMZone, gridZone.hemisphere, d + d3 / 2.0, d2 + d3 / 2.0);
            if (this.sw != null && this.se != null && this.nw != null && this.ne != null) {
                this.adjustDateLineCrossingPoints();
                this.boundingSector = Sector.boundingSector(Arrays.asList(this.sw, this.se, this.nw, this.ne));
                this.centroid = this.squareCenter;
            }
            this.isTruncated = !this.isInsideGridZone();
        }

        private void adjustDateLineCrossingPoints() {
            ArrayList<Position> arrayList = new ArrayList<Position>(Arrays.asList(this.sw, this.se, this.nw, this.ne));
            if (!LatLon.positionsCrossDateLine(arrayList)) {
                return;
            }
            double d = 0.0;
            for (LatLon latLon : arrayList) {
                if (Math.abs(latLon.getLongitude().degrees) == 180.0) continue;
                d = Math.signum(latLon.getLongitude().degrees);
            }
            if (d == 0.0) {
                return;
            }
            if (Math.abs(this.sw.getLongitude().degrees) == 180.0 && Math.signum(this.sw.getLongitude().degrees) != d) {
                this.sw = new Position(this.sw.getLatitude(), this.sw.getLongitude().multiply(-1.0), this.sw.getElevation());
            }
            if (Math.abs(this.se.getLongitude().degrees) == 180.0 && Math.signum(this.se.getLongitude().degrees) != d) {
                this.se = new Position(this.se.getLatitude(), this.se.getLongitude().multiply(-1.0), this.se.getElevation());
            }
            if (Math.abs(this.nw.getLongitude().degrees) == 180.0 && Math.signum(this.nw.getLongitude().degrees) != d) {
                this.nw = new Position(this.nw.getLatitude(), this.nw.getLongitude().multiply(-1.0), this.nw.getElevation());
            }
            if (Math.abs(this.ne.getLongitude().degrees) == 180.0 && Math.signum(this.ne.getLongitude().degrees) != d) {
                this.ne = new Position(this.ne.getLatitude(), this.ne.getLongitude().multiply(-1.0), this.ne.getElevation());
            }
        }

        public Extent getExtent(Globe globe, double d) {
            if (this.extent == null || d != this.extentVerticalExaggeration) {
                this.extent = globe.computeBoundingCylinder(d, this.boundingSector);
                this.extentVerticalExaggeration = d;
            }
            return this.extent;
        }

        public boolean isInView(DrawContext drawContext) {
            if (!MGRSGraticuleLayer.this.viewFrustum.intersects(this.getExtent(drawContext.getGlobe(), drawContext.getVerticalExaggeration()))) {
                return false;
            }
            return !(this.getSizeInPixels(drawContext) <= 50.0);
        }

        public boolean isInsideGridZone() {
            if (!this.gridZone.isPositionInside(this.nw)) {
                return false;
            }
            if (!this.gridZone.isPositionInside(this.ne)) {
                return false;
            }
            if (!this.gridZone.isPositionInside(this.sw)) {
                return false;
            }
            return this.gridZone.isPositionInside(this.se);
        }

        public boolean isOutsideGridZone() {
            if (this.gridZone.isPositionInside(this.nw)) {
                return false;
            }
            if (this.gridZone.isPositionInside(this.ne)) {
                return false;
            }
            if (this.gridZone.isPositionInside(this.sw)) {
                return false;
            }
            return !this.gridZone.isPositionInside(this.se);
        }

        public double getSizeInPixels(DrawContext drawContext) {
            View view = drawContext.getView();
            if (this.centerPoint == null || MGRSGraticuleLayer.this.frameCount % 10L == 0L) {
                this.centerPoint = MGRSGraticuleLayer.this.getSurfacePoint(drawContext, this.centroid.getLatitude(), this.centroid.getLongitude());
            }
            Double d = view.getEyePoint().distanceTo3(this.centerPoint);
            return this.size / view.computePixelSizeAtDistance(d);
        }

        public void computeTruncatedSegment(Position position, Position position2, ArrayList<Position> arrayList) {
            boolean bl = this.gridZone.isPositionInside(position);
            boolean bl2 = this.gridZone.isPositionInside(position2);
            if (!bl && !bl2) {
                return;
            }
            if (bl && bl2) {
                arrayList.add(position);
                arrayList.add(position2);
            } else {
                Position position3 = !bl ? position : position2;
                Position position4 = bl ? position : position2;
                for (int i = 1; i <= 2; ++i) {
                    LatLon latLon = null;
                    if (position3.getLongitude().degrees > ((GridZone)this.gridZone).sector.getMaxLongitude().degrees || ((GridZone)this.gridZone).sector.getMaxLongitude().degrees == 180.0 && position3.getLongitude().degrees < 0.0) {
                        latLon = this.gridZone.greatCircleIntersectionAtLongitude(position4, position3, this.gridZone.sector.getMaxLongitude());
                    } else if (position3.getLongitude().degrees < ((GridZone)this.gridZone).sector.getMinLongitude().degrees || ((GridZone)this.gridZone).sector.getMinLongitude().degrees == -180.0 && position3.getLongitude().degrees > 0.0) {
                        latLon = this.gridZone.greatCircleIntersectionAtLongitude(position4, position3, this.gridZone.sector.getMinLongitude());
                    } else if (position3.getLatitude().degrees > ((GridZone)this.gridZone).sector.getMaxLatitude().degrees) {
                        latLon = this.gridZone.greatCircleIntersectionAtLatitude(position4, position3, this.gridZone.sector.getMaxLatitude());
                    } else if (position3.getLatitude().degrees < ((GridZone)this.gridZone).sector.getMinLatitude().degrees) {
                        latLon = this.gridZone.greatCircleIntersectionAtLatitude(position4, position3, this.gridZone.sector.getMinLatitude());
                    }
                    if (latLon == null) break;
                    position3 = new Position(latLon, position3.getElevation());
                }
                arrayList.add(position4);
                arrayList.add(position3);
            }
        }
    }

    private class GridZone {
        private static final double ONEHT = 100000.0;
        private static final double TWOMIL = 2000000.0;
        private Sector sector;
        private boolean isUPS = false;
        private String name = "";
        private int UTMZone = 0;
        private char hemisphere = (char)32;
        private Extent extent;
        private double extentVerticalExaggeration = 1.0;
        private ArrayList<UTMGraticuleLayer.GridElement> gridElements;
        private ArrayList<SquareZone> squares;

        public GridZone(Sector sector) {
            this.sector = sector;
            this.isUPS = sector.getMaxLatitude().degrees > 84.0 || sector.getMinLatitude().degrees < -80.0;
            try {
                MGRSCoord mGRSCoord = MGRSCoord.fromLatLon(sector.getCentroid().getLatitude(), sector.getCentroid().getLongitude(), MGRSGraticuleLayer.this.globe);
                if (this.isUPS) {
                    this.name = mGRSCoord.toString().substring(2, 3);
                    this.hemisphere = (char)(sector.getMinLatitude().degrees > 0.0 ? 78 : 83);
                } else {
                    this.name = mGRSCoord.toString().substring(0, 3);
                    UTMCoord uTMCoord = UTMCoord.fromLatLon(sector.getCentroid().getLatitude(), sector.getCentroid().getLongitude(), MGRSGraticuleLayer.this.globe);
                    this.UTMZone = uTMCoord.getZone();
                    this.hemisphere = uTMCoord.getHemisphere();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public Extent getExtent(Globe globe, double d) {
            if (this.extent == null || d != this.extentVerticalExaggeration) {
                this.extent = globe.computeBoundingCylinder(d, this.sector);
                this.extentVerticalExaggeration = d;
            }
            return this.extent;
        }

        public boolean isInView(DrawContext drawContext) {
            return MGRSGraticuleLayer.this.viewFrustum.intersects(this.getExtent(drawContext.getGlobe(), drawContext.getVerticalExaggeration()));
        }

        public void selectRenderables(DrawContext drawContext, Sector sector, MGRSGraticuleLayer mGRSGraticuleLayer) {
            if (this.gridElements == null) {
                this.createRenderables();
            }
            for (UTMGraticuleLayer.GridElement object : this.gridElements) {
                if (!object.isInView(drawContext, sector) || object.type.equals("GridElement_LineNorth") && MGRSGraticuleLayer.this.isNorthNeighborInView(this, drawContext) || object.type.equals("GridElement_LineEast") && MGRSGraticuleLayer.this.isEastNeighborInView(this, drawContext)) continue;
                mGRSGraticuleLayer.addRenderable(object.renderable, MGRSGraticuleLayer.GRATICULE_UTM_GRID);
                MGRSGraticuleLayer.this.renderablesCount++;
            }
            if (drawContext.getView().getEyePosition().getElevation() > MGRSGraticuleLayer.this.squareMaxAltitude) {
                return;
            }
            if (this.squares == null) {
                this.createSquares();
            }
            for (SquareZone squareZone : this.squares) {
                if (squareZone.isInView(drawContext)) {
                    squareZone.selectRenderables(drawContext, sector, mGRSGraticuleLayer);
                    MGRSGraticuleLayer.this.visibleCellsCount++;
                    continue;
                }
                squareZone.clearRenderables();
            }
        }

        public void clearRenderables() {
            if (this.gridElements != null) {
                this.gridElements.clear();
                this.gridElements = null;
            }
            if (this.squares != null) {
                for (SquareZone squareZone : this.squares) {
                    squareZone.clearRenderables();
                }
                this.squares.clear();
                this.squares = null;
            }
        }

        private void createSquares() {
            if (this.isUPS) {
                this.createSquaresUPS();
            } else {
                this.createSquaresUTM();
            }
        }

        private void createSquaresUTM() {
            this.squares = new ArrayList();
            try {
                UTMCoord uTMCoord = UTMCoord.fromLatLon(this.sector.getMinLatitude(), this.sector.getCentroid().getLongitude(), MGRSGraticuleLayer.this.globe);
                double d = uTMCoord.getNorthing();
                uTMCoord = UTMCoord.fromLatLon(this.sector.getMaxLatitude(), this.sector.getCentroid().getLongitude(), MGRSGraticuleLayer.this.globe);
                double d2 = uTMCoord.getNorthing();
                d2 = d2 == 0.0 ? 1.0E7 : d2;
                uTMCoord = UTMCoord.fromLatLon(this.sector.getMinLatitude(), this.sector.getMinLongitude(), MGRSGraticuleLayer.this.globe);
                double d3 = uTMCoord.getEasting();
                uTMCoord = UTMCoord.fromLatLon(this.sector.getMaxLatitude(), this.sector.getMinLongitude(), MGRSGraticuleLayer.this.globe);
                d3 = uTMCoord.getEasting() < d3 ? uTMCoord.getEasting() : d3;
                double d4 = 1000000.0 - d3;
                if (this.name.equals("32V")) {
                    d2 += 20000.0;
                }
                if (this.name.equals("31X")) {
                    d4 += 100000.0;
                }
                this.createSquaresGrid(d3, d4, d, d2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private void createSquaresUPS() {
            double d;
            double d2;
            double d3;
            double d4;
            this.squares = new ArrayList();
            if (this.hemisphere == 'N') {
                d4 = 1300000.0;
                d3 = 2700000.0;
                d2 = this.name.equals("Y") ? 1300000.0 : 2000000.0;
                d = this.name.equals("Y") ? 2000000.0 : 2700000.0;
            } else {
                d4 = 800000.0;
                d3 = 3200000.0;
                d2 = this.name.equals("A") ? 800000.0 : 2000000.0;
                d = this.name.equals("A") ? 2000000.0 : 3200000.0;
            }
            this.createSquaresGrid(d2, d, d4, d3);
        }

        private void createSquaresGrid(double d, double d2, double d3, double d4) {
            double d5 = Math.floor(d / 100000.0) * 100000.0;
            double d6 = Math.floor(d3 / 100000.0) * 100000.0;
            int n = (int)Math.ceil((d2 - d5) / 100000.0);
            int n2 = (int)Math.ceil((d4 - d6) / 100000.0);
            SquareZone[][] squareZoneArray = new SquareZone[n2][n];
            int n3 = 0;
            for (double d7 = d5; d7 < d2; d7 += 100000.0) {
                int n4 = 0;
                for (double d8 = d6; d8 < d4; d8 += 100000.0) {
                    SquareZone squareZone = new SquareZone(this, d7, d8, 100000.0);
                    if (squareZone.boundingSector != null && !squareZone.isOutsideGridZone()) {
                        this.squares.add(squareZone);
                        squareZoneArray[n4][n3] = squareZone;
                    }
                    ++n4;
                }
                ++n3;
            }
            for (n3 = 0; n3 < n; ++n3) {
                for (int i = 0; i < n2; ++i) {
                    SquareZone squareZone = squareZoneArray[i][n3];
                    if (squareZone == null) continue;
                    squareZone.setNorthNeighbor(i + 1 < n2 ? squareZoneArray[i + 1][n3] : null);
                    squareZone.setEastNeighbor(n3 + 1 < n ? squareZoneArray[i][n3 + 1] : null);
                }
            }
        }

        private void createRenderables() {
            this.gridElements = new ArrayList();
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.clear();
            arrayList.add(new Position(this.sector.getMinLatitude(), this.sector.getMinLongitude(), 10000.0));
            arrayList.add(new Position(this.sector.getMaxLatitude(), this.sector.getMinLongitude(), 10000.0));
            Polyline polyline = new Polyline(arrayList);
            polyline.setPathType(1);
            polyline.setFollowTerrain(true);
            polyline.setTerrainConformance(50.0);
            Sector sector = new Sector(this.sector.getMinLatitude(), this.sector.getMaxLatitude(), this.sector.getMinLongitude(), this.sector.getMinLongitude());
            this.gridElements.add(new UTMGraticuleLayer.GridElement(MGRSGraticuleLayer.this, sector, polyline, "GridElement_LineWest"));
            if (!this.isUPS) {
                arrayList.clear();
                arrayList.add(new Position(this.sector.getMinLatitude(), this.sector.getMaxLongitude(), 10000.0));
                arrayList.add(new Position(this.sector.getMaxLatitude(), this.sector.getMaxLongitude(), 10000.0));
                polyline = new Polyline(arrayList);
                polyline.setPathType(1);
                polyline.setFollowTerrain(true);
                polyline.setTerrainConformance(50.0);
                sector = new Sector(this.sector.getMinLatitude(), this.sector.getMaxLatitude(), this.sector.getMaxLongitude(), this.sector.getMaxLongitude());
                this.gridElements.add(new UTMGraticuleLayer.GridElement(MGRSGraticuleLayer.this, sector, polyline, "GridElement_LineEast"));
                arrayList.clear();
                arrayList.add(new Position(this.sector.getMinLatitude(), this.sector.getMinLongitude(), 10000.0));
                arrayList.add(new Position(this.sector.getMinLatitude(), this.sector.getMaxLongitude(), 10000.0));
                polyline = new Polyline(arrayList);
                polyline.setPathType(1);
                polyline.setFollowTerrain(true);
                polyline.setTerrainConformance(20.0);
                sector = new Sector(this.sector.getMinLatitude(), this.sector.getMinLatitude(), this.sector.getMinLongitude(), this.sector.getMaxLongitude());
                this.gridElements.add(new UTMGraticuleLayer.GridElement(MGRSGraticuleLayer.this, sector, polyline, "GridElement_LineSouth"));
                arrayList.clear();
                arrayList.add(new Position(this.sector.getMaxLatitude(), this.sector.getMinLongitude(), 10000.0));
                arrayList.add(new Position(this.sector.getMaxLatitude(), this.sector.getMaxLongitude(), 10000.0));
                polyline = new Polyline(arrayList);
                polyline.setPathType(1);
                polyline.setFollowTerrain(true);
                polyline.setTerrainConformance(20.0);
                sector = new Sector(this.sector.getMaxLatitude(), this.sector.getMaxLatitude(), this.sector.getMinLongitude(), this.sector.getMaxLongitude());
                this.gridElements.add(new UTMGraticuleLayer.GridElement(MGRSGraticuleLayer.this, sector, polyline, "GridElement_LineNorth"));
            }
            UserFacingText userFacingText = new UserFacingText(this.name, new Position(this.sector.getCentroid(), 0.0));
            this.gridElements.add(new UTMGraticuleLayer.GridElement(MGRSGraticuleLayer.this, this.sector, userFacingText, "GridElement_GridZoneLabel"));
        }

        public boolean isPositionInside(Position position) {
            return position != null && this.sector.contains(position);
        }

        public LatLon greatCircleIntersectionAtLongitude(LatLon latLon, LatLon latLon2, Angle angle) {
            if (latLon.getLongitude().degrees == angle.degrees) {
                return latLon;
            }
            if (latLon2.getLongitude().degrees == angle.degrees) {
                return latLon2;
            }
            LatLon latLon3 = null;
            Double d = this.getDeltaLongitude((LatLon)latLon, (Angle)latLon2.getLongitude()).degrees;
            if (this.getDeltaLongitude((LatLon)latLon, (Angle)angle).degrees < d && this.getDeltaLongitude((LatLon)latLon2, (Angle)angle).degrees < d) {
                int n = 0;
                double d2 = 1.567855942887398E-7;
                LatLon latLon4 = latLon;
                LatLon latLon5 = latLon2;
                LatLon latLon6 = this.greatCircleMidPoint(latLon4, latLon5);
                while (this.getDeltaLongitude((LatLon)latLon6, (Angle)angle).radians > d2 && n <= 20) {
                    ++n;
                    if (this.getDeltaLongitude((LatLon)latLon4, (Angle)angle).degrees < this.getDeltaLongitude((LatLon)latLon5, (Angle)angle).degrees) {
                        latLon5 = latLon6;
                    } else {
                        latLon4 = latLon6;
                    }
                    latLon6 = this.greatCircleMidPoint(latLon4, latLon5);
                }
                latLon3 = latLon6;
            }
            if (latLon3 != null) {
                latLon3 = new LatLon(latLon3.getLatitude(), angle);
            }
            return latLon3;
        }

        public LatLon greatCircleIntersectionAtLatitude(LatLon latLon, LatLon latLon2, Angle angle) {
            LatLon latLon3 = null;
            if (Math.signum(latLon.getLatitude().degrees - angle.degrees) != Math.signum(latLon2.getLatitude().degrees - angle.degrees)) {
                int n = 0;
                double d = 1.567855942887398E-7;
                LatLon latLon4 = latLon;
                LatLon latLon5 = latLon2;
                LatLon latLon6 = this.greatCircleMidPoint(latLon4, latLon5);
                while (Math.abs(latLon6.getLatitude().radians - angle.radians) > d && n <= 20) {
                    ++n;
                    if (Math.signum(latLon4.getLatitude().degrees - angle.degrees) != Math.signum(latLon6.getLatitude().degrees - angle.degrees)) {
                        latLon5 = latLon6;
                    } else {
                        latLon4 = latLon6;
                    }
                    latLon6 = this.greatCircleMidPoint(latLon4, latLon5);
                }
                latLon3 = latLon6;
            }
            if (latLon3 != null) {
                latLon3 = new LatLon(angle, latLon3.getLongitude());
            }
            return latLon3;
        }

        public LatLon greatCircleMidPoint(LatLon latLon, LatLon latLon2) {
            Angle angle = LatLon.greatCircleAzimuth(latLon, latLon2);
            Angle angle2 = LatLon.greatCircleDistance(latLon, latLon2);
            return LatLon.greatCircleEndPosition(latLon, angle.radians, angle2.radians / 2.0);
        }

        public Angle getDeltaLongitude(LatLon latLon, Angle angle) {
            double d = Math.abs(latLon.getLongitude().degrees - angle.degrees);
            return Angle.fromDegrees(d < 180.0 ? d : 360.0 - d);
        }
    }

    private class MetricScaleSupport {
        private int zone;
        private char hemisphere;
        private double offsetFactorX = -0.5;
        private double offsetFactorY = -0.5;
        private double visibleDistanceFactor = 10.0;
        UTMExtremes[] extremes = new UTMExtremes[5];

        private MetricScaleSupport() {
        }

        public int getZone() {
            return this.zone;
        }

        private void computeZone(DrawContext drawContext) {
            try {
                Position position = ((OrbitView)drawContext.getView()).getCenterPosition();
                if (position != null) {
                    this.hemisphere = (char)(position.latitude.degrees > 0.0 ? 78 : 83);
                    if (position.latitude.degrees <= 84.0 && position.latitude.degrees >= -80.0) {
                        UTMCoord uTMCoord = UTMCoord.fromLatLon(position.getLatitude(), position.getLongitude(), drawContext.getGlobe());
                        this.zone = uTMCoord.getZone();
                    } else {
                        this.zone = 0;
                    }
                }
            }
            catch (Exception exception) {
                this.zone = 0;
                this.hemisphere = (char)78;
            }
        }

        public void clear() {
            for (int i = 0; i < 5; ++i) {
                if (this.extremes[i] == null) {
                    this.extremes[i] = new UTMExtremes();
                }
                this.extremes[i].clear();
            }
        }

        public void computeMetricScaleExtremes(GridZone gridZone, UTMGraticuleLayer.GridElement gridElement, double d) {
            if (gridZone.UTMZone != this.zone) {
                return;
            }
            if (d < 1.0 || d > 100000.0) {
                return;
            }
            UTMExtremes uTMExtremes = this.extremes[(int)Math.log10(d) - 1];
            if (gridElement.type.equals("GridElement_LineEasting") || gridElement.type.equals("GridElement_LineEast") || gridElement.type.equals("GridElement_LineWest")) {
                uTMExtremes.minX = gridElement.value < uTMExtremes.minX ? gridElement.value : uTMExtremes.minX;
                uTMExtremes.maxX = gridElement.value > uTMExtremes.maxX ? gridElement.value : uTMExtremes.maxX;
            } else if (gridElement.type.equals("GridElement_LineNorthing") || gridElement.type.equals("GridElement_LineSouth") || gridElement.type.equals("GridElement_LineNorth")) {
                if (gridZone.hemisphere == uTMExtremes.minYHemisphere) {
                    uTMExtremes.minY = gridElement.value < uTMExtremes.minY ? gridElement.value : uTMExtremes.minY;
                } else if (gridZone.hemisphere == 'S') {
                    uTMExtremes.minY = gridElement.value;
                    uTMExtremes.minYHemisphere = gridZone.hemisphere;
                }
                if (gridZone.hemisphere == uTMExtremes.maxYHemisphere) {
                    uTMExtremes.maxY = gridElement.value > uTMExtremes.maxY ? gridElement.value : uTMExtremes.maxY;
                } else if (gridZone.hemisphere == 'N') {
                    uTMExtremes.maxY = gridElement.value;
                    uTMExtremes.maxYHemisphere = gridZone.hemisphere;
                }
            }
        }

        public void selectRenderables(DrawContext drawContext) {
            try {
                char c;
                double d;
                double d2;
                Object object;
                OrbitView orbitView = (OrbitView)drawContext.getView();
                Double d3 = orbitView.computePixelSizeAtDistance(orbitView.getZoom());
                Double d4 = (double)orbitView.getViewport().width * d3 * this.offsetFactorX / 2.0;
                Double d5 = (double)orbitView.getViewport().height * d3 * this.offsetFactorY / 2.0;
                Position position = orbitView.getCenterPosition();
                if (this.zone > 0) {
                    object = UTMCoord.fromLatLon(position.getLatitude(), position.getLongitude(), drawContext.getGlobe());
                    d2 = ((UTMCoord)object).getEasting() + d4;
                    d = ((UTMCoord)object).getNorthing() + d5;
                    c = ((UTMCoord)object).getHemisphere();
                } else {
                    object = UPSCoord.fromLatLon(position.getLatitude(), position.getLongitude(), drawContext.getGlobe());
                    d2 = ((UPSCoord)object).getEasting() + d4;
                    d = ((UPSCoord)object).getNorthing() + d5;
                    c = ((UPSCoord)object).getHemisphere();
                }
                for (int i = 0; i < 5; ++i) {
                    Object object2;
                    Object object3;
                    Object object4;
                    Angle angle;
                    UTMExtremes uTMExtremes = this.extremes[i];
                    double d6 = Math.pow(10.0, i);
                    double d7 = d6 * 10.0;
                    String string = MGRSGraticuleLayer.this.getTypeFor((int)d6);
                    if (uTMExtremes.minX <= uTMExtremes.maxX) {
                        for (double d8 = uTMExtremes.minX; d8 <= uTMExtremes.maxX; d8 += d6) {
                            if (i != 4 && d8 % d7 == 0.0) continue;
                            try {
                                object = MGRSGraticuleLayer.this.computePosition(this.zone, c, d8, d);
                                Angle angle2 = ((LatLon)object).getLatitude();
                                angle = ((LatLon)object).getLongitude();
                                object4 = MGRSGraticuleLayer.this.getSurfacePoint(drawContext, angle2, angle);
                                if (!MGRSGraticuleLayer.this.viewFrustum.contains((Vec4)object4) || !this.isPointInRange(drawContext, (Vec4)object4)) continue;
                                object3 = String.valueOf((int)(d8 % 100000.0));
                                object2 = new UserFacingText((CharSequence)object3, new Position(angle2, angle, 0.0));
                                MGRSGraticuleLayer.this.addRenderable(object2, string);
                                MGRSGraticuleLayer.this.renderablesCount++;
                                continue;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                    }
                    if (uTMExtremes.maxYHemisphere == 'S' && uTMExtremes.maxY == 0.0) continue;
                    char c2 = uTMExtremes.minYHemisphere;
                    for (double d9 = uTMExtremes.minY; d9 <= uTMExtremes.maxY || c2 != uTMExtremes.maxYHemisphere; d9 += d6) {
                        if (i != 4 && d9 % d7 == 0.0) continue;
                        try {
                            object = MGRSGraticuleLayer.this.computePosition(this.zone, c2, d2, d9);
                            angle = ((LatLon)object).getLatitude();
                            object4 = ((LatLon)object).getLongitude();
                            object3 = MGRSGraticuleLayer.this.getSurfacePoint(drawContext, angle, (Angle)object4);
                            if (MGRSGraticuleLayer.this.viewFrustum.contains((Vec4)object3) && this.isPointInRange(drawContext, (Vec4)object3)) {
                                object2 = String.valueOf((int)(d9 % 100000.0));
                                UserFacingText userFacingText = new UserFacingText((CharSequence)object2, new Position(angle, (Angle)object4, 0.0));
                                MGRSGraticuleLayer.this.addRenderable(userFacingText, string);
                                MGRSGraticuleLayer.this.renderablesCount++;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        if (c2 == uTMExtremes.maxYHemisphere || !(d9 >= 1.0E7 - d6)) continue;
                        c2 = uTMExtremes.maxYHemisphere;
                        d9 = -d6;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private boolean isPointInRange(DrawContext drawContext, Vec4 vec4) {
            double d = MGRSGraticuleLayer.this.computeAltitudeAboveGround(drawContext);
            return drawContext.getView().getEyePoint().distanceTo3(vec4) < d * this.visibleDistanceFactor;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                stringBuilder.append("level ");
                stringBuilder.append(String.valueOf(i));
                stringBuilder.append(" : ");
                UTMExtremes uTMExtremes = this.extremes[i];
                if (uTMExtremes.minX < uTMExtremes.maxX || uTMExtremes.maxYHemisphere != 'S' || uTMExtremes.maxY != 0.0) {
                    stringBuilder.append(uTMExtremes.minX);
                    stringBuilder.append(", ");
                    stringBuilder.append(uTMExtremes.maxX);
                    stringBuilder.append(" - ");
                    stringBuilder.append(uTMExtremes.minY);
                    stringBuilder.append(uTMExtremes.minYHemisphere);
                    stringBuilder.append(", ");
                    stringBuilder.append(uTMExtremes.maxY);
                    stringBuilder.append(uTMExtremes.maxYHemisphere);
                } else {
                    stringBuilder.append("empty");
                }
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }

        private class UTMExtremes {
            protected double minX;
            protected double maxX;
            protected double minY;
            protected double maxY;
            protected char minYHemisphere;
            protected char maxYHemisphere;

            public UTMExtremes() {
                this.clear();
            }

            public void clear() {
                this.minX = 1000000.0;
                this.maxX = 0.0;
                this.minY = 1.0E7;
                this.minYHemisphere = (char)78;
                this.maxY = 0.0;
                this.maxYHemisphere = (char)83;
            }
        }
    }
}

