/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.util.LevelSet;
import java.util.GregorianCalendar;

public class MSVirtualEarthLayer
extends BasicTiledImageLayer {
    public static final String LAYER_AERIAL = "gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer.Aerial";
    public static final String LAYER_ROADS = "gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer.Roads";
    public static final String LAYER_HYBRID = "gov.nasa.worldwind.layers.Earth.MSVirtualEarthLayer.Hybrid";
    private String layerName;

    public MSVirtualEarthLayer() {
        this(LAYER_AERIAL);
    }

    public MSVirtualEarthLayer(String string) {
        super(MSVirtualEarthLayer.makeLevels(string));
        this.setUseTransparentTextures(true);
        this.setUseMipMaps(true);
        this.setMaxActiveAltitude(1000000.0);
        this.layerName = string.equals(LAYER_HYBRID) ? "Hybrid" : (string.equals(LAYER_ROADS) ? "Roads" : "Aerial");
        this.setAvailableImageFormats(new String[]{"image/jpg"});
    }

    private static LevelSet makeLevels(String string) {
        String string2 = string.equals(LAYER_HYBRID) ? "h" : (string.equals(LAYER_ROADS) ? "r" : "a");
        long l = new GregorianCalendar(2009, 1, 25).getTimeInMillis();
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", "Earth/MS Virtual Earth " + string2);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", "http://worldwind28.arc.nasa.gov/vewms/vewms.aspx");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string2);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".dds");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 12);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(Angle.fromDegrees(2.25), Angle.fromDegrees(2.25)));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", Sector.FULL_SPHERE);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ExpiryTime", l);
        return new LevelSet(aVListImpl);
    }

    public String toString() {
        return "MS Virtual Earth " + this.layerName;
    }
}

