/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;

public class USGSTopographicMaps
extends BasicTiledImageLayer {
    public USGSTopographicMaps() {
        super(USGSTopographicMaps.makeLevels());
        this.setMaxActiveAltitude(7000000.0);
    }

    private static LevelSet makeLevels() {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", "Earth/USGS Topographic Maps");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", "http://worldwind25.arc.nasa.gov/tile/tile.aspx");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", "102dds");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".dds");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 9);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 2);
        Angle angle = Angle.fromDegrees(3.2);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(angle, angle));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", new Sector(Angle.fromDegrees(17.84), Angle.fromDegrees(71.55), Angle.fromDegrees(-168.67), Angle.fromDegrees(-65.15)));
        return new LevelSet(aVListImpl);
    }

    public String toString() {
        return Logging.getMessage("layers.Earth.USGSTopographicMaps.Name");
    }
}

