/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Mercator.examples;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.layers.Mercator.BasicMercatorTiledImageLayer;
import gov.nasa.worldwind.layers.Mercator.MercatorSector;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileUrlBuilder;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;

public class OSMMapnikTransparentLayer
extends BasicMercatorTiledImageLayer {
    public OSMMapnikTransparentLayer() {
        super(OSMMapnikTransparentLayer.makeLevels());
        this.setSplitScale(1.3);
    }

    private static LevelSet makeLevels() {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 256);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 256);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", "Earth/OSM-Mercator/OpenStreetMap Mapnik Transparent");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", "http://a.tile.openstreetmap.org/");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", "h");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".png");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 16);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(Angle.fromDegrees(22.5), Angle.fromDegrees(45.0)));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", new MercatorSector(-1.0, 1.0, Angle.NEG180, Angle.POS180));
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder());
        return new LevelSet(aVListImpl);
    }

    protected BufferedImage modifyImage(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                bufferedImage2.setRGB(i, j, this.convertTransparent(bufferedImage.getRGB(i, j)));
            }
        }
        return bufferedImage2;
    }

    private int convertTransparent(int n) {
        if (n == -921880 || n == -4861744) {
            return n & 0xFFFFFF;
        }
        return n;
    }

    public String toString() {
        return "OpenStreetMap Mapnik";
    }

    private static class URLBuilder
    implements TileUrlBuilder {
        private URLBuilder() {
        }

        public URL getURL(Tile tile, String string) throws MalformedURLException {
            return new URL(tile.getLevel().getService() + (tile.getLevelNumber() + 3) + "/" + tile.getColumn() + "/" + ((1 << tile.getLevelNumber() + 3) - 1 - tile.getRow()) + ".png");
        }
    }
}

