/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Mercator.examples;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.media.opengl.GL;

public class VirtualEarthLogo
implements OrderedRenderable {
    public static final String NORTHWEST = "NorthWest";
    public static final String SOUTHWEST = "SouthWest";
    public static final String NORTHEAST = "NorthEast";
    public static final String SOUTHEAST = "SouthEast";
    public static final String RESIZE_STRETCH = "Stretch";
    public static final String RESIZE_SHRINK_ONLY = "ShrinkOnly";
    public static final String RESIZE_KEEP_FIXED_SIZE = "FixedSize";
    private String iconFilePath = "logo_msve.png";
    private int iconWidth;
    private int iconHeight;
    private double iconScale = 1.0;
    private double toViewportScale = 1.0;
    private String resizeBehavior = "ShrinkOnly";
    private String position = "SouthWest";
    private int borderWidth = 20;
    private int borderHeight = 20;
    private double opacity = 0.7;

    public double getDistanceFromEye() {
        return 0.0;
    }

    public void pick(DrawContext drawContext, Point point) {
        this.drawIcon(drawContext);
    }

    public void render(DrawContext drawContext) {
        this.drawIcon(drawContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawIcon(DrawContext drawContext) {
        if (this.iconFilePath == null) {
            return;
        }
        GL gL = drawContext.getGL();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            gL.glPushAttrib(293121);
            bl = true;
            Texture texture = drawContext.getTextureCache().get(this);
            if (texture == null) {
                this.initializeTexture(drawContext);
                texture = drawContext.getTextureCache().get(this);
                if (texture == null) {
                    return;
                }
            }
            gL.glEnable(3042);
            gL.glBlendFunc(770, 1);
            gL.glDisable(2929);
            double d = this.getScaledIconWidth();
            double d2 = this.getScaledIconHeight();
            Rectangle rectangle = drawContext.getView().getViewport();
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            bl3 = true;
            gL.glLoadIdentity();
            double d3 = d > d2 ? d : d2;
            gL.glOrtho(0.0, rectangle.width, 0.0, rectangle.height, -0.6 * d3, 0.6 * d3);
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            bl2 = true;
            gL.glLoadIdentity();
            double d4 = this.computeScale(rectangle);
            Vec4 vec4 = this.computeLocation(rectangle, d4);
            gL.glTranslated(vec4.x(), vec4.y(), vec4.z());
            gL.glScaled(d4, d4, 1.0);
            gL.glScaled(d, d2, 1.0);
            if (!drawContext.isPickingMode()) {
                gL.glColor4d(1.0, 1.0, 1.0, this.getOpacity());
                gL.glEnable(3553);
                texture.bind();
                TextureCoords textureCoords = texture.getImageTexCoords();
                drawContext.drawUnitQuad(textureCoords);
            }
        }
        finally {
            if (bl3) {
                gL.glMatrixMode(5889);
                gL.glPopMatrix();
            }
            if (bl2) {
                gL.glMatrixMode(5888);
                gL.glPopMatrix();
            }
            if (bl) {
                gL.glPopAttrib();
            }
        }
    }

    private void initializeTexture(DrawContext drawContext) {
        Object object;
        Texture texture = drawContext.getTextureCache().get(this);
        if (texture != null) {
            return;
        }
        try {
            File file;
            object = this.getClass().getResourceAsStream(this.iconFilePath);
            if (object == null && (file = new File(this.iconFilePath)).exists()) {
                object = new FileInputStream(file);
            }
            texture = TextureIO.newTexture((InputStream)object, true, null);
            texture.bind();
            this.iconWidth = texture.getWidth();
            this.iconHeight = texture.getHeight();
            drawContext.getTextureCache().put(this, texture);
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("layers.IOExceptionDuringInitialization");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string, iOException);
        }
        object = drawContext.getGL();
        object.glTexEnvf(8960, 8704, 8448.0f);
        object.glTexParameteri(3553, 10241, 9987);
        object.glTexParameteri(3553, 10240, 9729);
        object.glTexParameteri(3553, 10242, 33071);
        object.glTexParameteri(3553, 10243, 33071);
    }

    private double getScaledIconWidth() {
        return (double)this.iconWidth * this.iconScale;
    }

    private double getScaledIconHeight() {
        return (double)this.iconHeight * this.iconScale;
    }

    private double computeScale(Rectangle rectangle) {
        if (this.resizeBehavior.equals(RESIZE_SHRINK_ONLY)) {
            return Math.min(1.0, this.toViewportScale * (double)rectangle.width / this.getScaledIconWidth());
        }
        if (this.resizeBehavior.equals(RESIZE_STRETCH)) {
            return this.toViewportScale * (double)rectangle.width / this.getScaledIconWidth();
        }
        if (this.resizeBehavior.equals(RESIZE_KEEP_FIXED_SIZE)) {
            return 1.0;
        }
        return 1.0;
    }

    private Vec4 computeLocation(Rectangle rectangle, double d) {
        double d2;
        double d3;
        double d4 = this.getScaledIconWidth();
        double d5 = this.getScaledIconHeight();
        double d6 = d * d4;
        double d7 = d * d5;
        if (this.position.equals(NORTHEAST)) {
            d3 = rectangle.getWidth() - d6 - (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 - (double)this.borderHeight;
        } else if (this.position.equals(SOUTHEAST)) {
            d3 = rectangle.getWidth() - d6 - (double)this.borderWidth;
            d2 = 0.0 + (double)this.borderHeight;
        } else if (this.position.equals(NORTHWEST)) {
            d3 = 0.0 + (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 - (double)this.borderHeight;
        } else if (this.position.equals(SOUTHWEST)) {
            d3 = 0.0 + (double)this.borderWidth;
            d2 = 0.0 + (double)this.borderHeight;
        } else {
            d3 = rectangle.getWidth() - d6 / 2.0 - (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 / 2.0 - (double)this.borderHeight;
        }
        return new Vec4(d3, d2, 0.0);
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        this.opacity = d;
    }
}

