/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Mercator.examples;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.layers.Mercator.BasicMercatorTiledImageLayer;
import gov.nasa.worldwind.layers.Mercator.MercatorSector;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileUrlBuilder;
import java.net.MalformedURLException;
import java.net.URL;

public class YahooMapsLayer
extends BasicMercatorTiledImageLayer {
    public YahooMapsLayer() {
        super(YahooMapsLayer.makeLevels());
        this.setSplitScale(1.3);
    }

    private static LevelSet makeLevels() {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 256);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 256);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", "Earth/Yahoo Maps Mercator");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", "http://maps.yimg.com/cv/img");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", "a");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".jpg");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 16);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(Angle.fromDegrees(22.5), Angle.fromDegrees(45.0)));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", new MercatorSector(-1.0, 1.0, Angle.NEG180, Angle.POS180));
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder());
        return new LevelSet(aVListImpl);
    }

    public String toString() {
        return "Yahoo Maps";
    }

    private static class URLBuilder
    implements TileUrlBuilder {
        private URLBuilder() {
        }

        public URL getURL(Tile tile, String string) throws MalformedURLException {
            int n = tile.getRow() - (int)Math.pow(2.0, tile.getLevelNumber() + 2);
            return new URL(tile.getLevel().getService() + "?md=200705152300" + "&x=" + tile.getColumn() + "&y=" + n + "&z=" + (15 - tile.getLevelNumber()) + "&v=1.7&t=a");
        }
    }
}

