/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.ViewControlsLayer;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class ViewControlsSelectListener
implements SelectListener {
    protected WorldWindow wwd;
    protected ViewControlsLayer viewControlsLayer;
    protected ScreenAnnotation pressedControl;
    protected String pressedControlType;
    protected Point lastPickPoint = null;
    private Timer repeatTimer;
    private int timerDelay = 50;
    private double panStep = 0.6;
    private double zoomStep = 0.8;
    private double headingStep = 1.0;
    private double pitchStep = 1.0;
    private double fovStep = 1.05;

    public ViewControlsSelectListener(WorldWindow worldWindow, ViewControlsLayer viewControlsLayer) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (viewControlsLayer == null) {
            String string = Logging.getMessage("nullValue.LayerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.viewControlsLayer = viewControlsLayer;
        this.repeatTimer = new Timer(this.timerDelay, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ViewControlsSelectListener.this.pressedControl != null) {
                    ViewControlsSelectListener.this.updateView(ViewControlsSelectListener.this.pressedControl, ViewControlsSelectListener.this.pressedControlType);
                }
            }
        });
        this.repeatTimer.start();
    }

    public void setRepeatTimerDelay(int n) {
        if (n <= 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.repeatTimer.setDelay(n);
    }

    public int getReapeatTimerDelay() {
        return this.repeatTimer.getDelay();
    }

    public void setPanIncrement(double d) {
        this.panStep = d;
    }

    public double getPanIncrement() {
        return this.panStep;
    }

    public void setZoomIncrement(double d) {
        this.zoomStep = d;
    }

    public double getZoomIncrement() {
        return this.zoomStep;
    }

    public void setHeadingIncrement(double d) {
        this.headingStep = d;
    }

    public double getHeadingIncrement() {
        return this.headingStep;
    }

    public void setPitchIncrement(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pitchStep = d;
    }

    public double getPitchIncrement() {
        return this.pitchStep;
    }

    public void setFovIncrement(double d) {
        if (d < 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.fovStep = d;
    }

    public double getFovIncrement() {
        return this.fovStep;
    }

    public void selected(SelectEvent selectEvent) {
        if (this.wwd == null) {
            return;
        }
        if (!(this.wwd.getView() instanceof OrbitView)) {
            return;
        }
        OrbitView orbitView = (OrbitView)this.wwd.getView();
        this.viewControlsLayer.highlight(null);
        if (selectEvent.getTopObject() == null || !(selectEvent.getTopObject() instanceof AVList)) {
            return;
        }
        String string = ((AVList)selectEvent.getTopObject()).getStringValue("gov.nasa.worldwind.avkey.ViewOperation");
        if (string == null) {
            return;
        }
        ScreenAnnotation screenAnnotation = (ScreenAnnotation)selectEvent.getTopObject();
        this.lastPickPoint = selectEvent.getPickPoint();
        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
            this.viewControlsLayer.highlight(screenAnnotation);
            this.wwd.redraw();
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftPress") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag") && string.equals("gov.nasa.worldwind.avkey.Pan") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag") && string.equals("gov.nasa.worldwind.avkey.ControlLook")) {
            this.pressedControl = screenAnnotation;
            this.pressedControlType = string;
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftDoubleClick") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) {
            this.pressedControl = null;
            this.resetOrbitView(orbitView);
        }
        if (this.pressedControl != null) {
            this.viewControlsLayer.highlight(this.pressedControl);
            this.wwd.redraw();
        }
    }

    protected void updateView(ScreenAnnotation screenAnnotation, String string) {
        if (this.wwd == null) {
            return;
        }
        if (!(this.wwd.getView() instanceof OrbitView)) {
            return;
        }
        OrbitView orbitView = (OrbitView)this.wwd.getView();
        orbitView.stopStateIterators();
        orbitView.stopMovement();
        if (string.equals("gov.nasa.worldwind.avkey.Pan")) {
            this.resetOrbitView(orbitView);
            Angle angle = this.computePanHeading(orbitView, screenAnnotation);
            Angle angle2 = this.computePanAmount(this.wwd.getModel().getGlobe(), orbitView, screenAnnotation, this.panStep);
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)orbitView.getCenterPosition(), angle, angle2);
            if (Math.abs(latLon.getLongitude().degrees - orbitView.getCenterPosition().getLongitude().degrees) > 20.0) {
                orbitView.setHeading(Angle.POS180.subtract(orbitView.getHeading()));
            }
            orbitView.setCenterPosition(new Position(latLon, orbitView.getCenterPosition().getElevation()));
        } else if (string.equals("gov.nasa.worldwind.avkey.ControlLook")) {
            this.setupFirstPersonView(orbitView);
            Angle angle = this.computeLookHeading(orbitView, screenAnnotation, this.headingStep);
            Angle angle3 = this.computeLookPitch(orbitView, screenAnnotation, this.pitchStep);
            Vec4 vec4 = this.computeSurfacePoint(orbitView, angle, angle3);
            if (vec4 != null) {
                Position position = orbitView.getEyePosition();
                orbitView.setHeading(angle);
                orbitView.setPitch(angle3);
                orbitView.setZoom(0.0);
                orbitView.setCenterPosition(position);
            }
        } else if (string.equals("gov.nasa.worldwind.avkey.ZoomIn")) {
            this.resetOrbitView(orbitView);
            orbitView.setZoom(this.computeNewZoom(orbitView, -this.zoomStep));
        } else if (string.equals("gov.nasa.worldwind.avkey.ZoomOut")) {
            this.resetOrbitView(orbitView);
            orbitView.setZoom(this.computeNewZoom(orbitView, this.zoomStep));
        } else if (string.equals("gov.nasa.worldwind.avkey.HeadingLeft")) {
            this.resetOrbitView(orbitView);
            orbitView.setHeading(orbitView.getHeading().addDegrees(this.headingStep));
        } else if (string.equals("gov.nasa.worldwind.avkey.HeadingRight")) {
            this.resetOrbitView(orbitView);
            orbitView.setHeading(orbitView.getHeading().addDegrees(-this.headingStep));
        } else if (string.equals("gov.nasa.worldwind.avkey.PitchUp")) {
            this.resetOrbitView(orbitView);
            if (orbitView.getPitch().degrees >= this.pitchStep) {
                orbitView.setPitch(orbitView.getPitch().addDegrees(-this.pitchStep));
            }
        } else if (string.equals("gov.nasa.worldwind.avkey.PitchDown")) {
            this.resetOrbitView(orbitView);
            if (orbitView.getPitch().degrees <= 90.0 - this.pitchStep) {
                orbitView.setPitch(orbitView.getPitch().addDegrees(this.pitchStep));
            }
        } else if (string.equals("gov.nasa.worldwind.avkey.FovNarrow")) {
            if (orbitView.getFieldOfView().degrees / this.fovStep >= 4.0) {
                orbitView.setFieldOfView(orbitView.getFieldOfView().divide(this.fovStep));
            }
        } else if (string.equals("gov.nasa.worldwind.avkey.FovWide") && orbitView.getFieldOfView().degrees * this.fovStep < 120.0) {
            orbitView.setFieldOfView(orbitView.getFieldOfView().multiply(this.fovStep));
        }
        this.wwd.redraw();
    }

    protected double computeNewZoom(OrbitView orbitView, double d) {
        double d2 = 0.05;
        double d3 = d2 * d;
        double d4 = orbitView.getZoom() != 0.0 ? Math.log(orbitView.getZoom()) : 0.0;
        return Math.exp(d4 + d3);
    }

    protected Angle computePanHeading(OrbitView orbitView, ScreenAnnotation screenAnnotation) {
        double d = (double)screenAnnotation.getAttributes().getSize().width * screenAnnotation.getAttributes().getScale();
        Vec4 vec4 = new Vec4(screenAnnotation.getScreenPoint().x, (double)screenAnnotation.getScreenPoint().y + d / 2.0, 0.0);
        double d2 = (double)this.lastPickPoint.x - vec4.x;
        double d3 = orbitView.getViewport().getHeight() - (double)this.lastPickPoint.y - vec4.y;
        Angle angle = orbitView.getHeading().add(Angle.fromRadians(Math.atan2(d2, d3)));
        angle = angle.degrees >= 0.0 ? angle : angle.addDegrees(360.0);
        return angle;
    }

    protected Angle computePanAmount(Globe globe, OrbitView orbitView, ScreenAnnotation screenAnnotation, double d) {
        double d2 = (double)screenAnnotation.getAttributes().getSize().width * screenAnnotation.getAttributes().getScale();
        Vec4 vec4 = new Vec4(screenAnnotation.getScreenPoint().x, (double)screenAnnotation.getScreenPoint().y + d2 / 2.0, 0.0);
        double d3 = (double)this.lastPickPoint.x - vec4.x;
        double d4 = orbitView.getViewport().getHeight() - (double)this.lastPickPoint.y - vec4.y;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        double d6 = Math.min(d5 / 10.0, 5.0);
        Position position = orbitView.getEyePosition();
        double d7 = globe.getRadiusAt(position);
        double d8 = 0.5 * (180.0 / (Math.PI * d7));
        double d9 = 1.0;
        double d10 = position.getElevation() / d7;
        d10 = d10 < 0.0 ? 0.0 : (d10 > 1.0 ? 1.0 : d10);
        double d11 = 2.0;
        double d12 = d8 + (d9 - d8) * ((Math.pow(d11, d10) - 1.0) / (d11 - 1.0));
        return Angle.fromDegrees(d12 * d6 * d);
    }

    protected Angle computeLookHeading(OrbitView orbitView, ScreenAnnotation screenAnnotation, double d) {
        double d2 = (double)screenAnnotation.getAttributes().getSize().width * screenAnnotation.getAttributes().getScale();
        Vec4 vec4 = new Vec4(screenAnnotation.getScreenPoint().x, (double)screenAnnotation.getScreenPoint().y + d2 / 2.0, 0.0);
        double d3 = (double)this.lastPickPoint.x - vec4.x;
        double d4 = Math.min(Math.abs(d3) / 3000.0, 5.0) * Math.signum(d3);
        Angle angle = orbitView.getHeading().add(Angle.fromRadians(d * d4));
        angle = angle.degrees >= 0.0 ? angle : angle.addDegrees(360.0);
        return angle;
    }

    protected Angle computeLookPitch(OrbitView orbitView, ScreenAnnotation screenAnnotation, double d) {
        double d2 = (double)screenAnnotation.getAttributes().getSize().width * screenAnnotation.getAttributes().getScale();
        Vec4 vec4 = new Vec4(screenAnnotation.getScreenPoint().x, (double)screenAnnotation.getScreenPoint().y + d2 / 2.0, 0.0);
        double d3 = orbitView.getViewport().getHeight() - (double)this.lastPickPoint.y - vec4.y;
        double d4 = Math.min(Math.abs(d3) / 3000.0, 5.0) * Math.signum(d3);
        Angle angle = orbitView.getPitch().add(Angle.fromRadians(d * d4));
        angle = angle.degrees >= 0.0 ? (angle.degrees <= 90.0 ? angle : Angle.fromDegrees(90.0)) : Angle.ZERO;
        return angle;
    }

    protected void resetOrbitView(OrbitView orbitView) {
        if (orbitView.getZoom() > 0.0) {
            return;
        }
        Vec4 vec4 = this.computeSurfacePoint(orbitView, orbitView.getHeading(), orbitView.getPitch());
        if (vec4 != null) {
            Vec4 vec42 = orbitView.getEyePoint();
            Position position = this.wwd.getModel().getGlobe().computePositionFromPoint(vec4);
            Vec4 vec43 = this.wwd.getModel().getGlobe().computeSurfaceNormalAtLocation(position.getLatitude(), position.getLongitude());
            Vec4 vec44 = this.wwd.getModel().getGlobe().computeNorthPointingTangentAtLocation(position.getLatitude(), position.getLongitude());
            orbitView.setPitch(Angle.POS180.subtract(orbitView.getForwardVector().angleBetween3(vec43)));
            Vec4 vec45 = orbitView.getForwardVector().perpendicularTo3(vec43);
            Angle angle = vec45.angleBetween3(vec44);
            double d = Math.signum(-vec43.cross3(vec44).dot3(vec45));
            orbitView.setHeading(angle.multiply(d));
            orbitView.setZoom(vec42.distanceTo3(vec4));
            orbitView.setCenterPosition(position);
        }
    }

    protected void setupFirstPersonView(OrbitView orbitView) {
        if (orbitView.getZoom() == 0.0) {
            return;
        }
        Vec4 vec4 = orbitView.getEyePoint();
        Position position = this.wwd.getModel().getGlobe().computePositionFromPoint(vec4);
        Vec4 vec42 = this.wwd.getModel().getGlobe().computeSurfaceNormalAtLocation(position.getLatitude(), position.getLongitude());
        Vec4 vec43 = this.wwd.getModel().getGlobe().computeNorthPointingTangentAtLocation(position.getLatitude(), position.getLongitude());
        orbitView.setPitch(Angle.POS180.subtract(orbitView.getForwardVector().angleBetween3(vec42)));
        Vec4 vec44 = orbitView.getForwardVector().perpendicularTo3(vec42);
        Angle angle = vec44.angleBetween3(vec43);
        double d = Math.signum(-vec42.cross3(vec43).dot3(vec44));
        orbitView.setHeading(angle.multiply(d));
        orbitView.setZoom(0.0);
        orbitView.setCenterPosition(position);
    }

    protected Vec4 computeSurfacePoint(OrbitView orbitView, Angle angle, Angle angle2) {
        Globe globe = this.wwd.getModel().getGlobe();
        Matrix matrix = globe.computeTransformToPosition(orbitView.getCenterPosition());
        matrix = matrix.multiply(Matrix.fromRotationZ(angle.multiply(-1.0)));
        matrix = matrix.multiply(Matrix.fromRotationX(Angle.NEG90.add(angle2)));
        Vec4 vec4 = Vec4.UNIT_Y.transformBy4(matrix);
        Intersection[] intersectionArray = this.wwd.getSceneController().getTerrain().intersect(new Line(orbitView.getEyePoint(), vec4));
        return intersectionArray != null && intersectionArray.length != 0 ? intersectionArray[0].getIntersectionPoint() : null;
    }
}

