/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.rpf;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.formats.dds.DDSCompressor;
import gov.nasa.worldwind.formats.nitfs.NITFSImageSegment;
import gov.nasa.worldwind.formats.nitfs.NITFSSegmentType;
import gov.nasa.worldwind.formats.rpf.RPFDataSeries;
import gov.nasa.worldwind.formats.rpf.RPFFile;
import gov.nasa.worldwind.formats.rpf.RPFFrameFileComponents;
import gov.nasa.worldwind.formats.rpf.RPFFrameFilename;
import gov.nasa.worldwind.formats.rpf.RPFFrameTransform;
import gov.nasa.worldwind.formats.rpf.RPFImageFile;
import gov.nasa.worldwind.formats.wvt.WaveletCodec;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.rpf.RPFFileIndex;
import gov.nasa.worldwind.layers.rpf.RPFGenerator;
import gov.nasa.worldwind.layers.rpf.RPFTiledImageLayer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.WWIO;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPFTiledImageProcessor {
    private int numThreads = -1;
    private final PropertyChangeSupport propertyChangeSupport;
    private final Object fileLock = new Object();
    private volatile boolean doStop = false;
    private static final int DEFAULT_WAVELET_SIZE = 256;
    public static final String BEGIN_SUB_TASK = "BeginSubTask";
    public static final String END_SUB_TASK = "EndSubTask";
    public static final String SUB_TASK_NUM_STEPS = "SubTaskNumSteps";
    public static final String SUB_TASK_STEP_COMPLETE = "SubTaskStepComplete";
    public static final String SUB_TASK_STEP_FAILED = "SubTaskStepFailed";

    public RPFTiledImageProcessor() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public int getThreadPoolSize() {
        return this.numThreads;
    }

    public void setThreadPoolSize(int n) {
        this.numThreads = n;
    }

    public RPFFileIndex makeFileIndex(File file, String string, String string2, Iterable<File> iterable) {
        if (file == null) {
            String string3 = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (iterable == null) {
            String string5 = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        RPFFileIndex rPFFileIndex = null;
        if (!this.doStop) {
            RPFFileIndex rPFFileIndex2 = new RPFFileIndex();
            rPFFileIndex2.getIndexProperties().setRootPath(file.getAbsolutePath());
            rPFFileIndex2.getIndexProperties().setDataSeriesIdentifier(string);
            rPFFileIndex2.getIndexProperties().setDescription(string2);
            for (File file2 : iterable) {
                rPFFileIndex2.createRPFFileRecord(file2);
            }
            int n = 256;
            int n2 = 256;
            this.processFileIndex(rPFFileIndex2, n, n2);
            rPFFileIndex2.updateBoundingSector();
            if (!this.doStop) {
                rPFFileIndex = rPFFileIndex2;
            }
        }
        return rPFFileIndex;
    }

    public Layer makeLayer(RPFFileIndex rPFFileIndex) {
        if (rPFFileIndex == null) {
            String string = "RPFFileIndex is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rPFFileIndex.getIndexProperties() == null) {
            String string = "RPFFileIndex.IndexProperties is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        RPFTiledImageLayer rPFTiledImageLayer = null;
        if (!this.doStop) {
            String string = rPFFileIndex.getIndexProperties().getRootPath();
            String string2 = rPFFileIndex.getIndexProperties().getDataSeriesIdentifier();
            File file = WorldWind.getDataFileStore().newFile(RPFTiledImageLayer.getFileIndexCachePath(string, string2));
            this.saveFileIndex(rPFFileIndex, file);
            AVListImpl aVListImpl = new AVListImpl();
            aVListImpl.setValue("rpf.RootPath", string);
            aVListImpl.setValue("rpf.DataSeriesId", string2);
            Collection<Tile> collection = RPFTiledImageLayer.createTopLevelTiles(aVListImpl);
            RPFGenerator rPFGenerator = new RPFGenerator(aVListImpl);
            this.createTiledImagery(collection, rPFGenerator);
            if (!this.doStop) {
                rPFTiledImageLayer = new RPFTiledImageLayer(aVListImpl);
            }
        }
        return rPFTiledImageLayer;
    }

    public void stop() {
        this.doStop = true;
    }

    private String makeWaveletCachePath(RPFFileIndex rPFFileIndex, long l) {
        File file;
        String string = null;
        if (rPFFileIndex != null && rPFFileIndex.getIndexProperties() != null && l != -1L && (file = rPFFileIndex.getRPFFile(l)) != null) {
            String string2 = file.getPath();
            String string3 = rPFFileIndex.getIndexProperties().getRootPath();
            int n = string2.lastIndexOf(string3);
            String string4 = string2.substring(n + string3.length(), string2.length());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(WWIO.formPath(rPFFileIndex.getIndexProperties().getRootPath(), rPFFileIndex.getIndexProperties().getDataSeriesIdentifier(), "wavelet"));
            stringBuilder.append(File.separator);
            stringBuilder.append(string4);
            stringBuilder.append(".wvt");
            string = stringBuilder.toString();
        }
        return string;
    }

    private void processFileIndex(final RPFFileIndex rPFFileIndex, final int n, final int n2) {
        RPFFileIndex.Table table = rPFFileIndex.getRPFFileTable();
        List<RPFFileIndex.Record> list = table.getRecords();
        if (list != null) {
            this.firePropertyChange(BEGIN_SUB_TASK, null, null);
            this.firePropertyChange(SUB_TASK_NUM_STEPS, null, list.size());
            ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
            for (final RPFFileIndex.Record record : list) {
                arrayList.add(new Runnable(){

                    public void run() {
                        File file = rPFFileIndex.getRPFFile(record.getKey());
                        try {
                            RPFTiledImageProcessor.this.processRecord(rPFFileIndex, record, n, n2);
                            RPFTiledImageProcessor.this.firePropertyChange(RPFTiledImageProcessor.SUB_TASK_STEP_COMPLETE, null, file.getName());
                        }
                        catch (Throwable throwable) {
                            String string = String.format("Exception while processing file: %s", file);
                            Logging.logger().log(Level.SEVERE, string, throwable);
                            RPFTiledImageProcessor.this.firePropertyChange(RPFTiledImageProcessor.SUB_TASK_STEP_FAILED, null, file.getName());
                        }
                    }
                });
            }
            if (this.numThreads > 1) {
                this.runAsynchronously(arrayList, this.numThreads, true);
            } else {
                this.run(arrayList);
            }
            this.firePropertyChange(END_SUB_TASK, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRecord(RPFFileIndex rPFFileIndex, RPFFileIndex.Record record, int n, int n2) throws IOException {
        Object object;
        Object object2;
        Comparable<Sector> comparable;
        if (rPFFileIndex == null) {
            String string = "RPFFileIndex is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (record == null) {
            String string = "RPFFileIndex.Record is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        File file = null;
        RPFImageFile rPFImageFile = null;
        if (!this.doStop && (comparable = this.getFileSector(rPFImageFile = RPFImageFile.load(file = rPFFileIndex.getRPFFile(record.getKey())))) != null) {
            ((RPFFileIndex.RPFFileRecord)record).setSector((Sector)comparable);
        }
        comparable = null;
        if (!this.doStop) {
            object2 = this.fileLock;
            synchronized (object2) {
                object = this.makeWaveletCachePath(rPFFileIndex, record.getKey());
                comparable = WorldWind.getDataFileStore().newFile((String)object);
            }
            if (comparable != null) {
                rPFFileIndex.createWaveletRecord((File)comparable, record.getKey());
            }
        }
        object2 = null;
        if (!this.doStop) {
            if (comparable != null && file != null && file.lastModified() > ((File)comparable).lastModified()) {
                object = rPFImageFile.getBufferedImage();
                if ((object = this.deproject(file, (BufferedImage)object)) != null) {
                    object2 = this.createWavelet((BufferedImage)object, n, n2);
                    object = null;
                }
            }
            rPFImageFile = null;
        }
        if (!this.doStop && object2 != null) {
            object = WaveletCodec.save((WaveletCodec)object2);
            if (object != null) {
                WWIO.saveBuffer((ByteBuffer)object, (File)comparable);
                object = null;
            }
            object2 = null;
        }
    }

    private WaveletCodec createWavelet(BufferedImage bufferedImage, int n, int n2) {
        int n3;
        switch (bufferedImage.getType()) {
            case 10: {
                n3 = 10;
                break;
            }
            case 1: 
            case 4: {
                n3 = 5;
                break;
            }
            case 2: {
                n3 = 6;
                break;
            }
            default: {
                n3 = 5;
            }
        }
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, n3);
        this.scaleImage(bufferedImage, bufferedImage2);
        return WaveletCodec.encode(bufferedImage2);
    }

    private BufferedImage scaleImage(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        double d = (double)bufferedImage2.getWidth() / (double)bufferedImage.getWidth();
        double d2 = (double)bufferedImage2.getHeight() / (double)bufferedImage.getHeight();
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.scale(d, d2);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        return bufferedImage2;
    }

    private Sector getFileSector(RPFFile rPFFile) {
        Sector sector = null;
        if (rPFFile != null) {
            File file = rPFFile.getFile();
            if (file != null) {
                sector = this.sectorFromFilename(file);
            }
            if (sector == null) {
                sector = this.sectorFromHeader(rPFFile);
            }
        }
        return sector;
    }

    private Sector sectorFromHeader(RPFFile rPFFile) {
        Sector sector = null;
        try {
            if (rPFFile != null) {
                Angle angle;
                NITFSImageSegment nITFSImageSegment = (NITFSImageSegment)rPFFile.getNITFSSegment(NITFSSegmentType.IMAGE_SEGMENT);
                RPFFrameFileComponents rPFFrameFileComponents = nITFSImageSegment.getUserDefinedImageSubheader().getRPFFrameFileComponents();
                Angle angle2 = rPFFrameFileComponents.swLowerleft.getLatitude();
                Angle angle3 = rPFFrameFileComponents.neUpperRight.getLatitude();
                Angle angle4 = rPFFrameFileComponents.swLowerleft.getLongitude();
                if (Angle.crossesLongitudeBoundary(angle4, angle = rPFFrameFileComponents.neUpperRight.getLongitude()) && angle4.compareTo(angle) > 0) {
                    double d = 360.0 + angle.degrees;
                    angle = Angle.fromDegrees(d);
                }
                sector = new Sector(angle2, angle3, angle4, angle);
            }
        }
        catch (Exception exception) {
            String string = String.format("Exception while getting file sector: %s", rPFFile != null ? rPFFile.getFile() : "");
            Logging.logger().log(Level.SEVERE, string, exception);
            sector = null;
        }
        return sector;
    }

    private Sector sectorFromFilename(File file) {
        Sector sector = null;
        try {
            if (file != null && file.getName() != null) {
                RPFFrameFilename rPFFrameFilename = RPFFrameFilename.parseFilename(file.getName().toUpperCase());
                RPFDataSeries rPFDataSeries = RPFDataSeries.dataSeriesFor(rPFFrameFilename.getDataSeriesCode());
                RPFFrameTransform rPFFrameTransform = RPFFrameTransform.createFrameTransform(rPFFrameFilename.getZoneCode(), rPFDataSeries.rpfDataType, rPFDataSeries.scaleOrGSD);
                sector = rPFFrameTransform.computeFrameCoverage(rPFFrameFilename.getFrameNumber());
            }
        }
        catch (Exception exception) {
            String string = String.format("Exception while computing file sector: %s", file);
            Logging.logger().log(Level.SEVERE, string, exception);
            sector = null;
        }
        return sector;
    }

    private boolean isPolarFile(File file) {
        boolean bl = false;
        try {
            RPFFrameFilename rPFFrameFilename;
            char c;
            if (file != null && file.getName() != null && ((c = (rPFFrameFilename = RPFFrameFilename.parseFilename(file.getName().toUpperCase())).getZoneCode()) == '9' || c == 'J')) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void createTiledImagery(Collection<Tile> collection, RPFGenerator rPFGenerator) {
        this.firePropertyChange(BEGIN_SUB_TASK, null, null);
        this.firePropertyChange(SUB_TASK_NUM_STEPS, null, collection.size());
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
        final RPFGenerator.RPFServiceInstance rPFServiceInstance = rPFGenerator.getServiceInstance();
        for (final Tile tile : collection) {
            arrayList.add(new Runnable(){

                public void run() {
                    try {
                        RPFTiledImageProcessor.this.createTileImage(tile, rPFServiceInstance);
                        RPFTiledImageProcessor.this.firePropertyChange(RPFTiledImageProcessor.SUB_TASK_STEP_COMPLETE, null, tile.getPath());
                    }
                    catch (Throwable throwable) {
                        String string = String.format("Exception while processing image: %s", tile.getPath());
                        Logging.logger().log(Level.SEVERE, string, throwable);
                        RPFTiledImageProcessor.this.firePropertyChange(RPFTiledImageProcessor.SUB_TASK_STEP_FAILED, null, tile.getPath());
                    }
                }
            });
        }
        if (this.numThreads > 1) {
            this.runAsynchronously(arrayList, this.numThreads, true);
        } else {
            this.run(arrayList);
        }
        this.firePropertyChange(END_SUB_TASK, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTileImage(Tile tile, RPFGenerator.RPFServiceInstance rPFServiceInstance) throws Exception {
        Object object;
        Object object2;
        if (tile == null) {
            String string = "Tile is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rPFServiceInstance == null) {
            String string = "RPFGenerator.RPFServiceInstance is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        File file = null;
        if (!this.doStop) {
            object2 = this.fileLock;
            synchronized (object2) {
                file = WorldWind.getDataFileStore().newFile(tile.getPath());
            }
        }
        object2 = null;
        if (!this.doStop && (object = tile.getResourceURL()) != null) {
            object2 = rPFServiceInstance.serviceRequest((URL)object);
        }
        if (!this.doStop && object2 != null && (object = DDSCompressor.compressImage((BufferedImage)object2)) != null && file != null) {
            WWIO.saveBuffer((ByteBuffer)object, file);
        }
    }

    private void saveFileIndex(RPFFileIndex rPFFileIndex, File file) {
        try {
            ByteBuffer byteBuffer = null;
            if (rPFFileIndex != null) {
                byteBuffer = rPFFileIndex.save();
            }
            if (byteBuffer != null && file != null) {
                WWIO.saveBuffer(byteBuffer, file);
            }
        }
        catch (Exception exception) {
            String string = String.format("Exception while saving RPFFileIndex: %s", file);
            Logging.logger().log(Level.SEVERE, string, exception);
        }
    }

    private BufferedImage deproject(File file, BufferedImage bufferedImage) {
        RPFFrameFilename rPFFrameFilename = RPFFrameFilename.parseFilename(file.getName().toUpperCase());
        RPFDataSeries rPFDataSeries = RPFDataSeries.dataSeriesFor(rPFFrameFilename.getDataSeriesCode());
        RPFFrameTransform rPFFrameTransform = RPFFrameTransform.createFrameTransform(rPFFrameFilename.getZoneCode(), rPFDataSeries.rpfDataType, rPFDataSeries.scaleOrGSD);
        RPFFrameTransform.RPFImage[] rPFImageArray = rPFFrameTransform.deproject(rPFFrameFilename.getFrameNumber(), bufferedImage);
        if (rPFImageArray.length == 1) {
            return rPFImageArray[0].getImage();
        }
        BufferedImage bufferedImage2 = rPFImageArray[0].getImage();
        BufferedImage bufferedImage3 = rPFImageArray[1].getImage();
        BufferedImage bufferedImage4 = new BufferedImage(bufferedImage2.getWidth() + bufferedImage3.getWidth(), bufferedImage2.getHeight(), 6);
        Graphics2D graphics2D = (Graphics2D)bufferedImage4.getGraphics();
        graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
        graphics2D.drawImage((Image)bufferedImage3, bufferedImage2.getWidth(), 0, null);
        return bufferedImage4;
    }

    private void run(Iterable<Runnable> iterable) {
        try {
            if (iterable != null) {
                for (Runnable runnable : iterable) {
                    if (this.doStop) continue;
                    runnable.run();
                }
            }
        }
        catch (Exception exception) {
            String string = "Exception while executing tasks";
            Logging.logger().log(Level.SEVERE, string, exception);
        }
    }

    private void runAsynchronously(Iterable<Runnable> iterable, int n, boolean bl) {
        try {
            if (iterable != null) {
                ExecutorService executorService = Executors.newFixedThreadPool(n);
                for (Runnable runnable : iterable) {
                    if (this.doStop || runnable == null) continue;
                    executorService.submit(runnable);
                }
                executorService.shutdown();
                while (bl && !executorService.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                }
            }
        }
        catch (Exception exception) {
            String string = "Exception while executing tasks";
            Logging.logger().log(Level.SEVERE, string, exception);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }
}

