/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfaceObject;
import gov.nasa.worldwind.util.Logging;

public abstract class AbstractSurfaceObject
implements SurfaceObject {
    protected boolean visible = true;
    protected long lastModifiedTime;

    public AbstractSurfaceObject() {
        this.updateModifiedTime();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        this.updateModifiedTime();
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void renderToRegion(DrawContext drawContext, Sector sector, int n, int n2, int n3, int n4) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        this.doRenderToRegion(drawContext, sector, n, n2, n3, n4);
    }

    protected abstract void doRenderToRegion(DrawContext var1, Sector var2, int var3, int var4, int var5, int var6);

    protected void updateModifiedTime() {
        this.lastModifiedTime = System.currentTimeMillis();
    }
}

