/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.AbstractSurfaceObject;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.SurfaceShapeSupport;
import gov.nasa.worldwind.render.TiledSurfaceObjectRenderer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.measure.AreaMeasurer;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSurfaceShape
extends AbstractSurfaceObject
implements SurfaceShape,
Movable {
    protected static final String DEFAULT_PATH_TYPE = "gov.nasa.worldwind.avkey.GreatCircle";
    protected static final int DEFAULT_TEXELS_PER_EDGE_INTERVAL = 50;
    protected static final int DEFAULT_MIN_EDGE_INTERVALS = 0;
    protected static final int DEFAULT_MAX_EDGE_INTERVALS = 100;
    private ShapeAttributes attributes;
    private PropertyChangeListener attributeChangeListener;
    protected String pathType;
    protected double texelsPerEdgeInterval;
    protected int minEdgeIntervals;
    protected int maxEdgeIntervals;
    protected boolean showBoundingSectors = false;
    private static SurfaceShapeSupport surfaceShapeSupport;
    protected TiledSurfaceObjectRenderer renderer;
    protected Map<Object, DrawLocationInfo> drawLocationMap;
    protected AreaMeasurer areaMeasurer;
    protected long areaMeasurerLastModifiedTime;

    public AbstractSurfaceShape(ShapeAttributes shapeAttributes) {
        if (shapeAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setAttributes(shapeAttributes);
        this.setPathType(DEFAULT_PATH_TYPE);
        this.setTexelsPerEdgeInterval(50.0);
        this.setMinAndMaxEdgeIntervals(0, 100);
        this.drawLocationMap = new HashMap<Object, DrawLocationInfo>();
    }

    public AbstractSurfaceShape() {
        this(new BasicShapeAttributes());
    }

    @Override
    public ShapeAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(ShapeAttributes shapeAttributes) {
        if (shapeAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.attributes != null && this.attributeChangeListener != null) {
            this.attributes.removePropertyChangeListener(this.attributeChangeListener);
        }
        this.attributes = shapeAttributes;
        if (this.attributes != null) {
            this.attributeChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    AbstractSurfaceShape.this.onShapeChanged();
                }
            };
            this.attributes.addPropertyChangeListener(this.attributeChangeListener);
        }
        this.onShapeChanged();
    }

    @Override
    public String getPathType() {
        return this.pathType;
    }

    @Override
    public void setPathType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PathTypeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.pathType = string;
        this.onShapeChanged();
    }

    @Override
    public double getTexelsPerEdgeInterval() {
        return this.texelsPerEdgeInterval;
    }

    @Override
    public void setTexelsPerEdgeInterval(double d) {
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "texelsPerEdgeInterval <= 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.texelsPerEdgeInterval = d;
        this.onShapeChanged();
    }

    @Override
    public int[] getMinAndMaxEdgeIntervals() {
        return new int[]{this.minEdgeIntervals, this.maxEdgeIntervals};
    }

    @Override
    public void setMinAndMaxEdgeIntervals(int n, int n2) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "minEdgeIntervals < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "maxEdgeIntervals < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minEdgeIntervals = n;
        this.maxEdgeIntervals = n2;
        this.onShapeChanged();
    }

    public boolean isShowBoundingSectors() {
        return this.showBoundingSectors;
    }

    public void setShowBoundingSectors(boolean bl) {
        this.showBoundingSectors = bl;
        this.onShapeChanged();
    }

    @Override
    public Iterable<? extends LatLon> getLocations(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        this.computeLocations(globe, arrayList);
        return arrayList;
    }

    @Override
    public Iterable<? extends Sector> getSectors(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterable<? extends LatLon> iterable = this.getLocations(drawContext.getGlobe());
        Iterable<? extends Sector> iterable2 = AbstractSurfaceShape.getSurfaceShapeSupport().computeBoundingSectors(iterable, this.pathType);
        iterable2 = AbstractSurfaceShape.getSurfaceShapeSupport().adjustSectorsByBorderWidth(iterable2, this.getAttributes());
        return iterable2;
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        this.getRenderer().preRender(drawContext);
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        this.getRenderer().render(drawContext);
    }

    @Override
    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    @Override
    public double getArea(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        AreaMeasurer areaMeasurer = this.setupAreaMeasurer(globe);
        return areaMeasurer.getArea(globe);
    }

    @Override
    public double getArea(Globe globe, boolean bl) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        AreaMeasurer areaMeasurer = this.setupAreaMeasurer(globe);
        areaMeasurer.setFollowTerrain(bl);
        return areaMeasurer.getArea(globe);
    }

    @Override
    public double getPerimeter(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        AreaMeasurer areaMeasurer = this.setupAreaMeasurer(globe);
        return areaMeasurer.getPerimeter(globe);
    }

    @Override
    public double getWidth(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        AreaMeasurer areaMeasurer = this.setupAreaMeasurer(globe);
        return areaMeasurer.getWidth(globe);
    }

    @Override
    public double getHeight(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        AreaMeasurer areaMeasurer = this.setupAreaMeasurer(globe);
        return areaMeasurer.getHeight(globe);
    }

    @Override
    public double getLength(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        AreaMeasurer areaMeasurer = this.setupAreaMeasurer(globe);
        return areaMeasurer.getLength(globe);
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.moveTo(position2.add(position));
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.doMoveTo(position2, position);
    }

    @Override
    public abstract Position getReferencePosition();

    protected abstract void doMoveTo(Position var1, Position var2);

    protected abstract void computeLocations(Globe var1, List<LatLon> var2);

    protected abstract void computeDrawLocations(Globe var1, double var2, List<LatLon> var4);

    protected void onShapeChanged() {
        this.updateModifiedTime();
    }

    protected static SurfaceShapeSupport getSurfaceShapeSupport() {
        if (surfaceShapeSupport == null) {
            surfaceShapeSupport = new SurfaceShapeSupport();
        }
        return surfaceShapeSupport;
    }

    protected double computeEdgeIntervalsPerDegree(DrawContext drawContext, Sector sector, int n, int n2, int n3, int n4) {
        double d = Math.max((double)n3 / sector.getDeltaLonDegrees(), (double)n4 / sector.getDeltaLatDegrees());
        double d2 = 1.0 / this.getTexelsPerEdgeInterval();
        return d2 * d;
    }

    protected List<? extends LatLon> getDrawLocations(DrawContext drawContext, double d) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        DrawLocationKey drawLocationKey = new DrawLocationKey(this, d);
        DrawLocationInfo drawLocationInfo = this.getCachedDrawLocations(drawLocationKey);
        if (drawLocationInfo == null) {
            drawLocationInfo = new DrawLocationInfo();
        }
        if (drawLocationInfo.getLastModifiedTime() < this.getLastModifiedTime()) {
            drawLocationInfo.getLocations().clear();
            this.computeDrawLocations(drawContext.getGlobe(), d, drawLocationInfo.getLocations());
            drawLocationInfo.setLastModifiedTime(this.getLastModifiedTime());
            this.putCachedDrawLocations(drawLocationKey, drawLocationInfo);
        }
        return drawLocationInfo.getLocations();
    }

    protected List<? extends LatLon> getDrawLocations(DrawContext drawContext, Sector sector, int n, int n2, int n3, int n4) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.computeEdgeIntervalsPerDegree(drawContext, sector, n, n2, n3, n4);
        return this.getDrawLocations(drawContext, d);
    }

    protected DrawLocationInfo getCachedDrawLocations(DrawLocationKey drawLocationKey) {
        return this.drawLocationMap.get(drawLocationKey);
    }

    protected void putCachedDrawLocations(DrawLocationKey drawLocationKey, DrawLocationInfo drawLocationInfo) {
        this.drawLocationMap.put(drawLocationKey, drawLocationInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawBoundingSectors(DrawContext drawContext, Sector sector, int n, int n2, int n3, int n4) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        SurfaceShapeSupport surfaceShapeSupport = AbstractSurfaceShape.getSurfaceShapeSupport();
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>();
        surfaceShapeSupport.beginRendering(drawContext);
        try {
            surfaceShapeSupport.applyMaterialState(drawContext, Material.GREEN, 1.0);
            for (Sector sector2 : this.getSectors(drawContext)) {
                arrayList.clear();
                surfaceShapeSupport.assembleShapeVertices(sector, n, n2, n3, n4, sector2, arrayList);
                surfaceShapeSupport.bindVertexData(drawContext, 2, arrayList);
                surfaceShapeSupport.drawArrays(drawContext, 2, 0, arrayList.size());
            }
        }
        finally {
            surfaceShapeSupport.endRendering(drawContext);
        }
    }

    protected TiledSurfaceObjectRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new TiledSurfaceObjectRenderer();
            this.renderer.setPickEnabled(false);
            this.renderer.setSurfaceObjects(Arrays.asList(this));
        }
        return this.renderer;
    }

    protected AreaMeasurer setupAreaMeasurer(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.areaMeasurer == null) {
            this.areaMeasurer = new AreaMeasurer();
        }
        if (this.areaMeasurerLastModifiedTime < this.getLastModifiedTime()) {
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            this.computeLocations(globe, arrayList);
            this.areaMeasurer.setPositions(arrayList, 0.0);
            this.areaMeasurerLastModifiedTime = this.getLastModifiedTime();
        }
        this.areaMeasurer.setFollowTerrain(true);
        return this.areaMeasurer;
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        restorableSupport.addStateValueAsBoolean(stateObject, "visible", this.isVisible());
        restorableSupport.addStateValueAsString(stateObject, "pathType", this.getPathType());
        restorableSupport.addStateValueAsDouble(stateObject, "texelsPerEdgeInterval", this.getTexelsPerEdgeInterval());
        int[] nArray = this.getMinAndMaxEdgeIntervals();
        restorableSupport.addStateValueAsInteger(stateObject, "minEdgeIntervals", nArray[0]);
        restorableSupport.addStateValueAsInteger(stateObject, "maxEdgeIntervals", nArray[1]);
        this.attributes.getRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "attributes"));
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        RestorableSupport.StateObject stateObject2;
        Integer n;
        Object object;
        String string;
        this.legacyRestoreState(restorableSupport, stateObject);
        Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "visible");
        if (bl != null) {
            this.setVisible(bl);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "pathType")) != null && (object = this.pathTypeFromString(string)) != null) {
            this.setPathType((String)object);
        }
        if ((object = restorableSupport.getStateValueAsDouble(stateObject, "texelsPerEdgeInterval")) != null) {
            this.setTexelsPerEdgeInterval((Double)object);
        }
        int[] nArray = this.getMinAndMaxEdgeIntervals();
        Integer n2 = restorableSupport.getStateValueAsInteger(stateObject, "minEdgeIntervals");
        if (n2 != null) {
            nArray[0] = n2;
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "maxEdgeIntervals")) != null) {
            nArray[1] = n;
        }
        if (n2 != null || n != null) {
            this.setMinAndMaxEdgeIntervals(nArray[0], nArray[1]);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "attributes")) != null) {
            this.getAttributes().restoreState(restorableSupport, stateObject2);
        }
    }

    protected void legacyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Boolean bl;
        Double d;
        Color color = restorableSupport.getStateValueAsColor(stateObject, "color");
        if (color != null) {
            this.getAttributes().setInteriorMaterial(new Material(color));
        }
        if ((color = restorableSupport.getStateValueAsColor(stateObject, "borderColor")) != null) {
            this.getAttributes().setOutlineMaterial(new Material(color));
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "lineWidth")) != null) {
            this.getAttributes().setOutlineWidth(d);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "drawBorder")) != null) {
            this.getAttributes().setDrawOutline(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "drawInterior")) != null) {
            this.getAttributes().setDrawInterior(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "antialias")) != null) {
            this.getAttributes().setEnableAntialiasing(bl);
        }
    }

    protected String pathTypeFromString(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(DEFAULT_PATH_TYPE)) {
            return DEFAULT_PATH_TYPE;
        }
        if (string.equals("gov.nasa.worldwind.avkey.Linear")) {
            return "gov.nasa.worldwind.avkey.Linear";
        }
        if (string.equals("gov.nasa.worldwind.avkey.Loxodrome")) {
            return "gov.nasa.worldwind.avkey.Loxodrome";
        }
        if (string.equals("gov.nasa.worldwind.avkey.RhumbLine")) {
            return "gov.nasa.worldwind.avkey.RhumbLine";
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DrawLocationInfo {
        protected long lastModifiedTime;
        protected List<LatLon> locationList;

        public DrawLocationInfo(List<LatLon> list) {
            this.locationList = list;
        }

        public DrawLocationInfo() {
            this(new ArrayList<LatLon>());
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public void setLastModifiedTime(long l) {
            this.lastModifiedTime = l;
        }

        public List<LatLon> getLocations() {
            return this.locationList;
        }
    }

    protected static class DrawLocationKey {
        protected Object owner;
        protected double edgeIntervalsPerDegree;

        public DrawLocationKey(Object object, double d) {
            this.owner = object;
            this.edgeIntervalsPerDegree = d;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DrawLocationKey drawLocationKey = (DrawLocationKey)object;
            if (Double.compare(this.edgeIntervalsPerDegree, drawLocationKey.edgeIntervalsPerDegree) != 0) {
                return false;
            }
            return !(this.owner != null ? !this.owner.equals(drawLocationKey.owner) : drawLocationKey.owner != null);
        }

        public int hashCode() {
            long l = this.edgeIntervalsPerDegree != 0.0 ? Double.doubleToLongBits(this.edgeIntervalsPerDegree) : 0L;
            int n = (int)(l ^ l >>> 32);
            n = 31 * n + (this.owner != null ? this.owner.hashCode() : 0);
            return n;
        }
    }
}

