/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.ConformingPolygon;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Color;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConformingEllipticalPolygon
extends ConformingPolygon {
    private LatLon center;
    private double semiMajorAxisLength;
    private double semiMinorAxisLength;
    private Angle orientation;
    private int intervals;

    public ConformingEllipticalPolygon(Globe globe, LatLon latLon, double d, double d2, Angle angle, int n) {
        super(globe, ConformingEllipticalPolygon.makePositions(globe, latLon, d, d2, angle, n), null, null, false);
        this.center = latLon;
        this.semiMajorAxisLength = d;
        this.semiMinorAxisLength = d2;
        this.orientation = angle;
        this.intervals = n;
    }

    public ConformingEllipticalPolygon(Globe globe, LatLon latLon, double d, double d2, Angle angle, int n, Color color, Color color2) {
        super(globe, ConformingEllipticalPolygon.makePositions(globe, latLon, d, d2, angle, n), color, color2, false);
        this.center = latLon;
        this.semiMajorAxisLength = d;
        this.semiMinorAxisLength = d2;
        this.orientation = angle;
        this.intervals = n;
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsDouble(stateObject, "semiMajorAxisLength", this.getSemiMajorAxisLength());
        restorableSupport.addStateValueAsDouble(stateObject, "semiMinorAxisLength", this.getSemiMinorAxisLength());
        restorableSupport.addStateValueAsLatLon(stateObject, "center", this.getCenter());
        restorableSupport.addStateValueAsInteger(stateObject, "intervals", this.getIntervals());
        restorableSupport.addStateValueAsDouble(stateObject, "orientationDegrees", this.getOrientation().degrees);
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        Integer n;
        LatLon latLon;
        super.doRestoreState(restorableSupport, stateObject);
        Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "semiMajorAxisLength");
        Double d3 = restorableSupport.getStateValueAsDouble(stateObject, "semiMinorAxisLength");
        if (d2 != null && d3 != null) {
            this.setAxisLengths(d2, d3);
        }
        if ((latLon = restorableSupport.getStateValueAsLatLon(stateObject, "center")) != null) {
            this.setCenter(latLon);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "intervals")) != null) {
            this.setIntervals(n);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "orientationDegrees")) != null) {
            this.setOrientation(Angle.fromDegrees(d));
        }
    }

    public LatLon getCenter() {
        return this.center;
    }

    public void setCenter(LatLon latLon) {
        this.center = latLon;
        this.setOriginalVertices(ConformingEllipticalPolygon.makePositions(this.globe, this.center, this.semiMajorAxisLength, this.semiMajorAxisLength, this.orientation, this.intervals));
    }

    public double getSemiMajorAxisLength() {
        return this.semiMajorAxisLength;
    }

    public double getSemiMinorAxisLength() {
        return this.semiMinorAxisLength;
    }

    public void setAxisLengths(double d, double d2) {
        this.semiMajorAxisLength = d;
        this.semiMinorAxisLength = d2;
        this.setOriginalVertices(ConformingEllipticalPolygon.makePositions(this.globe, this.center, this.semiMajorAxisLength, this.semiMinorAxisLength, this.orientation, this.intervals));
    }

    public Angle getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Angle angle) {
        this.orientation = angle;
        this.setOriginalVertices(ConformingEllipticalPolygon.makePositions(this.globe, this.center, this.semiMajorAxisLength, this.semiMinorAxisLength, this.orientation, this.intervals));
    }

    public int getIntervals() {
        return this.intervals;
    }

    public void setIntervals(int n) {
        this.intervals = n;
        this.setOriginalVertices(ConformingEllipticalPolygon.makePositions(this.globe, this.center, this.semiMajorAxisLength, this.semiMinorAxisLength, this.orientation, this.intervals));
    }

    public static Iterable<LatLon> makePositions(Globe globe, LatLon latLon, double d, double d2, Angle angle, int n) {
        if (angle == null) {
            angle = Angle.ZERO;
        }
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = Logging.getMessage("Geom.MajorAxisInvalid", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = Logging.getMessage("Geom.MajorAxisInvalid", d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = 1 + Math.max(n, 4);
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        double d3 = globe.getRadiusAt(latLon.getLatitude(), latLon.getLongitude());
        double d4 = Math.PI * 2 / (double)(n2 - 1);
        for (int i = 0; i < n2; ++i) {
            double d5 = i != n2 - 1 ? (double)i * d4 : 0.0;
            double d6 = d * Math.cos(d5);
            double d7 = d2 * Math.sin(d5);
            double d8 = Math.sqrt(d6 * d6 + d7 * d7);
            double d9 = 1.5707963267948966 - (Math.acos(d6 / d8) * Math.signum(d7) + angle.radians);
            LatLon latLon2 = LatLon.greatCircleEndPosition(latLon, d9, d8 / d3);
            arrayList.add(latLon2);
        }
        return arrayList;
    }
}

