/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.ConformingShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.terrain.SectorGeometry;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.measure.AreaMeasurer;
import java.awt.Color;
import java.util.ArrayList;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConformingPolygon
extends ConformingShape {
    private ArrayList<LatLon> originalVertices = new ArrayList();
    private ArrayList<ConvexPartition> partitions = new ArrayList();
    private boolean rebuildPartitions = true;
    protected Globe globe;
    private boolean tessellateContour;
    private AreaMeasurer areaMeasurer = null;
    private static double constantLatitudeToleranceInDegrees = 1.0E-4;
    private static double constantLatitudeToleranceInRadians = Math.toRadians(constantLatitudeToleranceInDegrees);
    private static GLU glu = new GLU();

    public ConformingPolygon(Globe globe, Iterable<? extends LatLon> iterable) {
        this(globe, iterable, null, null);
    }

    public ConformingPolygon(Globe globe, Iterable<? extends LatLon> iterable, Color color, Color color2) {
        this(globe, iterable, color, color2, true);
    }

    protected ConformingPolygon(Globe globe, Iterable<? extends LatLon> iterable, Color color, Color color2, boolean bl) {
        super(color, color2);
        this.globe = globe;
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.tessellateContour = bl;
        this.setOriginalVertices(iterable);
    }

    private boolean externalEdge(ConvexPartition convexPartition, Vec4 vec4, Vec4 vec42) {
        if (this.partitions.size() == 1) {
            return true;
        }
        double d = Math.max(vec4.x, Math.max(vec4.y, vec4.z));
        d = Math.max(d, Math.max(vec42.x, Math.max(vec42.y, vec42.z)));
        double d2 = 1.0E-5 * d;
        for (ConvexPartition convexPartition2 : this.partitions) {
            if (convexPartition2 == convexPartition) continue;
            boolean bl = true;
            for (Plane plane : convexPartition2.boundingPlanes) {
                if (!(plane.dot(vec4) > d2) && !(plane.dot(vec42) > d2)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public Position getReferencePosition() {
        return new Position(this.originalVertices.get(0), 0.0);
    }

    @Override
    protected void invalidateCache() {
        MemoryCache memoryCache = WorldWind.getMemoryCache(CONFORMINGSHAPE_CACHE_KEY);
        for (ConvexPartition convexPartition : this.partitions) {
            memoryCache.remove(new ConformingShape.CacheKey(this.getClass(), convexPartition.getSector(), convexPartition.serialNumber));
        }
        this.areaMeasurer = null;
    }

    @Override
    public void moveTo(Position position) {
        this.invalidateCache();
        Position position2 = this.getReferencePosition();
        for (int i = 0; i < this.originalVertices.size(); ++i) {
            LatLon object = this.originalVertices.get(i);
            double d = LatLon.greatCircleDistance((LatLon)position2, (LatLon)object).radians;
            double d2 = LatLon.greatCircleAzimuth((LatLon)position2, (LatLon)object).radians;
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, d2, d);
            this.originalVertices.set(i, latLon);
        }
        for (ConvexPartition convexPartition : this.partitions) {
            convexPartition.update(this.globe, this.originalVertices);
        }
    }

    @Override
    protected boolean renderInterior(DrawContext drawContext, GL gL) {
        if (this.globe == null) {
            this.globe = drawContext.getGlobe();
        }
        if (this.rebuildPartitions) {
            this.createPartitions();
        }
        float[] fArray = new float[4];
        MemoryCache memoryCache = WorldWind.getMemoryCache(CONFORMINGSHAPE_CACHE_KEY);
        boolean bl = false;
        if (this.drawInterior || this.drawBorder) {
            for (ConvexPartition convexPartition : this.partitions) {
                ConformingShape.CacheKey cacheKey = new ConformingShape.CacheKey(this.getClass(), convexPartition.getSector(), convexPartition.serialNumber);
                CachedShapeDescription cachedShapeDescription = (CachedShapeDescription)memoryCache.getObject(cacheKey);
                ArrayList<SectorGeometry.ExtractedShapeDescription> arrayList = null;
                if (cachedShapeDescription != null) {
                    arrayList = cachedShapeDescription.esdL;
                }
                if (arrayList == null || this.isExpired(drawContext)) {
                    if (arrayList != null) {
                        memoryCache.remove(cacheKey);
                        arrayList = null;
                    }
                    Plane[] planeArray = convexPartition.getBoundingPlanes();
                    Sector[] sectorArray = convexPartition.getSector();
                    for (Vec4[] vec4Array : drawContext.getSurfaceGeometry()) {
                        boolean bl2 = false;
                        Object object = sectorArray;
                        int n = ((Sector[])object).length;
                        for (int i = 0; i < n; ++i) {
                            Sector sector = object[i];
                            if (!vec4Array.getSector().intersects(sector)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2 || (object = vec4Array.getIntersectingTessellationPieces(planeArray)) == null) continue;
                        if (arrayList == null) {
                            arrayList = new ArrayList(4);
                        }
                        arrayList.add((SectorGeometry.ExtractedShapeDescription)object);
                        bl = true;
                    }
                    if (arrayList != null) {
                        memoryCache.add(cacheKey, new CachedShapeDescription(arrayList), ConformingPolygon.sizeInBytesOf(arrayList));
                    }
                }
                if (arrayList == null || !this.drawInterior) continue;
                for (SectorGeometry.ExtractedShapeDescription extractedShapeDescription : arrayList) {
                    for (Vec4[] vec4Array : extractedShapeDescription.interiorPolys) {
                        if (!drawContext.isPickingMode()) {
                            gL.glColor4fv(this.fillColor.getComponents(fArray), 0);
                        }
                        gL.glBegin(9);
                        for (Vec4 vec4 : vec4Array) {
                            gL.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
                        }
                        gL.glEnd();
                    }
                }
            }
            this.updateExpiryCriteria(drawContext);
        }
        return bl;
    }

    @Override
    protected void renderBoundary(DrawContext drawContext, GL gL, boolean bl) {
        if (this.globe == null) {
            this.globe = drawContext.getGlobe();
        }
        if (this.rebuildPartitions) {
            this.createPartitions();
        }
        if (!bl) {
            for (ConvexPartition object : this.partitions) {
                Sector[] sectorArray = object.getSector();
                for (Object object2 : drawContext.getSurfaceGeometry()) {
                    for (Object object3 : sectorArray) {
                        if (!object2.getSector().intersects((Sector)object3)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    break;
                }
                if (!bl) continue;
                break;
            }
        }
        if (this.drawBorder && bl) {
            Object object4 = new float[4];
            if (!drawContext.isPickingMode()) {
                gL.glColor4fv(this.borderColor.getComponents((float[])object4), 0);
            }
            MemoryCache memoryCache = WorldWind.getMemoryCache(CONFORMINGSHAPE_CACHE_KEY);
            for (ConvexPartition convexPartition : this.partitions) {
                Object object2;
                object2 = new ConformingShape.CacheKey(this.getClass(), convexPartition.getSector(), convexPartition.serialNumber);
                CachedShapeDescription cachedShapeDescription = (CachedShapeDescription)memoryCache.getObject(object2);
                ArrayList<SectorGeometry.ExtractedShapeDescription> arrayList = null;
                if (cachedShapeDescription != null) {
                    arrayList = cachedShapeDescription.esdL;
                }
                if (arrayList == null) continue;
                for (SectorGeometry.ExtractedShapeDescription extractedShapeDescription : arrayList) {
                    gL.glBegin(1);
                    for (SectorGeometry.BoundaryEdge boundaryEdge : extractedShapeDescription.shapeOutline) {
                        Vec4 vec4 = boundaryEdge.vertices[boundaryEdge.i1];
                        Vec4 vec42 = boundaryEdge.vertices[boundaryEdge.i2];
                        if (!this.externalEdge(convexPartition, vec4, vec42)) continue;
                        gL.glVertex3d(vec4.x, vec4.y, vec4.z);
                        gL.glVertex3d(vec42.x, vec42.y, vec42.z);
                    }
                    gL.glEnd();
                }
            }
        }
    }

    protected void setOriginalVertices(Iterable<? extends LatLon> iterable) {
        this.originalVertices.clear();
        boolean bl = true;
        for (LatLon latLon : iterable) {
            if (bl) {
                bl = false;
                continue;
            }
            this.originalVertices.add(latLon);
        }
        this.createPartitions();
    }

    private void createPartitions() {
        this.partitions.clear();
        if (this.tessellateContour && this.originalVertices.size() > 3) {
            this.tessellate();
        } else {
            this.partitions.add(new ConvexPartition(this.globe, this.originalVertices, null));
        }
        this.rebuildPartitions = false;
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (this.originalVertices != null) {
            restorableSupport.addStateValueAsLatLonList(stateObject, "locations", this.originalVertices);
        }
        restorableSupport.addStateValueAsBoolean(stateObject, "tessellateContour", this.tessellateContour);
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Boolean bl;
        ArrayList<LatLon> arrayList = restorableSupport.getStateValueAsLatLonList(stateObject, "locations");
        if (arrayList != null) {
            this.originalVertices = arrayList;
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "tessellateContour")) != null) {
            this.tessellateContour = bl;
        }
        this.rebuildPartitions = true;
        this.globe = null;
    }

    @Override
    public double getLength(Globe globe) {
        if (this.areaMeasurer == null) {
            this.makeAreaMeasurer();
        }
        return this.areaMeasurer.getLength(globe);
    }

    @Override
    public double getArea(Globe globe) {
        if (this.areaMeasurer == null) {
            this.makeAreaMeasurer();
        }
        return this.areaMeasurer.getArea(globe);
    }

    @Override
    public double getPerimeter(Globe globe) {
        if (this.areaMeasurer == null) {
            this.makeAreaMeasurer();
        }
        return this.areaMeasurer.getPerimeter(globe);
    }

    @Override
    public double getWidth(Globe globe) {
        if (this.areaMeasurer == null) {
            this.makeAreaMeasurer();
        }
        return this.areaMeasurer.getWidth(globe);
    }

    @Override
    public double getHeight(Globe globe) {
        if (this.areaMeasurer == null) {
            this.makeAreaMeasurer();
        }
        return this.areaMeasurer.getHeight(globe);
    }

    private void makeAreaMeasurer() {
        ArrayList<Position> arrayList = new ArrayList<Position>(this.originalVertices.size() + 1);
        for (LatLon latLon : this.originalVertices) {
            arrayList.add(new Position(latLon.getLatitude(), latLon.getLongitude(), 0.0));
        }
        arrayList.add((Position)arrayList.get(0));
        this.areaMeasurer = new AreaMeasurer(arrayList);
        this.areaMeasurer.setFollowTerrain(true);
    }

    private void tessellate() {
        TessCallback tessCallback = new TessCallback(this.partitions, this.globe);
        GLUtessellator gLUtessellator = glu.gluNewTess();
        glu.gluTessCallback(gLUtessellator, 100100, tessCallback);
        glu.gluTessCallback(gLUtessellator, 100101, tessCallback);
        glu.gluTessCallback(gLUtessellator, 100102, tessCallback);
        glu.gluTessBeginPolygon(gLUtessellator, null);
        glu.gluTessBeginContour(gLUtessellator);
        int n = 0;
        for (LatLon latLon : this.originalVertices) {
            double[] dArray = new double[]{0.0, 0.0, 0.0};
            dArray[0] = latLon.getLongitude().radians;
            dArray[1] = latLon.getLatitude().radians;
            TaggedLatLonVertex taggedLatLonVertex = new TaggedLatLonVertex(latLon, n);
            glu.gluTessVertex(gLUtessellator, dArray, 0, taggedLatLonVertex);
            ++n;
        }
        glu.gluTessEndContour(gLUtessellator);
        glu.gluTessEndPolygon(gLUtessellator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TessCallback
    implements GLUtessellatorCallback {
        private int beginType = -1;
        private ArrayList<ConvexPartition> partitions;
        private Globe globe;
        private TaggedLatLonVertex[] workingStore;
        private int nextWSLoc;

        public TessCallback(ArrayList<ConvexPartition> arrayList, Globe globe) {
            this.partitions = arrayList;
            this.globe = globe;
            this.workingStore = new TaggedLatLonVertex[3];
            this.nextWSLoc = 0;
        }

        @Override
        public void begin(int n) {
            this.beginType = n;
            this.nextWSLoc = 0;
        }

        @Override
        public void beginData(int n, Object object) {
        }

        @Override
        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
        }

        @Override
        public void combineData(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2, Object object) {
        }

        @Override
        public void edgeFlag(boolean bl) {
        }

        @Override
        public void edgeFlagData(boolean bl, Object object) {
        }

        @Override
        public void end() {
            this.nextWSLoc = -1;
            this.beginType = -1;
        }

        @Override
        public void endData(Object object) {
        }

        @Override
        public void error(int n) {
        }

        @Override
        public void errorData(int n, Object object) {
        }

        @Override
        public void vertex(Object object) {
            TaggedLatLonVertex taggedLatLonVertex = (TaggedLatLonVertex)object;
            this.workingStore[this.nextWSLoc++] = taggedLatLonVertex;
            if (this.nextWSLoc == 3) {
                ArrayList<LatLon> arrayList = new ArrayList<LatLon>(3);
                arrayList.add(this.workingStore[0].ll);
                arrayList.add(this.workingStore[1].ll);
                arrayList.add(this.workingStore[2].ll);
                int[] nArray = new int[]{this.workingStore[0].ll_index, this.workingStore[1].ll_index, this.workingStore[2].ll_index};
                this.partitions.add(new ConvexPartition(this.globe, arrayList, nArray));
                switch (this.beginType) {
                    case 6: {
                        this.workingStore[1] = this.workingStore[2];
                        this.nextWSLoc = 2;
                        break;
                    }
                    case 5: {
                        this.workingStore[0] = this.workingStore[1];
                        this.workingStore[1] = this.workingStore[2];
                        this.nextWSLoc = 2;
                        break;
                    }
                    case 4: {
                        this.nextWSLoc = 0;
                        break;
                    }
                }
            }
        }

        @Override
        public void vertexData(Object object, Object object2) {
        }
    }

    private static class TaggedLatLonVertex {
        public LatLon ll;
        public int ll_index;

        public TaggedLatLonVertex(LatLon latLon, int n) {
            this.ll = latLon;
            this.ll_index = n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedShapeDescription {
        ArrayList<SectorGeometry.ExtractedShapeDescription> esdL;

        CachedShapeDescription(ArrayList<SectorGeometry.ExtractedShapeDescription> arrayList) {
            this.esdL = arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConvexPartition {
        private Sector bounds;
        private ArrayList<LatLon> llVerts;
        private final int[] originalVertexIndex;
        private Plane[] boundingPlanes;
        private final int serialNumber;

        public ConvexPartition(Globe globe, ArrayList<LatLon> arrayList, int[] nArray) {
            this.llVerts = arrayList;
            if (nArray == null) {
                this.originalVertexIndex = null;
            } else {
                this.originalVertexIndex = new int[nArray.length];
                System.arraycopy(nArray, 0, this.originalVertexIndex, 0, nArray.length);
            }
            this.computeBoundsAndPlanes(globe);
            this.serialNumber = ConformingShape.getUniqueSerialNumber();
        }

        private void computeBoundsAndPlanes(Globe globe) {
            int n;
            double d;
            double d2;
            double d3 = d2 = this.llVerts.get((int)0).getLatitude().radians;
            double d4 = d = this.llVerts.get((int)0).getLongitude().radians;
            Vec4[] vec4Array = new Vec4[this.llVerts.size()];
            vec4Array[0] = globe.computePointFromPosition(this.llVerts.get(0).getLatitude(), this.llVerts.get(0).getLongitude(), 0.0);
            for (int i = 1; i < this.llVerts.size(); ++i) {
                double d5 = this.llVerts.get((int)i).getLatitude().radians;
                if (d5 < d2) {
                    d2 = d5;
                } else if (d5 > d3) {
                    d3 = d5;
                }
                double d6 = this.llVerts.get((int)i).getLongitude().radians;
                if (d6 < d) {
                    d = d6;
                } else if (d6 > d4) {
                    d4 = d6;
                }
                vec4Array[i] = globe.computePointFromPosition(this.llVerts.get(i).getLatitude(), this.llVerts.get(i).getLongitude(), 0.0);
            }
            this.bounds = Sector.fromRadians(d2, d3, d, d4);
            double d7 = 99999.99;
            double d8 = 99999.99;
            int n2 = -1;
            int n3 = -1;
            for (n = 0; n < this.llVerts.size(); ++n) {
                double d9 = Math.abs(this.llVerts.get((int)n).getLatitude().radians - this.llVerts.get((int)((n + 1) % this.llVerts.size())).getLatitude().radians);
                if (n2 < 0) {
                    n2 = n;
                    d7 = d9;
                    continue;
                }
                if (d9 < d7) {
                    if (n != n2 + 1) {
                        n3 = n2;
                        d8 = d7;
                    }
                    n2 = n;
                    d7 = d9;
                    continue;
                }
                if (n == n2 + 1 || n3 >= 0 && !(d9 < d8)) continue;
                n3 = n;
                d8 = d9;
            }
            if (d7 > constantLatitudeToleranceInRadians) {
                n2 = -1;
            }
            if (d8 > constantLatitudeToleranceInRadians) {
                n3 = -1;
            }
            this.boundingPlanes = new Plane[this.llVerts.size()];
            n = this.llVerts.size() / 2;
            if (n < 2) {
                n = 2;
            }
            for (int i = 0; i < this.llVerts.size(); ++i) {
                Plane plane;
                Vec4 vec4;
                if (i == n2 || i == n3) {
                    vec4 = globe.computePointFromPosition(this.llVerts.get(i).getLatitude(), this.llVerts.get(i).getLongitude(), 0.0);
                    plane = new Plane(0.0, 1.0, 0.0, -vec4.getY());
                } else {
                    vec4 = vec4Array[i].cross3(vec4Array[(i + 1) % this.llVerts.size()]).normalize3();
                    plane = new Plane(vec4.getX(), vec4.getY(), vec4.getZ(), 0.0);
                }
                if (plane.dot(vec4Array[(i + n) % this.llVerts.size()]) > 0.0) {
                    vec4 = plane.getNormal();
                    double d10 = plane.getDistance();
                    plane = new Plane(-vec4.getX(), -vec4.getY(), -vec4.getZ(), -d10);
                }
                this.boundingPlanes[i] = plane;
            }
        }

        Plane[] getBoundingPlanes() {
            return this.boundingPlanes;
        }

        Sector[] getSector() {
            if (this.bounds.getMaxLongitude().degrees - this.bounds.getMinLongitude().degrees < 180.0) {
                Sector[] sectorArray = new Sector[]{this.bounds};
                return sectorArray;
            }
            Sector[] sectorArray = new Sector[]{Sector.fromDegrees(this.bounds.getMinLatitude().degrees, this.bounds.getMaxLatitude().degrees, -180.0, this.bounds.getMinLongitude().degrees), Sector.fromDegrees(this.bounds.getMinLatitude().degrees, this.bounds.getMaxLatitude().degrees, this.bounds.getMaxLongitude().degrees, 180.0)};
            return sectorArray;
        }

        void update(Globe globe, ArrayList<LatLon> arrayList) {
            if (this.originalVertexIndex != null) {
                for (int i = 0; i < this.llVerts.size(); ++i) {
                    this.llVerts.set(i, arrayList.get(this.originalVertexIndex[i]));
                }
            }
            this.computeBoundsAndPlanes(globe);
        }
    }
}

