/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.ConformingPolygon;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Color;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConformingQuad
extends ConformingPolygon {
    private LatLon center;
    private double halfWidth;
    private double halfHeight;
    private Angle orientation;

    public ConformingQuad(Globe globe, LatLon latLon, double d, double d2, Angle angle) {
        super(globe, ConformingQuad.makePositions(globe, latLon, d, d2, angle), null, null, false);
        this.center = latLon;
        this.halfWidth = d;
        this.halfHeight = d2;
        this.orientation = angle;
    }

    public ConformingQuad(Globe globe, LatLon latLon, double d, double d2, Angle angle, Color color, Color color2) {
        super(globe, ConformingQuad.makePositions(globe, latLon, d, d2, angle), color, color2, false);
        this.center = latLon;
        this.halfWidth = d;
        this.halfHeight = d2;
        this.orientation = angle;
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsDouble(stateObject, "halfWidth", this.getHalfWidth());
        restorableSupport.addStateValueAsDouble(stateObject, "halfHeight", this.getHalfHeight());
        restorableSupport.addStateValueAsLatLon(stateObject, "center", this.getCenter());
        if (this.orientation != null) {
            restorableSupport.addStateValueAsDouble(stateObject, "orientationDegrees", this.getOrientation().degrees);
        }
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        LatLon latLon;
        super.doRestoreState(restorableSupport, stateObject);
        Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "halfWidth");
        Double d3 = restorableSupport.getStateValueAsDouble(stateObject, "halfHeight");
        if (d2 != null && d3 != null) {
            this.setSize(d2, d3);
        }
        if ((latLon = restorableSupport.getStateValueAsLatLon(stateObject, "center")) != null) {
            this.setCenter(latLon);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "orientationDegrees")) != null) {
            this.setOrientation(Angle.fromDegrees(d));
        }
    }

    public LatLon getCenter() {
        return this.center;
    }

    public void setCenter(LatLon latLon) {
        this.center = latLon;
        this.setOriginalVertices(ConformingQuad.makePositions(this.globe, this.center, this.halfWidth, this.halfHeight, this.orientation));
    }

    public double getHalfWidth() {
        return this.halfWidth;
    }

    public double getHalfHeight() {
        return this.halfHeight;
    }

    public void setSize(double d, double d2) {
        this.halfWidth = d;
        this.halfHeight = d2;
        this.setOriginalVertices(ConformingQuad.makePositions(this.globe, this.center, this.halfWidth, this.halfHeight, this.orientation));
    }

    public Angle getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Angle angle) {
        this.orientation = angle;
        this.setOriginalVertices(ConformingQuad.makePositions(this.globe, this.center, this.halfWidth, this.halfHeight, this.orientation));
    }

    public static Iterable<LatLon> makePositions(Globe globe, LatLon latLon, double d, double d2, Angle angle) {
        if (angle == null) {
            angle = Angle.ZERO;
        }
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = Logging.getMessage("Geom.WidthInvalid", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = Logging.getMessage("Geom.HeightInvalid", d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[]{Math.atan2(d2, d), Math.atan2(d2, -d), Math.atan2(-d2, -d), Math.atan2(-d2, d), Math.atan2(d2, d)};
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(dArray.length);
        double d3 = globe.getRadiusAt(latLon.getLatitude(), latLon.getLongitude());
        double d4 = Math.sqrt(d * d + d2 * d2);
        for (double d5 : dArray) {
            double d6 = 1.5707963267948966 - (d5 + angle.radians);
            LatLon latLon2 = LatLon.greatCircleEndPosition(latLon, d6, d4 / d3);
            arrayList.add(latLon2);
        }
        return arrayList;
    }
}

