/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.Restorable;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.geom.MeasurableArea;
import gov.nasa.worldwind.geom.MeasurableLength;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.terrain.SectorGeometry;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConformingShape
implements Renderable,
Disposable,
Movable,
Restorable,
MeasurableArea,
MeasurableLength {
    protected Color fillColor;
    protected Color borderColor;
    protected double borderWidth = 1.0;
    protected boolean drawBorder = true;
    protected boolean drawInterior = true;
    private boolean antiAlias = true;
    private boolean useFrustumCull;
    private boolean combatZBufferFightingWithModelingXform = false;
    private boolean combatZBufferFightingWithProjectionXform = true;
    private static final Color DEFAULT_FILL_COLOR = new Color(1.0f, 1.0f, 0.0f, 0.4f);
    private static final Color DEFAULT_BORDER_COLOR = new Color(1.0f, 1.0f, 0.0f, 0.7f);
    protected static final String CONFORMINGSHAPE_CACHE_NAME = "Conforming Shape Cache";
    protected static final String CONFORMINGSHAPE_CACHE_KEY = ConformingShape.class.getName();
    private static final long DEFAULT_CONFORMINGSHAPE_CACHE_SIZE = 0x1000000L;
    private static int startCountDown = 1;
    private int countDown = 0;
    private static int nextSerialNumber = 1001;

    public ConformingShape() {
        this(null, null);
    }

    public ConformingShape(Color color, Color color2) {
        this.fillColor = color != null ? color : DEFAULT_FILL_COLOR;
        this.borderColor = color2 != null ? color2 : DEFAULT_BORDER_COLOR;
        this.useFrustumCull = false;
        if (!WorldWind.getMemoryCacheSet().containsCache(CONFORMINGSHAPE_CACHE_KEY)) {
            long l = 0x1000000L;
            BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
            basicMemoryCache.setName(CONFORMINGSHAPE_CACHE_NAME);
            WorldWind.getMemoryCacheSet().addCache(CONFORMINGSHAPE_CACHE_KEY, basicMemoryCache);
        }
    }

    @Override
    public void dispose() {
    }

    public Paint getInteriorColor() {
        return this.fillColor;
    }

    public void setInteriorColor(Color color) {
        this.invalidateCache();
        this.fillColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.invalidateCache();
        this.borderColor = color;
    }

    public double getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(double d) {
        this.invalidateCache();
        this.borderWidth = d;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.invalidateCache();
        this.drawBorder = bl;
    }

    public boolean isDrawInterior() {
        return this.drawInterior;
    }

    public void setDrawInterior(boolean bl) {
        this.invalidateCache();
        this.drawInterior = bl;
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean bl) {
        this.antiAlias = bl;
    }

    @Override
    public abstract Position getReferencePosition();

    protected static int getUniqueSerialNumber() {
        return nextSerialNumber++;
    }

    public boolean getUseFrustumCull() {
        return this.useFrustumCull;
    }

    public void setUseFrustumCull(boolean bl) {
        this.useFrustumCull = bl;
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.moveTo(this.getReferencePosition().add(position));
    }

    @Override
    public abstract void moveTo(Position var1);

    protected static long sizeInBytesOf(ArrayList<SectorGeometry.ExtractedShapeDescription> arrayList) {
        int n = 0;
        int n2 = 0;
        for (SectorGeometry.ExtractedShapeDescription extractedShapeDescription : arrayList) {
            ArrayList<Vec4[]> arrayList2 = extractedShapeDescription.interiorPolys;
            for (Vec4[] vec4Array : arrayList2) {
                n += vec4Array.length;
            }
            if (extractedShapeDescription.shapeOutline == null) continue;
            n2 += extractedShapeDescription.shapeOutline.size();
        }
        return 32 * n + n2 * 48;
    }

    protected abstract void invalidateCache();

    protected boolean isExpired(DrawContext drawContext) {
        return this.countDown == 0;
    }

    protected void updateExpiryCriteria(DrawContext drawContext) {
        if (this.countDown == 0) {
            this.countDown = startCountDown--;
            if (startCountDown < 1) {
                startCountDown = 30;
            }
        } else {
            --this.countDown;
        }
    }

    protected abstract boolean renderInterior(DrawContext var1, GL var2);

    protected abstract void renderBoundary(DrawContext var1, GL var2, boolean var3);

    @Override
    public void render(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glPushAttrib(16397);
        gL.glPolygonMode(1032, 6914);
        if (!drawContext.isPickingMode()) {
            gL.glBlendFunc(770, 771);
            gL.glEnable(3042);
        }
        gL.glLineWidth((float)this.borderWidth);
        if (this.combatZBufferFightingWithModelingXform) {
            gL.glPushMatrix();
            double d = 0.9;
            gL.glScaled(d, d, d);
        }
        if (this.combatZBufferFightingWithProjectionXform) {
            float[] fArray = new float[16];
            gL.glGetFloatv(2983, fArray, 0);
            fArray[10] = (float)((double)fArray[10] * 0.99);
            gL.glPushAttrib(4096);
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            gL.glLoadMatrixf(fArray, 0);
        }
        boolean bl = this.renderInterior(drawContext, gL);
        this.renderBoundary(drawContext, gL, bl);
        if (this.combatZBufferFightingWithModelingXform) {
            gL.glPopMatrix();
        }
        if (this.combatZBufferFightingWithProjectionXform) {
            gL.glMatrixMode(5889);
            gL.glPopMatrix();
            gL.glPopAttrib();
        }
        gL.glPopAttrib();
    }

    @Override
    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (this.getInteriorColor() instanceof Color) {
            restorableSupport.addStateValueAsColor(stateObject, "color", (Color)this.getInteriorColor());
        }
        restorableSupport.addStateValueAsDouble(stateObject, "lineWidth", this.getBorderWidth());
        restorableSupport.addStateValueAsColor(stateObject, "borderColor", this.getBorderColor());
        restorableSupport.addStateValueAsBoolean(stateObject, "drawInterior", this.isDrawInterior());
        restorableSupport.addStateValueAsBoolean(stateObject, "drawBorder", this.isDrawBorder());
        restorableSupport.addStateValueAsBoolean(stateObject, "antialias", this.isAntiAlias());
    }

    @Override
    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Boolean bl;
        Double d;
        Color color = restorableSupport.getStateValueAsColor(stateObject, "color");
        if (color != null) {
            this.setInteriorColor(color);
        }
        if ((color = restorableSupport.getStateValueAsColor(stateObject, "borderColor")) != null) {
            this.setBorderColor(color);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "lineWidth")) != null) {
            this.setBorderWidth(d);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "drawBorder")) != null) {
            this.setDrawBorder(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "drawInterior")) != null) {
            this.setDrawInterior(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "antialias")) != null) {
            this.setAntiAlias(bl);
        }
    }

    protected static class CacheKey {
        private final Class cls;
        private final Sector[] bounds;
        private final int serialNumber;
        private int hash = 0;

        public CacheKey(Class clazz, Sector[] sectorArray, int n) {
            this.cls = clazz;
            this.bounds = sectorArray;
            this.serialNumber = n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            return this.serialNumber == cacheKey.serialNumber;
        }

        public int hashCode() {
            if (this.hash == 0) {
                int n = this.hash = this.cls != null ? this.cls.hashCode() : 0;
                if (this.bounds == null) {
                    this.hash = 31 * this.hash;
                } else {
                    for (Sector sector : this.bounds) {
                        this.hash = 31 * this.hash + (sector != null ? sector.hashCode() : 0);
                    }
                }
                this.hash = 31 * this.hash + 131 * this.serialNumber;
            }
            return this.hash;
        }
    }
}

