/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContourLine
implements Renderable {
    private double elevation;
    private Sector sector;
    private Color color = Color.CYAN;
    private double lineWidth = 1.0;
    private boolean enabled = true;
    private ArrayList<Renderable> renderables = new ArrayList();
    private boolean viewClippingEnabled = false;
    protected boolean expired = true;
    protected long expiryTime = -1L;
    protected int minExpiryTime = 1000;
    protected int maxExpiryTime = 2000;
    protected static Random rand = new Random();
    protected Object globeStateKey;
    protected int maxConnectingDistance = 10;

    public ContourLine() {
        this(0.0, Sector.FULL_SPHERE);
    }

    public ContourLine(double d) {
        this(d, Sector.FULL_SPHERE);
    }

    public ContourLine(Sector sector) {
        this(0.0, sector);
    }

    public ContourLine(double d, Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.elevation = d;
        this.sector = sector;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double d) {
        if (this.elevation != d) {
            this.elevation = d;
            this.update();
        }
    }

    public Sector getSector() {
        return this.sector;
    }

    public void setSector(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.sector.equals(sector)) {
            this.sector = sector;
            this.update();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.color.equals(color)) {
            this.color = color;
            for (Renderable renderable : this.getRenderables()) {
                if (!(renderable instanceof Polyline)) continue;
                ((Polyline)renderable).setColor(color);
            }
        }
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double d) {
        if (this.lineWidth != d) {
            this.lineWidth = d;
            for (Renderable renderable : this.getRenderables()) {
                if (!(renderable instanceof Polyline)) continue;
                ((Polyline)renderable).setLineWidth(d);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isViewClippingEnabled() {
        return this.viewClippingEnabled;
    }

    public void setViewClippingEnabled(boolean bl) {
        this.viewClippingEnabled = bl;
    }

    public void update() {
        this.expired = true;
    }

    public ArrayList<Renderable> getRenderables() {
        return this.renderables;
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.getSector().intersects(drawContext.getVisibleSector())) {
            return;
        }
        if (this.isExpired(drawContext)) {
            this.makeContourLine(drawContext);
            this.updateExpiryCriteria(drawContext);
        }
        for (Renderable renderable : this.getRenderables()) {
            renderable.render(drawContext);
        }
    }

    protected boolean isExpired(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.expired) {
            return true;
        }
        if (drawContext.getFrameTimeStamp() >= this.expiryTime) {
            return true;
        }
        return this.globeStateKey != null && !this.globeStateKey.equals(drawContext.getGlobe().getStateKey(drawContext));
    }

    protected void updateExpiryCriteria(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.expiryTime = drawContext.getFrameTimeStamp() + (long)this.minExpiryTime + (long)rand.nextInt(this.maxExpiryTime - this.minExpiryTime);
        this.globeStateKey = drawContext.getGlobe().getStateKey(drawContext);
        this.expired = false;
    }

    protected void makeContourLine(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getRenderables().clear();
        double d = drawContext.getVerticalExaggeration();
        Intersection[] intersectionArray = drawContext.getSurfaceGeometry().intersect(this.getElevation() * d, this.getSector());
        if (intersectionArray != null) {
            ArrayList<Intersection> arrayList = new ArrayList<Intersection>(Arrays.asList(intersectionArray));
            if (this.isViewClippingEnabled()) {
                arrayList = this.filterIntersectionsOnViewFrustum(drawContext, arrayList);
            }
            arrayList = this.filterIntersections(drawContext, arrayList);
            this.makePolylinesConnected(drawContext, arrayList, this.maxConnectingDistance);
        }
    }

    protected ArrayList<Intersection> filterIntersectionsOnViewFrustum(DrawContext drawContext, ArrayList<Intersection> arrayList) {
        Frustum frustum = drawContext.getView().getFrustumInModelCoordinates();
        int n = 0;
        while (n < arrayList.size()) {
            if (frustum.contains(arrayList.get(n).getIntersectionPoint()) || frustum.contains(arrayList.get(n + 1).getIntersectionPoint())) {
                n += 2;
                continue;
            }
            arrayList.remove(n);
            arrayList.remove(n);
        }
        return arrayList;
    }

    protected ArrayList<Intersection> filterIntersections(DrawContext drawContext, ArrayList<Intersection> arrayList) {
        if (this.getSector().equals(Sector.FULL_SPHERE)) {
            return arrayList;
        }
        Globe globe = drawContext.getGlobe();
        Sector sector = this.getSector();
        int n = 0;
        while (n < arrayList.size()) {
            if (sector.contains(globe.computePositionFromPoint(arrayList.get(n).getIntersectionPoint())) && sector.contains(globe.computePositionFromPoint(arrayList.get(n + 1).getIntersectionPoint()))) {
                n += 2;
                continue;
            }
            arrayList.remove(n);
            arrayList.remove(n);
        }
        return arrayList;
    }

    protected int makePolylinesConnected(DrawContext drawContext, ArrayList<Intersection> arrayList, int n) {
        if (arrayList == null) {
            return 0;
        }
        Globe globe = drawContext.getGlobe();
        int n2 = n * n;
        int n3 = 0;
        while (arrayList.size() > 0) {
            ArrayList<Position> arrayList2 = new ArrayList<Position>();
            Vec4 vec4 = arrayList.remove(0).getIntersectionPoint();
            Vec4 vec42 = arrayList.remove(0).getIntersectionPoint();
            arrayList2.add(globe.computePositionFromPoint(vec4));
            arrayList2.add(globe.computePositionFromPoint(vec42));
            int n4 = 0;
            while (n4 < arrayList.size()) {
                Vec4 vec43 = arrayList.get(n4).getIntersectionPoint();
                if (vec43.distanceToSquared3(vec4) < (double)n2) {
                    arrayList.remove(n4);
                    vec4 = arrayList.remove(n4).getIntersectionPoint();
                    arrayList2.add(0, globe.computePositionFromPoint(vec4));
                    n4 = 0;
                    continue;
                }
                if (vec43.distanceToSquared3(vec42) < (double)n2) {
                    arrayList.remove(n4);
                    vec42 = arrayList.remove(n4).getIntersectionPoint();
                    arrayList2.add(globe.computePositionFromPoint(vec42));
                    n4 = 0;
                    continue;
                }
                vec43 = arrayList.get(n4 + 1).getIntersectionPoint();
                if (vec43.distanceToSquared3(vec4) < (double)n2) {
                    arrayList.remove(n4 + 1);
                    vec4 = arrayList.remove(n4).getIntersectionPoint();
                    arrayList2.add(0, globe.computePositionFromPoint(vec4));
                    n4 = 0;
                    continue;
                }
                if (vec43.distanceToSquared3(vec42) < (double)n2) {
                    arrayList.remove(n4 + 1);
                    vec42 = arrayList.remove(n4).getIntersectionPoint();
                    arrayList2.add(globe.computePositionFromPoint(vec42));
                    n4 = 0;
                    continue;
                }
                n4 += 2;
            }
            Polyline polyline = new Polyline(arrayList2);
            polyline.setNumSubsegments(0);
            polyline.setFollowTerrain(true);
            polyline.setColor(this.getColor());
            polyline.setLineWidth(this.getLineWidth());
            this.getRenderables().add(polyline);
            ++n3;
        }
        return n3;
    }
}

