/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.ContourLine;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.measure.AreaMeasurer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContourLinePolygon
extends ContourLine {
    private ArrayList<? extends LatLon> positions;

    public ContourLinePolygon() {
    }

    public ContourLinePolygon(double d) {
        super(d);
    }

    public ContourLinePolygon(double d, ArrayList<? extends LatLon> arrayList) {
        super(d);
        this.setPositions(arrayList);
    }

    public ArrayList<? extends LatLon> getPositions() {
        return this.positions;
    }

    public void setPositions(ArrayList<? extends LatLon> arrayList) {
        if (arrayList == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.positions = arrayList;
        this.setSector(Sector.boundingSector(arrayList));
        this.update();
    }

    @Override
    protected ArrayList<Intersection> filterIntersections(DrawContext drawContext, ArrayList<Intersection> arrayList) {
        arrayList = super.filterIntersections(drawContext, arrayList);
        if (this.getPositions() == null) {
            return arrayList;
        }
        Globe globe = drawContext.getGlobe();
        int n = 0;
        while (n < arrayList.size()) {
            if (AreaMeasurer.isLocationInside(globe.computePositionFromPoint(arrayList.get(n).getIntersectionPoint()), this.positions) && AreaMeasurer.isLocationInside(globe.computePositionFromPoint(arrayList.get(n + 1).getIntersectionPoint()), this.positions)) {
                n += 2;
                continue;
            }
            arrayList.remove(n);
            arrayList.remove(n);
        }
        return arrayList;
    }
}

