/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.FramebufferTexture;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FBOTexture
extends FramebufferTexture {
    public FBOTexture(DrawContext drawContext, WWTexture wWTexture, Sector sector, List<LatLon> list) {
        super(drawContext, wWTexture, sector, list);
        this.width = 1024;
        this.height = 1024;
    }

    @Override
    protected void initialize(DrawContext drawContext) {
    }

    @Override
    public boolean isTextureCurrent(DrawContext drawContext) {
        return true;
    }

    @Override
    public boolean bind(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Texture texture = drawContext.getTextureCache().get(this);
        if (texture == null) {
            texture = this.initializeTexture(drawContext);
        }
        if (texture != null) {
            texture.bind();
        }
        return texture != null;
    }

    @Override
    protected Texture initializeTexture(DrawContext drawContext) {
        GL gL = GLContext.getCurrent().getGL();
        int[] nArray = new int[1];
        gL.glGenFramebuffersEXT(1, nArray, 0);
        gL.glBindFramebufferEXT(36160, nArray[0]);
        TextureData textureData = new TextureData(6408, this.width, this.height, 0, 6408, 5121, false, false, true, BufferUtil.newByteBuffer(this.width * this.height * 4), null);
        Texture texture = TextureIO.newTexture(textureData);
        texture.bind();
        gL.glTexParameteri(3553, 10241, 9729);
        gL.glTexParameteri(3553, 10240, 9729);
        gL.glTexParameteri(3553, 10242, 33071);
        gL.glTexParameteri(3553, 10243, 33071);
        gL.glFramebufferTexture2DEXT(36160, 36064, 3553, texture.getTextureObject(), 0);
        int n = gL.glCheckFramebufferStatusEXT(36160);
        if (n != 36053) {
            throw new IllegalStateException("Frame Buffer Oject not created.");
        }
        this.generateTexture(drawContext, this.width, this.height);
        gL.glBindFramebufferEXT(36160, 0);
        gL.glDeleteFramebuffersEXT(1, nArray, 0);
        drawContext.getTextureCache().put(this, texture);
        return texture;
    }
}

