/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.geom.BilinearInterpolator;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FramebufferTexture
implements WWTexture {
    protected WWTexture sourceTexture;
    protected Sector sector;
    protected List<LatLon> corners;
    protected int width;
    protected int height;
    protected int tessellationDensity;
    protected static final int DEFAULT_TESSELLATION_DENSITY = 32;

    public FramebufferTexture(DrawContext drawContext, WWTexture wWTexture, Sector sector, List<LatLon> list) {
        if (wWTexture == null) {
            String string = Logging.getMessage("nullValue.ImageSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sourceTexture = wWTexture;
        this.sector = sector;
        this.corners = list;
        this.initialize(drawContext);
    }

    protected void initialize(DrawContext drawContext) {
        this.initializeTexture(drawContext);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public Sector getSector() {
        return this.sector;
    }

    public List<LatLon> getCorners() {
        return this.corners;
    }

    @Override
    public boolean isTextureCurrent(DrawContext drawContext) {
        return drawContext.getTextureCache().get(this) != null;
    }

    @Override
    public Object getImageSource() {
        return this.sourceTexture;
    }

    @Override
    public boolean bind(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Texture texture = drawContext.getTextureCache().get(this);
        if (texture != null) {
            texture.bind();
        }
        return texture != null;
    }

    @Override
    public void applyInternalTransform(DrawContext drawContext) {
    }

    protected int getTessellationDensity() {
        return this.tessellationDensity;
    }

    protected Texture initializeTexture(DrawContext drawContext) {
        GL gL = GLContext.getCurrent().getGL();
        this.width = Math.min(1024, drawContext.getDrawableWidth());
        this.height = Math.min(1024, drawContext.getDrawableHeight());
        this.tessellationDensity = 32;
        this.generateTexture(drawContext, this.width, this.height);
        TextureData textureData = new TextureData(6408, this.width, this.height, 0, 6408, 5121, false, false, false, null, null);
        Texture texture = TextureIO.newTexture(textureData);
        texture.bind();
        gL.glTexParameteri(3553, 10241, 9729);
        gL.glTexParameteri(3553, 10240, 9729);
        gL.glTexParameteri(3553, 10242, 33071);
        gL.glTexParameteri(3553, 10243, 33071);
        gL.glCopyTexImage2D(3553, 0, textureData.getInternalFormat(), 0, 0, textureData.getWidth(), textureData.getHeight(), textureData.getBorder());
        drawContext.getTextureCache().put(this, texture);
        return texture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateTexture(DrawContext drawContext, int n, int n2) {
        GL gL = drawContext.getGL();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        Matrix matrix = this.computeGeographicToCartesianTransform(this.sector);
        try {
            oGLStackHandler.pushAttrib(gL, 292864);
            gL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            gL.glClear(16384);
            gL.glDisable(3042);
            gL.glDisable(2884);
            gL.glDisable(2929);
            oGLStackHandler.pushProjectionIdentity(gL);
            gL.glViewport(0, 0, n, n2);
            gL.glOrtho(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
            oGLStackHandler.pushModelviewIdentity(gL);
            oGLStackHandler.pushTextureIdentity(gL);
            if (this.sourceTexture != null) {
                gL.glEnable(3553);
                this.sourceTexture.bind(drawContext);
                this.sourceTexture.applyInternalTransform(drawContext);
                gL.glTexEnvf(8960, 8704, 7681.0f);
                int n3 = this.getTessellationDensity();
                this.drawQuad(drawContext, matrix, n3, n3);
            }
        }
        finally {
            oGLStackHandler.pop(gL);
        }
    }

    protected Matrix computeGeographicToCartesianTransform(Sector sector) {
        double d = 2.0 / sector.getDeltaLonDegrees();
        double d2 = 2.0 / sector.getDeltaLatDegrees();
        double d3 = -sector.getMinLongitude().degrees;
        double d4 = -sector.getMinLatitude().degrees;
        Matrix matrix = Matrix.IDENTITY;
        matrix = matrix.multiply(Matrix.fromTranslation(-1.0, -1.0, 0.0));
        matrix = matrix.multiply(Matrix.fromScale(d, d2, 1.0));
        matrix = matrix.multiply(Matrix.fromTranslation(d3, d4, 0.0));
        return matrix;
    }

    protected Vec4 transformToQuadCoordinates(Matrix matrix, LatLon latLon) {
        return new Vec4(latLon.getLongitude().degrees, latLon.getLatitude().degrees, 0.0).transformBy4(matrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawQuad(DrawContext drawContext, Matrix matrix, int n, int n2) {
        Vec4 vec4 = this.transformToQuadCoordinates(matrix, this.corners.get(0));
        Vec4 vec42 = this.transformToQuadCoordinates(matrix, this.corners.get(1));
        Vec4 vec43 = this.transformToQuadCoordinates(matrix, this.corners.get(2));
        Vec4 vec44 = this.transformToQuadCoordinates(matrix, this.corners.get(3));
        BilinearInterpolator bilinearInterpolator = new BilinearInterpolator(vec4, vec42, vec43, vec44);
        GL gL = drawContext.getGL();
        gL.glBegin(5);
        try {
            this.drawQuad(drawContext, bilinearInterpolator, n, n2);
        }
        finally {
            gL.glEnd();
        }
    }

    protected void drawQuad(DrawContext drawContext, BilinearInterpolator bilinearInterpolator, int n, int n2) {
        double[] dArray = new double[4];
        double d = 1.0f / (float)n;
        double d2 = 1.0f / (float)n2;
        GL gL = drawContext.getGL();
        for (int i = 0; i < n2; ++i) {
            double d3 = (double)i * d2;
            double d4 = (double)(i + 1) * d2;
            if (i != 0) {
                bilinearInterpolator.interpolate((double)n * d, d3, dArray);
                gL.glTexCoord2d((double)n * d, d3);
                gL.glVertex3dv(dArray, 0);
                bilinearInterpolator.interpolate(0.0, d3, dArray);
                gL.glTexCoord2d(0.0, d3);
                gL.glVertex3dv(dArray, 0);
            }
            for (int j = 0; j <= n; ++j) {
                double d5 = (double)j * d;
                bilinearInterpolator.interpolate(d5, d3, dArray);
                gL.glTexCoord2d(d5, d3);
                gL.glVertex3dv(dArray, 0);
                bilinearInterpolator.interpolate(d5, d4, dArray);
                gL.glTexCoord2d(d5, d4);
                gL.glVertex3dv(dArray, 0);
            }
        }
    }
}

