/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Locatable;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.AbstractAnnotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import javax.media.opengl.GL;

public class GlobeAnnotation
extends AbstractAnnotation
implements Locatable,
Movable {
    private Position position;

    public GlobeAnnotation(String string, Position position) {
        this.init(string, position, null, null);
    }

    public GlobeAnnotation(String string, Position position, Font font) {
        this.init(string, position, font, null);
    }

    public GlobeAnnotation(String string, Position position, Font font, Color color) {
        this.init(string, position, font, color);
    }

    public GlobeAnnotation(String string, Position position, AnnotationAttributes annotationAttributes) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (position == null) {
            String string3 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (annotationAttributes == null) {
            String string4 = Logging.getMessage("nullValue.AnnotationAttributesIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.setText(string);
        this.position = position;
        this.getAttributes().setDefaults(annotationAttributes);
    }

    private void init(String string, Position position, Font font, Color color) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (position == null) {
            String string3 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.setText(string);
        this.position = position;
        this.getAttributes().setFont(font);
        this.getAttributes().setTextColor(color);
    }

    protected void doDraw(DrawContext drawContext) {
        if (drawContext.isPickingMode() && this.getPickSupport() == null) {
            return;
        }
        Vec4 vec4 = drawContext.getAnnotationRenderer().getAnnotationDrawPoint(drawContext, this);
        if (vec4 == null) {
            return;
        }
        if (drawContext.getView().getFrustumInModelCoordinates().getNear().distanceTo(vec4) < 0.0) {
            return;
        }
        double d = drawContext.getView().getEyePoint().distanceTo3(vec4);
        Vec4 vec42 = drawContext.getView().project(vec4);
        if (vec42 == null) {
            return;
        }
        Position position = drawContext.getGlobe().computePositionFromPoint(vec4);
        double d2 = this.computeLookAtDistance(drawContext) / d;
        double d3 = Math.min(1.0, Math.max(this.attributes.getDistanceMinOpacity(), Math.sqrt(d2)));
        d2 = Math.min(this.attributes.getDistanceMaxScale(), Math.max(this.attributes.getDistanceMinScale(), d2));
        this.setDepthFunc(drawContext, vec42);
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        gL.glTranslated(vec42.x, vec42.y, 0.0);
        this.drawAnnotation(drawContext, new Point((int)vec42.x, (int)vec42.y), d2, d3, position);
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = this.position.add(position);
    }

    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = position;
    }

    public Position getReferencePosition() {
        return this.position;
    }

    public String getRestorableState() {
        RestorableSupport.StateObject stateObject;
        RestorableSupport restorableSupport = null;
        String string = super.getRestorableState();
        if (string != null) {
            try {
                restorableSupport = RestorableSupport.parse(string);
            }
            catch (Exception exception) {
                String string2 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
                Logging.logger().severe(string2);
            }
        }
        if (restorableSupport == null) {
            restorableSupport = RestorableSupport.newRestorableSupport();
        }
        if (restorableSupport == null) {
            return null;
        }
        if (this.position != null && this.position.getLatitude() != null && this.position.getLongitude() != null && (stateObject = restorableSupport.addStateObject("position")) != null) {
            restorableSupport.addStateValueAsDouble(stateObject, "latitude", this.position.getLatitude().degrees);
            restorableSupport.addStateValueAsDouble(stateObject, "longitude", this.position.getLongitude().degrees);
            restorableSupport.addStateValueAsDouble(stateObject, "elevation", this.position.getElevation());
        }
        return restorableSupport.getStateAsXml();
    }

    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            super.restoreState(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        RestorableSupport.StateObject stateObject = restorableSupport.getStateObject("position");
        if (stateObject != null) {
            Double d = restorableSupport.getStateValueAsDouble(stateObject, "latitude");
            Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "longitude");
            Double d3 = restorableSupport.getStateValueAsDouble(stateObject, "elevation");
            if (d != null && d3 != null) {
                this.setPosition(Position.fromDegrees(d, d2, d3));
            }
        }
    }
}

