/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.j2d.TextRenderer;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.Locatable;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.Pedestal;
import gov.nasa.worldwind.render.ToolTipRenderer;
import gov.nasa.worldwind.render.WWIcon;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconRenderer {
    private Pedestal pedestal;
    private PickSupport pickSupport = new PickSupport();
    private HashMap<Font, ToolTipRenderer> toolTipRenderers = new HashMap();
    private boolean horizonClippingEnabled = false;
    private boolean viewClippingEnabled = false;
    private boolean alwaysUseAbsoluteElevation = false;

    public Pedestal getPedestal() {
        return this.pedestal;
    }

    public void setPedestal(Pedestal pedestal) {
        this.pedestal = pedestal;
    }

    public boolean isHorizonClippingEnabled() {
        return this.horizonClippingEnabled;
    }

    public void setHorizonClippingEnabled(boolean bl) {
        this.horizonClippingEnabled = bl;
    }

    public boolean isViewClippingEnabled() {
        return this.viewClippingEnabled;
    }

    public void setViewClippingEnabled(boolean bl) {
        this.viewClippingEnabled = bl;
    }

    private static boolean isIconValid(WWIcon wWIcon, boolean bl) {
        if (wWIcon == null || wWIcon.getImageSource() == null) {
            return false;
        }
        return !bl || wWIcon.getPosition() != null;
    }

    public boolean isAlwaysUseAbsoluteElevation() {
        return this.alwaysUseAbsoluteElevation;
    }

    public void setAlwaysUseAbsoluteElevation(boolean bl) {
        this.alwaysUseAbsoluteElevation = bl;
    }

    public void pick(DrawContext drawContext, Iterable<WWIcon> iterable, Point point, Layer layer) {
        this.drawMany(drawContext, iterable, layer);
    }

    public void pick(DrawContext drawContext, WWIcon wWIcon, Vec4 vec4, Point point, Layer layer) {
        if (!IconRenderer.isIconValid(wWIcon, false)) {
            return;
        }
        this.drawOne(drawContext, wWIcon, vec4, layer);
    }

    public void render(DrawContext drawContext, Iterable<WWIcon> iterable) {
        this.drawMany(drawContext, iterable, null);
    }

    public void render(DrawContext drawContext, WWIcon wWIcon, Vec4 vec4) {
        if (!IconRenderer.isIconValid(wWIcon, false)) {
            return;
        }
        this.drawOne(drawContext, wWIcon, vec4, null);
    }

    private void drawMany(DrawContext drawContext, Iterable<WWIcon> iterable, Layer layer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IconIterator");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<WWIcon> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        double d = drawContext.getView().computeHorizonDistance();
        while (iterator.hasNext()) {
            double d2;
            WWIcon wWIcon = iterator.next();
            if (!IconRenderer.isIconValid(wWIcon, true) || !wWIcon.isVisible()) continue;
            Position position = wWIcon.getPosition();
            Vec4 vec4 = null;
            if (position.getElevation() < drawContext.getGlobe().getMaxElevation() && !this.isAlwaysUseAbsoluteElevation()) {
                vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(wWIcon.getPosition());
            }
            if (vec4 == null) {
                vec4 = drawContext.getGlobe().computePointFromPosition(wWIcon.getPosition());
            }
            double d3 = d2 = wWIcon.isAlwaysOnTop() ? 0.0 : drawContext.getView().getEyePoint().distanceTo3(vec4);
            if (this.isHorizonClippingEnabled() && d2 > d || this.isViewClippingEnabled() && !drawContext.getView().getFrustumInModelCoordinates().contains(vec4)) continue;
            drawContext.addOrderedRenderable(new OrderedIcon(wWIcon, vec4, layer, d2, d));
            if (!wWIcon.isShowToolTip()) continue;
            this.addToolTip(drawContext, wWIcon, vec4);
        }
    }

    private void drawOne(DrawContext drawContext, WWIcon wWIcon, Vec4 vec4, Layer layer) {
        double d;
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        if (!wWIcon.isVisible()) {
            return;
        }
        if (vec4 == null) {
            Angle angle = wWIcon.getPosition().getLatitude();
            Angle angle2 = wWIcon.getPosition().getLongitude();
            if (!drawContext.getVisibleSector().contains(angle, angle2)) {
                return;
            }
            vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(angle, angle2, wWIcon.getPosition().getElevation());
            if (vec4 == null) {
                return;
            }
        }
        double d2 = drawContext.getView().computeHorizonDistance();
        double d3 = d = wWIcon.isAlwaysOnTop() ? 0.0 : drawContext.getView().getEyePoint().distanceTo3(vec4);
        if (this.isHorizonClippingEnabled() && d > d2) {
            return;
        }
        if (this.isViewClippingEnabled() && !drawContext.getView().getFrustumInModelCoordinates().contains(vec4)) {
            return;
        }
        drawContext.addOrderedRenderable(new OrderedIcon(wWIcon, vec4, layer, d, d2));
        if (wWIcon.isShowToolTip()) {
            this.addToolTip(drawContext, wWIcon, vec4);
        }
    }

    private void addToolTip(DrawContext drawContext, WWIcon wWIcon, Vec4 vec4) {
        if (wWIcon.getToolTipFont() == null && wWIcon.getToolTipText() == null) {
            return;
        }
        Vec4 vec42 = drawContext.getView().project(vec4);
        if (vec42 == null) {
            return;
        }
        OrderedText orderedText = new OrderedText(wWIcon.getToolTipText(), wWIcon.getToolTipFont(), vec42, wWIcon.getToolTipTextColor(), 0.0);
        drawContext.addOrderedRenderable(orderedText);
    }

    private void beginDrawIcons(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        int n = 293121;
        gL.glPushAttrib(n);
        gL.glEnable(2929);
        gL.glDepthMask(false);
        gL.glEnable(3008);
        gL.glAlphaFunc(516, 0.001f);
        int[] nArray = new int[4];
        gL.glGetIntegerv(2978, nArray, 0);
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glOrtho(0.0, nArray[2], 0.0, nArray[3], -1.0, 1.0);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glMatrixMode(5890);
        gL.glPushMatrix();
        if (drawContext.isPickingMode()) {
            this.pickSupport.beginPicking(drawContext);
            gL.glEnable(3553);
            gL.glTexEnvf(8960, 8704, 34160.0f);
            gL.glTexEnvf(8960, 34176, 34168.0f);
            gL.glTexEnvf(8960, 34161, 7681.0f);
        } else {
            gL.glEnable(3553);
            gL.glEnable(3042);
            gL.glBlendFunc(1, 771);
        }
    }

    private void endDrawIcons(DrawContext drawContext) {
        if (drawContext.isPickingMode()) {
            this.pickSupport.endPicking(drawContext);
        }
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glMatrixMode(5890);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }

    private Vec4 drawIcon(DrawContext drawContext, OrderedIcon orderedIcon) {
        double d;
        double d2;
        if (orderedIcon.point == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            return null;
        }
        WWIcon wWIcon = orderedIcon.icon;
        if (drawContext.getView().getFrustumInModelCoordinates().getNear().distanceTo(orderedIcon.point) < 0.0) {
            return null;
        }
        Vec4 vec4 = drawContext.getView().project(orderedIcon.point);
        if (vec4 == null) {
            return null;
        }
        Texture texture = drawContext.getTextureCache().get(wWIcon.getImageSource());
        if (texture == null) {
            texture = this.initializeTexture(drawContext, wWIcon.getImageSource());
        }
        Texture texture2 = null;
        if (this.pedestal != null) {
            d2 = this.pedestal.getScale();
            d = this.pedestal.getSpacingPixels();
            texture2 = drawContext.getTextureCache().get(this.pedestal.getPath());
            if (texture2 == null) {
                texture2 = this.initializeTexture(drawContext, this.pedestal.getImageSource());
            }
        } else {
            d2 = 0.0;
            d = 0.0;
        }
        GL gL = drawContext.getGL();
        this.setDepthFunc(drawContext, orderedIcon, vec4);
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        Dimension dimension = wWIcon.getSize();
        double d3 = dimension != null ? dimension.getWidth() : (double)texture.getWidth();
        double d4 = dimension != null ? dimension.getHeight() : (double)texture.getHeight();
        gL.glTranslated(vec4.x - d3 / 2.0, vec4.y + d2 * d4 + d, 0.0);
        if (wWIcon.isHighlighted()) {
            double d5 = this.pedestal != null ? 0.0 : d4 / 2.0;
            gL.glTranslated(d3 / 2.0, d5, 0.0);
            gL.glScaled(wWIcon.getHighlightScale(), wWIcon.getHighlightScale(), wWIcon.getHighlightScale());
            gL.glTranslated(-d3 / 2.0, -d5, 0.0);
        }
        if (drawContext.isPickingMode()) {
            Color color = drawContext.getUniquePickColor();
            int n = color.getRGB();
            this.pickSupport.addPickableObject(n, wWIcon, orderedIcon.getPosition(), false);
            gL.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        }
        if (wWIcon.getBackgroundImage() != null) {
            this.applyBackground(drawContext, wWIcon, vec4, d3, d4, d, d2);
        }
        texture.bind();
        TextureCoords textureCoords = texture.getImageTexCoords();
        gL.glScaled(d3, d4, 1.0);
        drawContext.drawUnitQuad(textureCoords);
        if (texture2 != null) {
            gL.glLoadIdentity();
            gL.glTranslated(vec4.x - d2 * (d3 / 2.0), vec4.y, 0.0);
            gL.glScaled(d3 * d2, d4 * d2, 1.0);
            texture2.bind();
            textureCoords = texture2.getImageTexCoords();
            drawContext.drawUnitQuad(textureCoords);
        }
        return vec4;
    }

    private void applyBackground(DrawContext drawContext, WWIcon wWIcon, Vec4 vec4, double d, double d2, double d3, double d4) {
        GL gL = drawContext.getGL();
        Object object = wWIcon.getBackgroundImage();
        double d5 = wWIcon.getBackgroundScale();
        Texture texture = drawContext.getTextureCache().get(object);
        if (texture == null) {
            texture = this.initializeTexture(drawContext, object);
        }
        if (texture != null) {
            texture.bind();
            TextureCoords textureCoords = texture.getImageTexCoords();
            gL.glPushMatrix();
            gL.glLoadIdentity();
            double d6 = d5 * d;
            double d7 = d5 * d2;
            gL.glTranslated(0.0, d4 * d2 + d3, 0.0);
            gL.glTranslated(vec4.x - d6 / 2.0, vec4.y - (d7 - d2) / 2.0, 0.0);
            gL.glScaled(d6, d7, 1.0);
            drawContext.drawUnitQuad(textureCoords);
            gL.glPopMatrix();
        }
    }

    private void setDepthFunc(DrawContext drawContext, OrderedIcon orderedIcon, Vec4 vec4) {
        GL gL = drawContext.getGL();
        if (orderedIcon.icon.isAlwaysOnTop()) {
            gL.glDepthFunc(519);
            return;
        }
        Position position = drawContext.getView().getEyePosition();
        if (position == null) {
            gL.glDepthFunc(519);
            return;
        }
        double d = position.getElevation();
        if (d < drawContext.getGlobe().getMaxElevation() * drawContext.getVerticalExaggeration()) {
            double d2 = vec4.z - 0.00391006472;
            d2 = d2 < 0.0 ? 0.0 : (d2 > 1.0 ? 1.0 : d2);
            gL.glDepthFunc(513);
            gL.glDepthRange(d2, d2);
        } else if (orderedIcon.eyeDistance > orderedIcon.horizonDistance) {
            gL.glDepthFunc(514);
            gL.glDepthRange(1.0, 1.0);
        } else {
            gL.glDepthFunc(519);
        }
    }

    private Texture initializeTexture(DrawContext drawContext, Object object) {
        try {
            Object object2;
            Texture texture = null;
            if (object instanceof String) {
                File file;
                object2 = (String)object;
                InputStream inputStream = this.getClass().getResourceAsStream("/" + (String)object2);
                if (inputStream == null && (file = new File((String)object2)).exists()) {
                    inputStream = new FileInputStream(file);
                }
                texture = TextureIO.newTexture(inputStream, true, null);
            } else if (object instanceof BufferedImage) {
                texture = TextureIO.newTexture((BufferedImage)object, true);
            }
            if (texture == null) {
                return null;
            }
            drawContext.getTextureCache().put(object, texture);
            texture.bind();
            object2 = drawContext.getGL();
            object2.glTexEnvf(8960, 8704, 8448.0f);
            object2.glTexParameteri(3553, 10241, 9987);
            object2.glTexParameteri(3553, 10240, 9729);
            object2.glTexParameteri(3553, 10242, 33071);
            object2.glTexParameteri(3553, 10243, 33071);
            return texture;
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("generic.IOExceptionDuringTextureInitialization");
            Logging.logger().log(Level.SEVERE, string, iOException);
            throw new WWRuntimeException(string, iOException);
        }
    }

    public String toString() {
        return Logging.getMessage("layers.IconLayer.Name");
    }

    private class OrderedIcon
    implements OrderedRenderable,
    Locatable {
        WWIcon icon;
        Vec4 point;
        double eyeDistance;
        double horizonDistance;
        Layer layer;

        OrderedIcon(WWIcon wWIcon, Vec4 vec4, double d, double d2) {
            this.icon = wWIcon;
            this.point = vec4;
            this.eyeDistance = d;
            this.horizonDistance = d2;
        }

        OrderedIcon(WWIcon wWIcon, Vec4 vec4, Layer layer, double d, double d2) {
            this.icon = wWIcon;
            this.point = vec4;
            this.eyeDistance = d;
            this.horizonDistance = d2;
            this.layer = layer;
        }

        public double getDistanceFromEye() {
            return this.eyeDistance;
        }

        public Position getPosition() {
            return this.icon.getPosition();
        }

        private IconRenderer getRenderer() {
            return IconRenderer.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void render(DrawContext drawContext) {
            IconRenderer.this.beginDrawIcons(drawContext);
            try {
                IconRenderer.this.drawIcon(drawContext, this);
                OrderedRenderable orderedRenderable = drawContext.getOrderedRenderables().peek();
                while (orderedRenderable != null && orderedRenderable instanceof OrderedIcon) {
                    OrderedIcon orderedIcon = (OrderedIcon)orderedRenderable;
                    if (orderedIcon.getRenderer() != IconRenderer.this) {
                        return;
                    }
                    drawContext.getOrderedRenderables().poll();
                    IconRenderer.this.drawIcon(drawContext, orderedIcon);
                    orderedRenderable = drawContext.getOrderedRenderables().peek();
                }
            }
            catch (WWRuntimeException wWRuntimeException) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingIcon", wWRuntimeException);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingIcon", exception);
            }
            finally {
                IconRenderer.this.endDrawIcons(drawContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pick(DrawContext drawContext, Point point) {
            IconRenderer.this.pickSupport.clearPickList();
            IconRenderer.this.beginDrawIcons(drawContext);
            try {
                IconRenderer.this.drawIcon(drawContext, this);
            }
            catch (WWRuntimeException wWRuntimeException) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingIcon", wWRuntimeException);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "generic.ExceptionWhilePickingIcon", exception);
            }
            finally {
                IconRenderer.this.endDrawIcons(drawContext);
                IconRenderer.this.pickSupport.resolvePick(drawContext, point, this.layer);
                IconRenderer.this.pickSupport.clearPickList();
            }
        }
    }

    private class OrderedText
    implements OrderedRenderable {
        Font font;
        String text;
        Vec4 point;
        double eyeDistance;
        Point pickPoint;
        Layer layer;
        Color color;

        OrderedText(String string, Font font, Vec4 vec4, Color color, double d) {
            this.text = string;
            this.font = font;
            this.point = vec4;
            this.eyeDistance = d;
            this.color = color;
        }

        OrderedText(String string, Font font, Vec4 vec4, Point point, Layer layer, double d) {
            this.text = string;
            this.font = font;
            this.point = vec4;
            this.eyeDistance = d;
            this.pickPoint = point;
            this.layer = layer;
        }

        public double getDistanceFromEye() {
            return this.eyeDistance;
        }

        public void render(DrawContext drawContext) {
            Object object;
            ToolTipRenderer toolTipRenderer = (ToolTipRenderer)IconRenderer.this.toolTipRenderers.get(this.font);
            if (toolTipRenderer == null) {
                if (this.font != null) {
                    object = new TextRenderer(this.font, true, true);
                    ((TextRenderer)object).setUseVertexArrays(false);
                    toolTipRenderer = new ToolTipRenderer((TextRenderer)object);
                } else {
                    toolTipRenderer = new ToolTipRenderer();
                }
                IconRenderer.this.toolTipRenderers.put(this.font, toolTipRenderer);
            }
            object = drawContext.getView().getViewport();
            toolTipRenderer.setForeground(this.color);
            toolTipRenderer.setUseSystemLookAndFeel(this.color == null);
            toolTipRenderer.beginRendering(((Rectangle)object).width, ((Rectangle)object).height);
            toolTipRenderer.draw(this.text, (int)this.point.x, (int)this.point.y);
            toolTipRenderer.endRendering();
        }

        public void pick(DrawContext drawContext, Point point) {
        }
    }
}

