/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.nio.DoubleBuffer;
import javax.media.opengl.GL;

public class Quadrilateral
implements Renderable,
Movable {
    private LatLon southwestCorner;
    private LatLon northeastCorner;
    private double elevation;
    private Vec4 referenceCenter;
    private DoubleBuffer vertices;
    private int antiAliasHint = 4353;
    private Color color = Color.WHITE;
    protected WWTexture texture;
    protected DoubleBuffer textureCoordinates;

    public Quadrilateral(LatLon latLon, LatLon latLon2, double d) {
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.southwestCorner = latLon;
        this.northeastCorner = latLon2;
        this.elevation = d;
    }

    public Quadrilateral(Sector sector, double d) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.southwestCorner = new LatLon(sector.getMinLatitude(), sector.getMinLongitude());
        this.northeastCorner = new LatLon(sector.getMaxLatitude(), sector.getMaxLongitude());
        this.elevation = d;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.color = color;
    }

    public void setImageSource(Object object) {
        if (object == null) {
            this.texture = null;
            return;
        }
        this.texture = new BasicWWTexture(object);
    }

    public Object getImageSource() {
        return this.texture != null ? this.texture.getImageSource() : null;
    }

    public int getAntiAliasHint() {
        return this.antiAliasHint;
    }

    public void setAntiAliasHint(int n) {
        if (n != 4352 && n != 4353 && n != 4354) {
            String string = Logging.getMessage("generic.InvalidHint");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.antiAliasHint = n;
    }

    public void setCorners(LatLon latLon, LatLon latLon2) {
        this.southwestCorner = latLon;
        this.northeastCorner = latLon2;
        this.vertices = null;
    }

    public LatLon[] getCorners() {
        LatLon[] latLonArray = new LatLon[]{this.southwestCorner, this.northeastCorner};
        return latLonArray;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double d) {
        this.elevation = d;
        this.vertices = null;
    }

    private void intializeGeometry(DrawContext drawContext) {
        DoubleBuffer doubleBuffer = BufferUtil.newDoubleBuffer(12);
        Vec4[] vec4Array = new Vec4[]{drawContext.getGlobe().computePointFromPosition(this.southwestCorner.getLatitude(), this.southwestCorner.getLongitude(), this.elevation), drawContext.getGlobe().computePointFromPosition(this.southwestCorner.getLatitude(), this.northeastCorner.getLongitude(), this.elevation), drawContext.getGlobe().computePointFromPosition(this.northeastCorner.getLatitude(), this.northeastCorner.getLongitude(), this.elevation), drawContext.getGlobe().computePointFromPosition(this.northeastCorner.getLatitude(), this.southwestCorner.getLongitude(), this.elevation)};
        Vec4 vec4 = new Vec4((vec4Array[0].x + vec4Array[2].x) / 2.0, (vec4Array[0].y + vec4Array[2].y) / 2.0, (vec4Array[0].z + vec4Array[2].z) / 2.0);
        for (int i = 0; i < 4; ++i) {
            doubleBuffer.put(vec4Array[i].x - vec4.x);
            doubleBuffer.put(vec4Array[i].y - vec4.y);
            doubleBuffer.put(vec4Array[i].z - vec4.z);
        }
        this.referenceCenter = vec4;
        this.vertices = doubleBuffer;
    }

    protected void initializeTextureCoordinates() {
        this.textureCoordinates = BufferUtil.newDoubleBuffer(8);
        this.textureCoordinates.put(0.0).put(0.0);
        this.textureCoordinates.put(1.0).put(0.0);
        this.textureCoordinates.put(1.0).put(1.0);
        this.textureCoordinates.put(0.0).put(1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (this.vertices == null) {
            this.intializeGeometry(drawContext);
        }
        GL gL = drawContext.getGL();
        boolean bl = false;
        int n = 49153;
        if (!drawContext.isPickingMode()) {
            if (this.color.getAlpha() != 255) {
                n |= 0x4000;
            }
            if (this.texture != null) {
                n |= 0x41000;
            }
        }
        gL.glPushAttrib(n);
        gL.glPushClientAttrib(2);
        drawContext.getView().pushReferenceCenter(drawContext, this.referenceCenter);
        try {
            if (!drawContext.isPickingMode()) {
                double d;
                double d2 = d = drawContext.getCurrentLayer() != null ? drawContext.getCurrentLayer().getOpacity() : 1.0;
                if (this.color.getAlpha() != 255 || d < 1.0) {
                    gL.glEnable(3042);
                    gL.glBlendFunc(770, 771);
                }
                drawContext.getGL().glColor4ub((byte)this.color.getRed(), (byte)this.color.getGreen(), (byte)this.color.getBlue(), (byte)((double)this.color.getAlpha() * d));
                if (this.texture != null) {
                    gL.glMatrixMode(5890);
                    gL.glPushMatrix();
                    bl = true;
                    gL.glLoadIdentity();
                    this.texture.applyInternalTransform(drawContext);
                    gL.glEnable(3553);
                    if (this.textureCoordinates == null) {
                        this.initializeTextureCoordinates();
                    }
                    gL.glEnableClientState(32888);
                    gL.glTexCoordPointer(2, 5130, 0, this.textureCoordinates.rewind());
                    gL.glEnable(3042);
                    gL.glBlendFunc(1, 771);
                    this.texture.bind(drawContext);
                }
            }
            gL.glHint(3155, this.antiAliasHint);
            gL.glEnableClientState(32884);
            gL.glVertexPointer(3, 5130, 0, this.vertices.rewind());
            gL.glDrawArrays(7, 0, 4);
        }
        finally {
            if (bl) {
                gL.glMatrixMode(5890);
                gL.glPopMatrix();
            }
            gL.glPopClientAttrib();
            gL.glPopAttrib();
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }

    public Position getReferencePosition() {
        return new Position(this.southwestCorner, this.elevation);
    }

    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.northeastCorner = this.northeastCorner.add(position);
        this.southwestCorner = this.southwestCorner.add(position);
        this.elevation += position.getElevation();
        this.vertices = null;
    }

    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = position.subtract(this.getReferencePosition());
        this.move(position2);
    }
}

