/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.Pickable;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.media.opengl.GL;

public class ScreenImage
implements Renderable,
Pickable {
    private Object imageSource;
    private OrderedImage orderedImage = new OrderedImage();
    private PickSupport pickSupport = new PickSupport();
    private int imageWidth;
    private int imageHeight;
    private Point screenLocation;
    private double opacity = 1.0;
    private Layer client;

    public Point getScreenLocation() {
        return this.screenLocation;
    }

    public void setScreenLocation(Point point) {
        this.screenLocation = point;
    }

    public Object getImageSource() {
        return this.imageSource;
    }

    public void setImageSource(Object object) {
        this.imageSource = object;
    }

    public Layer getClient() {
        return this.client;
    }

    public void setClient(Layer layer) {
        this.client = layer;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        this.opacity = d;
    }

    public void render(DrawContext drawContext) {
        this.doRender(drawContext);
    }

    public void pick(DrawContext drawContext, Point point) {
        this.doRender(drawContext);
    }

    protected void doRender(DrawContext drawContext) {
        drawContext.addOrderedRenderable(this.orderedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void draw(DrawContext drawContext) {
        if (this.screenLocation == null || this.imageSource == null) {
            return;
        }
        GL gL = drawContext.getGL();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            gL.glPushAttrib(293121);
            bl = true;
            gL.glDisable(2929);
            gL.glEnable(3008);
            gL.glAlphaFunc(516, 0.001f);
            Texture texture = null;
            if (!drawContext.isPickingMode() && (texture = drawContext.getTextureCache().get(this.imageSource)) == null) {
                this.initializeTexture(drawContext);
                texture = drawContext.getTextureCache().get(this.imageSource);
                if (texture == null) {
                    return;
                }
            }
            Rectangle rectangle = drawContext.getView().getViewport();
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            bl3 = true;
            gL.glLoadIdentity();
            gL.glOrtho(0.0, rectangle.width, 0.0, rectangle.height, -1.0, 1.0);
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            bl2 = true;
            gL.glLoadIdentity();
            gL.glTranslated(this.screenLocation.x - this.imageWidth / 2, rectangle.height - (this.screenLocation.y + this.imageHeight / 2), 0.0);
            if (!drawContext.isPickingMode()) {
                if (texture != null) {
                    gL.glEnable(3553);
                    texture.bind();
                    gL.glColor4d(1.0, 1.0, 1.0, this.opacity);
                    gL.glEnable(3042);
                    gL.glBlendFunc(770, 771);
                    TextureCoords textureCoords = texture.getImageTexCoords();
                    gL.glScaled(this.imageWidth, this.imageHeight, 1.0);
                    drawContext.drawUnitQuad(textureCoords);
                }
            } else {
                this.pickSupport.clearPickList();
                this.pickSupport.beginPicking(drawContext);
                Color color = drawContext.getUniquePickColor();
                int n = color.getRGB();
                this.pickSupport.addPickableObject(n, this, null, false);
                gL.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                gL.glScaled(this.imageWidth, this.imageHeight, 1.0);
                drawContext.drawUnitQuad();
                this.pickSupport.endPicking(drawContext);
                this.pickSupport.resolvePick(drawContext, drawContext.getPickPoint(), this.client);
            }
        }
        finally {
            if (bl3) {
                gL.glMatrixMode(5889);
                gL.glPopMatrix();
            }
            if (bl2) {
                gL.glMatrixMode(5888);
                gL.glPopMatrix();
            }
            if (bl) {
                gL.glPopAttrib();
            }
        }
    }

    private void initializeTexture(DrawContext drawContext) {
        Object object;
        block6: {
            Texture texture = drawContext.getTextureCache().get(this.imageSource);
            if (texture != null) {
                return;
            }
            try {
                if (this.imageSource instanceof BufferedImage) {
                    texture = TextureIO.newTexture((BufferedImage)this.imageSource, true);
                    texture.bind();
                    this.imageWidth = texture.getWidth();
                    this.imageHeight = texture.getHeight();
                    drawContext.getTextureCache().put(this.imageSource, texture);
                    break block6;
                }
                if (this.imageSource instanceof String) {
                    object = (String)this.imageSource;
                    Object object2 = WWIO.getFileOrResourceAsStream((String)object, this.getClass());
                    if (object2 == null || object2 instanceof Exception) {
                        Logging.logger().log(Level.SEVERE, "layers.TextureLayer.ExceptionAttemptingToReadTextureFile", object2 != null ? object2 : "");
                        return;
                    }
                    texture = TextureIO.newTexture((InputStream)object2, true, null);
                    texture.bind();
                    this.imageWidth = texture.getWidth();
                    this.imageHeight = texture.getHeight();
                    drawContext.getTextureCache().put(object, texture);
                    break block6;
                }
                Logging.logger().log(Level.SEVERE, "generic.UnrecognizedImageSourceTypeeType", this.imageSource.getClass().getName());
                return;
            }
            catch (IOException iOException) {
                String string = Logging.getMessage("layers.IOExceptionDuringInitialization");
                Logging.logger().severe(string);
                throw new WWRuntimeException(string, iOException);
            }
        }
        object = drawContext.getGL();
        object.glTexEnvf(8960, 8704, 8448.0f);
        object.glTexParameteri(3553, 10241, 9729);
        object.glTexParameteri(3553, 10240, 9729);
        object.glTexParameteri(3553, 10242, 33071);
        object.glTexParameteri(3553, 10243, 33071);
    }

    private class OrderedImage
    implements OrderedRenderable {
        private OrderedImage() {
        }

        public double getDistanceFromEye() {
            return 0.0;
        }

        public void pick(DrawContext drawContext, Point point) {
            ScreenImage.this.draw(drawContext);
        }

        public void render(DrawContext drawContext) {
            ScreenImage.this.draw(drawContext);
        }
    }
}

