/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceEllipse;
import gov.nasa.worldwind.util.Logging;

public class SurfaceCircle
extends SurfaceEllipse {
    public SurfaceCircle(ShapeAttributes shapeAttributes, LatLon latLon, double d, int n) {
        super(shapeAttributes, latLon, d, d, Angle.ZERO, n);
    }

    public SurfaceCircle(ShapeAttributes shapeAttributes, LatLon latLon, double d) {
        this(shapeAttributes, latLon, d, 32);
    }

    public SurfaceCircle(ShapeAttributes shapeAttributes, int n) {
        this(shapeAttributes, LatLon.ZERO, 0.0, n);
    }

    public SurfaceCircle(ShapeAttributes shapeAttributes) {
        this(shapeAttributes, 32);
    }

    public SurfaceCircle(LatLon latLon, double d, int n) {
        this(new BasicShapeAttributes(), latLon, d, n);
    }

    public SurfaceCircle(LatLon latLon, double d) {
        this(latLon, d, 32);
    }

    public SurfaceCircle() {
        this(new BasicShapeAttributes(), 32);
    }

    public double getRadius() {
        return this.getMajorRadius();
    }

    public void setRadius(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setRadii(d, d);
    }
}

