/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.SurfaceEllipseGeometry;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;

public class SurfaceCircleGeometry
extends SurfaceEllipseGeometry {
    public SurfaceCircleGeometry(Globe globe, LatLon latLon, double d, int n) {
        super(globe, latLon, d, d, null, n, null, null);
    }

    public SurfaceCircleGeometry(Globe globe, LatLon latLon, double d, int n, Color color, Color color2) {
        super(globe, latLon, d, d, null, n, color, color2);
    }

    public double getRadius() {
        return super.getMajorAxisLength();
    }

    public void setRadius(double d) {
        if (d <= 0.0) {
            String string = Logging.getMessage("Geom.RadiusInvalid", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.setAxisLengths(d, d);
    }
}

