/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceConvexShape;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.WWMath;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceEllipse
extends SurfaceConvexShape {
    protected static final int ELLIPSE_MIN_NUM_INTERVALS = 8;
    protected static final int ELLIPSE_DEFAULT_NUM_INTERVALS = 32;
    protected LatLon center;
    protected double majorRadius;
    protected double minorRadius;
    protected Angle heading;
    private int intervals;

    public SurfaceEllipse(ShapeAttributes shapeAttributes, LatLon latLon, double d, double d2, Angle angle, int n) {
        super(shapeAttributes);
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "majorRadius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "minorRadius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 8) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "intervals < 8");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = latLon;
        this.majorRadius = d;
        this.minorRadius = d2;
        this.heading = angle;
        this.intervals = n;
    }

    public SurfaceEllipse(ShapeAttributes shapeAttributes, LatLon latLon, double d, double d2, Angle angle) {
        this(shapeAttributes, latLon, d, d2, angle, 32);
    }

    public SurfaceEllipse(ShapeAttributes shapeAttributes, int n) {
        this(shapeAttributes, LatLon.ZERO, 0.0, 0.0, Angle.ZERO, n);
    }

    public SurfaceEllipse(ShapeAttributes shapeAttributes) {
        this(shapeAttributes, 32);
    }

    public SurfaceEllipse(LatLon latLon, double d, double d2, Angle angle, int n) {
        this(new BasicShapeAttributes(), latLon, d, d2, angle, n);
    }

    public SurfaceEllipse(LatLon latLon, double d, double d2, Angle angle) {
        this(latLon, d, d2, angle, 32);
    }

    public SurfaceEllipse() {
        this(new BasicShapeAttributes(), 32);
    }

    public LatLon getCenter() {
        return this.center;
    }

    public void setCenter(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = latLon;
        this.onShapeChanged();
    }

    public double getMajorRadius() {
        return this.majorRadius;
    }

    public double getMinorRadius() {
        return this.minorRadius;
    }

    public void setMajorRadius(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.majorRadius = d;
        this.onShapeChanged();
    }

    public void setMinorRadius(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minorRadius = d;
        this.onShapeChanged();
    }

    public void setRadii(double d, double d2) {
        this.setMajorRadius(d);
        this.setMinorRadius(d2);
    }

    public Angle getHeading() {
        return this.heading;
    }

    public void setHeading(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.heading = angle;
        this.onShapeChanged();
    }

    public int getIntervals() {
        return this.intervals;
    }

    public void setIntervals(int n) {
        if (n < 8) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "intervals < 8");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.intervals = n;
        this.onShapeChanged();
    }

    @Override
    public Iterable<? extends Sector> getSectors(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterable<? extends Sector> iterable = this.computeBoundingSectors(drawContext.getGlobe());
        iterable = SurfaceEllipse.getSurfaceShapeSupport().adjustSectorsByBorderWidth(iterable, this.getAttributes());
        return iterable;
    }

    @Override
    public Position getReferencePosition() {
        return new Position(this.center, 0.0);
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        Angle angle = LatLon.greatCircleAzimuth(position, this.center);
        Angle angle2 = LatLon.greatCircleDistance(position, this.center);
        this.setCenter(LatLon.greatCircleEndPosition((LatLon)position2, angle, angle2));
    }

    protected LatLon computeLocationFor(Globe globe, Angle angle) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.majorRadius * Math.cos(angle.radians);
        double d2 = this.minorRadius * Math.sin(angle.radians);
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = globe.getRadiusAt(this.center.getLatitude(), this.center.getLongitude());
        double d5 = 1.5707963267948966 - (Math.acos(d / d3) * Math.signum(d2) - this.heading.radians);
        return LatLon.greatCircleEndPosition(this.center, d5, d3 / d4);
    }

    protected Iterable<? extends Sector> computeBoundingSectors(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = Math.max(this.majorRadius, this.minorRadius);
        return Sector.splitBoundingSectors(globe, this.center, d);
    }

    protected void computeLocations(Globe globe, int n, List<LatLon> list) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = 1 + Math.max(8, n);
        double d = Math.PI * 2 / (double)(n2 - 1);
        for (int i = 0; i < n2; ++i) {
            double d2 = i != n2 - 1 ? (double)i * d : 0.0;
            list.add(this.computeLocationFor(globe, Angle.fromRadians(d2)));
        }
    }

    @Override
    protected void computeLocations(Globe globe, List<LatLon> list) {
        this.computeLocations(globe, this.intervals, list);
    }

    @Override
    protected void computeDrawLocations(Globe globe, double d, List<LatLon> list) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = this.computeNumIntervals(globe, d);
        this.computeLocations(globe, n, list);
    }

    protected int computeNumIntervals(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = this.computeNumEdgeIntervals(globe, d);
        return n * this.intervals;
    }

    protected int computeNumEdgeIntervals(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = 1 + Math.max(8, this.intervals);
        double d2 = Math.max(this.majorRadius, this.minorRadius);
        double d3 = Math.PI * 2 / (double)(n - 1);
        Angle angle = Angle.fromRadians(d3 * d2 / globe.getRadiusAt(this.center));
        double d4 = WWMath.clamp(d * angle.degrees, this.minEdgeIntervals, this.maxEdgeIntervals);
        return (int)Math.ceil(d4);
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsLatLon(stateObject, "center", this.getCenter());
        restorableSupport.addStateValueAsDouble(stateObject, "majorRadius", this.getMajorRadius());
        restorableSupport.addStateValueAsDouble(stateObject, "minorRadius", this.getMinorRadius());
        restorableSupport.addStateValueAsDouble(stateObject, "headingDegrees", this.getHeading().degrees);
        restorableSupport.addStateValueAsInteger(stateObject, "intervals", this.getIntervals());
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        super.doRestoreState(restorableSupport, stateObject);
        LatLon latLon = restorableSupport.getStateValueAsLatLon(stateObject, "center");
        if (latLon != null) {
            this.setCenter(latLon);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "majorRadius")) != null) {
            this.setMajorRadius(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "minorRadius")) != null) {
            this.setMinorRadius(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "headingDegrees")) != null) {
            this.setHeading(Angle.fromDegrees(d));
        }
        Integer n = restorableSupport.getStateValueAsInteger(stateObject, "intervals");
        if (d != null) {
            this.setIntervals(n);
        }
    }

    @Override
    protected void legacyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.legacyRestoreState(restorableSupport, stateObject);
        Double d = restorableSupport.getStateValueAsDouble(stateObject, "orientationDegrees");
        if (d != null) {
            this.setHeading(Angle.fromDegrees(d));
        }
    }
}

