/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.FramebufferTexture;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceTile;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceImage
implements SurfaceTile,
Renderable,
PreRenderable,
Movable {
    private Sector sector;
    private Position referencePosition;
    private double opacity = 1.0;
    protected Extent extent;
    protected Object globeStateKey;
    protected WWTexture sourceTexture;
    protected WWTexture generatedTexture;
    protected List<LatLon> corners;

    public SurfaceImage(Object object, Sector sector) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.ImageSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.initializeGeometry(sector);
        this.initializeSourceTexture(object);
    }

    public SurfaceImage(Object object, Iterable<? extends LatLon> iterable) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.ImageSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.initializeGeometry(iterable);
        this.initializeSourceTexture(object);
    }

    protected void initializeGeometry(Iterable<? extends LatLon> iterable) {
        this.corners = new ArrayList<LatLon>(4);
        for (LatLon latLon : iterable) {
            this.corners.add(latLon);
        }
        this.sector = Sector.boundingSector(this.corners);
        this.referencePosition = new Position(this.sector.getCentroid(), 0.0);
        this.extent = null;
        this.globeStateKey = null;
        this.generatedTexture = null;
    }

    protected void initializeSourceTexture(Object object) {
        this.sourceTexture = new BasicWWTexture(object);
        if (Sector.isSector(this.corners) && this.sector.isSameSector(this.corners)) {
            this.generatedTexture = this.sourceTexture;
        }
    }

    public Object getImageSource() {
        return this.sourceTexture.getImageSource();
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        this.opacity = d;
    }

    @Override
    public Sector getSector() {
        return this.sector;
    }

    protected void setSector(Sector sector) {
        this.sector = sector;
    }

    public void setCorners(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.initializeGeometry(iterable);
    }

    public List<LatLon> getCorners() {
        return new ArrayList<LatLon>(this.corners);
    }

    @Override
    public Extent getExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.extent == null || !this.isExtentValid(drawContext)) {
            this.extent = drawContext.getGlobe().computeBoundingCylinder(drawContext.getVerticalExaggeration(), this.getSector());
            this.globeStateKey = drawContext.getGlobe().getStateKey(drawContext);
        }
        return this.extent;
    }

    protected boolean isExtentValid(DrawContext drawContext) {
        return drawContext.getGlobe() != null && this.globeStateKey != null && this.globeStateKey.equals(drawContext.getGlobe().getStateKey(drawContext));
    }

    @Override
    public boolean bind(DrawContext drawContext) {
        return this.generatedTexture != null && this.generatedTexture.bind(drawContext);
    }

    @Override
    public void applyInternalTransform(DrawContext drawContext) {
        if (this.generatedTexture != null) {
            this.generatedTexture.applyInternalTransform(drawContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (!this.getSector().intersects(drawContext.getVisibleSector())) {
            return;
        }
        GL gL = drawContext.getGL();
        try {
            if (!drawContext.isPickingMode()) {
                double d;
                double d2 = d = drawContext.getCurrentLayer() != null ? this.getOpacity() * drawContext.getCurrentLayer().getOpacity() : this.getOpacity();
                if (d < 1.0) {
                    gL.glPushAttrib(16393);
                    gL.glColor4d(d, d, d, d);
                } else {
                    gL.glPushAttrib(16392);
                }
                gL.glEnable(3042);
                gL.glBlendFunc(1, 771);
            } else {
                gL.glPushAttrib(8);
            }
            gL.glPolygonMode(1028, 6914);
            gL.glEnable(2884);
            gL.glCullFace(1029);
            drawContext.getGeographicSurfaceTileRenderer().renderTile(drawContext, this);
        }
        finally {
            gL.glPopAttrib();
        }
    }

    @Override
    public void preRender(DrawContext drawContext) {
        if (this.generatedTexture == null) {
            this.generatedTexture = this.makeGeneratedTexture(drawContext);
        } else if (!this.generatedTexture.isTextureCurrent(drawContext)) {
            this.generatedTexture = this.makeGeneratedTexture(drawContext);
        }
    }

    protected WWTexture makeGeneratedTexture(DrawContext drawContext) {
        return new FramebufferTexture(drawContext, this.sourceTexture, this.sector, this.corners);
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.moveTo(this.getReferencePosition().add(position));
    }

    @Override
    public void moveTo(Position position) {
        Position position2 = this.getReferencePosition();
        for (int i = 0; i < this.corners.size(); ++i) {
            LatLon latLon = this.corners.get(i);
            double d = LatLon.greatCircleDistance((LatLon)position2, (LatLon)latLon).radians;
            double d2 = LatLon.greatCircleAzimuth((LatLon)position2, (LatLon)latLon).radians;
            LatLon latLon2 = LatLon.greatCircleEndPosition((LatLon)position, d2, d);
            this.corners.set(i, latLon2);
        }
        this.setCorners(this.corners);
    }

    @Override
    public Position getReferencePosition() {
        return this.referencePosition;
    }

    protected void setReferencePosition(Position position) {
        this.referencePosition = position;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SurfaceImage surfaceImage = (SurfaceImage)object;
        return this.sourceTexture.getImageSource().equals(surfaceImage.getImageSource()) && this.getSector().equals(surfaceImage.getSector());
    }

    public int hashCode() {
        int n = this.getImageSource().hashCode();
        n = 31 * n + this.getSector().hashCode();
        return n;
    }
}

