/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.AbstractSurfaceShape;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceShapeSupport;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfacePolygon
extends AbstractSurfaceShape {
    protected List<LatLon> locationList = new ArrayList<LatLon>();

    public SurfacePolygon(ShapeAttributes shapeAttributes, Iterable<? extends LatLon> iterable) {
        super(shapeAttributes);
        this.addLocations(iterable);
    }

    public SurfacePolygon(ShapeAttributes shapeAttributes) {
        this(shapeAttributes, null);
    }

    public SurfacePolygon(Iterable<? extends LatLon> iterable) {
        this(new BasicShapeAttributes(), iterable);
    }

    public SurfacePolygon() {
        this(new BasicShapeAttributes());
    }

    public Iterable<? extends LatLon> getLocations() {
        return Collections.unmodifiableList(this.locationList);
    }

    public void setLocations(Iterable<? extends LatLon> iterable) {
        this.locationList.clear();
        this.addLocations(iterable);
        this.onShapeChanged();
    }

    protected void addLocations(Iterable<? extends LatLon> iterable) {
        if (iterable != null) {
            for (LatLon latLon : iterable) {
                this.locationList.add(latLon);
            }
        }
    }

    @Override
    public Position getReferencePosition() {
        if (this.locationList.isEmpty()) {
            return null;
        }
        return new Position(this.locationList.get(0), 0.0);
    }

    @Override
    protected void computeLocations(Globe globe, List<LatLon> list) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        list.addAll(this.locationList);
        SurfacePolygon.getSurfaceShapeSupport().makeClosedPath(list);
    }

    @Override
    protected void computeDrawLocations(Globe globe, double d, List<LatLon> list) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        SurfacePolygon.getSurfaceShapeSupport().generateIntermediateLocations(this.locationList, this.pathType, d, this.minEdgeIntervals, this.maxEdgeIntervals, true, list);
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        int n = this.locationList.size();
        LatLon[] latLonArray = new LatLon[n];
        for (int i = 0; i < n; ++i) {
            LatLon latLon = this.locationList.get(i);
            Angle angle = LatLon.greatCircleAzimuth(position, latLon);
            Angle angle2 = LatLon.greatCircleDistance(position, latLon);
            latLonArray[i] = LatLon.greatCircleEndPosition((LatLon)position2, angle, angle2);
        }
        this.setLocations(Arrays.asList(latLonArray));
    }

    @Override
    protected void doRenderToRegion(DrawContext drawContext, Sector sector, int n, int n2, int n3, int n4) {
        ShapeAttributes shapeAttributes;
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.isShowBoundingSectors()) {
            this.drawBoundingSectors(drawContext, sector, n, n2, n3, n4);
        }
        if (!((shapeAttributes = this.getAttributes()).isDrawInterior() && shapeAttributes.getInteriorOpacity() > 0.0 || shapeAttributes.isDrawOutline() && shapeAttributes.getOutlineOpacity() > 0.0)) {
            return;
        }
        List<? extends LatLon> list = this.getDrawLocations(drawContext, sector, n, n2, n3, n4);
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>();
        SurfaceShapeSupport surfaceShapeSupport = SurfacePolygon.getSurfaceShapeSupport();
        surfaceShapeSupport.assembleShapeVertices(sector, n, n2, n3, n4, list, arrayList);
        surfaceShapeSupport.makeWindingCounterClockwise(arrayList);
        surfaceShapeSupport.stripRedundantEndPoint(arrayList);
        surfaceShapeSupport.beginRendering(drawContext);
        surfaceShapeSupport.bindVertexData(drawContext, 2, arrayList);
        if (shapeAttributes.isDrawInterior() && shapeAttributes.getInteriorOpacity() > 0.0) {
            surfaceShapeSupport.applyInteriorState(drawContext, shapeAttributes);
            surfaceShapeSupport.drawArraysAsPolygon(drawContext, arrayList);
        }
        if (shapeAttributes.isDrawOutline() && shapeAttributes.getOutlineOpacity() > 0.0) {
            surfaceShapeSupport.applyOutlineState(drawContext, shapeAttributes);
            surfaceShapeSupport.drawArrays(drawContext, 2, 0, arrayList.size());
        }
        surfaceShapeSupport.endRendering(drawContext);
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsLatLonList(stateObject, "locationList", this.getLocations());
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doRestoreState(restorableSupport, stateObject);
        ArrayList<LatLon> arrayList = restorableSupport.getStateValueAsLatLonList(stateObject, "locationList");
        if (arrayList != null) {
            this.setLocations(arrayList);
        }
    }

    @Override
    protected void legacyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.legacyRestoreState(restorableSupport, stateObject);
        ArrayList<LatLon> arrayList = restorableSupport.getStateValueAsLatLonList(stateObject, "locations");
        if (arrayList != null) {
            this.setLocations(arrayList);
        }
    }
}

