/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.render.SurfaceShapeSupport;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfacePolyline
extends SurfacePolygon {
    public SurfacePolyline(ShapeAttributes shapeAttributes, Iterable<? extends LatLon> iterable) {
        super(shapeAttributes, iterable);
    }

    public SurfacePolyline(Iterable<? extends LatLon> iterable) {
        super(iterable);
    }

    public SurfacePolyline(ShapeAttributes shapeAttributes) {
        super(shapeAttributes);
    }

    public SurfacePolyline() {
    }

    @Override
    protected void computeLocations(Globe globe, List<LatLon> list) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        list.addAll(this.locationList);
    }

    @Override
    protected void computeDrawLocations(Globe globe, double d, List<LatLon> list) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        SurfacePolyline.getSurfaceShapeSupport().generateIntermediateLocations(this.locationList, this.pathType, d, this.minEdgeIntervals, this.maxEdgeIntervals, false, list);
    }

    @Override
    protected void doRenderToRegion(DrawContext drawContext, Sector sector, int n, int n2, int n3, int n4) {
        ShapeAttributes shapeAttributes;
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.isShowBoundingSectors()) {
            this.drawBoundingSectors(drawContext, sector, n, n2, n3, n4);
        }
        if (!(shapeAttributes = this.getAttributes()).isDrawOutline() || !(shapeAttributes.getOutlineOpacity() > 0.0)) {
            return;
        }
        List<? extends LatLon> list = this.getDrawLocations(drawContext, sector, n, n2, n3, n4);
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>();
        SurfaceShapeSupport surfaceShapeSupport = SurfacePolyline.getSurfaceShapeSupport();
        surfaceShapeSupport.beginRendering(drawContext);
        surfaceShapeSupport.assembleShapeVertices(sector, n, n2, n3, n4, list, arrayList);
        surfaceShapeSupport.bindVertexData(drawContext, 2, arrayList);
        surfaceShapeSupport.applyOutlineState(drawContext, shapeAttributes);
        surfaceShapeSupport.drawArrays(drawContext, 3, 0, arrayList.size());
        surfaceShapeSupport.endRendering(drawContext);
    }
}

