/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceConvexShape;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceQuad
extends SurfaceConvexShape {
    protected static final int MIN_NUM_INTERVALS = 1;
    protected LatLon center;
    protected double width;
    protected double height;
    protected Angle heading;

    public SurfaceQuad(ShapeAttributes shapeAttributes, LatLon latLon, double d, double d2, Angle angle) {
        super(shapeAttributes);
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "height < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = latLon;
        this.width = d;
        this.height = d2;
        this.heading = angle;
    }

    public SurfaceQuad(ShapeAttributes shapeAttributes) {
        this(shapeAttributes, LatLon.ZERO, 0.0, 0.0, Angle.ZERO);
    }

    public SurfaceQuad(LatLon latLon, double d, double d2, Angle angle) {
        this(new BasicShapeAttributes(), latLon, d, d2, angle);
    }

    public SurfaceQuad() {
        this(new BasicShapeAttributes());
    }

    public LatLon getCenter() {
        return this.center;
    }

    public void setCenter(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = latLon;
        this.onShapeChanged();
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setWidth(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.width = d;
        this.onShapeChanged();
    }

    public void setHeight(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "height < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.height = d;
        this.onShapeChanged();
    }

    public void setSize(double d, double d2) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "height < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.width = d;
        this.height = d2;
        this.onShapeChanged();
    }

    public Angle getHeading() {
        return this.heading;
    }

    public void setHeading(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.HeadingIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.heading = angle;
        this.onShapeChanged();
    }

    @Override
    public Position getReferencePosition() {
        return new Position(this.center, 0.0);
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        Angle angle = LatLon.greatCircleAzimuth(position, this.center);
        Angle angle2 = LatLon.greatCircleDistance(position, this.center);
        this.setCenter(LatLon.greatCircleEndPosition((LatLon)position2, angle, angle2));
    }

    @Override
    protected void computeLocations(Globe globe, List<LatLon> list) {
        double[] dArray;
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.width / 2.0;
        double d2 = this.height / 2.0;
        double d3 = globe.getRadiusAt(this.center.getLatitude(), this.center.getLongitude());
        double d4 = Math.sqrt(d * d + d2 * d2);
        double d5 = d4 / d3;
        for (double d6 : dArray = new double[]{Math.atan2(-d2, -d), Math.atan2(-d2, d), Math.atan2(d2, d), Math.atan2(d2, -d), Math.atan2(-d2, -d)}) {
            double d7 = 1.5707963267948966 - (d6 - this.heading.radians);
            LatLon latLon = LatLon.greatCircleEndPosition(this.center, d7, d5);
            list.add(latLon);
        }
    }

    @Override
    protected void computeDrawLocations(Globe globe, double d, List<LatLon> list) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        this.computeLocations(globe, arrayList);
        SurfaceQuad.getSurfaceShapeSupport().generateIntermediateLocations(arrayList, this.pathType, d, this.minEdgeIntervals, this.maxEdgeIntervals, false, list);
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsLatLon(stateObject, "center", this.getCenter());
        restorableSupport.addStateValueAsDouble(stateObject, "width", this.getWidth());
        restorableSupport.addStateValueAsDouble(stateObject, "height", this.getHeight());
        restorableSupport.addStateValueAsDouble(stateObject, "headingDegrees", this.getHeading().degrees);
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        super.doRestoreState(restorableSupport, stateObject);
        LatLon latLon = restorableSupport.getStateValueAsLatLon(stateObject, "center");
        if (latLon != null) {
            this.setCenter(latLon);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "width")) != null) {
            this.setWidth(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "height")) != null) {
            this.setHeight(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "headingDegrees")) != null) {
            this.setHeading(Angle.fromDegrees(d));
        }
    }

    @Override
    protected void legacyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        super.legacyRestoreState(restorableSupport, stateObject);
        Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "halfWidth");
        Double d3 = restorableSupport.getStateValueAsDouble(stateObject, "halfHeight");
        if (d2 != null && d3 != null) {
            this.setSize(2.0 * d2, 2.0 * d3);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "orientationDegrees")) != null) {
            this.setHeading(Angle.fromDegrees(d));
        }
    }
}

