/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.SurfacePolygonGeometry;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceQuadGeometry
extends SurfacePolygonGeometry {
    private LatLon center;
    private double width;
    private double height;
    private Angle orientation;

    public SurfaceQuadGeometry(Globe globe, LatLon latLon, double d, double d2, Angle angle) {
        super(SurfaceQuadGeometry.makePositions(globe, latLon, d, d2, angle), null, null);
        this.globe = globe;
        this.center = latLon;
        this.width = d;
        this.height = d2;
        this.orientation = angle;
    }

    public SurfaceQuadGeometry(Globe globe, LatLon latLon, double d, double d2, Angle angle, Color color, Color color2) {
        super(SurfaceQuadGeometry.makePositions(globe, latLon, d, d2, angle), color, color2);
        this.globe = globe;
        this.center = latLon;
        this.width = d;
        this.height = d2;
        this.orientation = angle;
    }

    public LatLon getCenter() {
        return this.center;
    }

    public void setCenter(LatLon latLon) {
        this.center = latLon;
        this.setPositions(SurfaceQuadGeometry.makePositions(this.globe, this.center, this.width, this.height, this.orientation));
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setSize(double d, double d2) {
        this.width = d;
        this.height = d2;
        this.setPositions(SurfaceQuadGeometry.makePositions(this.globe, this.center, this.width, this.height, this.orientation));
    }

    public Angle getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Angle angle) {
        this.orientation = angle;
        this.setPositions(SurfaceQuadGeometry.makePositions(this.globe, this.center, this.width, this.height, this.orientation));
    }

    private static Iterable<LatLon> makePositions(Globe globe, LatLon latLon, double d, double d2, Angle angle) {
        if (angle == null) {
            angle = Angle.ZERO;
        }
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = Logging.getMessage("Geom.WidthInvalid", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = Logging.getMessage("Geom.HeightInvalid", d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[]{Math.atan2(d2, d), Math.atan2(d2, -d), Math.atan2(-d2, -d), Math.atan2(-d2, d), Math.atan2(d2, d)};
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(dArray.length);
        double d3 = globe.getRadiusAt(latLon.getLatitude(), latLon.getLongitude());
        double d4 = Math.sqrt(d * d + d2 * d2);
        for (double d5 : dArray) {
            double d6 = 1.5707963267948966 - (d5 + angle.radians);
            LatLon latLon2 = LatLon.greatCircleEndPosition(latLon, d6, d4 / d3);
            arrayList.add(latLon2);
        }
        return arrayList;
    }
}

