/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceConvexShape;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceSector
extends SurfaceConvexShape {
    protected static final String SECTOR_DEFAULT_PATH_TYPE = "gov.nasa.worldwind.avkey.Linear";
    protected Sector sector;

    public SurfaceSector(ShapeAttributes shapeAttributes, Sector sector) {
        super(shapeAttributes);
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = sector;
        this.setPathType(SECTOR_DEFAULT_PATH_TYPE);
    }

    public SurfaceSector(ShapeAttributes shapeAttributes) {
        this(shapeAttributes, Sector.EMPTY_SECTOR);
    }

    public SurfaceSector(Sector sector) {
        this(new BasicShapeAttributes(), sector);
    }

    public SurfaceSector() {
        this(new BasicShapeAttributes());
    }

    public Sector getSector() {
        return this.sector;
    }

    public void setSector(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = sector;
        this.onShapeChanged();
    }

    @Override
    public Position getReferencePosition() {
        return new Position(this.sector.getCentroid(), 0.0);
    }

    @Override
    protected void computeLocations(Globe globe, List<LatLon> list) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        list.addAll(this.sector.asList());
        SurfaceSector.getSurfaceShapeSupport().makeClosedPath(list);
    }

    @Override
    protected void computeDrawLocations(Globe globe, double d, List<LatLon> list) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        SurfaceSector.getSurfaceShapeSupport().generateIntermediateLocations(this.sector, this.pathType, d, this.minEdgeIntervals, this.maxEdgeIntervals, true, list);
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        LatLon[] latLonArray = new LatLon[]{new LatLon(this.sector.getMinLatitude(), this.sector.getMinLongitude()), new LatLon(this.sector.getMaxLatitude(), this.sector.getMaxLongitude())};
        LatLon[] latLonArray2 = new LatLon[2];
        for (int i = 0; i < 2; ++i) {
            Angle angle = LatLon.greatCircleAzimuth(position, latLonArray[i]);
            Angle angle2 = LatLon.greatCircleDistance(position, latLonArray[i]);
            latLonArray2[i] = LatLon.greatCircleEndPosition((LatLon)position2, angle, angle2);
        }
        this.setSector(new Sector(latLonArray2[0].getLatitude(), latLonArray2[1].getLatitude(), latLonArray2[0].getLongitude(), latLonArray2[1].getLongitude()));
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsSector(stateObject, "sector", this.getSector());
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doRestoreState(restorableSupport, stateObject);
        Sector sector = restorableSupport.getStateValueAsSector(stateObject, "sector");
        if (sector != null) {
            this.setSector(sector);
        }
    }

    @Override
    protected void legacyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.legacyRestoreState(restorableSupport, stateObject);
        ArrayList<LatLon> arrayList = restorableSupport.getStateValueAsLatLonList(stateObject, "locations");
        if (arrayList != null) {
            this.setSector(Sector.boundingSector(arrayList));
        }
    }
}

