/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfacePolygonGeometry;
import gov.nasa.worldwind.terrain.RectangularTessellator;
import gov.nasa.worldwind.terrain.SectorGeometry;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Paint;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SurfaceShapeGeometry
implements Renderable,
Disposable,
Movable {
    protected Globe globe;
    protected ArrayList<LatLon> positions = new ArrayList();
    private Sector sector;
    private Vector<Triangle> triangles;
    private Vector<Polygon> polygons = new Vector();
    private Polyline polyline;
    private Extent extent;
    private long lastFrameTime = 0L;
    private boolean forceSurfaceIntersect = true;
    private Color interiorColor;
    private float[] interiorColorGL = new float[4];
    private boolean drawBorder = true;
    private boolean drawInterior = true;
    private boolean antiAlias = true;
    private DoubleBuffer buff;
    private int[] firsts;
    private int[] counts;
    private static long THROTTLE_RATE = 1000L;
    private static final double EPSILON = 1.0E-10;
    private static final Color DEFAULT_COLOR = new Color(1.0f, 1.0f, 0.0f, 0.4f);
    private static final Color DEFAULT_BORDER_COLOR = new Color(1.0f, 1.0f, 0.0f, 0.7f);
    private static final int X = 0;
    private static final int Y = 1;
    private static final int Z = 2;

    public SurfaceShapeGeometry(Iterable<? extends LatLon> iterable, Color color, Color color2) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setInteriorColor(color != null ? color : DEFAULT_COLOR);
        this.polyline = new Polyline();
        this.polyline.setColor(color2 != null ? color2 : DEFAULT_BORDER_COLOR);
        this.polyline.setFollowTerrain(true);
        this.polyline.setPathType(1);
        this.replacePositions(iterable);
    }

    private void replacePositions(Iterable<? extends LatLon> iterable) {
        this.positions.clear();
        for (LatLon latLon : iterable) {
            this.positions.add(latLon);
        }
        this.polyline.setPositions(this.positions, 0.0);
        this.resetBounds();
    }

    @Override
    public void dispose() {
    }

    public ArrayList<Sector> getSectors() {
        ArrayList<Sector> arrayList = new ArrayList<Sector>();
        arrayList.add(this.sector);
        return arrayList;
    }

    public Iterable<LatLon> getPositions() {
        return this.positions;
    }

    public void setPositions(Iterable<? extends LatLon> iterable) {
        this.replacePositions(iterable);
    }

    public Paint getInteriorColor() {
        return this.interiorColor;
    }

    public void setInteriorColor(Color color) {
        this.interiorColor = color;
        this.interiorColorGL[0] = (float)this.interiorColor.getRed() / 255.0f;
        this.interiorColorGL[1] = (float)this.interiorColor.getGreen() / 255.0f;
        this.interiorColorGL[2] = (float)this.interiorColor.getBlue() / 255.0f;
        this.interiorColorGL[3] = (float)this.interiorColor.getAlpha() / 255.0f;
    }

    public Color getBorderColor() {
        return this.polyline.getColor();
    }

    public void setBorderColor(Color color) {
        this.polyline.setColor(color);
    }

    public void setBorderWidth(double d) {
        this.polyline.setLineWidth(d);
    }

    public double getBorderWidth() {
        return this.polyline.getLineWidth();
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
    }

    public boolean isDrawInterior() {
        return this.drawInterior;
    }

    public void setDrawInterior(boolean bl) {
        this.drawInterior = bl;
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean bl) {
        this.antiAlias = bl;
    }

    public double getPerimeter() {
        return this.polyline.getLength();
    }

    public double getArea() throws IllegalStateException {
        if (this.polygons == null || this.polygons.size() == 0 || this.globe == null) {
            throw new IllegalStateException("NPE in getArea");
        }
        double d = 0.0;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        for (Polygon polygon : this.polygons) {
            for (int i = 2; i < polygon.numVerts; ++i) {
                dArray[0] = polygon.xy[i - 1][0] - polygon.xy[0][0];
                dArray[1] = polygon.xy[i - 1][1] - polygon.xy[0][1];
                dArray[2] = polygon.xy[i - 1][2] - polygon.xy[0][2];
                dArray2[0] = polygon.xy[i][0] - polygon.xy[0][0];
                dArray2[1] = polygon.xy[i][1] - polygon.xy[0][1];
                dArray2[2] = polygon.xy[i][2] - polygon.xy[0][2];
                double d2 = dArray[1] * dArray2[2] - dArray2[1] * dArray[2];
                double d3 = dArray[0] * dArray2[2] - dArray2[0] * dArray[2];
                double d4 = dArray[0] * dArray2[1] - dArray2[0] * dArray[1];
                d += 0.5 * Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
            }
        }
        return d;
    }

    @Override
    public void render(DrawContext drawContext) {
        this.globe = drawContext.getGlobe();
        Frustum frustum = drawContext.getView().getFrustumInModelCoordinates();
        if (!this.getExtent(drawContext).intersects(frustum)) {
            return;
        }
        if (this.triangles == null) {
            this.tessellate();
        }
        if (System.currentTimeMillis() - this.lastFrameTime > THROTTLE_RATE || this.forceSurfaceIntersect) {
            Iterable<SectorGeometry> iterable = this.getIntersectingGeometryTiles(drawContext.getSurfaceGeometry());
            this.intersectSurfaceGeometry(iterable);
            this.packagePolygonsForDrawing();
            this.lastFrameTime = System.currentTimeMillis();
            this.forceSurfaceIntersect = false;
        }
        this.renderPolygons(drawContext);
    }

    private void packagePolygonsForDrawing() {
        if (this.polygons.size() == 0) {
            return;
        }
        int n = 0;
        for (Polygon object : this.polygons) {
            n += object.numVerts;
        }
        this.buff = BufferUtil.newDoubleBuffer(n * 3);
        this.firsts = new int[this.polygons.size()];
        this.counts = new int[this.polygons.size()];
        n = 0;
        int n2 = 0;
        for (Polygon polygon : this.polygons) {
            this.firsts[n2] = n;
            this.counts[n2] = polygon.numVerts;
            for (int i = 0; i < polygon.numVerts; ++i) {
                this.buff.put(polygon.xy[i]);
            }
            n += polygon.numVerts;
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderPolygons(DrawContext drawContext) {
        Vec4 vec4 = this.getReferencePoint();
        GL gL = drawContext.getGL();
        gL.glPushAttrib(16393);
        drawContext.getView().pushReferenceCenter(drawContext, vec4);
        this.pushOffset(drawContext);
        try {
            if (!drawContext.isPickingMode()) {
                gL.glEnable(3042);
                gL.glBlendFunc(770, 771);
                gL.glColor4fv(this.interiorColorGL, 0);
            }
            if (this.drawInterior || drawContext.isPickingMode()) {
                gL.glPolygonMode(1032, 6914);
                gL.glEnableClientState(32884);
                this.buff.rewind();
                gL.glVertexPointer(3, 5130, 0, this.buff);
                gL.glMultiDrawArrays(6, this.firsts, 0, this.counts, 0, this.firsts.length);
                gL.glDisableClientState(32884);
            }
            if (!drawContext.isPickingMode() && this.drawBorder) {
                this.polyline.render(drawContext);
            }
        }
        finally {
            this.popOffset(drawContext);
            drawContext.getView().popReferenceCenter(drawContext);
            gL.glPopAttrib();
        }
    }

    private void pushOffset(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        float[] fArray = new float[16];
        gL.glGetFloatv(2983, fArray, 0);
        fArray[10] = (float)((double)fArray[10] * 0.99);
        gL.glPushAttrib(4096);
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadMatrixf(fArray, 0);
    }

    private void popOffset(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }

    private void intersectSurfaceGeometry(Iterable<SectorGeometry> iterable) {
        this.polygons.clear();
        if (iterable == null) {
            return;
        }
        for (SectorGeometry sectorGeometry : iterable) {
            RectangularTessellator.RectGeometry rectGeometry = RectangularTessellator.getTerrainGeometry(sectorGeometry);
            for (Triangle triangle : this.triangles) {
                if (triangle.spansDateline) {
                    this.splitAtDateline(triangle, rectGeometry);
                    continue;
                }
                this.intersectTerrain(triangle, rectGeometry);
            }
        }
    }

    private void intersectTerrain(Triangle triangle, RectangularTessellator.RectGeometry rectGeometry) {
        ActiveEdge activeEdge = new ActiveEdge(triangle.vertices[0], triangle.vertices[1]);
        ActiveEdge activeEdge2 = new ActiveEdge(triangle.vertices[1], triangle.vertices[2]);
        ActiveEdge activeEdge3 = new ActiveEdge(triangle.vertices[0], triangle.vertices[2]);
        ArrayList<ActiveEdge> arrayList = new ArrayList<ActiveEdge>(3);
        if (Math.abs(activeEdge.deltaY) > 1.0E-10) {
            arrayList.add(activeEdge);
        }
        if (Math.abs(activeEdge2.deltaY) > 1.0E-10) {
            if (activeEdge2.p0Lat < activeEdge.p0Lat) {
                arrayList.add(0, activeEdge2);
            } else {
                arrayList.add(activeEdge2);
            }
        }
        if (Math.abs(activeEdge3.deltaY) > 1.0E-10) {
            if (activeEdge3.p0Lat < ((ActiveEdge)arrayList.get((int)0)).p0Lat) {
                arrayList.add(0, activeEdge3);
            } else if (arrayList.size() == 2 && activeEdge3.p0Lat < ((ActiveEdge)arrayList.get((int)1)).p0Lat) {
                arrayList.add(1, activeEdge3);
            } else {
                arrayList.add(activeEdge3);
            }
        }
        if (arrayList.size() < 2) {
            return;
        }
        Iterator iterator = arrayList.iterator();
        activeEdge = (ActiveEdge)iterator.next();
        activeEdge2 = (ActiveEdge)iterator.next();
        if (activeEdge.p1Lat <= rectGeometry.getMinLatitude()) {
            if (iterator.hasNext()) {
                activeEdge = activeEdge2;
                activeEdge2 = (ActiveEdge)iterator.next();
            } else {
                return;
            }
        }
        if (activeEdge2.p1Lat <= rectGeometry.getMinLatitude()) {
            if (iterator.hasNext()) {
                activeEdge2 = (ActiveEdge)iterator.next();
            } else {
                return;
            }
        }
        double d = activeEdge.p0Lon;
        double d2 = activeEdge2.p0Lon;
        double d3 = activeEdge.p0Lat;
        int n = rectGeometry.getRowAtLat(d3);
        if (n >= rectGeometry.getNumRows()) {
            return;
        }
        if (n < 0) {
            n = 0;
            d3 = rectGeometry.getLatAtRow(n);
            d = activeEdge.getLonAtLat(d3);
            d2 = activeEdge2.getLonAtLat(d3);
        }
        if (d > d2) {
            double d4 = d;
            d = d2;
            d2 = d4;
        }
        Vertex vertex = new Vertex(d, d3);
        Vertex vertex2 = new Vertex(d2, d3);
        while (true) {
            double d5;
            if ((d5 = rectGeometry.getLatAtRow(n + 1)) <= activeEdge.p1Lat && d5 <= activeEdge2.p1Lat) {
                ++n;
            } else {
                if (d5 > activeEdge.p1Lat) {
                    d5 = activeEdge.p1Lat;
                }
                if (d5 > activeEdge2.p1Lat) {
                    d5 = activeEdge2.p1Lat;
                }
            }
            Vertex vertex3 = new Vertex(activeEdge.getLonAtLat(d5), d5);
            Vertex vertex4 = new Vertex(activeEdge2.getLonAtLat(d5), d5);
            if (vertex3.x > vertex4.x) {
                Vertex vertex5 = vertex3;
                vertex3 = vertex4;
                vertex4 = vertex5;
            }
            double d6 = vertex.x < vertex3.x ? vertex.x : vertex3.x;
            double d7 = vertex2.x > vertex4.x ? vertex2.x : vertex4.x;
            int n2 = rectGeometry.getColAtLon(d6);
            int n3 = rectGeometry.getColAtLon(d7);
            if (n2 < rectGeometry.getNumCols() && n3 >= 0) {
                Polygon polygon = new Polygon();
                polygon.addVertex(vertex.x, vertex.y);
                polygon.addVertex(vertex3.x, vertex3.y);
                polygon.addVertex(vertex4.x, vertex4.y);
                polygon.addVertex(vertex2.x, vertex2.y);
                if (n2 < 0) {
                    polygon.splitAtXPlane(rectGeometry.getMinLongitude());
                    n2 = 0;
                }
                if (n3 >= rectGeometry.getNumCols()) {
                    polygon = polygon.splitAtXPlane(rectGeometry.getMaxLongitude());
                    n3 = rectGeometry.getNumCols() - 1;
                }
                for (int i = n2 + 1; i <= n3; ++i) {
                    double d8 = rectGeometry.getLonAtCol(i);
                    Polygon polygon2 = polygon.splitAtXPlane(d8);
                    if (polygon2 == null) continue;
                    polygon2.convertToXYZ(rectGeometry);
                    this.polygons.add(polygon2);
                }
                polygon.convertToXYZ(rectGeometry);
                this.polygons.add(polygon);
            }
            if (d5 >= activeEdge.p1Lat) {
                if (!iterator.hasNext()) break;
                activeEdge = (ActiveEdge)iterator.next();
            }
            if (d5 >= activeEdge2.p1Lat) {
                if (!iterator.hasNext()) break;
                activeEdge2 = (ActiveEdge)iterator.next();
            }
            if (n >= rectGeometry.getNumRows()) break;
            vertex = vertex3;
            vertex2 = vertex4;
        }
    }

    private void splitAtDateline(Triangle triangle, RectangularTessellator.RectGeometry rectGeometry) {
        int n;
        Polygon polygon = new Polygon();
        for (int i = 0; i < 3; ++i) {
            double d = triangle.vertices[i].getLatitude().degrees;
            double d2 = triangle.vertices[i].getLongitude().degrees;
            if (d2 > 0.0) {
                d2 -= Angle.POS360.degrees;
            }
            polygon.addVertex(d2, d);
        }
        Polygon polygon2 = polygon.splitAtXPlane(Angle.NEG180.degrees);
        Triangle triangle2 = new Triangle();
        for (n = 2; n < polygon2.numVerts; ++n) {
            triangle2.vertices[0] = new LatLon(Angle.fromDegrees(polygon2.xy[0][1]), Angle.fromDegrees(polygon2.xy[0][0] + Angle.POS360.degrees));
            triangle2.vertices[1] = new LatLon(Angle.fromDegrees(polygon2.xy[n - 1][1]), Angle.fromDegrees(polygon2.xy[n - 1][0] + Angle.POS360.degrees));
            triangle2.vertices[2] = new LatLon(Angle.fromDegrees(polygon2.xy[n][1]), Angle.fromDegrees(polygon2.xy[n][0] + Angle.POS360.degrees));
            this.intersectTerrain(triangle2, rectGeometry);
        }
        for (n = 2; n < polygon.numVerts; ++n) {
            triangle2.vertices[0] = new LatLon(Angle.fromDegrees(polygon.xy[0][1]), Angle.fromDegrees(polygon.xy[0][0]));
            triangle2.vertices[1] = new LatLon(Angle.fromDegrees(polygon.xy[n - 1][1]), Angle.fromDegrees(polygon.xy[n - 1][0]));
            triangle2.vertices[2] = new LatLon(Angle.fromDegrees(polygon.xy[n][1]), Angle.fromDegrees(polygon.xy[n][0]));
            this.intersectTerrain(triangle2, rectGeometry);
        }
    }

    protected Iterable<SectorGeometry> getIntersectingGeometryTiles(SectorGeometryList sectorGeometryList) {
        ArrayList<SectorGeometry> arrayList = null;
        for (SectorGeometry sectorGeometry : sectorGeometryList) {
            if (!this.getSector().intersects(sectorGeometry.getSector())) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<SectorGeometry>();
            }
            arrayList.add(sectorGeometry);
        }
        return arrayList;
    }

    @Override
    public Position getReferencePosition() {
        return new Position(this.positions.get(0), 0.0);
    }

    public Vec4 getReferencePoint() {
        Position position = this.getReferencePosition();
        double d = this.globe.getElevation(position.getLatitude(), position.getLongitude());
        return this.globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), d);
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.moveTo(this.getReferencePosition().add(position));
    }

    public void shiftTo(Position position) {
        LatLon latLon;
        if (this.globe == null) {
            return;
        }
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = this.globe.computePointFromPosition(this.getReferencePosition().getLatitude(), this.getReferencePosition().getLongitude(), 0.0);
        Vec4 vec42 = this.globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), 0.0);
        Vec4 vec43 = vec42.subtract3(vec4);
        for (int i = 0; i < this.positions.size(); ++i) {
            LatLon object = this.positions.get(i);
            Vec4 i2 = this.globe.computePointFromPosition(object.getLatitude(), object.getLongitude(), 0.0);
            i2 = i2.add3(vec43);
            latLon = this.globe.computePositionFromPoint(i2);
            this.positions.set(i, new LatLon(latLon.getLatitude(), latLon.getLongitude()));
        }
        this.polyline.setPositions(this.positions, 0.0);
        for (Triangle triangle : this.triangles) {
            for (int i = 0; i < 3; ++i) {
                latLon = triangle.vertices[i];
                Vec4 vec44 = this.globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), 0.0);
                vec44 = vec44.add3(vec43);
                Position position2 = this.globe.computePositionFromPoint(vec44);
                triangle.vertices[i] = new LatLon(position2.getLatitude(), position2.getLongitude());
            }
            triangle.setOrClearDatelineFlag();
        }
        this.resetBounds();
        this.forceSurfaceIntersect = true;
    }

    @Override
    public void moveTo(Position position) {
        double d;
        if (LatLon.positionsCrossDateLine(this.positions)) {
            this.shiftTo(position);
            return;
        }
        Position position2 = this.getReferencePosition();
        for (int i = 0; i < this.positions.size(); ++i) {
            LatLon object = this.positions.get(i);
            double d2 = LatLon.greatCircleDistance((LatLon)position2, (LatLon)object).radians;
            d = LatLon.greatCircleAzimuth((LatLon)position2, (LatLon)object).radians;
            LatLon latLon = LatLon.greatCircleEndPosition((LatLon)position, d, d2);
            this.positions.set(i, latLon);
        }
        this.polyline.setPositions(this.positions, 0.0);
        for (Triangle triangle : this.triangles) {
            for (int i = 0; i < 3; ++i) {
                LatLon latLon;
                LatLon latLon2 = triangle.vertices[i];
                d = LatLon.greatCircleDistance((LatLon)position2, (LatLon)latLon2).radians;
                double d3 = LatLon.greatCircleAzimuth((LatLon)position2, (LatLon)latLon2).radians;
                triangle.vertices[i] = latLon = LatLon.greatCircleEndPosition((LatLon)position, d3, d);
            }
            triangle.setOrClearDatelineFlag();
        }
        this.resetBounds();
        this.forceSurfaceIntersect = true;
    }

    public static SurfaceShapeGeometry createEllipse(Globe globe, LatLon latLon, double d, double d2, Angle angle, int n, Color color, Color color2) {
        if (angle == null) {
            angle = Angle.ZERO;
        }
        if (d <= 0.0) {
            String string = Logging.getMessage("Geom.MajorAxisInvalid");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = Logging.getMessage("Geom.MajorAxisInvalid");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = 1 + Math.max(n, 4);
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        double d3 = globe.getRadiusAt(latLon.getLatitude(), latLon.getLongitude());
        double d4 = Math.PI * 2 / (double)(n2 - 1);
        for (int i = 0; i < n2; ++i) {
            double d5 = i != n2 - 1 ? (double)i * d4 : 0.0;
            double d6 = 1.5707963267948966 - (d5 + angle.radians);
            double d7 = d * Math.cos(d5);
            double d8 = d2 * Math.sin(d5);
            double d9 = Math.sqrt(d7 * d7 + d8 * d8);
            LatLon latLon2 = LatLon.greatCircleEndPosition(latLon, d6, d9 / d3);
            arrayList.add(latLon2);
        }
        return new SurfacePolygonGeometry(arrayList, color, color2);
    }

    private Sector getSector() {
        if (this.sector == null) {
            this.sector = Sector.boundingSector(this.positions);
        }
        return this.sector;
    }

    private Extent getExtent(DrawContext drawContext) {
        if (this.extent == null) {
            this.extent = this.globe.computeBoundingCylinder(drawContext.getVerticalExaggeration(), this.getSector());
        }
        return this.extent;
    }

    private void resetBounds() {
        this.sector = null;
        this.extent = null;
    }

    private void tessellate() {
        this.triangles = new Vector();
        GLU gLU = new GLU();
        GLUtessellator gLUtessellator = gLU.gluNewTess();
        TessCallback tessCallback = new TessCallback(gLU);
        gLU.gluTessCallback(gLUtessellator, 100101, tessCallback);
        gLU.gluTessCallback(gLUtessellator, 100105, tessCallback);
        gLU.gluTessCallback(gLUtessellator, 100104, tessCallback);
        gLU.gluTessCallback(gLUtessellator, 100100, tessCallback);
        gLU.gluTessCallback(gLUtessellator, 100102, tessCallback);
        gLU.gluTessCallback(gLUtessellator, 100103, tessCallback);
        int n = this.positions.size();
        double[][] dArray = new double[n][3];
        gLU.gluTessBeginPolygon(gLUtessellator, null);
        gLU.gluTessBeginContour(gLUtessellator);
        for (int i = 0; i < n; ++i) {
            LatLon latLon = this.positions.get(i);
            dArray[i][0] = latLon.getLongitude().degrees;
            if (dArray[i][0] > 0.0) {
                double[] dArray2 = dArray[i];
                dArray2[0] = dArray2[0] - Angle.POS360.degrees;
            }
            dArray[i][1] = latLon.getLatitude().degrees;
            dArray[i][2] = 0.0;
            gLU.gluTessVertex(gLUtessellator, dArray[i], 0, dArray[i]);
        }
        gLU.gluTessEndContour(gLUtessellator);
        gLU.gluTessEndPolygon(gLUtessellator);
        gLU.gluDeleteTess(gLUtessellator);
    }

    private static class Triangle {
        LatLon[] vertices = new LatLon[3];
        boolean spansDateline = false;

        public void setOrClearDatelineFlag() {
            this.spansDateline = false;
            if ((this.vertices[0] != null || this.vertices[1] != null || this.vertices[2] != null) && (LatLon.positionsCrossLongitudeBoundary(this.vertices[0], this.vertices[1]) || LatLon.positionsCrossLongitudeBoundary(this.vertices[1], this.vertices[2]) || LatLon.positionsCrossLongitudeBoundary(this.vertices[0], this.vertices[2]))) {
                this.spansDateline = true;
            }
        }
    }

    private class TessCallback
    extends GLUtessellatorCallbackAdapter {
        private GLU glu;
        private int type;
        private Triangle currTriangle;
        private short state;
        private boolean flipOrder;

        public TessCallback(GLU gLU) {
            this.glu = gLU;
        }

        public void begin(int n) {
            this.state = 0;
            this.type = n;
            this.flipOrder = false;
            this.currTriangle = new Triangle();
        }

        public void end() {
        }

        public void vertex(Object object) {
            if (!(object instanceof double[])) {
                return;
            }
            double[] dArray = (double[])object;
            Angle angle = Angle.normalizedLongitude(Angle.fromDegrees(dArray[0]));
            Angle angle2 = Angle.normalizedLatitude(Angle.fromDegrees(dArray[1]));
            short s = this.state;
            this.state = (short)(s + 1);
            this.currTriangle.vertices[s] = new LatLon(angle2, angle);
            if (this.state == 3) {
                this.currTriangle.setOrClearDatelineFlag();
                SurfaceShapeGeometry.this.triangles.add(this.currTriangle);
                switch (this.type) {
                    case 6: {
                        Triangle triangle = new Triangle();
                        triangle.vertices[0] = this.currTriangle.vertices[0];
                        triangle.vertices[1] = this.currTriangle.vertices[2];
                        this.currTriangle = triangle;
                        this.state = (short)2;
                        break;
                    }
                    case 5: {
                        int n;
                        int n2;
                        Triangle triangle = new Triangle();
                        if (this.flipOrder) {
                            n2 = 0;
                            n = 2;
                        } else {
                            n2 = 2;
                            n = 1;
                        }
                        this.flipOrder = !this.flipOrder;
                        triangle.vertices[0] = this.currTriangle.vertices[n2];
                        triangle.vertices[1] = this.currTriangle.vertices[n];
                        this.currTriangle = triangle;
                        this.state = (short)2;
                        break;
                    }
                    case 4: {
                        this.currTriangle = new Triangle();
                        this.state = 0;
                        break;
                    }
                    default: {
                        String string = Logging.getMessage("SurfaceShape.UnknownTriangleForm", this.type);
                        Logging.logger().severe(string);
                    }
                }
            }
        }

        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2]};
            objectArray2[0] = dArray2;
        }

        public void edgeFlag(boolean bl) {
        }

        public void error(int n) {
            String string = this.glu.gluErrorString(n);
            String string2 = Logging.getMessage("SurfaceShape.TessellationError", string);
            Logging.logger().severe(string2);
            throw new RuntimeException();
        }
    }

    private class ActiveEdge {
        double p0Lon;
        double p0Lat;
        double p1Lon;
        double p1Lat;
        double deltaX;
        double deltaY;
        int begRow;
        int endRow;
        int begCol;
        int endCol;

        public ActiveEdge(LatLon latLon, LatLon latLon2) {
            if (latLon.getLatitude().degrees > latLon2.getLatitude().degrees) {
                this.p0Lon = latLon2.getLongitude().degrees;
                this.p0Lat = latLon2.getLatitude().degrees;
                this.p1Lon = latLon.getLongitude().degrees;
                this.p1Lat = latLon.getLatitude().degrees;
            } else {
                this.p0Lon = latLon.getLongitude().degrees;
                this.p0Lat = latLon.getLatitude().degrees;
                this.p1Lon = latLon2.getLongitude().degrees;
                this.p1Lat = latLon2.getLatitude().degrees;
            }
            this.deltaX = this.p1Lon - this.p0Lon;
            this.deltaY = this.p1Lat - this.p0Lat;
        }

        public double getLonAtLat(double d) {
            if (Math.abs(this.deltaY) < 1.0E-10) {
                return Double.MAX_VALUE;
            }
            double d2 = (d - this.p0Lat) / this.deltaY;
            return this.p0Lon + d2 * this.deltaX;
        }

        public double getLatAtLon(double d) {
            if (Math.abs(this.deltaX) < 1.0E-10) {
                return Double.MAX_VALUE;
            }
            double d2 = (d - this.p0Lon) / this.deltaX;
            return this.p0Lat + d2 * this.deltaY;
        }
    }

    private class Vertex {
        double x;
        double y;

        public Vertex(double d, double d2) {
            this.x = d;
            this.y = d2;
        }
    }

    private class Polygon {
        double[][] xy = new double[6][2];
        int numVerts = 0;

        public void addVertex(double d, double d2) throws IllegalStateException {
            if (this.numVerts >= this.xy.length) {
                throw new IllegalStateException("SOMETHING'S DREADFULLY WRONG!!");
            }
            this.xy[this.numVerts][0] = d;
            this.xy[this.numVerts][1] = d2;
            ++this.numVerts;
        }

        public Polygon splitAtXPlane(double d) {
            double[][] dArray = new double[6][2];
            double[][] dArray2 = new double[6][2];
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.numVerts; ++i) {
                if (this.xy[i][0] < d) {
                    dArray[n++] = this.xy[i];
                } else if (this.xy[i][0] > d) {
                    dArray2[n2++] = this.xy[i];
                }
                int n3 = (i + 1) % this.numVerts;
                double d2 = this.intersectAtX(d, this.xy[i][0], this.xy[n3][0]);
                if (d2 < 0.0 || d2 > 1.0) continue;
                double[] dArray3 = new double[]{d, this.valAtParam(d2, this.xy[i][1], this.xy[n3][1])};
                if (dArray3[1] == Double.MAX_VALUE) {
                    dArray3[1] = this.xy[i][1];
                }
                dArray[n++] = dArray3;
                dArray2[n2++] = dArray3;
            }
            this.xy = dArray2;
            this.numVerts = n2;
            Polygon polygon = null;
            if (n > 0) {
                polygon = new Polygon();
                polygon.xy = dArray;
                polygon.numVerts = n;
            }
            return polygon;
        }

        private double valAtParam(double d, double d2, double d3) {
            double d4 = d3 - d2;
            if (Math.abs(d4) < 1.0E-10) {
                return Double.MAX_VALUE;
            }
            return d2 + d * d4;
        }

        private double intersectAtX(double d, double d2, double d3) {
            double d4 = d2 - d3;
            if (Math.abs(d4) < 1.0E-10) {
                return Double.MAX_VALUE;
            }
            return (d2 - d) / d4;
        }

        public void convertToXYZ(RectangularTessellator.RectGeometry rectGeometry) {
            Vec4 vec4 = SurfaceShapeGeometry.this.getReferencePoint();
            for (int i = 0; i < this.numVerts; ++i) {
                this.xy[i] = rectGeometry.getPointAt(this.xy[i][1], this.xy[i][0]);
                double[] dArray = this.xy[i];
                dArray[0] = dArray[0] - vec4.x;
                double[] dArray2 = this.xy[i];
                dArray2[1] = dArray2[1] - vec4.y;
                double[] dArray3 = this.xy[i];
                dArray3[2] = dArray3[2] - vec4.z;
            }
        }
    }
}

