/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.j2d.TextRenderer;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.AbstractSurfaceRenderable;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceText
extends AbstractSurfaceRenderable
implements Movable {
    private String text;
    private LatLon location;
    private Font font = Font.decode("Arial-BOLD-24");
    private Color color = Color.WHITE;
    protected TextRenderer textRenderer;
    protected Rectangle2D textBounds;
    private final float[] compArray = new float[4];

    public SurfaceText(String string, LatLon latLon, Font font, Color color) {
        this.setText(string);
        this.setLocation(latLon);
        this.setFont(font);
        this.setColor(color);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.text = string;
        this.updateTextBounds();
    }

    public LatLon getLocation() {
        return this.location;
    }

    public void setLocation(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.location = latLon;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.font = font;
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = null;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.color = color;
    }

    @Override
    public long getLastModifiedTime() {
        return System.currentTimeMillis();
    }

    @Override
    public Iterable<? extends Sector> getSectors(DrawContext drawContext) {
        return Arrays.asList(this.computeSector(drawContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRenderToRegion(DrawContext drawContext, Sector sector, int n, int n2, int n3, int n4) {
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        try {
            this.applyDrawTransform(drawContext, sector, n, n2, n3, n4);
            this.drawText(this.text, Vec4.ZERO);
        }
        finally {
            gL.glPopMatrix();
        }
    }

    protected Sector computeSector(DrawContext drawContext) {
        Globe globe = drawContext.getGlobe();
        double d = this.computePixelSizeAtLocation(drawContext, this.location);
        double d2 = this.textBounds.getHeight() * d / globe.getRadius();
        double d3 = this.textBounds.getWidth() * d / globe.getRadius() / this.location.getLatitude().cos();
        Sector sector = new Sector(this.location.getLatitude(), this.location.getLatitude().addRadians(d2), this.location.getLongitude().subtractRadians(d3 / 2.0), this.location.getLongitude().addRadians(d3 / 2.0));
        return this.computeRotatedSectorBounds(sector, this.location, this.computeDrawHeading(drawContext));
    }

    protected Angle computeDrawHeading(DrawContext drawContext) {
        return this.getViewHeading(drawContext);
    }

    protected TextRenderer getTextRenderer() {
        if (this.textRenderer == null) {
            this.textRenderer = new TextRenderer(this.font, true, true);
        }
        return this.textRenderer;
    }

    protected void updateTextBounds() {
        this.textBounds = this.getTextRenderer().getBounds(this.text);
    }

    protected void applyDrawTransform(DrawContext drawContext, Sector sector, int n, int n2, int n3, int n4) {
        Vec4 vec4 = this.computeDrawPoint(this.location, sector, n, n2, n3, n4);
        double d = this.computeDrawPixelSize(drawContext, sector, n3, n4);
        double d2 = this.computePixelSizeAtLocation(drawContext, this.location);
        double d3 = d2 / d;
        GL gL = drawContext.getGL();
        gL.glTranslated(vec4.x(), vec4.y(), vec4.z());
        gL.glScaled(d3 / this.location.getLatitude().cos(), d3, 1.0);
        gL.glRotated(this.computeDrawHeading((DrawContext)drawContext).degrees, 0.0, 0.0, -1.0);
    }

    protected void drawText(String string, Vec4 vec4) {
        TextRenderer textRenderer = this.getTextRenderer();
        int n = (int)(vec4.x() - this.textBounds.getWidth() / 2.0);
        int n2 = (int)vec4.y();
        textRenderer.begin3DRendering();
        textRenderer.setColor(this.computeBackgroundColor(this.color));
        textRenderer.draw(string, n + 1, n2 - 1);
        textRenderer.setColor(this.color);
        textRenderer.draw(string, n, n2);
        textRenderer.end3DRendering();
    }

    protected Color computeBackgroundColor(Color color) {
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), this.compArray);
        if ((double)this.compArray[2] > 0.5) {
            return new Color(0.0f, 0.0f, 0.0f, 0.7f);
        }
        return new Color(1.0f, 1.0f, 1.0f, 0.7f);
    }

    @Override
    public Position getReferencePosition() {
        return new Position(this.location, 0.0);
    }

    @Override
    public void move(Position position) {
        this.moveTo(this.getReferencePosition().add(position));
    }

    @Override
    public void moveTo(Position position) {
        this.setLocation(position.getLatLon());
    }
}

