/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.TextureTile;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfaceObject;
import gov.nasa.worldwind.render.SurfaceTile;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.Level;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLOrtho2DSupport;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLStateSupport;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileKey;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TiledSurfaceObjectRenderer {
    protected static final LatLon DEFAULT_TILE_DELTA = LatLon.fromDegrees(36.0, 36.0);
    protected static final Sector DEFAULT_SECTOR = Sector.FULL_SPHERE;
    protected static final int DEFAULT_NUM_LEVELS = 17;
    protected static final int DEFAULT_NUM_EMPTY_LEVELS = 0;
    protected static final int DEFAULT_TILE_WIDTH = 512;
    protected static final int DEFAULT_TILE_HEIGHT = 512;
    protected static final boolean DEFAULT_PICK_ENABLED = false;
    protected static final boolean DEFAULT_USE_MIPMAPS = false;
    protected static final double DEFAULT_TEXEL_TO_PIXEL_RATIO = 1.5;
    protected static final Color DEFAULT_TILE_BACKGROUND_COLOR = new Color(0, 0, 0, 0);
    protected static final boolean DEFAULT_SHOW_TILE_OUTLINES = false;
    protected static final String DEFAULT_TILE_COUNT_NAME = "Surface Object Tiles";
    protected static long uniqueId = 1L;
    protected Iterable<? extends SurfaceObject> surfaceObjectIterable;
    protected LevelSet levelSet;
    protected boolean pickEnabled;
    protected boolean useMipmaps;
    protected double texelToPixelRatio;
    protected Color tileBackgroundColor;
    protected List<SurfaceObjectInfo> currentSurfaceObjects;
    protected List<TextureTile> currentTiles;
    protected Map<TileKey, SurfaceObjectState> tileStateMap;
    protected Sector currentBoundingSector;
    protected PickTile pickTile;
    protected boolean havePickTile;
    protected PickSupport pickSupport = new PickSupport();
    protected OGLOrtho2DSupport renderToTextureSupport = new OGLOrtho2DSupport();
    protected boolean showTileOutlines;
    protected String tileCountName;

    public TiledSurfaceObjectRenderer(LevelSet levelSet) {
        if (levelSet == null) {
            String string = Logging.getMessage("nullValue.LevelSetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.levelSet = levelSet;
        this.useMipmaps = false;
        this.tileBackgroundColor = DEFAULT_TILE_BACKGROUND_COLOR;
        this.texelToPixelRatio = 1.5;
        this.currentSurfaceObjects = new ArrayList<SurfaceObjectInfo>();
        this.currentTiles = new ArrayList<TextureTile>();
        this.tileStateMap = new HashMap<TileKey, SurfaceObjectState>();
        this.pickTile = new PickTile(Sector.EMPTY_SECTOR);
        this.showTileOutlines = false;
        this.tileCountName = DEFAULT_TILE_COUNT_NAME;
    }

    public TiledSurfaceObjectRenderer(AVList aVList) {
        this(new LevelSet(TiledSurfaceObjectRenderer.initParams(aVList)));
    }

    public TiledSurfaceObjectRenderer() {
        this(new AVListImpl());
    }

    protected static AVList initParams(AVList aVList) {
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParamsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = null;
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta");
        if (object == null || !(object instanceof LatLon)) {
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", DEFAULT_TILE_DELTA);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) == null || !(object instanceof LatLon)) {
            aVList.setValue("gov.nasa.worldwind.avKey.Sector", DEFAULT_SECTOR);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.NumLevels")) == null || !(object instanceof Integer)) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", 17);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.NumEmptyLevels")) == null || !(object instanceof Integer)) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.TileWidthKey")) == null || !(object instanceof Integer)) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 512);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.TileHeightKey")) == null || !(object instanceof Integer)) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 512);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.DataCacheNameKey")) == null) {
            if (string == null) {
                string = TiledSurfaceObjectRenderer.createUniqueCacheId();
            }
            aVList.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", string);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.DatasetNameKey")) == null) {
            if (string == null) {
                string = TiledSurfaceObjectRenderer.createUniqueCacheId();
            }
            aVList.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey")) == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".xyz");
        }
        return aVList;
    }

    protected static String createUniqueCacheId() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TiledSurfaceObjectRenderer.class.getName());
        stringBuilder.append("/");
        stringBuilder.append(TiledSurfaceObjectRenderer.nextUniqueId());
        return stringBuilder.toString();
    }

    protected static long nextUniqueId() {
        return uniqueId++;
    }

    public boolean isPickEnabled() {
        return this.pickEnabled;
    }

    public void setPickEnabled(boolean bl) {
        this.pickEnabled = bl;
    }

    public boolean isUseMipmaps() {
        return this.useMipmaps;
    }

    public void setUseMipmaps(boolean bl) {
        this.useMipmaps = bl;
    }

    public double getTexelToPixelRatio() {
        return this.texelToPixelRatio;
    }

    public void setTexelToPixelRatio(double d) {
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "ratio <= 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.texelToPixelRatio = d;
    }

    public Color getTileBackgroundColor() {
        return this.tileBackgroundColor;
    }

    public void setTileBackgroundColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.tileBackgroundColor = color;
    }

    public boolean isShowTileOutlines() {
        return this.showTileOutlines;
    }

    public void setShowTileOutlines(boolean bl) {
        this.showTileOutlines = bl;
    }

    public Iterable<? extends SurfaceObject> getSurfaceObjects() {
        return this.surfaceObjectIterable;
    }

    public void setSurfaceObjects(Iterable<? extends SurfaceObject> iterable) {
        this.surfaceObjectIterable = iterable;
    }

    public void preRender(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.surfaceObjectIterable == null) {
            return;
        }
        this.clearSurfaceObjects(drawContext);
        this.clearTiles(drawContext);
        this.assembleSurfaceObjects(drawContext);
        this.assembleTiles(drawContext);
        this.updateTiles(drawContext);
    }

    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.surfaceObjectIterable == null) {
            return;
        }
        this.draw(drawContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pick(DrawContext drawContext, Point point, Layer layer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.surfaceObjectIterable == null) {
            return;
        }
        if (!this.pickEnabled) {
            return;
        }
        this.pickSupport.beginPicking(drawContext);
        try {
            this.draw(drawContext, true);
        }
        finally {
            this.pickSupport.endPicking(drawContext);
        }
        this.resolvePick(drawContext, point, layer);
        this.pickSupport.clearPickList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(DrawContext drawContext, boolean bl) {
        if (this.currentTiles.isEmpty()) {
            return;
        }
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        this.beginRendering(drawContext, oGLStackHandler);
        try {
            this.drawTiles(drawContext, bl);
        }
        finally {
            this.endRendering(drawContext, oGLStackHandler);
        }
    }

    protected void drawTiles(DrawContext drawContext, boolean bl) {
        if (bl) {
            this.drawPickTiles(drawContext);
        } else {
            this.drawRenderTiles(drawContext);
        }
    }

    protected void drawRenderTiles(DrawContext drawContext) {
        drawContext.getGeographicSurfaceTileRenderer().setShowImageTileOutlines(this.showTileOutlines);
        drawContext.getGeographicSurfaceTileRenderer().renderTiles(drawContext, this.currentTiles);
    }

    protected void drawPickTiles(DrawContext drawContext) {
        if (!this.havePickTile) {
            return;
        }
        boolean bl = drawContext.isPickingMode();
        if (bl) {
            drawContext.disablePickingMode();
        }
        drawContext.getGeographicSurfaceTileRenderer().setShowImageTileOutlines(false);
        drawContext.getGeographicSurfaceTileRenderer().renderTile(drawContext, this.pickTile);
        if (bl) {
            drawContext.enablePickingMode();
        }
    }

    protected void beginRendering(DrawContext drawContext, OGLStackHandler oGLStackHandler) {
        GL gL = drawContext.getGL();
        OGLStateSupport oGLStateSupport = new OGLStateSupport();
        oGLStateSupport.setEnableAlphaTest(true);
        oGLStateSupport.setEnableBlending(!drawContext.isPickingMode());
        oGLStateSupport.setColorMode(OGLStateSupport.COLOR_PREMULTIPLIED_ALPHA);
        int n = oGLStateSupport.getAttributeBits() | 0x4000 | 1 | 8;
        oGLStackHandler.pushAttrib(gL, n);
        oGLStateSupport.apply(gL);
        gL.glPolygonMode(1028, 6914);
        gL.glEnable(2884);
        gL.glCullFace(1029);
    }

    protected void endRendering(DrawContext drawContext, OGLStackHandler oGLStackHandler) {
        oGLStackHandler.pop(drawContext.getGL());
    }

    protected PickedObject bindPickableObject(DrawContext drawContext, Object object, Object object2) {
        Color color = drawContext.getUniquePickColor();
        int n = color.getRGB();
        drawContext.getGL().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        PickedObject pickedObject = new PickedObject(n, object);
        if (object2 != null) {
            pickedObject.setValue("gov.nasa.worldwind.avkey.PickedObject.ID", object2);
        }
        this.pickSupport.addPickableObject(pickedObject);
        return pickedObject;
    }

    protected void resolvePick(DrawContext drawContext, Point point, Layer layer) {
        if (point == null) {
            return;
        }
        PickedObject pickedObject = this.getTopPickedSurfaceObject(drawContext, point);
        if (pickedObject == null) {
            return;
        }
        Position position = this.getPickedTerrainPosition(drawContext);
        if (position != null) {
            pickedObject.setPosition(position);
        }
        if (layer != null) {
            pickedObject.setParentLayer(layer);
        }
        drawContext.addPickedObject(pickedObject);
    }

    protected PickedObject getTopPickedSurfaceObject(DrawContext drawContext, Point point) {
        PickedObject pickedObject = this.pickSupport.getTopObject(drawContext, point);
        if (pickedObject == null) {
            return null;
        }
        Object object = pickedObject.getObject();
        if (object == null || !(object instanceof SurfaceObject)) {
            return null;
        }
        return pickedObject;
    }

    protected Position getPickedTerrainPosition(DrawContext drawContext) {
        Intersection[] intersectionArray;
        PickedObject pickedObject = drawContext.getPickedObjects().getTerrainObject();
        if (pickedObject != null) {
            return pickedObject.getPosition();
        }
        View view = drawContext.getView();
        Globe globe = drawContext.getGlobe();
        if (view == null || globe == null) {
            return null;
        }
        Point point = drawContext.getPickPoint();
        if (point == null) {
            return null;
        }
        Line line = view.computeRayFromScreenPoint(point.getX(), point.getY());
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList != null && (intersectionArray = sectorGeometryList.intersect(line)) != null && intersectionArray.length != 0) {
            return globe.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
        }
        return globe.getIntersectionPosition(line);
    }

    protected void clearSurfaceObjects(DrawContext drawContext) {
        this.currentSurfaceObjects.clear();
    }

    protected void assembleSurfaceObjects(DrawContext drawContext) {
        for (SurfaceObject surfaceObject : this.surfaceObjectIterable) {
            this.addSurfaceObject(drawContext, surfaceObject);
        }
        this.currentBoundingSector = this.computeCurrentBoundingSector();
    }

    protected void addSurfaceObject(DrawContext drawContext, SurfaceObject surfaceObject) {
        Iterable<? extends Sector> iterable = surfaceObject.getSectors(drawContext);
        if (iterable == null) {
            return;
        }
        SurfaceObjectInfo surfaceObjectInfo = new SurfaceObjectInfo(surfaceObject, iterable);
        this.currentSurfaceObjects.add(surfaceObjectInfo);
    }

    protected Sector computeCurrentBoundingSector() {
        Sector sector = null;
        for (SurfaceObjectInfo surfaceObjectInfo : this.currentSurfaceObjects) {
            for (Sector sector2 : surfaceObjectInfo.getSectors()) {
                sector = sector != null ? sector.union(sector2) : sector2;
            }
        }
        return sector;
    }

    protected SurfaceObjectState getCurrentStateFor(Sector sector) {
        ArrayList<SurfaceObject> arrayList = new ArrayList<SurfaceObject>();
        for (SurfaceObjectInfo surfaceObjectInfo : this.currentSurfaceObjects) {
            if (!surfaceObjectInfo.intersects(sector)) continue;
            arrayList.add(surfaceObjectInfo.getSurfaceObject());
        }
        return new SurfaceObjectState(arrayList);
    }

    protected void clearTiles(DrawContext drawContext) {
        this.currentTiles.clear();
    }

    protected void assembleTiles(DrawContext drawContext) {
        if (this.currentSurfaceObjects.isEmpty()) {
            return;
        }
        if (this.currentBoundingSector == null || this.currentBoundingSector.equals(Sector.EMPTY_SECTOR)) {
            return;
        }
        for (TextureTile textureTile : this.assembleTopLevelTiles(this.levelSet, this.currentBoundingSector)) {
            this.addTileOrDescendants(drawContext, textureTile);
        }
        drawContext.setPerFrameStatistic("gov.nasa.worldwind.perfstat.ImageTileCount", this.tileCountName, this.currentTiles.size());
        this.assemblePickTile(drawContext);
    }

    protected void assemblePickTile(DrawContext drawContext) {
        TextureTile textureTile;
        this.havePickTile = false;
        if (!this.pickEnabled) {
            return;
        }
        Position position = this.getPickedTerrainPosition(drawContext);
        if (position != null && (textureTile = this.getIntersectingTile(position.getLatitude(), position.getLongitude(), this.currentTiles)) != null) {
            this.pickTile.setSector(textureTile.getSector());
            this.pickTile.setPreferredWidth(textureTile.getLevel().getTileWidth());
            this.pickTile.setPreferredHeight(textureTile.getLevel().getTileHeight());
            this.havePickTile = true;
        }
    }

    protected void addTileOrDescendants(DrawContext drawContext, TextureTile textureTile) {
        if (!this.isTileVisible(drawContext, textureTile)) {
            return;
        }
        if (!this.isTileNeeded(drawContext, textureTile)) {
            return;
        }
        if (this.isTileMeetsRenderCriteria(drawContext, textureTile)) {
            this.addTile(drawContext, textureTile);
            return;
        }
        Level level = this.levelSet.getLevel(textureTile.getLevelNumber() + 1);
        for (TextureTile textureTile2 : textureTile.createSubTiles(level)) {
            this.addTileOrDescendants(drawContext, textureTile2);
        }
    }

    protected void addTile(DrawContext drawContext, TextureTile textureTile) {
        this.currentTiles.add(textureTile);
    }

    protected boolean isTileVisible(DrawContext drawContext, SurfaceTile surfaceTile) {
        if (drawContext.getVisibleSector() != null && !drawContext.getVisibleSector().intersects(surfaceTile.getSector())) {
            return false;
        }
        return surfaceTile.getExtent(drawContext).intersects(drawContext.getView().getFrustumInModelCoordinates());
    }

    protected boolean isTileNeeded(DrawContext drawContext, Tile tile) {
        if (!tile.getSector().intersects(this.currentBoundingSector)) {
            return false;
        }
        boolean bl = false;
        for (SurfaceObjectInfo surfaceObjectInfo : this.currentSurfaceObjects) {
            if (!surfaceObjectInfo.intersects(tile.getSector())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected boolean isTileMeetsRenderCriteria(DrawContext drawContext, Tile tile) {
        Level level = tile.getLevel();
        if (this.levelSet.isFinalLevel(level.getLevelNumber())) {
            return true;
        }
        return !this.needToSubdivide(drawContext, tile.getSector(), level.getTileWidth(), level.getTileHeight());
    }

    protected TextureTile getIntersectingTile(Angle angle, Angle angle2, Iterable<? extends TextureTile> iterable) {
        for (TextureTile textureTile : iterable) {
            if (!textureTile.getSector().contains(angle, angle2)) continue;
            return textureTile;
        }
        return null;
    }

    protected boolean needToSubdivide(DrawContext drawContext, Sector sector, int n, int n2) {
        Vec4 vec4 = this.getNearestPointInSector(drawContext, sector);
        double d = vec4.getLength3() * sector.getDeltaLatRadians() / (double)n2;
        double d2 = drawContext.getView().getEyePoint().distanceTo3(vec4);
        double d3 = drawContext.getView().computePixelSizeAtDistance(d2);
        double d4 = d / d3;
        return d4 > this.texelToPixelRatio;
    }

    protected Vec4 getNearestPointInSector(DrawContext drawContext, Sector sector) {
        Position position = drawContext.getView().getEyePosition();
        if (sector.contains(position)) {
            Vec4 vec4 = drawContext.getPointOnGlobe(position.getLatitude(), position.getLongitude());
            if (vec4 == null) {
                double d = drawContext.getGlobe().getElevation(position.getLatitude(), position.getLongitude()) * drawContext.getVerticalExaggeration();
                return drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), d);
            }
            return vec4;
        }
        LatLon latLon = null;
        Angle angle = Angle.fromDegrees(Double.MAX_VALUE);
        for (LatLon latLon2 : sector) {
            Angle angle2 = LatLon.greatCircleDistance(latLon2, position);
            if (angle2.compareTo(angle) >= 0) continue;
            latLon = latLon2;
            angle = angle2;
        }
        if (latLon == null) {
            return null;
        }
        Vec4 vec4 = drawContext.getPointOnGlobe(latLon.getLatitude(), latLon.getLongitude());
        if (vec4 != null) {
            return vec4;
        }
        double d = drawContext.getGlobe().getElevation(latLon.getLatitude(), latLon.getLongitude()) * drawContext.getVerticalExaggeration();
        return drawContext.getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d);
    }

    protected TextureTile[] assembleTopLevelTiles(LevelSet levelSet, Sector sector) {
        Level level = levelSet.getFirstLevel();
        Angle angle = level.getTileDelta().getLatitude();
        Angle angle2 = level.getTileDelta().getLongitude();
        Angle angle3 = levelSet.getTileOrigin().getLatitude();
        Angle angle4 = levelSet.getTileOrigin().getLongitude();
        int n = Tile.computeRow(angle, sector.getMinLatitude(), angle3);
        int n2 = Tile.computeColumn(angle2, sector.getMinLongitude(), angle4);
        int n3 = Tile.computeRow(angle, sector.getMaxLatitude(), angle3);
        int n4 = Tile.computeColumn(angle2, sector.getMaxLongitude(), angle4);
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        int n7 = 0;
        TextureTile[] textureTileArray = new TextureTile[n5 * n6];
        Angle angle5 = Tile.computeRowLatitude(n, angle, angle3);
        for (int i = n; i <= n3; ++i) {
            Angle angle6 = angle5.add(angle);
            Angle angle7 = Tile.computeColumnLongitude(n2, angle2, angle4);
            for (int j = n2; j <= n4; ++j) {
                Angle angle8 = angle7.add(angle2);
                TileKey tileKey = new TileKey(level.getLevelNumber(), i, j, level.getCacheName());
                TextureTile textureTile = this.getTileFromMemoryCache(tileKey);
                if (textureTile == null) {
                    textureTile = new TextureTile(new Sector(angle5, angle6, angle7, angle8), level, i, j);
                    TextureTile.getMemoryCache().add(tileKey, textureTile);
                }
                textureTileArray[n7++] = textureTile;
                angle7 = angle8;
            }
            angle5 = angle6;
        }
        return textureTileArray;
    }

    protected TextureTile getTileFromMemoryCache(TileKey tileKey) {
        return (TextureTile)TextureTile.getMemoryCache().getObject(tileKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTiles(DrawContext drawContext) {
        if (this.currentTiles.isEmpty()) {
            return;
        }
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        this.beginUpdateTiles(drawContext, oGLStackHandler);
        try {
            for (TextureTile textureTile : this.currentTiles) {
                this.updateTile(drawContext, textureTile);
            }
            if (this.pickEnabled && this.havePickTile) {
                this.updatePickTile(drawContext, this.pickTile);
            }
        }
        finally {
            this.endUpdateTiles(drawContext, oGLStackHandler);
        }
    }

    protected void beginUpdateTiles(DrawContext drawContext, OGLStackHandler oGLStackHandler) {
        GL gL = drawContext.getGL();
        this.renderToTextureSupport.beginRendering(gL);
        OGLStateSupport oGLStateSupport = new OGLStateSupport();
        oGLStateSupport.setEnableAlphaTest(true);
        oGLStateSupport.setEnableBlending(true);
        oGLStateSupport.setColorMode(OGLStateSupport.COLOR_NO_PREMULTIPLIED_ALPHA);
        oGLStackHandler.pushAttrib(gL, oGLStateSupport.getAttributeBits());
        oGLStateSupport.apply(gL);
    }

    protected void endUpdateTiles(DrawContext drawContext, OGLStackHandler oGLStackHandler) {
        GL gL = drawContext.getGL();
        oGLStackHandler.pop(gL);
        this.renderToTextureSupport.endRendering(gL);
    }

    protected void updateTile(DrawContext drawContext, TextureTile textureTile) {
        SurfaceObjectState surfaceObjectState = this.getCurrentStateFor(textureTile.getSector());
        if (this.isTileCurrent(drawContext, textureTile, surfaceObjectState)) {
            return;
        }
        this.updateTileData(drawContext, textureTile, surfaceObjectState);
        surfaceObjectState.setLastModifiedTime(System.currentTimeMillis());
        this.setTileState(textureTile, surfaceObjectState);
    }

    protected void updatePickTile(DrawContext drawContext, PickTile pickTile) {
        this.updatePickTileData(drawContext, pickTile);
    }

    protected boolean isTileCurrent(DrawContext drawContext, TextureTile textureTile, SurfaceObjectState surfaceObjectState) {
        SurfaceObjectState surfaceObjectState2 = this.getTileState(textureTile);
        if (surfaceObjectState2 == null || surfaceObjectState2.isStateNewerOrModified(surfaceObjectState)) {
            return false;
        }
        return textureTile.getTexture(drawContext.getTextureCache()) != null;
    }

    protected SurfaceObjectState getTileState(TextureTile textureTile) {
        return this.tileStateMap.get(textureTile.getTileKey());
    }

    protected void setTileState(TextureTile textureTile, SurfaceObjectState surfaceObjectState) {
        this.tileStateMap.put(textureTile.getTileKey(), surfaceObjectState);
    }

    protected void updateTileData(DrawContext drawContext, TextureTile textureTile, SurfaceObjectState surfaceObjectState) {
        GL gL = drawContext.getGL();
        Level level = textureTile.getLevel();
        int[] nArray = this.setupRenderToTexture(drawContext, level.getTileWidth(), level.getTileHeight());
        int n = nArray[0];
        int n2 = nArray[1];
        this.renderToTextureSupport.clear(gL, this.tileBackgroundColor);
        for (SurfaceObject surfaceObject : surfaceObjectState.getSurfaceObjects()) {
            surfaceObject.renderToRegion(drawContext, textureTile.getSector(), 0, 0, n, n2);
        }
        this.copyFramebufferContentsToTile(drawContext, textureTile, n, n2, this.useMipmaps);
    }

    protected void updatePickTileData(DrawContext drawContext, PickTile pickTile) {
        GL gL = drawContext.getGL();
        boolean bl = drawContext.isPickingMode();
        if (!bl) {
            drawContext.enablePickingMode();
        }
        this.pickSupport.beginPicking(drawContext);
        int[] nArray = this.setupRenderToTexture(drawContext, pickTile.getPreferredWidth(), pickTile.getPreferredHeight());
        int n = nArray[0];
        int n2 = nArray[1];
        this.renderToTextureSupport.clear(gL, new Color(0, 0, 0, 0));
        for (SurfaceObjectInfo surfaceObjectInfo : this.currentSurfaceObjects) {
            if (!surfaceObjectInfo.intersects(pickTile.getSector())) continue;
            this.bindPickableObject(drawContext, surfaceObjectInfo.getSurfaceObject(), null);
            surfaceObjectInfo.getSurfaceObject().renderToRegion(drawContext, pickTile.getSector(), 0, 0, n, n2);
        }
        this.copyFramebufferContentsToTile(drawContext, pickTile.getDelegate(), n, n2, false);
        this.pickSupport.endPicking(drawContext);
        if (!bl) {
            drawContext.disablePickingMode();
        }
    }

    protected int[] setupRenderToTexture(DrawContext drawContext, int n, int n2) {
        GL gL = drawContext.getGL();
        int n3 = this.renderToTextureSupport.getWidth();
        int n4 = this.renderToTextureSupport.getHeight();
        if (n != n3 || n2 != n4) {
            this.renderToTextureSupport.setSize(gL, n, n2);
        }
        n3 = this.renderToTextureSupport.getWidth();
        n4 = this.renderToTextureSupport.getHeight();
        return new int[]{n3, n4};
    }

    protected void copyFramebufferContentsToTile(DrawContext drawContext, TextureTile textureTile, int n, int n2, boolean bl) {
        boolean bl2;
        Texture texture = textureTile.getTexture(drawContext.getTextureCache());
        boolean bl3 = bl2 = texture != null && texture.getWidth() == n && texture.getHeight() == n2;
        if (!bl2) {
            textureTile.setTextureData(this.createTileTextureData(n, n2, bl));
        }
        textureTile.bind(drawContext);
        texture = textureTile.getTexture(drawContext.getTextureCache());
        if (texture == null) {
            String string = Logging.getMessage("nullValue.TextureIsNull");
            Logging.logger().warning(string);
            return;
        }
        if (bl2) {
            drawContext.getGL().glCopyTexSubImage2D(texture.getTarget(), 0, 0, 0, 0, 0, n, n2);
        } else {
            drawContext.getGL().glCopyTexImage2D(texture.getTarget(), 0, 6408, 0, 0, n, n2, 0);
        }
    }

    protected TextureData createTileTextureData(int n, int n2, boolean bl) {
        return new TextureData(6408, n, n2, 0, 6408, 5121, bl, false, false, null, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PickTile
    implements SurfaceTile {
        protected Sector sector;
        protected int preferredWidth;
        protected int preferredHeight;
        protected TextureTile delegate;
        private Extent extent = null;
        private Object globeStateKey;

        public PickTile(Sector sector) {
            this.sector = sector;
            this.delegate = new TextureTile(sector);
        }

        @Override
        public Sector getSector() {
            return this.sector;
        }

        public void setSector(Sector sector) {
            this.sector = sector;
            this.extent = null;
        }

        public int getPreferredWidth() {
            return this.preferredWidth;
        }

        public void setPreferredWidth(int n) {
            this.preferredWidth = n;
        }

        public int getPreferredHeight() {
            return this.preferredHeight;
        }

        public void setPreferredHeight(int n) {
            this.preferredHeight = n;
        }

        public TextureTile getDelegate() {
            return this.delegate;
        }

        @Override
        public boolean bind(DrawContext drawContext) {
            return this.delegate.bind(drawContext);
        }

        @Override
        public void applyInternalTransform(DrawContext drawContext) {
            this.delegate.applyInternalTransform(drawContext);
        }

        @Override
        public List<? extends LatLon> getCorners() {
            return this.sector.asList();
        }

        @Override
        public Extent getExtent(DrawContext drawContext) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (this.extent == null || !this.isExtentValid(drawContext)) {
                this.extent = drawContext.getGlobe().computeBoundingCylinder(drawContext.getVerticalExaggeration(), this.getSector());
                this.globeStateKey = drawContext.getGlobe().getStateKey(drawContext);
            }
            return this.extent;
        }

        protected boolean isExtentValid(DrawContext drawContext) {
            return drawContext.getGlobe() != null && this.globeStateKey != null && this.globeStateKey.equals(drawContext.getGlobe().getStateKey(drawContext));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SurfaceObjectState {
        protected long lastModifiedTime;
        protected List<SurfaceObject> surfaceObjectList;

        public SurfaceObjectState(List<SurfaceObject> list) {
            this.surfaceObjectList = list;
            for (SurfaceObject surfaceObject : list) {
                if (this.lastModifiedTime >= surfaceObject.getLastModifiedTime()) continue;
                this.lastModifiedTime = surfaceObject.getLastModifiedTime();
            }
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public void setLastModifiedTime(long l) {
            this.lastModifiedTime = l;
        }

        public Iterable<? extends SurfaceObject> getSurfaceObjects() {
            return this.surfaceObjectList;
        }

        public boolean isStateNewerOrModified(SurfaceObjectState surfaceObjectState) {
            if (surfaceObjectState == null) {
                return false;
            }
            return this.lastModifiedTime < surfaceObjectState.lastModifiedTime || !((Object)this.surfaceObjectList).equals(surfaceObjectState.surfaceObjectList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SurfaceObjectInfo {
        protected SurfaceObject surfaceObject;
        protected Iterable<? extends Sector> sectors;

        public SurfaceObjectInfo(SurfaceObject surfaceObject, Iterable<? extends Sector> iterable) {
            if (surfaceObject == null) {
                String string = Logging.getMessage("nullValue.ObjectIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (iterable == null) {
                String string = Logging.getMessage("nullValue.IterableIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.surfaceObject = surfaceObject;
            this.sectors = iterable;
        }

        public SurfaceObject getSurfaceObject() {
            return this.surfaceObject;
        }

        public Iterable<? extends Sector> getSectors() {
            return this.sectors;
        }

        public boolean contains(LatLon latLon) {
            if (latLon == null) {
                String string = Logging.getMessage("nullValue.LatLonIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            for (Sector sector : this.sectors) {
                if (!sector.contains(latLon)) continue;
                return true;
            }
            return false;
        }

        public boolean contains(Sector sector) {
            if (sector == null) {
                String string = Logging.getMessage("nullValue.SectorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            for (Sector sector2 : this.sectors) {
                if (!sector2.contains(sector)) continue;
                return true;
            }
            return false;
        }

        public boolean intersects(Sector sector) {
            if (sector == null) {
                String string = Logging.getMessage("nullValue.SectorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            for (Sector sector2 : this.sectors) {
                if (!sector2.intersects(sector)) continue;
                return true;
            }
            return false;
        }
    }
}

