/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.Locatable;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.Geometry;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.PerformanceStatistic;
import java.awt.Color;
import java.awt.Point;
import java.nio.Buffer;
import java.util.Iterator;
import java.util.logging.Level;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AirspaceRenderer {
    private static final String EXT_BLEND_FUNC_SEPARATE_STRING = "GL_EXT_blend_func_separate";
    private boolean enableBlending = true;
    private boolean enableLighting = true;
    private boolean useEXTBlendFuncSeparate = true;
    private boolean haveEXTBlendFuncSeparate = false;
    private boolean drawExtents = false;
    private boolean drawWireframe = false;
    private Material lightMaterial;
    private Vec4 lightDirection;
    private final PickSupport pickSupport = new PickSupport();
    private double linePickWidth = 8.0;

    public AirspaceRenderer() {
        this.lightMaterial = Material.WHITE;
        this.lightDirection = new Vec4(1.0, 0.5, 1.0);
    }

    public boolean isEnableBlending() {
        return this.enableBlending;
    }

    public void setEnableBlending(boolean bl) {
        this.enableBlending = bl;
    }

    public boolean isEnableLighting() {
        return this.enableLighting;
    }

    public void setEnableLighting(boolean bl) {
        this.enableLighting = bl;
    }

    public boolean isUseEXTBlendFuncSeparate() {
        return this.useEXTBlendFuncSeparate;
    }

    public void setUseEXTBlendFuncSeparate(boolean bl) {
        this.useEXTBlendFuncSeparate = bl;
    }

    protected boolean isHaveEXTBlendFuncSeparate() {
        return this.haveEXTBlendFuncSeparate;
    }

    protected void setHaveEXTBlendFuncSeparate(boolean bl) {
        this.haveEXTBlendFuncSeparate = bl;
    }

    public boolean isDrawExtents() {
        return this.drawExtents;
    }

    public void setDrawExtents(boolean bl) {
        this.drawExtents = bl;
    }

    public boolean isDrawWireframe() {
        return this.drawWireframe;
    }

    public void setDrawWireframe(boolean bl) {
        this.drawWireframe = bl;
    }

    public Material getLightMaterial() {
        return this.lightMaterial;
    }

    public void setLightMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.lightMaterial = material;
    }

    public Vec4 getLightDirection() {
        return this.lightDirection;
    }

    public void setLightDirection(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.DirectionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.lightDirection = vec4;
    }

    public double getLinePickWidth() {
        return this.linePickWidth;
    }

    public void setLinePickWidth(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.linePickWidth = d;
    }

    public PickSupport getPickSupport() {
        return this.pickSupport;
    }

    public void pick(DrawContext drawContext, Iterable<? extends Airspace> iterable, Point point, Layer layer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = "nullValue.AirspaceIterableIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pickSupport.clearPickList();
        this.draw(drawContext, iterable);
        this.pickSupport.resolvePick(drawContext, point, layer);
        this.pickSupport.clearPickList();
    }

    public void render(DrawContext drawContext, Iterable<? extends Airspace> iterable) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = "nullValue.AirspaceIterableIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.draw(drawContext, iterable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(DrawContext drawContext, Iterable<? extends Airspace> iterable) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = "nullValue.AirspaceIterableIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.beginRendering(drawContext);
        try {
            this.drawAirspaces(drawContext, iterable);
        }
        finally {
            this.endRendering(drawContext);
        }
    }

    protected void drawAirspaces(DrawContext drawContext, Iterable<? extends Airspace> iterable) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (iterable == null) {
            String string = "nullValue.AirspaceIterableIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (Airspace airspace : iterable) {
            try {
                if (airspace == null) continue;
                this.drawAirspace(drawContext, airspace);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionWhileRenderingAirspace");
                Logging.logger().log(Level.SEVERE, string, exception);
            }
        }
    }

    protected void drawAirspace(DrawContext drawContext, Airspace airspace) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (airspace == null) {
            String string = "nullValue.AirspaceIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!airspace.isVisible()) {
            return;
        }
        if (!airspace.isAirspaceVisible(drawContext)) {
            return;
        }
        if (drawContext.isPickingMode()) {
            Color color = drawContext.getUniquePickColor();
            this.addPickableObject(color, airspace);
            drawContext.getGL().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        }
        if (airspace.getAttributes().isDrawOutline()) {
            this.drawAirspaceOutline(drawContext, airspace);
        }
        if (airspace.getAttributes().isDrawInterior()) {
            this.drawAirspaceInterior(drawContext, airspace);
        }
        if (!drawContext.isPickingMode() && this.isDrawExtents()) {
            airspace.renderExtent(drawContext);
        }
    }

    protected void drawAirspaceInterior(DrawContext drawContext, Airspace airspace) {
        if (!drawContext.isPickingMode()) {
            if (this.isEnableLighting()) {
                drawContext.getGL().glEnable(2896);
            }
            airspace.getAttributes().applyInterior(drawContext, this.isEnableLighting());
        }
        airspace.renderGeometry(drawContext, "Airspace.DrawStyleFill");
    }

    protected void drawAirspaceOutline(DrawContext drawContext, Airspace airspace) {
        if (drawContext.isPickingMode()) {
            double d = airspace.getAttributes().getOutlineWidth();
            if (!airspace.getAttributes().isDrawInterior() && d != 0.0) {
                d += this.getLinePickWidth();
            }
            drawContext.getGL().glLineWidth((float)d);
        } else {
            if (this.isEnableLighting()) {
                drawContext.getGL().glDisable(2896);
            }
            airspace.getAttributes().applyOutline(drawContext, false);
        }
        airspace.renderGeometry(drawContext, "Airspace.DrawStyleOutline");
    }

    protected void beginRendering(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        GL gL = drawContext.getGL();
        gL.glPushClientAttrib(2);
        gL.glEnableClientState(32884);
        if (!drawContext.isPickingMode()) {
            int n = (this.isDrawWireframe() ? 8 : 0) | (this.isEnableBlending() ? 16384 : 0) | (this.isEnableLighting() ? 4160 : 0) | 1 | 4;
            gL.glPushAttrib(n);
            if (this.isDrawWireframe()) {
                gL.glPolygonMode(1032, 6913);
            }
            if (this.isEnableBlending()) {
                this.setBlending(drawContext);
            }
            if (this.isEnableLighting()) {
                gL.glEnableClientState(32885);
                this.setLighting(drawContext);
            }
        } else {
            this.pickSupport.beginPicking(drawContext);
            int n = 5;
            gL.glPushAttrib(n);
        }
    }

    protected void endRendering(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        GL gL = drawContext.getGL();
        if (!drawContext.isPickingMode()) {
            gL.glPopAttrib();
        } else {
            this.pickSupport.endPicking(drawContext);
            gL.glPopAttrib();
        }
        gL.glPopClientAttrib();
    }

    protected void addPickableObject(Color color, Airspace airspace) {
        if (airspace instanceof Locatable) {
            this.pickSupport.addPickableObject(color.getRGB(), airspace, ((Locatable)((Object)airspace)).getPosition(), false);
        } else {
            this.pickSupport.addPickableObject(color.getRGB(), airspace);
        }
    }

    public void drawGeometry(DrawContext drawContext, int n, int n2, int n3, Buffer buffer, Geometry geometry) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (buffer == null) {
            String string = "nullValue.ElementBufferIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = "nullValue.AirspaceGeometryIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry.getBuffer(2) == null) {
            String string = "nullValue.VertexBufferIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        int n4 = geometry.getSize(2);
        int n5 = geometry.getGLType(2);
        int n6 = geometry.getStride(2);
        Buffer buffer2 = geometry.getBuffer(2);
        gL.glVertexPointer(n4, n5, n6, buffer2);
        Buffer buffer3 = null;
        if (!drawContext.isPickingMode() && this.isEnableLighting()) {
            buffer3 = geometry.getBuffer(3);
            if (buffer3 == null) {
                gL.glDisableClientState(32885);
            } else {
                n5 = geometry.getGLType(3);
                n6 = geometry.getStride(3);
                gL.glNormalPointer(n5, n6, buffer3);
            }
        }
        int n7 = 0;
        int n8 = geometry.getCount(2) - 1;
        gL.glDrawRangeElements(n, n7, n8, n2, n3, buffer);
        if (!drawContext.isPickingMode()) {
            if (this.isEnableLighting() && buffer3 == null) {
                gL.glEnableClientState(32885);
            }
            this.logGeometryStatistics(drawContext, geometry);
        }
    }

    public void drawGeometry(DrawContext drawContext, Geometry geometry) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = "nullValue.AirspaceGeometryIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry.getBuffer(1) == null) {
            String string = "nullValue.ElementBufferIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = geometry.getMode(1);
        int n2 = geometry.getCount(1);
        int n3 = geometry.getGLType(1);
        Buffer buffer = geometry.getBuffer(1);
        this.drawGeometry(drawContext, n, n2, n3, buffer, geometry);
    }

    public void drawGeometry(DrawContext drawContext, Geometry geometry, Geometry geometry2) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = "nullValue.ElementGeometryIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry.getBuffer(1) == null) {
            String string = "nullValue.ElementBufferIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null) {
            String string = "nullValue.VertexGeometryIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = geometry.getMode(1);
        int n2 = geometry.getCount(1);
        int n3 = geometry.getGLType(1);
        Buffer buffer = geometry.getBuffer(1);
        this.drawGeometry(drawContext, n, n2, n3, buffer, geometry2);
    }

    public void setBlending(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        GL gL = drawContext.getGL();
        if (this.isUseEXTBlendFuncSeparate()) {
            this.setHaveEXTBlendFuncSeparate(gL.isExtensionAvailable(EXT_BLEND_FUNC_SEPARATE_STRING));
        }
        gL.glEnable(3008);
        gL.glAlphaFunc(516, 0.0f);
        gL.glEnable(3042);
        if (this.isUseEXTBlendFuncSeparate() && this.isHaveEXTBlendFuncSeparate()) {
            gL.glBlendFuncSeparate(770, 771, 1, 771);
        } else {
            gL.glBlendFunc(770, 771);
        }
    }

    public void setLighting(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        GL gL = drawContext.getGL();
        gL.glEnable(2896);
        AirspaceRenderer.setLightModel(gL);
        AirspaceRenderer.setShadeModel(gL);
        gL.glEnable(16384);
        AirspaceRenderer.setLightMaterial(gL, 16384, this.lightMaterial);
        AirspaceRenderer.setLightDirection(gL, 16384, this.lightDirection);
    }

    protected static void setLightModel(GL gL) {
        if (gL == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        float[] fArray = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
        gL.glLightModelfv(2899, fArray, 0);
        gL.glLightModeli(2897, 1);
        gL.glLightModeli(2898, 0);
    }

    protected static void setShadeModel(GL gL) {
        if (gL == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        gL.glShadeModel(7425);
    }

    protected static void setLightMaterial(GL gL, int n, Material material) {
        if (gL == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        float[] fArray3 = new float[4];
        material.getDiffuse().getRGBColorComponents(fArray2);
        material.getSpecular().getRGBColorComponents(fArray3);
        fArray3[3] = 0.0f;
        fArray2[3] = 0.0f;
        fArray[3] = 0.0f;
        gL.glLightfv(n, 4608, fArray, 0);
        gL.glLightfv(n, 4609, fArray2, 0);
        gL.glLightfv(n, 4610, fArray3, 0);
    }

    protected static void setLightDirection(GL gL, int n, Vec4 vec4) {
        if (gL == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.DirectionIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Vec4 vec42 = vec4.normalize3();
        float[] fArray = new float[]{(float)vec42.x, (float)vec42.y, (float)vec42.z, 0.0f};
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glLightfv(n, 4611, fArray, 0);
        gL.glPopMatrix();
    }

    protected void logGeometryStatistics(DrawContext drawContext, Geometry geometry) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (geometry == null) {
            String string = Logging.getMessage("nullValue.GeometryIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        int n2 = 0;
        Iterator<PerformanceStatistic> iterator = drawContext.getPerFrameStatistics().iterator();
        while (iterator.hasNext()) {
            PerformanceStatistic performanceStatistic = iterator.next();
            if ("gov.nasa.worldwind.perfstat.AirspaceGeometryCount".equals(performanceStatistic.getKey())) {
                n += ((Integer)performanceStatistic.getValue()).intValue();
                iterator.remove();
            }
            if (!"gov.nasa.worldwind.perfstat.AirspaceVertexCount".equals(performanceStatistic.getKey())) continue;
            n2 += ((Integer)performanceStatistic.getValue()).intValue();
            iterator.remove();
        }
        drawContext.setPerFrameStatistic("gov.nasa.worldwind.perfstat.AirspaceGeometryCount", "Airspace Geometry Count", ++n);
        drawContext.setPerFrameStatistic("gov.nasa.worldwind.perfstat.AirspaceVertexCount", "Airspace Vertex Count", n2 += geometry.getCount(2));
    }
}

