/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.airspaces.AbstractAirspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.DetailLevel;
import gov.nasa.worldwind.render.airspaces.Geometry;
import gov.nasa.worldwind.render.airspaces.ScreenSizeDetailLevel;
import gov.nasa.worldwind.util.GeometryBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;

public class CappedCylinder
extends AbstractAirspace {
    protected static final int DEFAULT_SLICES = 32;
    protected static final int DEFAULT_STACKS = 1;
    protected static final int DEFAULT_LOOPS = 8;
    private LatLon center = LatLon.ZERO;
    private double innerRadius = 0.0;
    private double outerRadius = 1.0;
    private boolean enableCaps = true;
    private int slices = 32;
    private final int stacks = 1;
    private int loops = 8;

    public CappedCylinder(LatLon latLon, double d) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = latLon;
        this.outerRadius = d;
        this.makeDefaultDetailLevels();
    }

    public CappedCylinder(AirspaceAttributes airspaceAttributes) {
        super(airspaceAttributes);
        this.makeDefaultDetailLevels();
    }

    public CappedCylinder() {
        this.makeDefaultDetailLevels();
    }

    private void makeDefaultDetailLevels() {
        ArrayList<DetailLevel> arrayList = new ArrayList<DetailLevel>();
        double[] dArray = ScreenSizeDetailLevel.computeDefaultScreenSizeRamp(5);
        ScreenSizeDetailLevel screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[0], "Detail-Level-0");
        screenSizeDetailLevel.setValue("Slices", 32);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("Loops", 8);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[1], "Detail-Level-1");
        screenSizeDetailLevel.setValue("Slices", 26);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("Loops", 6);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[2], "Detail-Level-2");
        screenSizeDetailLevel.setValue("Slices", 20);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("Loops", 4);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[3], "Detail-Level-3");
        screenSizeDetailLevel.setValue("Slices", 14);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("Loops", 2);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[4], "Detail-Level-4");
        screenSizeDetailLevel.setValue("Slices", 8);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("Loops", 1);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", true);
        arrayList.add(screenSizeDetailLevel);
        this.setDetailLevels(arrayList);
    }

    public LatLon getCenter() {
        return this.center;
    }

    public void setCenter(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = latLon;
        this.setExtentOutOfDate();
    }

    public double[] getRadii() {
        double[] dArray = new double[]{this.innerRadius, this.outerRadius};
        return dArray;
    }

    public void setRadii(double d, double d2) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "innerRadius=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "outerRadius=" + d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.innerRadius = d;
        this.outerRadius = d2;
        this.setExtentOutOfDate();
    }

    public void setRadius(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setRadii(0.0, d);
    }

    public boolean isEnableCaps() {
        return this.enableCaps;
    }

    public void setEnableCaps(boolean bl) {
        this.enableCaps = bl;
    }

    public Position getReferencePosition() {
        double[] dArray = this.getAltitudes();
        return new Position(this.center, dArray[0]);
    }

    protected void doMoveTo(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.doMoveTo(position, position2);
        LatLon latLon = this.getCenter();
        double d = LatLon.greatCircleDistance((LatLon)position, (LatLon)latLon).radians;
        double d2 = LatLon.greatCircleAzimuth((LatLon)position, (LatLon)latLon).radians;
        this.setCenter(LatLon.greatCircleEndPosition((LatLon)position2, d2, d));
    }

    protected int getSlices() {
        return this.slices;
    }

    protected void setSlices(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "slices=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.slices = n;
    }

    protected int getStacks() {
        return this.stacks;
    }

    protected int getLoops() {
        return this.loops;
    }

    protected void setLoops(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "loops=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.loops = n;
    }

    protected Vec4 computeReferenceCenter(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = this.getAltitudes(drawContext.getVerticalExaggeration());
        return drawContext.getGlobe().computePointFromPosition(this.center.getLatitude(), this.center.getLongitude(), dArray[0]);
    }

    protected Matrix computeTransform(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = this.getAltitudes(drawContext.getVerticalExaggeration());
        return drawContext.getGlobe().computeTransformToPosition(this.center.getLatitude(), this.center.getLongitude(), dArray[0]);
    }

    protected Extent doComputeExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Globe globe = drawContext.getGlobe();
        Matrix matrix = this.computeTransform(drawContext);
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        int n = geometryBuilder.getCylinderVertexCount(8, 0);
        int n2 = 3 * n;
        float[] fArray = new float[n2];
        geometryBuilder.makeCylinderVertices((float)Math.max(this.innerRadius, this.outerRadius), 0.0f, 8, 0, fArray);
        ArrayList<Position> arrayList = new ArrayList<Position>();
        for (int i = 0; i < n2; i += 3) {
            Vec4 vec4 = new Vec4(fArray[i], fArray[i + 1], fArray[i + 2]);
            vec4 = vec4.transformBy4(matrix);
            arrayList.add(globe.computePositionFromPoint(vec4));
        }
        return this.computeBoundingCylinder(drawContext, arrayList);
    }

    protected void doRenderGeometry(DrawContext drawContext, String string) {
        Object object;
        Object object2;
        if (drawContext == null) {
            String string2 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (drawContext.getGL() == null) {
            String string3 = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        double[] dArray = this.getAltitudes(drawContext.getVerticalExaggeration());
        boolean[] blArray = this.isTerrainConforming();
        double[] dArray2 = this.getRadii();
        int n = this.slices;
        int n2 = this.stacks;
        int n3 = this.loops;
        if (this.isEnableLevelOfDetail()) {
            object2 = this.computeDetailLevel(drawContext);
            object = object2.getValue("Slices");
            if (object != null && object instanceof Integer) {
                n = (Integer)object;
            }
            if ((object = object2.getValue("Stacks")) != null && object instanceof Integer) {
                n2 = (Integer)object;
            }
            if ((object = object2.getValue("Loops")) != null && object instanceof Integer) {
                n3 = (Integer)object;
            }
            if ((object = object2.getValue("DisableTerrainConformance")) != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
                blArray[1] = false;
                blArray[0] = false;
            }
        }
        object2 = this.computeReferenceCenter(drawContext);
        this.setExpiryTime(this.nextExpiryTime(drawContext, blArray));
        this.clearElevationMap();
        object = drawContext.getGL();
        drawContext.getView().pushReferenceCenter(drawContext, (Vec4)object2);
        if ("Airspace.DrawStyleOutline".equals(string)) {
            if (dArray2[1] != 0.0) {
                this.drawCylinderOutline(drawContext, dArray2[1], dArray, blArray, n, n2, 0, (Vec4)object2);
            }
            if (dArray2[0] != 0.0) {
                this.drawCylinderOutline(drawContext, dArray2[0], dArray, blArray, n, n2, 1, (Vec4)object2);
            }
        } else if ("Airspace.DrawStyleFill".equals(string)) {
            if (this.enableCaps) {
                object.glPushAttrib(8);
                object.glEnable(2884);
                object.glFrontFace(2305);
            }
            if (this.enableCaps && dArray2[0] != dArray2[1]) {
                this.drawDisk(drawContext, dArray2, dArray[1], blArray[1], n, n3, 0, (Vec4)object2);
                if (!this.isAirspaceCollapsed()) {
                    this.drawDisk(drawContext, dArray2, dArray[0], blArray[0], n, n3, 1, (Vec4)object2);
                }
            }
            if (!this.isAirspaceCollapsed()) {
                if (dArray2[1] != 0.0) {
                    this.drawCylinder(drawContext, dArray2[1], dArray, blArray, n, n2, 0, (Vec4)object2);
                }
                if (dArray2[0] != 0.0) {
                    this.drawCylinder(drawContext, dArray2[0], dArray, blArray, n, n2, 1, (Vec4)object2);
                }
            }
            if (this.enableCaps) {
                object.glPopAttrib();
            }
        }
        drawContext.getView().popReferenceCenter(drawContext);
    }

    private void drawCylinder(DrawContext drawContext, double d, double[] dArray, boolean[] blArray, int n, int n2, int n3, Vec4 vec4) {
        Geometry geometry = this.createCylinderVertexGeometry(drawContext, d, dArray, blArray, n, n2, n3, vec4);
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "Cylinder.Indices", n, n2, n3);
        Geometry geometry2 = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry2 == null) {
            geometry2 = new Geometry();
            this.makeCylinderIndices(n, n2, n3, geometry2);
            this.getGeometryCache().add(cacheKey, geometry2);
        }
        this.getRenderer().drawGeometry(drawContext, geometry2, geometry);
    }

    private void drawCylinderOutline(DrawContext drawContext, double d, double[] dArray, boolean[] blArray, int n, int n2, int n3, Vec4 vec4) {
        Geometry geometry = this.createCylinderVertexGeometry(drawContext, d, dArray, blArray, n, n2, n3, vec4);
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "Cylinder.OutlineIndices", n, n2, n3);
        Geometry geometry2 = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry2 == null) {
            geometry2 = new Geometry();
            this.makeCylinderOutlineIndices(n, n2, n3, geometry2);
            this.getGeometryCache().add(cacheKey, geometry2);
        }
        this.getRenderer().drawGeometry(drawContext, geometry2, geometry);
    }

    private Geometry createCylinderVertexGeometry(DrawContext drawContext, double d, double[] dArray, boolean[] blArray, int n, int n2, int n3, Vec4 vec4) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "Cylinder.Vertices", d, dArray[0], dArray[1], blArray[0], blArray[1], n, n2, n3, vec4);
        Geometry geometry = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry == null || this.isExpired(drawContext, geometry)) {
            if (geometry == null) {
                geometry = new Geometry();
            }
            this.makeCylinder(drawContext, d, dArray, blArray, n, n2, n3, vec4, geometry);
            this.updateExpiryCriteria(drawContext, geometry);
            this.getGeometryCache().add(cacheKey, geometry);
        }
        return geometry;
    }

    private void makeCylinder(DrawContext drawContext, double d, double[] dArray, boolean[] blArray, int n, int n2, int n3, Vec4 vec4, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        float f = (float)(dArray[1] - dArray[0]);
        int n4 = geometryBuilder.getCylinderVertexCount(n, n2);
        int n5 = 3 * n4;
        float[] fArray = new float[n5];
        float[] fArray2 = new float[n5];
        geometryBuilder.makeCylinderVertices((float)d, f, n, n2, fArray);
        this.makeCylinderTerrainConformant(drawContext, n, n2, fArray, dArray, blArray, vec4);
        geometryBuilder.makeCylinderNormals(n, n2, fArray2);
        geometry.setVertexData(n4, fArray);
        geometry.setNormalData(n4, fArray2);
    }

    private void makeCylinderTerrainConformant(DrawContext drawContext, int n, int n2, float[] fArray, double[] dArray, boolean[] blArray, Vec4 vec4) {
        Globe globe = drawContext.getGlobe();
        Matrix matrix = this.computeTransform(drawContext);
        for (int i = 0; i < n; ++i) {
            int n3 = i * (n2 + 1);
            n3 = 3 * n3;
            Vec4 vec42 = new Vec4(fArray[n3], fArray[n3 + 1], fArray[n3 + 2]);
            vec42 = vec42.transformBy4(matrix);
            Position position = globe.computePositionFromPoint(vec42);
            for (int j = 0; j <= n2; ++j) {
                double d = dArray[j];
                if (blArray[j]) {
                    d += this.computeElevationAt(drawContext, position.getLatitude(), position.getLongitude());
                }
                vec42 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), d);
                n3 = j + i * (n2 + 1);
                n3 = 3 * n3;
                fArray[n3] = (float)(vec42.x - vec4.x);
                fArray[n3 + 1] = (float)(vec42.y - vec4.y);
                fArray[n3 + 2] = (float)(vec42.z - vec4.z);
            }
        }
    }

    private void makeCylinderIndices(int n, int n2, int n3, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        int n4 = geometryBuilder.getCylinderDrawMode();
        int n5 = geometryBuilder.getCylinderIndexCount(n, n2);
        int[] nArray = new int[n5];
        geometryBuilder.makeCylinderIndices(n, n2, nArray);
        geometry.setElementData(n4, n5, nArray);
    }

    private void makeCylinderOutlineIndices(int n, int n2, int n3, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        int n4 = geometryBuilder.getCylinderOutlineDrawMode();
        int n5 = geometryBuilder.getCylinderOutlineIndexCount(n, n2);
        int[] nArray = new int[n5];
        geometryBuilder.makeCylinderOutlineIndices(n, n2, nArray);
        geometry.setElementData(n4, n5, nArray);
    }

    private void drawDisk(DrawContext drawContext, double[] dArray, double d, boolean bl, int n, int n2, int n3, Vec4 vec4) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "Disk.Vertices", dArray[0], dArray[1], d, bl, n, n2, n3, vec4);
        Geometry geometry = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry == null || this.isExpired(drawContext, geometry)) {
            if (geometry == null) {
                geometry = new Geometry();
            }
            this.makeDisk(drawContext, dArray, d, bl, n, n2, n3, vec4, geometry);
            this.updateExpiryCriteria(drawContext, geometry);
            this.getGeometryCache().add(cacheKey, geometry);
        }
        cacheKey = new Geometry.CacheKey(this.getClass(), "Disk.Indices", n, n2, n3);
        Geometry geometry2 = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry2 == null) {
            geometry2 = new Geometry();
            this.makeDiskIndices(n, n2, n3, geometry2);
            this.getGeometryCache().add(cacheKey, geometry2);
        }
        this.getRenderer().drawGeometry(drawContext, geometry2, geometry);
    }

    private void makeDisk(DrawContext drawContext, double[] dArray, double d, boolean bl, int n, int n2, int n3, Vec4 vec4, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        int n4 = geometryBuilder.getDiskVertexCount(n, n2);
        int n5 = 3 * n4;
        float[] fArray = new float[n5];
        float[] fArray2 = new float[n5];
        geometryBuilder.makeDiskVertices((float)dArray[0], (float)dArray[1], n, n2, fArray);
        this.makeDiskTerrainConformant(drawContext, n5, fArray, d, bl, vec4);
        geometryBuilder.makeDiskVertexNormals((float)dArray[0], (float)dArray[1], n, n2, fArray, fArray2);
        geometry.setVertexData(n4, fArray);
        geometry.setNormalData(n4, fArray2);
    }

    private void makeDiskTerrainConformant(DrawContext drawContext, int n, float[] fArray, double d, boolean bl, Vec4 vec4) {
        Globe globe = drawContext.getGlobe();
        Matrix matrix = this.computeTransform(drawContext);
        for (int i = 0; i < n; i += 3) {
            Vec4 vec42 = new Vec4(fArray[i], fArray[i + 1], fArray[i + 2]);
            vec42 = vec42.transformBy4(matrix);
            Position position = globe.computePositionFromPoint(vec42);
            double d2 = d;
            if (bl) {
                d2 += this.computeElevationAt(drawContext, position.getLatitude(), position.getLongitude());
            }
            vec42 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), d2);
            fArray[i] = (float)(vec42.x - vec4.x);
            fArray[i + 1] = (float)(vec42.y - vec4.y);
            fArray[i + 2] = (float)(vec42.z - vec4.z);
        }
    }

    private void makeDiskIndices(int n, int n2, int n3, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n3);
        int n4 = geometryBuilder.getCylinderDrawMode();
        int n5 = geometryBuilder.getDiskIndexCount(n, n2);
        int[] nArray = new int[n5];
        geometryBuilder.makeDiskIndices(n, n2, nArray);
        geometry.setElementData(n4, n5, nArray);
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsBoolean(stateObject, "capsVisible", this.isEnableCaps());
        restorableSupport.addStateValueAsLatLon(stateObject, "center", this.getCenter());
        restorableSupport.addStateValueAsDouble(stateObject, "innerRadius", this.getRadii()[0]);
        restorableSupport.addStateValueAsDouble(stateObject, "outerRadius", this.getRadii()[1]);
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        Double d2;
        LatLon latLon;
        super.doRestoreState(restorableSupport, stateObject);
        Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "capsVisible");
        if (bl != null) {
            this.setEnableCaps(bl);
        }
        if ((latLon = restorableSupport.getStateValueAsLatLon(stateObject, "center")) != null) {
            this.setCenter(latLon);
        }
        if ((d2 = restorableSupport.getStateValueAsDouble(stateObject, "innerRadius")) == null) {
            d2 = this.getRadii()[0];
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "outerRadius")) == null) {
            d = this.getRadii()[1];
        }
        this.setRadii(d2, d);
    }
}

