/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.Box;
import gov.nasa.worldwind.render.airspaces.TrackAirspace;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Route
extends TrackAirspace {
    private List<LatLon> locations = new ArrayList<LatLon>();
    private double width = 1.0;

    public Route(List<? extends LatLon> list, double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.addLocations(list);
        this.width = d;
        this.setEnableInnerCaps(false);
    }

    public Route(AirspaceAttributes airspaceAttributes) {
        super(airspaceAttributes);
        this.setEnableInnerCaps(false);
    }

    public Route() {
        this.setEnableInnerCaps(false);
    }

    public Iterable<? extends LatLon> getLocations() {
        return Collections.unmodifiableList(this.locations);
    }

    public void setLocations(Iterable<? extends LatLon> iterable) {
        this.locations.clear();
        this.removeAllLegs();
        this.addLocations(iterable);
    }

    protected void addLocations(Iterable<? extends LatLon> iterable) {
        if (iterable != null) {
            LatLon latLon = null;
            for (LatLon latLon2 : iterable) {
                if (latLon2 == null) continue;
                if (latLon != null) {
                    this.addLeg(latLon, latLon2);
                }
                latLon = latLon2;
            }
            this.setExtentOutOfDate();
            this.setLegsOutOfDate();
        }
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.width = d;
        double d2 = this.width / 2.0;
        for (Box box : this.getLegs()) {
            box.setWidths(d2, d2);
        }
        this.setExtentOutOfDate();
        this.setLegsOutOfDate();
    }

    public Box addLeg(LatLon latLon, LatLon latLon2) {
        Object object;
        if (latLon == null) {
            String string = "nullValue.StartIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon2 == null) {
            String string = "nullValue.EndIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.locations.size() == 0) {
            this.locations.add(latLon);
            this.locations.add(latLon2);
        } else {
            object = this.locations.get(this.locations.size() - 1);
            if (latLon.equals(object)) {
                this.locations.add(latLon2);
            } else {
                String string = "Shapes.Route.DisjointLegDetected";
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
        }
        object = this.getAltitudes();
        boolean[] blArray = this.isTerrainConforming();
        double d = this.width / 2.0;
        Box box = new Box();
        box.setAltitudes((double)object[0], (double)object[1]);
        box.setTerrainConforming(blArray[0], blArray[1]);
        box.setLocations(latLon, latLon2);
        box.setWidths(d, d);
        this.addLeg(box);
        return box;
    }

    @Override
    public Position getReferencePosition() {
        return this.computeReferencePosition(this.locations, this.getAltitudes());
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.doMoveTo(position, position2);
        int n = this.locations.size();
        LatLon[] latLonArray = new LatLon[n];
        for (int i = 0; i < n; ++i) {
            LatLon latLon = this.locations.get(i);
            double d = LatLon.greatCircleDistance((LatLon)position, (LatLon)latLon).radians;
            double d2 = LatLon.greatCircleAzimuth((LatLon)position, (LatLon)latLon).radians;
            latLonArray[i] = LatLon.greatCircleEndPosition((LatLon)position2, d2, d);
        }
        this.setLocations(Arrays.asList(latLonArray));
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsDouble(stateObject, "width", this.width);
        restorableSupport.addStateValueAsLatLonList(stateObject, "locations", this.locations);
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        ArrayList<LatLon> arrayList;
        super.doRestoreState(restorableSupport, stateObject);
        Double d = restorableSupport.getStateValueAsDouble(stateObject, "width");
        if (d != null) {
            this.setWidth(d);
        }
        if ((arrayList = restorableSupport.getStateValueAsLatLonList(stateObject, "locations")) != null) {
            this.setLocations(arrayList);
        }
    }
}

