/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces.editor;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceControlPoint;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditor;
import gov.nasa.worldwind.render.airspaces.editor.BasicAirspaceControlPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AirspaceEditorUtil {
    public static final int LOWER_ALTITUDE = 0;
    public static final int UPPER_ALTITUDE = 1;

    public static double computeLowestHeightAboveSurface(WorldWindow worldWindow, Iterable<? extends AirspaceControlPoint> iterable, int n) {
        double d = Double.MAX_VALUE;
        for (AirspaceControlPoint airspaceControlPoint : iterable) {
            double d2;
            if (n != airspaceControlPoint.getAltitudeIndex() || !((d2 = AirspaceEditorUtil.computeHeightAboveSurface(worldWindow, airspaceControlPoint.getPoint())) < d)) continue;
            d = d2;
        }
        return d;
    }

    public static double computeHeightAboveSurface(WorldWindow worldWindow, Vec4 vec4) {
        Position position = worldWindow.getModel().getGlobe().computePositionFromPoint(vec4);
        Vec4 vec42 = AirspaceEditorUtil.computeSurfacePoint(worldWindow, position.getLatitude(), position.getLongitude());
        Vec4 vec43 = worldWindow.getModel().getGlobe().computeSurfaceNormalAtPoint(vec4);
        return vec4.subtract3(vec42).dot3(vec43);
    }

    public static double computeMinimumDistanceBetweenAltitudes(int n, Iterable<? extends AirspaceControlPoint> iterable) {
        double d = Double.MAX_VALUE;
        HashMap<Object, AirspaceControlPoint> hashMap = new HashMap<Object, AirspaceControlPoint>();
        for (AirspaceControlPoint object : iterable) {
            hashMap.put(object.getKey(), object);
        }
        for (int i = 0; i < n; ++i) {
            double d2;
            Object object = BasicAirspaceControlPoint.keyFor(i, 0);
            Object object2 = BasicAirspaceControlPoint.keyFor(i, 1);
            AirspaceControlPoint airspaceControlPoint = (AirspaceControlPoint)hashMap.get(object);
            AirspaceControlPoint airspaceControlPoint2 = (AirspaceControlPoint)hashMap.get(object2);
            if (airspaceControlPoint == null || airspaceControlPoint2 == null || !((d2 = airspaceControlPoint.getPoint().distanceTo3(airspaceControlPoint2.getPoint())) < d)) continue;
            d = d2;
        }
        return d == Double.MAX_VALUE ? 0.0 : d;
    }

    public static AirspaceControlPoint createControlPointFor(WorldWindow worldWindow, Line line, AirspaceEditor airspaceEditor, Airspace airspace, EdgeInfo edgeInfo) {
        Vec4 vec4 = AirspaceEditorUtil.intersectAirspaceAltitudeAt(worldWindow, airspace, edgeInfo.altitudeIndex, line);
        Vec4 vec42 = AirspaceEditorUtil.nearestPointOnSegment(edgeInfo.point1, edgeInfo.point2, vec4);
        int n = edgeInfo.altitudeIndex;
        int n2 = vec42 == edgeInfo.point1 ? edgeInfo.locationIndex : (vec42 == edgeInfo.point2 ? edgeInfo.nextLocationIndex + 1 : edgeInfo.nextLocationIndex);
        return new BasicAirspaceControlPoint(airspaceEditor, airspace, n2, n, vec4);
    }

    /*
     * WARNING - void declaration
     */
    public static List<EdgeInfo> computeEdgeInfoFor(int n, Iterable<? extends AirspaceControlPoint> iterable) {
        ArrayList<EdgeInfo> arrayList = new ArrayList<EdgeInfo>();
        HashMap<Object, AirspaceControlPoint> hashMap = new HashMap<Object, AirspaceControlPoint>();
        for (AirspaceControlPoint airspaceControlPoint : iterable) {
            hashMap.put(airspaceControlPoint.getKey(), airspaceControlPoint);
        }
        for (int i = 0; i < 2; ++i) {
            void var5_8;
            boolean j = false;
            while (var5_8 < n) {
                int n2 = var5_8 < n - 1 ? var5_8 + true : 0;
                Object object = BasicAirspaceControlPoint.keyFor((int)var5_8, i);
                Object object2 = BasicAirspaceControlPoint.keyFor(n2, i);
                AirspaceControlPoint airspaceControlPoint = (AirspaceControlPoint)hashMap.get(object);
                AirspaceControlPoint airspaceControlPoint2 = (AirspaceControlPoint)hashMap.get(object2);
                if (airspaceControlPoint != null && airspaceControlPoint2 != null) {
                    arrayList.add(new EdgeInfo((int)var5_8, n2, i, airspaceControlPoint.getPoint(), airspaceControlPoint2.getPoint()));
                }
                ++var5_8;
            }
        }
        return arrayList;
    }

    public static EdgeInfo selectBestEdgeMatch(WorldWindow worldWindow, Line line, Airspace airspace, List<? extends EdgeInfo> list) {
        Vec4[] vec4Array = new Vec4[]{AirspaceEditorUtil.intersectAirspaceAltitudeAt(worldWindow, airspace, 0, line), AirspaceEditorUtil.intersectAirspaceAltitudeAt(worldWindow, airspace, 1, line)};
        EdgeInfo edgeInfo = null;
        double d = Double.MAX_VALUE;
        for (EdgeInfo edgeInfo2 : list) {
            for (int i = 0; i < 2; ++i) {
                double d2;
                Vec4 vec4 = AirspaceEditorUtil.nearestPointOnSegment(edgeInfo2.point1, edgeInfo2.point2, vec4Array[i]);
                if (AirspaceEditorUtil.isPointBehindLineOrigin(line, vec4) || !((d2 = vec4.distanceTo3(vec4Array[i])) < d)) continue;
                edgeInfo = edgeInfo2;
                d = d2;
            }
        }
        return edgeInfo;
    }

    public static Vec4 intersectAirspaceAltitudeAt(WorldWindow worldWindow, Airspace airspace, int n, Line line) {
        Vec4 vec4;
        Intersection[] intersectionArray;
        double d = airspace.getAltitudes()[n];
        boolean bl = airspace.isTerrainConforming()[n];
        if (bl && (intersectionArray = worldWindow.getSceneController().getTerrain().intersect(line)) != null && (vec4 = AirspaceEditorUtil.nearestIntersectionPoint(line, intersectionArray)) != null) {
            Position position = worldWindow.getModel().getGlobe().computePositionFromPoint(vec4);
            d += position.getElevation();
        }
        return AirspaceEditorUtil.intersectGlobeAt(worldWindow, d, line);
    }

    public static Vec4 intersectGlobeAt(WorldWindow worldWindow, double d, Line line) {
        Intersection[] intersectionArray = worldWindow.getModel().getGlobe().intersect(line, d);
        if (intersectionArray == null || intersectionArray.length == 0) {
            return null;
        }
        return AirspaceEditorUtil.nearestIntersectionPoint(line, intersectionArray);
    }

    public static double surfaceElevationAt(WorldWindow worldWindow, Line line) {
        Vec4 vec4;
        Intersection[] intersectionArray;
        double d = 0.0;
        if (worldWindow.getSceneController().getTerrain() != null && (intersectionArray = worldWindow.getSceneController().getTerrain().intersect(line)) != null && (vec4 = AirspaceEditorUtil.nearestIntersectionPoint(line, intersectionArray)) != null) {
            Position position = worldWindow.getModel().getGlobe().computePositionFromPoint(vec4);
            d = position.getElevation();
        }
        return d;
    }

    public static Vec4 computeSurfacePoint(WorldWindow worldWindow, Angle angle, Angle angle2) {
        Vec4 vec4 = worldWindow.getSceneController().getTerrain().getSurfacePoint(angle, angle2);
        if (vec4 != null) {
            return vec4;
        }
        return worldWindow.getModel().getGlobe().computePointFromPosition(angle, angle2, 0.0);
    }

    public static boolean isPointBehindLineOrigin(Line line, Vec4 vec4) {
        double d = vec4.subtract3(line.getOrigin()).dot3(line.getDirection());
        return d < 0.0;
    }

    public static Vec4 nearestPointOnLine(Line line, Line line2) {
        double d = line.getDirection().dot3(line2.getDirection());
        double d2 = 1.0 / (d * d - 1.0);
        double d3 = line2.getOrigin().subtract3(line.getOrigin()).dot3(line.getDirection());
        double d4 = line2.getOrigin().subtract3(line.getOrigin()).dot3(line2.getDirection());
        double d5 = d2 * (d4 * d - d3);
        return line.getPointAt(d5);
    }

    public static Vec4 nearestPointOnSegment(Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        Vec4 vec44 = vec42.subtract3(vec4);
        Vec4 vec45 = vec44.normalize3();
        double d = vec43.subtract3(vec4).dot3(vec45);
        if (d < 0.0) {
            return vec4;
        }
        if (d > vec44.getLength3()) {
            return vec42;
        }
        return Vec4.fromLine3(vec4, d, vec45);
    }

    public static Vec4 nearestIntersectionPoint(Line line, Intersection[] intersectionArray) {
        Vec4 vec4 = null;
        double d = Double.MAX_VALUE;
        for (Intersection intersection : intersectionArray) {
            double d2;
            if (AirspaceEditorUtil.isPointBehindLineOrigin(line, intersection.getIntersectionPoint()) || !((d2 = intersection.getIntersectionPoint().distanceTo3(line.getOrigin())) < d)) continue;
            vec4 = intersection.getIntersectionPoint();
            d = d2;
        }
        return vec4;
    }

    public static class EdgeInfo {
        int locationIndex;
        int nextLocationIndex;
        int altitudeIndex;
        Vec4 point1;
        Vec4 point2;

        public EdgeInfo(int n, int n2, int n3, Vec4 vec4, Vec4 vec42) {
            this.locationIndex = n;
            this.nextLocationIndex = n2;
            this.altitudeIndex = n3;
            this.point1 = vec4;
            this.point2 = vec42;
        }
    }
}

