/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces.editor;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceControlPoint;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditor;

public class BasicAirspaceControlPoint
implements AirspaceControlPoint {
    private AirspaceEditor editor;
    private Airspace airspace;
    private int locationIndex;
    private int altitudeIndex;
    private Vec4 point;

    public BasicAirspaceControlPoint(AirspaceEditor airspaceEditor, Airspace airspace, int n, int n2, Vec4 vec4) {
        this.editor = airspaceEditor;
        this.airspace = airspace;
        this.locationIndex = n;
        this.altitudeIndex = n2;
        this.point = vec4;
    }

    public BasicAirspaceControlPoint(AirspaceEditor airspaceEditor, Airspace airspace, Vec4 vec4) {
        this(airspaceEditor, airspace, -1, -1, vec4);
    }

    public AirspaceEditor getEditor() {
        return this.editor;
    }

    public Airspace getAirspace() {
        return this.airspace;
    }

    public int getLocationIndex() {
        return this.locationIndex;
    }

    public int getAltitudeIndex() {
        return this.altitudeIndex;
    }

    public Vec4 getPoint() {
        return this.point;
    }

    public Object getKey() {
        return BasicAirspaceControlPoint.keyFor(this.locationIndex, this.altitudeIndex);
    }

    public static Object keyFor(int n, int n2) {
        return new BasicControlPointKey(n, n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BasicAirspaceControlPoint basicAirspaceControlPoint = (BasicAirspaceControlPoint)object;
        if (this.editor != basicAirspaceControlPoint.editor) {
            return false;
        }
        if (this.airspace != basicAirspaceControlPoint.airspace) {
            return false;
        }
        if (this.altitudeIndex != basicAirspaceControlPoint.altitudeIndex) {
            return false;
        }
        if (this.locationIndex != basicAirspaceControlPoint.locationIndex) {
            return false;
        }
        return !(this.point != null ? !this.point.equals(basicAirspaceControlPoint.point) : basicAirspaceControlPoint.point != null);
    }

    public int hashCode() {
        int n = this.editor != null ? this.editor.hashCode() : 0;
        n = 31 * n + (this.airspace != null ? this.airspace.hashCode() : 0);
        n = 31 * n + this.locationIndex;
        n = 31 * n + this.altitudeIndex;
        n = 31 * n + (this.point != null ? this.point.hashCode() : 0);
        return n;
    }

    public static class BasicControlPointKey {
        private int locationIndex;
        private int altitudeIndex;

        public BasicControlPointKey(int n, int n2) {
            this.locationIndex = n;
            this.altitudeIndex = n2;
        }

        public int getLocationIndex() {
            return this.locationIndex;
        }

        public int getAltitudeIndex() {
            return this.altitudeIndex;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            BasicControlPointKey basicControlPointKey = (BasicControlPointKey)object;
            return this.locationIndex == basicControlPointKey.locationIndex && this.altitudeIndex == basicControlPointKey.altitudeIndex;
        }

        public int hashCode() {
            int n = this.locationIndex;
            n = 31 * n + this.altitudeIndex;
            return n;
        }
    }
}

