/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces.editor;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.Polygon;
import gov.nasa.worldwind.render.airspaces.editor.AbstractAirspaceEditor;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceControlPoint;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceControlPointRenderer;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditEvent;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditorUtil;
import gov.nasa.worldwind.render.airspaces.editor.BasicAirspaceControlPoint;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class PolygonEditor
extends AbstractAirspaceEditor {
    private Polygon polygon;
    private static final double DEFAULT_POLYGON_HEIGHT = 10.0;

    public PolygonEditor(AirspaceControlPointRenderer airspaceControlPointRenderer) {
        super(airspaceControlPointRenderer);
    }

    public PolygonEditor() {
    }

    public Airspace getAirspace() {
        return this.getPolygon();
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public void setPolygon(Polygon polygon) {
        this.polygon = polygon;
    }

    protected void assembleControlPoints(DrawContext drawContext) {
        if (this.getPolygon() == null) {
            return;
        }
        int n = this.getPolygon().getLocations().size();
        boolean bl = this.getPolygon().isAirspaceCollapsed();
        for (int i = 0; i < n; ++i) {
            if (!bl) {
                this.addPolygonControlPoint(drawContext, i, 0);
            }
            this.addPolygonControlPoint(drawContext, i, 1);
        }
    }

    protected void addPolygonControlPoint(DrawContext drawContext, int n, int n2) {
        LatLon latLon = this.getPolygon().getLocations().get(n);
        double d = this.getPolygon().getAltitudes()[n2];
        boolean bl = this.getPolygon().isTerrainConforming()[n2];
        Vec4 vec4 = this.getPolygon().computePointFromPosition(drawContext, latLon.getLatitude(), latLon.getLongitude(), d, bl);
        BasicAirspaceControlPoint basicAirspaceControlPoint = new BasicAirspaceControlPoint(this, this.getPolygon(), n, n2, vec4);
        this.addControlPoint(drawContext, basicAirspaceControlPoint);
    }

    protected AirspaceControlPoint doAddControlPoint(WorldWindow worldWindow, Airspace airspace, Point point) {
        if (this.getPolygon().getLocations().isEmpty()) {
            return this.doAddFirstLocation(worldWindow, point);
        }
        return this.doAddNextLocation(worldWindow, point);
    }

    protected AirspaceControlPoint doAddFirstLocation(WorldWindow worldWindow, Point point) {
        Line line = worldWindow.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        double d = AirspaceEditorUtil.surfaceElevationAt(worldWindow, line);
        Vec4 vec4 = AirspaceEditorUtil.intersectGlobeAt(worldWindow, d, line);
        if (vec4 == null) {
            return null;
        }
        Position position = worldWindow.getModel().getGlobe().computePositionFromPoint(vec4);
        boolean[] blArray = this.getPolygon().isTerrainConforming();
        double[] dArray = new double[]{blArray[0] ? 0.0 : position.getElevation(), blArray[1] ? 0.0 : position.getElevation() + 10.0};
        this.getPolygon().setAltitudes(dArray[0], dArray[1]);
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        arrayList.add(new LatLon(position));
        if (this.isUseRubberBand()) {
            arrayList.add(new LatLon(position));
        }
        this.getPolygon().setLocations(arrayList);
        BasicAirspaceControlPoint basicAirspaceControlPoint = new BasicAirspaceControlPoint(this, this.getPolygon(), 0, 0, vec4);
        this.fireControlPointAdded(new AirspaceEditEvent(worldWindow, this.getAirspace(), this, basicAirspaceControlPoint));
        if (this.isUseRubberBand()) {
            basicAirspaceControlPoint = new BasicAirspaceControlPoint(this, this.getPolygon(), 1, 0, vec4);
            this.fireControlPointAdded(new AirspaceEditEvent(worldWindow, this.getAirspace(), this, basicAirspaceControlPoint));
        }
        return basicAirspaceControlPoint;
    }

    protected AirspaceControlPoint doAddNextLocation(WorldWindow worldWindow, Point point) {
        List<AirspaceEditorUtil.EdgeInfo> list = AirspaceEditorUtil.computeEdgeInfoFor(this.getPolygon().getLocations().size(), this.getCurrentControlPoints());
        if (list.isEmpty()) {
            return null;
        }
        Line line = worldWindow.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        AirspaceEditorUtil.EdgeInfo edgeInfo = AirspaceEditorUtil.selectBestEdgeMatch(worldWindow, line, this.getAirspace(), list);
        if (edgeInfo == null) {
            return null;
        }
        AirspaceControlPoint airspaceControlPoint = AirspaceEditorUtil.createControlPointFor(worldWindow, line, this, this.getAirspace(), edgeInfo);
        Vec4 vec4 = airspaceControlPoint.getPoint();
        LatLon latLon = new LatLon(worldWindow.getModel().getGlobe().computePositionFromPoint(vec4));
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(this.getPolygon().getLocations());
        arrayList.add(airspaceControlPoint.getLocationIndex(), latLon);
        this.getPolygon().setLocations(arrayList);
        this.fireControlPointAdded(new AirspaceEditEvent(worldWindow, this.getAirspace(), this, airspaceControlPoint));
        return airspaceControlPoint;
    }

    protected void doRemoveControlPoint(WorldWindow worldWindow, AirspaceControlPoint airspaceControlPoint) {
        int n = airspaceControlPoint.getLocationIndex();
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(this.getPolygon().getLocations());
        arrayList.remove(n);
        this.getPolygon().setLocations(arrayList);
        this.fireControlPointRemoved(new AirspaceEditEvent(worldWindow, airspaceControlPoint.getAirspace(), this, airspaceControlPoint));
    }

    protected void doMoveControlPoint(WorldWindow worldWindow, AirspaceControlPoint airspaceControlPoint, Point point, Point point2) {
        Position position = worldWindow.getModel().getGlobe().computePositionFromPoint(airspaceControlPoint.getPoint());
        Line line = worldWindow.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Line line2 = worldWindow.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Vec4 vec4 = AirspaceEditorUtil.intersectGlobeAt(worldWindow, position.getElevation(), line);
        Vec4 vec42 = AirspaceEditorUtil.intersectGlobeAt(worldWindow, position.getElevation(), line2);
        if (vec4 == null || vec42 == null) {
            return;
        }
        Position position2 = worldWindow.getModel().getGlobe().computePositionFromPoint(vec4);
        Position position3 = worldWindow.getModel().getGlobe().computePositionFromPoint(vec42);
        Position position4 = position2.subtract(position3);
        int n = airspaceControlPoint.getLocationIndex();
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(this.getPolygon().getLocations());
        LatLon latLon = ((LatLon)arrayList.get(n)).add((LatLon)position4);
        arrayList.set(n, latLon);
        this.getPolygon().setLocations(arrayList);
        this.fireControlPointChanged(new AirspaceEditEvent(worldWindow, airspaceControlPoint.getAirspace(), this, airspaceControlPoint));
    }

    protected void doResizeAtControlPoint(WorldWindow worldWindow, AirspaceControlPoint airspaceControlPoint, Point point, Point point2) {
        double d;
        Vec4 vec4 = worldWindow.getModel().getGlobe().computeSurfaceNormalAtPoint(airspaceControlPoint.getPoint());
        Line line = new Line(airspaceControlPoint.getPoint(), vec4);
        Line line2 = worldWindow.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line3 = worldWindow.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec42 = AirspaceEditorUtil.nearestPointOnLine(line, line2);
        Vec4 vec43 = AirspaceEditorUtil.nearestPointOnLine(line, line3);
        Position position = worldWindow.getModel().getGlobe().computePositionFromPoint(vec42);
        Position position2 = worldWindow.getModel().getGlobe().computePositionFromPoint(vec43);
        double d2 = position2.getElevation() - position.getElevation();
        int n = this.getPolygon().isAirspaceCollapsed() ? (d2 < 0.0 ? 0 : 1) : airspaceControlPoint.getAltitudeIndex();
        double[] dArray = airspaceControlPoint.getAirspace().getAltitudes();
        boolean[] blArray = airspaceControlPoint.getAirspace().isTerrainConforming();
        if (this.isKeepControlPointsAboveTerrain()) {
            if (blArray[n]) {
                if (dArray[n] + d2 < 0.0) {
                    d2 = -dArray[n];
                }
            } else {
                d = AirspaceEditorUtil.computeLowestHeightAboveSurface(worldWindow, this.getCurrentControlPoints(), n);
                if (d2 <= -d) {
                    d2 = -d;
                }
            }
        }
        d = AirspaceEditorUtil.computeMinimumDistanceBetweenAltitudes(this.getPolygon().getLocations().size(), this.getCurrentControlPoints());
        if (n == 0) {
            if (d2 > d) {
                d2 = d;
            }
        } else if (n == 1 && d2 < -d) {
            d2 = -d;
        }
        int n2 = n;
        dArray[n2] = dArray[n2] + d2;
        airspaceControlPoint.getAirspace().setAltitudes(dArray[0], dArray[1]);
        AirspaceEditEvent airspaceEditEvent = new AirspaceEditEvent(worldWindow, airspaceControlPoint.getAirspace(), this, airspaceControlPoint);
        this.fireControlPointChanged(airspaceEditEvent);
        this.fireAirspaceResized(airspaceEditEvent);
    }
}

