/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces.editor;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.SphereAirspace;
import gov.nasa.worldwind.render.airspaces.editor.AbstractAirspaceEditor;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceControlPoint;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceControlPointRenderer;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditEvent;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditorUtil;
import gov.nasa.worldwind.render.airspaces.editor.BasicAirspaceControlPoint;
import gov.nasa.worldwind.render.airspaces.editor.BasicAirspaceControlPointRenderer;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;

public class SphereAirspaceEditor
extends AbstractAirspaceEditor {
    private SphereAirspace sphere = null;
    private double minRadius = 1.0;
    private double maxRadius = Double.MAX_VALUE;
    private boolean alwaysShowRadiusControl = false;
    private double radiusControlDrawDistance = 14.0;
    public static final int RADIUS_CONTROL_ID = 1024;

    public SphereAirspaceEditor(AirspaceControlPointRenderer airspaceControlPointRenderer) {
        super(airspaceControlPointRenderer);
    }

    public SphereAirspaceEditor() {
        this(SphereAirspaceEditor.getDefaultRenderer());
    }

    public static AirspaceControlPointRenderer getDefaultRenderer() {
        BasicAirspaceControlPointRenderer basicAirspaceControlPointRenderer = new BasicAirspaceControlPointRenderer();
        basicAirspaceControlPointRenderer.setControlPointMarker(SphereAirspaceEditor.createDefaultMarker());
        basicAirspaceControlPointRenderer.setEnableDepthTest(false);
        return basicAirspaceControlPointRenderer;
    }

    public static Marker createDefaultMarker() {
        BasicMarkerAttributes basicMarkerAttributes = new BasicMarkerAttributes(Material.BLUE, "gov.nasa.worldwind.render.markers.Sphere", 1.0, 12.0, 0.1);
        return new BasicMarker(null, basicMarkerAttributes, null);
    }

    public Airspace getAirspace() {
        return this.getSphere();
    }

    public SphereAirspace getSphere() {
        return this.sphere;
    }

    public void setSphere(SphereAirspace sphereAirspace) {
        this.sphere = sphereAirspace;
    }

    public double getMinRadius() {
        return this.minRadius;
    }

    public void setMinRadius(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minRadius = d;
    }

    public double getMaxRadius() {
        return this.maxRadius;
    }

    public void setMaxRadius(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "radius < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.maxRadius = d;
    }

    public boolean isAlwaysShowRadiusControl() {
        return this.alwaysShowRadiusControl;
    }

    public void setAlwaysShowRadiusControl(boolean bl) {
        this.alwaysShowRadiusControl = bl;
    }

    public double getRadiusControlDrawDistance() {
        return this.radiusControlDrawDistance;
    }

    public void setRadiusControlDrawDistance(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "distance < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.radiusControlDrawDistance = d;
    }

    protected void assembleControlPoints(DrawContext drawContext) {
        if (this.getSphere() == null) {
            return;
        }
        Extent extent = this.getSphere().getExtent(drawContext);
        if (extent == null) {
            return;
        }
        Point point = drawContext.getPickPoint();
        if (point == null) {
            return;
        }
        Line line = drawContext.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec4 = extent.getCenter();
        double d = extent.getRadius();
        Vec4 vec42 = line.nearestPointTo(vec4);
        Vec4 vec43 = vec42.subtract3(vec4).normalize3();
        Vec4 vec44 = vec43.multiply3(d).add3(vec4);
        Vec4 vec45 = drawContext.getView().project(vec42);
        Vec4 vec46 = drawContext.getView().project(vec44);
        double d2 = vec45.distanceTo3(vec46);
        if (this.isAlwaysShowRadiusControl() || d2 < this.getRadiusControlDrawDistance()) {
            BasicAirspaceControlPoint basicAirspaceControlPoint = new BasicAirspaceControlPoint(this, this.getSphere(), 1024, 1024, vec44);
            this.addControlPoint(drawContext, basicAirspaceControlPoint);
        }
    }

    protected Vec4 getCenterPoint(WorldWindow worldWindow, Airspace airspace) {
        Vec4 vec4;
        if (!(airspace instanceof SphereAirspace)) {
            return null;
        }
        SphereAirspace sphereAirspace = (SphereAirspace)airspace;
        LatLon latLon = sphereAirspace.getLocation();
        double d = sphereAirspace.getAltitudes()[0];
        boolean bl = sphereAirspace.isTerrainConforming()[0];
        if (bl) {
            if (worldWindow.getSceneController().getTerrain() != null) {
                vec4 = worldWindow.getSceneController().getTerrain().getSurfacePoint(latLon.getLatitude(), latLon.getLongitude(), d);
            } else {
                double d2 = worldWindow.getModel().getGlobe().getElevation(latLon.getLatitude(), latLon.getLongitude());
                vec4 = worldWindow.getModel().getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d2 + d);
            }
        } else {
            vec4 = worldWindow.getModel().getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d);
        }
        return vec4;
    }

    protected void doMoveAirspaceVertically(WorldWindow worldWindow, Airspace airspace, Point point, Point point2) {
        double d;
        double d2 = this.getAirspace().getAltitudes()[0];
        boolean bl = this.getAirspace().isTerrainConforming()[0];
        Vec4 vec4 = this.getCenterPoint(worldWindow, airspace);
        Vec4 vec42 = worldWindow.getModel().getGlobe().computeSurfaceNormalAtPoint(vec4);
        Line line = new Line(vec4, vec42);
        Line line2 = worldWindow.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line3 = worldWindow.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec43 = AirspaceEditorUtil.nearestPointOnLine(line, line2);
        Vec4 vec44 = AirspaceEditorUtil.nearestPointOnLine(line, line3);
        Position position = worldWindow.getModel().getGlobe().computePositionFromPoint(vec43);
        Position position2 = worldWindow.getModel().getGlobe().computePositionFromPoint(vec44);
        double d3 = position2.getElevation() - position.getElevation();
        if (this.isKeepControlPointsAboveTerrain()) {
            if (bl) {
                if (d2 + d3 < 0.0) {
                    d3 = -d2;
                }
            } else {
                d = AirspaceEditorUtil.computeHeightAboveSurface(worldWindow, vec4);
                if (d3 <= -d) {
                    d3 = -d;
                }
            }
        }
        d = d2 + d3;
        this.getAirspace().setAltitude(d);
        this.fireAirspaceMoved(new AirspaceEditEvent(worldWindow, airspace, this));
    }

    protected AirspaceControlPoint doAddControlPoint(WorldWindow worldWindow, Airspace airspace, Point point) {
        return null;
    }

    protected void doRemoveControlPoint(WorldWindow worldWindow, AirspaceControlPoint airspaceControlPoint) {
    }

    protected void doMoveControlPoint(WorldWindow worldWindow, AirspaceControlPoint airspaceControlPoint, Point point, Point point2) {
        if (airspaceControlPoint.getLocationIndex() == 1024) {
            this.doMoveRadiusControlPoint(worldWindow, airspaceControlPoint, point, point2);
        }
    }

    protected void doResizeAtControlPoint(WorldWindow worldWindow, AirspaceControlPoint airspaceControlPoint, Point point, Point point2) {
    }

    protected void doMoveRadiusControlPoint(WorldWindow worldWindow, AirspaceControlPoint airspaceControlPoint, Point point, Point point2) {
        Vec4 vec4 = this.getCenterPoint(worldWindow, this.getSphere());
        Line line = worldWindow.getView().computeRayFromScreenPoint(point2.getX(), point2.getY());
        Line line2 = worldWindow.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec42 = line.nearestPointTo(vec4);
        Vec4 vec43 = line2.nearestPointTo(vec4);
        double d = vec42.distanceTo3(vec4);
        double d2 = vec43.distanceTo3(vec4);
        double d3 = d2 - d;
        double d4 = this.getSphere().getRadius() + d3;
        if (d4 < this.getMinRadius()) {
            d4 = this.getMinRadius();
        }
        if (d4 > this.getMaxRadius()) {
            d4 = this.getMaxRadius();
        }
        this.getSphere().setRadius(d4);
        AirspaceEditEvent airspaceEditEvent = new AirspaceEditEvent(worldWindow, this.getSphere(), this, airspaceControlPoint);
        this.fireControlPointChanged(airspaceEditEvent);
        this.fireAirspaceResized(airspaceEditEvent);
    }
}

