/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.markers;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerRenderer {
    private double elevation = 10.0;
    private boolean overrideMarkerElevation = false;
    private boolean keepSeparated = true;
    private boolean enablePickSizeReturn = false;
    protected PickSupport pickSupport = new PickSupport();
    private MarkerAttributes previousAttributes;

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double d) {
        this.elevation = d;
    }

    public boolean isOverrideMarkerElevation() {
        return this.overrideMarkerElevation;
    }

    public void setOverrideMarkerElevation(boolean bl) {
        this.overrideMarkerElevation = bl;
    }

    public boolean isKeepSeparated() {
        return this.keepSeparated;
    }

    public void setKeepSeparated(boolean bl) {
        this.keepSeparated = bl;
    }

    public boolean isEnablePickSizeReturn() {
        return this.enablePickSizeReturn;
    }

    public void setEnablePickSizeReturn(boolean bl) {
        this.enablePickSizeReturn = bl;
    }

    public void render(DrawContext drawContext, Iterable<Marker> iterable) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.MarkerListIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.draw(drawContext, iterable);
    }

    public void pick(DrawContext drawContext, Iterable<Marker> iterable, Point point, Layer layer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = Logging.getMessage("nullValue.PickPoint");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.pickSupport.clearPickList();
        this.draw(drawContext, iterable);
        this.pickSupport.resolvePick(drawContext, point, layer);
        this.pickSupport.clearPickList();
    }

    protected void draw(DrawContext drawContext, Iterable<Marker> iterable) {
        if (this.isKeepSeparated()) {
            this.drawSeparated(drawContext, iterable);
        } else {
            this.drawAll(drawContext, iterable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawSeparated(DrawContext drawContext, Iterable<Marker> iterable) {
        this.begin(drawContext);
        try {
            ArrayList<Marker> arrayList;
            if (iterable instanceof List) {
                arrayList = (ArrayList<Marker>)iterable;
            } else {
                arrayList = new ArrayList<Marker>();
                for (Marker object2 : iterable) {
                    arrayList.add(object2);
                }
            }
            if (arrayList.size() == 0) {
                return;
            }
            this.previousAttributes = null;
            Marker marker = (Marker)arrayList.get(0);
            Vec4 vec4 = this.computeSurfacePoint(drawContext, marker.getPosition());
            double d = this.computeMarkerRadius(drawContext, vec4, marker);
            this.drawMarker(drawContext, 0, marker, vec4, d);
            if (arrayList.size() < 2) {
                return;
            }
            Marker marker2 = (Marker)arrayList.get(arrayList.size() - 1);
            Vec4 vec42 = this.computeSurfacePoint(drawContext, marker2.getPosition());
            double d2 = this.computeMarkerRadius(drawContext, vec42, marker2);
            this.drawMarker(drawContext, arrayList.size() - 1, marker2, vec42, d2);
            if (arrayList.size() < 3) {
                return;
            }
            this.drawInBetweenMarkers(drawContext, 0, vec4, d, arrayList.size() - 1, vec42, d2, arrayList);
        }
        finally {
            this.end(drawContext);
        }
    }

    private void drawInBetweenMarkers(DrawContext drawContext, int n, Vec4 vec4, double d, int n2, Vec4 vec42, double d2, List<Marker> list) {
        if (n2 == n + 1) {
            return;
        }
        if (vec4.distanceTo3(vec42) <= d + d2) {
            return;
        }
        int n3 = (n + n2) / 2;
        Marker marker = list.get(n3);
        Vec4 vec43 = this.computeSurfacePoint(drawContext, marker.getPosition());
        double d3 = this.computeMarkerRadius(drawContext, vec43, marker);
        boolean bl = false;
        boolean bl2 = false;
        if (vec43.distanceTo3(vec4) > d3 + d) {
            this.drawInBetweenMarkers(drawContext, n, vec4, d, n3, vec43, d3, list);
            bl = true;
        }
        if (vec43.distanceTo3(vec42) > d3 + d2) {
            this.drawInBetweenMarkers(drawContext, n3, vec43, d3, n2, vec42, d2, list);
            bl2 = true;
        }
        if (bl && bl2) {
            this.drawMarker(drawContext, n3, marker, vec43, d3);
        }
    }

    private void drawMarker(DrawContext drawContext, int n, Marker marker, Vec4 vec4, double d) {
        Object object;
        if (!drawContext.getView().getFrustumInModelCoordinates().contains(vec4)) {
            return;
        }
        if (drawContext.isPickingMode()) {
            object = drawContext.getUniquePickColor();
            int n2 = ((Color)object).getRGB();
            PickedObject pickedObject = new PickedObject(n2, marker, marker.getPosition(), false);
            pickedObject.setValue("gov.nasa.worldwind.avkey.PickedObject.ID", n);
            if (this.enablePickSizeReturn) {
                pickedObject.setValue("gov.nasa.worldwind.avkey.PickedObject.Size", 2.0 * d);
            }
            this.pickSupport.addPickableObject(pickedObject);
            drawContext.getGL().glColor3ub((byte)((Color)object).getRed(), (byte)((Color)object).getGreen(), (byte)((Color)object).getBlue());
        }
        if ((object = marker.getAttributes()) != this.previousAttributes) {
            object.apply(drawContext);
            this.previousAttributes = object;
        }
        marker.render(drawContext, vec4, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawAll(DrawContext drawContext, Iterable<Marker> iterable) {
        this.begin(drawContext);
        try {
            MarkerAttributes markerAttributes = null;
            Iterator<Marker> iterator = iterable.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Marker marker = iterator.next();
                if (marker != null) {
                    MarkerAttributes markerAttributes2 = marker.getAttributes();
                    if (markerAttributes2 != markerAttributes) {
                        markerAttributes2.apply(drawContext);
                        markerAttributes = markerAttributes2;
                    }
                    Position position = marker.getPosition();
                    Vec4 vec4 = this.computeSurfacePoint(drawContext, position);
                    if (drawContext.getView().getFrustumInModelCoordinates().contains(vec4)) {
                        double d = this.computeMarkerRadius(drawContext, vec4, marker);
                        if (drawContext.isPickingMode()) {
                            Color color = drawContext.getUniquePickColor();
                            int n2 = color.getRGB();
                            PickedObject pickedObject = new PickedObject(n2, marker, position, false);
                            pickedObject.setValue("gov.nasa.worldwind.avkey.PickedObject.ID", n);
                            if (this.enablePickSizeReturn) {
                                pickedObject.setValue("gov.nasa.worldwind.avkey.PickedObject.Size", 2.0 * d);
                            }
                            this.pickSupport.addPickableObject(pickedObject);
                            drawContext.getGL().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                        }
                        marker.render(drawContext, vec4, d);
                    }
                }
                ++n;
            }
        }
        finally {
            this.end(drawContext);
        }
    }

    protected void begin(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        Vec4 vec4 = drawContext.getView().getEyePoint();
        if (drawContext.isPickingMode()) {
            this.pickSupport.beginPicking(drawContext);
            gL.glPushAttrib(12289);
            gL.glDisable(3553);
            gL.glDisable(2903);
        } else {
            gL.glPushAttrib(290881);
            gL.glDisable(3553);
            float[] fArray = new float[]{(float)(vec4.x * 2.0), (float)(vec4.y / 2.0), (float)vec4.z, 0.0f};
            float[] fArray2 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            float[] fArray3 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            float[] fArray4 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            gL.glDisable(2903);
            gL.glLightfv(16385, 4611, fArray, 0);
            gL.glLightfv(16385, 4609, fArray2, 0);
            gL.glLightfv(16385, 4608, fArray3, 0);
            gL.glLightfv(16385, 4610, fArray4, 0);
            gL.glDisable(16384);
            gL.glEnable(16385);
            gL.glEnable(2896);
            gL.glEnable(2977);
            drawContext.getGL().glEnable(3042);
            drawContext.getGL().glBlendFunc(770, 771);
        }
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
    }

    protected void end(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        if (drawContext.isPickingMode()) {
            this.pickSupport.endPicking(drawContext);
        } else {
            gL.glDisable(16385);
            gL.glEnable(16384);
            gL.glDisable(2896);
            gL.glDisable(2977);
        }
        gL.glPopAttrib();
    }

    protected Vec4 computeSurfacePoint(DrawContext drawContext, Position position) {
        if (!this.overrideMarkerElevation) {
            return drawContext.getGlobe().computePointFromPosition(position);
        }
        Vec4 vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(position.getLatitude(), position.getLongitude(), this.elevation);
        if (vec4 != null) {
            return vec4;
        }
        return drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), this.elevation);
    }

    protected double computeMarkerRadius(DrawContext drawContext, Vec4 vec4, Marker marker) {
        double d = vec4.distanceTo3(drawContext.getView().getEyePoint());
        double d2 = marker.getAttributes().getMarkerPixels() * drawContext.getView().computePixelSizeAtDistance(d);
        if (d2 < marker.getAttributes().getMinMarkerSize()) {
            d2 = marker.getAttributes().getMinMarkerSize();
        } else if (d2 > marker.getAttributes().getMaxMarkerSize()) {
            d2 = marker.getAttributes().getMaxMarkerSize();
        }
        return d2;
    }
}

