/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.retrieve;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.retrieve.BulkRetrievable;
import gov.nasa.worldwind.retrieve.Progress;
import gov.nasa.worldwind.util.Logging;

public abstract class BulkRetrievalThread
extends Thread {
    protected int RETRIEVAL_SERVICE_POLL_DELAY = 10000;
    protected final BulkRetrievable retrievable;
    protected final Sector sector;
    protected final double resolution;
    protected final Progress progress;

    public BulkRetrievalThread(BulkRetrievable bulkRetrievable, Sector sector, double d) {
        if (bulkRetrievable == null) {
            String string = Logging.getMessage("nullValue.RetrievableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.retrievable = bulkRetrievable;
        this.sector = sector;
        this.resolution = d;
        this.progress = new Progress();
    }

    public abstract void run();

    public BulkRetrievable getRetrievable() {
        return this.retrievable;
    }

    public Sector getSector() {
        return this.sector;
    }

    public double getResolution() {
        return this.resolution;
    }

    public Progress getProgress() {
        return this.progress;
    }
}

