/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.util.Logging;

public abstract class AbstractElevationModel
extends WWObjectImpl
implements ElevationModel {
    protected double missingDataFlag = -1.7976931348623157E308;
    protected double missingDataValue = 0.0;
    private boolean networkRetrievalEnabled = true;

    public String getName() {
        Object object = this.getValue("gov.nasa.worldwind.avkey.DisplayName");
        return object != null ? object.toString() : this.toString();
    }

    public void setName(String string) {
        this.setValue("gov.nasa.worldwind.avkey.DisplayName", string);
    }

    public String toString() {
        Object object = this.getValue("gov.nasa.worldwind.avkey.DisplayName");
        return object != null ? object.toString() : super.toString();
    }

    public boolean isNetworkRetrievalEnabled() {
        return this.networkRetrievalEnabled;
    }

    public void setNetworkRetrievalEnabled(boolean bl) {
        this.networkRetrievalEnabled = bl;
    }

    public double getMissingDataSignal() {
        return this.missingDataFlag;
    }

    public void setMissingDataSignal(double d) {
        this.missingDataFlag = d;
    }

    public double getMissingDataReplacement() {
        return this.missingDataValue;
    }

    public void setMissingDataReplacement(double d) {
        this.missingDataValue = d;
    }

    public double getDetailHint(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return 0.0;
    }

    public double getElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.getUnmappedElevation(angle, angle2);
        return d == this.missingDataFlag ? this.missingDataValue : d;
    }

    public String getRestorableState() {
        return null;
    }

    public void restoreState(String string) {
        String string2 = Logging.getMessage("RestorableSupport.RestoreNotSupported");
        Logging.logger().severe(string2);
        throw new UnsupportedOperationException(string2);
    }
}

