/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.worldfile.WorldFile;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.terrain.AbstractElevationModel;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalElevationModel
extends AbstractElevationModel {
    protected double[] extremeElevations = null;
    protected CopyOnWriteArrayList<LocalTile> tiles = new CopyOnWriteArrayList();

    @Override
    public double getMinElevation() {
        return this.extremeElevations[0];
    }

    @Override
    public double getMaxElevation() {
        return this.extremeElevations[1];
    }

    @Override
    public double[] getExtremeElevations(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.tiles.size() == 0) {
            return new double[]{this.missingDataValue, this.missingDataValue};
        }
        double d = Double.MAX_VALUE;
        double d2 = -d;
        for (LocalTile localTile : this.tiles) {
            if (!localTile.sector.contains(angle, angle2)) continue;
            if (localTile.minElevation < d) {
                d = localTile.minElevation;
            }
            if (!(localTile.maxElevation > d2)) continue;
            d2 = localTile.maxElevation;
        }
        return new double[]{d != Double.MAX_VALUE ? d : this.missingDataValue, d2 != -1.7976931348623157E308 ? d2 : this.missingDataValue};
    }

    @Override
    public double[] getExtremeElevations(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.tiles.size() == 0) {
            return new double[]{this.missingDataValue, this.missingDataValue};
        }
        double d = Double.MAX_VALUE;
        double d2 = -d;
        for (LocalTile localTile : this.tiles) {
            if (!localTile.sector.intersects(sector)) continue;
            if (localTile.minElevation < d) {
                d = localTile.minElevation;
            }
            if (!(localTile.maxElevation > d2)) continue;
            d2 = localTile.maxElevation;
        }
        return new double[]{d != Double.MAX_VALUE ? d : this.missingDataValue, d2 != -1.7976931348623157E308 ? d2 : this.missingDataValue};
    }

    @Override
    public double getBestResolution(Sector sector) {
        double d = Double.MAX_VALUE;
        for (LocalTile localTile : this.tiles) {
            double d2;
            if (!sector.intersects(localTile.sector) || !((d2 = localTile.sector.getDeltaLatRadians() / (double)localTile.tileHeight) < d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public double getUnmappedElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.lookupElevation(angle.radians, angle2.radians);
    }

    @Override
    public double getElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LatLonListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ElevationsBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length < list.size()) {
            String string = Logging.getMessage("ElevationModel.ElevationsBufferTooSmall", list.size());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < list.size(); ++i) {
            double d2;
            LatLon latLon = list.get(i);
            if (latLon == null || (d2 = this.lookupElevation(latLon.getLatitude().radians, latLon.getLongitude().radians)) == this.missingDataFlag) continue;
            dArray[i] = d2;
        }
        return this.getBestResolution(sector);
    }

    public void addElevations(String string, Sector sector, int n, int n2) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = Logging.getMessage("generic.FileNotFound", file.getPath());
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (sector == null) {
            String string4 = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string4);
            throw new IllegalStateException(string4);
        }
        try {
            Double d;
            Object object;
            File[] fileArray = WorldFile.getWorldFiles(file);
            AVList aVList = WorldFile.decodeWorldFiles(fileArray, null);
            Object object2 = aVList.getValue("gov.nasa.worldwind.avkey.PixelType");
            if (object2 == null) {
                object2 = "gov.nasa.worldwind.avkey.Int16";
            }
            if ((object = aVList.getValue("gov.nasa.worldwind.avkey.ByteOrder")) == null) {
                object = "gov.nasa.worldwind.avkey.LittleEndian";
            }
            if ((d = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.avkey.MissingDataValue")) == null) {
                d = this.getMissingDataSignal();
            }
            AVListImpl aVListImpl = new AVListImpl();
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DataType", object2);
            aVListImpl.setValue("gov.nasa.worldwind.avkey.ByteOrder", object);
            ByteBuffer byteBuffer = WWIO.readFileToBuffer(file);
            BufferWrapper bufferWrapper = BufferWrapper.wrap(byteBuffer, aVListImpl);
            LocalTile localTile = new LocalTile(sector, d, n, n2, bufferWrapper);
            this.tiles.add(localTile);
            this.adjustMinMax(localTile);
        }
        catch (IOException iOException) {
            String string5 = Logging.getMessage("ElevationModel.ExceptionReadingElevationFile", string);
            Logging.logger().severe(string5);
            throw iOException;
        }
    }

    public void addElevations(String string) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = Logging.getMessage("generic.FileNotFound", file.getPath());
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = WWIO.getSuffix(string);
        if (string4 == null) {
            return;
        }
        this.addElevationsFromWorldFiles(string);
    }

    protected void addElevationsFromWorldFiles(String string) throws IOException {
        Sector sector;
        int[] nArray;
        try {
            File[] fileArray = WorldFile.getWorldFiles(new File(string));
            if (fileArray == null || fileArray.length == 0) {
                String string2 = Logging.getMessage("WorldFile.WorldFileNotFound", string);
                Logging.logger().severe(string2);
                throw new FileNotFoundException(string2);
            }
            AVList aVList = WorldFile.decodeWorldFiles(fileArray, null);
            nArray = (int[])aVList.getValue("gov.nasa.worldwind.worldFile.ImageSize");
            if (nArray == null) {
                String string3 = Logging.getMessage("WorldFile.NoSizeSpecified", string);
                throw new WWRuntimeException(string3);
            }
            sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
            if (sector == null) {
                String string4 = Logging.getMessage("WorldFile.NoSectorSpecified", string);
                throw new WWRuntimeException(string4);
            }
        }
        catch (IOException iOException) {
            String string5 = Logging.getMessage("ElevationModel.ExceptionReadingElevationFile", string);
            Logging.logger().severe(string5);
            throw iOException;
        }
        this.addElevations(string, sector, nArray[0], nArray[1]);
    }

    @Override
    public int intersects(Sector sector) {
        boolean bl = false;
        for (LocalTile localTile : this.tiles) {
            if (localTile.sector.contains(sector)) {
                return 0;
            }
            if (!localTile.sector.intersects(sector)) continue;
            bl = true;
        }
        return bl ? 1 : -1;
    }

    @Override
    public boolean contains(Angle angle, Angle angle2) {
        for (LocalTile localTile : this.tiles) {
            if (!localTile.sector.contains(angle, angle2)) continue;
            return true;
        }
        return false;
    }

    protected void adjustMinMax(LocalTile localTile) {
        if (this.extremeElevations == null && localTile != null) {
            this.extremeElevations = new double[]{localTile.minElevation, localTile.maxElevation};
        } else if (localTile != null) {
            if (localTile.minElevation < this.extremeElevations[0]) {
                this.extremeElevations[0] = localTile.minElevation;
            }
            if (localTile.maxElevation > this.extremeElevations[1]) {
                this.extremeElevations[1] = localTile.maxElevation;
            }
        } else {
            double d = Double.MAX_VALUE;
            double d2 = -d;
            for (LocalTile localTile2 : this.tiles) {
                if (localTile2.minElevation < d) {
                    d = localTile2.minElevation;
                }
                if (!(localTile2.maxElevation > d2)) continue;
                d2 = localTile2.maxElevation;
            }
            this.extremeElevations = new double[]{d != Double.MAX_VALUE ? d : 0.0, d2 != -1.7976931348623157E308 ? d2 : 0.0};
        }
    }

    protected double lookupElevation(double d, double d2) {
        double d3;
        LocalTile localTile = this.findTile(d, d2);
        if (localTile == null) {
            return this.missingDataFlag;
        }
        double d4 = localTile.sector.getDeltaLat().radians;
        double d5 = localTile.sector.getDeltaLon().radians;
        double d6 = localTile.sector.getMaxLatitude().radians - d;
        double d7 = d2 - localTile.sector.getMinLongitude().radians;
        double d8 = d6 / d4;
        double d9 = d7 / d5;
        int n = (int)((double)(localTile.tileHeight - 1) * d8);
        int n2 = (int)((double)(localTile.tileWidth - 1) * d9);
        int n3 = n * localTile.tileWidth + n2;
        double d10 = localTile.elevations.getDouble(n3);
        double d11 = d3 = n2 < localTile.tileWidth - 1 ? localTile.elevations.getDouble(n3 + 1) : d10;
        if (localTile.missingDataFlag == d10 || localTile.missingDataFlag == d3) {
            return this.missingDataFlag;
        }
        double d12 = d5 / (double)(localTile.tileWidth - 1);
        double d13 = d4 / (double)(localTile.tileHeight - 1);
        double d14 = (d7 - (double)n2 * d12) / d12;
        double d15 = (d6 - (double)n * d13) / d13;
        double d16 = d10 + d14 * (d3 - d10);
        if (n < localTile.tileHeight - 1 && n2 < localTile.tileWidth - 1) {
            d10 = localTile.elevations.getDouble(n3 + localTile.tileWidth);
            d3 = localTile.elevations.getDouble(n3 + localTile.tileWidth + 1);
            if (localTile.missingDataFlag == d10 || localTile.missingDataFlag == d3) {
                return this.missingDataFlag;
            }
        }
        double d17 = d10 + d14 * (d3 - d10);
        return d16 + d15 * (d17 - d16);
    }

    protected LocalTile findTile(double d, double d2) {
        for (LocalTile localTile : this.tiles) {
            if (!localTile.sector.containsRadians(d, d2)) continue;
            return localTile;
        }
        return null;
    }

    protected static class LocalTile {
        protected final Sector sector;
        protected final int tileWidth;
        protected final int tileHeight;
        protected final double minElevation;
        protected final double maxElevation;
        protected final double missingDataFlag;
        protected final BufferWrapper elevations;

        protected LocalTile(Sector sector, double d, int n, int n2, BufferWrapper bufferWrapper) {
            this.sector = sector;
            this.tileWidth = n;
            this.tileHeight = n2;
            this.missingDataFlag = d;
            this.elevations = bufferWrapper;
            int n3 = this.elevations.length();
            if (n3 != 0) {
                double d2 = Double.MAX_VALUE;
                double d3 = -d2;
                for (int i = 0; i < n3; ++i) {
                    double d4 = this.elevations.getDouble(i);
                    if (d4 == this.missingDataFlag) continue;
                    if (d4 < d2) {
                        d2 = d4;
                    }
                    if (!(d4 > d3)) continue;
                    d3 = d4;
                }
                this.minElevation = d2;
                this.maxElevation = d3;
            } else {
                this.minElevation = 0.0;
                this.maxElevation = 0.0;
            }
        }
    }
}

