/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.terrain.BasicElevationModel;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileUrlBuilder;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwind.wms.BoundingBox;
import gov.nasa.worldwind.wms.Capabilities;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.xpath.XPath;
import org.w3c.dom.Element;

public class WMSBasicElevationModel
extends BasicElevationModel {
    protected static final String[] formatOrderPreference = new String[]{"image/bil", "image/png", "image/tiff", "image/bil"};

    public WMSBasicElevationModel(Capabilities capabilities, AVList aVList) {
        super(WMSBasicElevationModel.initParamsFromCapsDoc(capabilities, aVList));
        this.setName(WMSBasicElevationModel.makeTitle(capabilities, aVList.getStringValue("gov.nasa.worldwind.avkey.LayerNames"), aVList.getStringValue("gov.nasa.worldwind.avkey.StyleNames")));
    }

    public WMSBasicElevationModel(Element element, AVList aVList) {
        super(element, WMSBasicElevationModel.initParamsFromConfiguration(element, aVList));
    }

    public WMSBasicElevationModel(String string) {
        super(string);
        RestorableSupport restorableSupport;
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string2 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    protected static AVList initParamsFromConfiguration(Element element, AVList aVList) {
        String string;
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        XPath xPath = WWXML.makeXPath();
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.WMSVersion", "Service/@version", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.LayerNames", "Service/LayerNames", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.StyleNames", "Service/StyleNames", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.GetMapURL", "Service/GetMapURL", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.GetCapabilitiesURL", "Service/GetCapabilitiesURL", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.ImageFormat", "ImageFormat", xPath);
        aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", aVList.getValue("gov.nasa.worldwind.avkey.GetMapURL"));
        String string3 = aVList.getStringValue("gov.nasa.worldwind.avkey.ServiceURLKey");
        if (string3 != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", WWXML.fixGetMapString(string3));
        }
        if ((string = aVList.getStringValue("gov.nasa.worldwind.avkey.LayerNames")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string);
        }
        aVList.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder(aVList.getStringValue("gov.nasa.worldwind.avkey.WMSVersion"), aVList));
        return aVList;
    }

    protected static AVList initParamsFromCapsDoc(Capabilities capabilities, AVList aVList) {
        Object uRISyntaxException;
        String string2;
        if (capabilities == null) {
            String string2 = Logging.getMessage("nullValue.WMSCapabilities");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (aVList == null) {
            String string3 = Logging.getMessage("nullValue.ElevationModelConfigParams");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = aVList.getStringValue("gov.nasa.worldwind.avkey.LayerNames");
        if (string4 == null || string4.length() == 0) {
            String string5 = Logging.getMessage("nullValue.WMSLayerNames");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        String[] stringArray = string4.split(",");
        if (stringArray == null || stringArray.length == 0) {
            String string6 = Logging.getMessage("nullValue.WMSLayerNames");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        for (String string2 : stringArray) {
            if (capabilities.getLayerByName(string2) != null) continue;
            String string9 = Logging.getMessage("WMS.LayerNameMissing", string2);
            Logging.logger().severe(string9);
            throw new IllegalArgumentException(string9);
        }
        aVList.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string4);
        Long l = capabilities.getLayerLatestLastUpdateTime(capabilities, stringArray);
        if (l != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ExpiryTime", l);
        }
        Double[] doubleArray = capabilities.getLayerExtremeElevations(capabilities, stringArray);
        Double d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.ElevationMinKey");
        if (d == null && doubleArray != null && doubleArray[0] != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", doubleArray[0]);
        }
        if (d == null && doubleArray != null && doubleArray[1] != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", doubleArray[1]);
        }
        string2 = capabilities.getGetMapRequestGetURL();
        string2 = WWXML.fixGetMapString(string2);
        if (aVList.getValue("gov.nasa.worldwind.avkey.ServiceURLKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", string2);
        }
        if ((string2 = aVList.getStringValue("gov.nasa.worldwind.avkey.ServiceURLKey")) == null || string2.length() == 0) {
            Logging.logger().severe("WMS.RequestMapURLMissing");
            throw new IllegalArgumentException(Logging.getMessage("WMS.RequestMapURLMissing"));
        }
        String string3 = aVList.getStringValue("gov.nasa.worldwind.avkey.StyleNames");
        if (aVList.getValue("gov.nasa.worldwind.avkey.DataCacheNameKey") == null) {
            try {
                uRISyntaxException = new URI(string2);
                String string10 = WWIO.formPath(((URI)uRISyntaxException).getAuthority(), ((URI)uRISyntaxException).getPath(), string4, string3);
                aVList.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", string10);
            }
            catch (URISyntaxException uRISyntaxException2) {
                String string5 = Logging.getMessage("WMS.RequestMapURLBad", string2);
                Logging.logger().severe(string5);
                throw new IllegalArgumentException(string5);
            }
        }
        if (aVList.getStringValue("gov.nasa.worldwind.avkey.ImageFormat") == null) {
            uRISyntaxException = WMSBasicElevationModel.chooseImageFormat(capabilities);
            aVList.setValue("gov.nasa.worldwind.avkey.ImageFormat", uRISyntaxException);
        }
        if (aVList.getStringValue("gov.nasa.worldwind.avkey.ImageFormat") == null) {
            Logging.logger().severe("WMS.NoImageFormats");
            throw new IllegalArgumentException(Logging.getMessage("WMS.NoImageFormats"));
        }
        uRISyntaxException = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        if (uRISyntaxException == null) {
            for (String string6 : stringArray) {
                BoundingBox boundingBox = capabilities.getLayerGeographicBoundingBox(capabilities.getLayerByName(string6));
                if (boundingBox == null) {
                    Logging.logger().log(Level.SEVERE, "WMS.NoGeographicBoundingBoxForLayer", string6);
                    continue;
                }
                uRISyntaxException = Sector.union((Sector)uRISyntaxException, Sector.fromDegrees(WWMath.clamp(boundingBox.getMiny(), -90.0, 90.0), WWMath.clamp(boundingBox.getMaxy(), -90.0, 90.0), WWMath.clamp(boundingBox.getMinx(), -180.0, 180.0), WWMath.clamp(boundingBox.getMaxx(), -180.0, 180.0)));
            }
            if (uRISyntaxException == null) {
                Logging.logger().severe("WMS.NoGeographicBoundingBox");
                throw new IllegalArgumentException(Logging.getMessage("WMS.NoGeographicBoundingBox"));
            }
            aVList.setValue("gov.nasa.worldwind.avKey.Sector", uRISyntaxException);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta") == null) {
            Angle angle = Angle.fromDegrees(20.0);
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(angle, angle));
        }
        aVList.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder(capabilities.getVersion(), aVList));
        return aVList;
    }

    protected static String makeTitle(Capabilities capabilities, String string, String string2) {
        String[] stringArray = string.split(",");
        String[] stringArray2 = string2 != null ? string2.split(",") : null;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            Element element;
            String string4;
            Element element2;
            String string5;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append((string5 = capabilities.getLayerTitle(element2 = capabilities.getLayerByName(string4 = stringArray[i]))) != null ? string5 : string4);
            if (stringArray2 == null || stringArray2.length <= i || (element = capabilities.getLayerStyleByName(element2, string3 = stringArray2[i])) == null) continue;
            stringBuilder.append(" : ");
            String string6 = capabilities.getStyleTitle(element2, element);
            stringBuilder.append(string6 != null ? string6 : string3);
        }
        return stringBuilder.toString();
    }

    protected static String chooseImageFormat(Capabilities capabilities) {
        String[] stringArray = capabilities.getGetMapFormats();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        for (String string : formatOrderPreference) {
            for (String string2 : stringArray) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return string2;
            }
        }
        return stringArray[0];
    }

    protected void doGetRestorableStateForAVPair(String string, Object object, RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (object instanceof URLBuilder) {
            restorableSupport.addStateValueAsString(stateObject, "wms.Version", ((URLBuilder)object).wmsVersion);
            restorableSupport.addStateValueAsString(stateObject, "wms.Crs", ((URLBuilder)object).crs);
        } else {
            super.doGetRestorableStateForAVPair(string, object, restorableSupport, stateObject);
        }
    }

    protected static AVList wmsXmlStateToParams(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        AVListImpl aVListImpl = new AVListImpl();
        WMSBasicElevationModel.restoreStateForParams(restorableSupport, null, aVListImpl);
        WMSBasicElevationModel.wmsRestoreStateForParams(restorableSupport, null, aVListImpl);
        return aVListImpl;
    }

    protected static void wmsRestoreStateForParams(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject, AVList aVList) {
        String string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.ImageFormat");
        if (string != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ImageFormat", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.Title")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.Title", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.LayerNames")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.LayerNames", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.StyleNames")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.StyleNames", string);
        }
        string = restorableSupport.getStateValueAsString(stateObject, "wms.Version");
        aVList.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder(string, aVList));
    }

    protected static class URLBuilder
    implements TileUrlBuilder {
        protected static final String MAX_VERSION = "1.3.0";
        private final String layerNames;
        private final String styleNames;
        private final String imageFormat;
        private final String wmsVersion;
        private final String crs;
        protected String URLTemplate = null;

        protected URLBuilder(String string, AVList aVList) {
            this.layerNames = aVList.getStringValue("gov.nasa.worldwind.avkey.LayerNames");
            this.styleNames = aVList.getStringValue("gov.nasa.worldwind.avkey.StyleNames");
            this.imageFormat = aVList.getStringValue("gov.nasa.worldwind.avkey.ImageFormat");
            if (string == null || string.compareTo(MAX_VERSION) >= 0) {
                this.wmsVersion = MAX_VERSION;
                this.crs = "&crs=EPSG:4326";
            } else {
                this.wmsVersion = string;
                this.crs = "&srs=EPSG:4326";
            }
        }

        public URL getURL(Tile tile, String string) throws MalformedURLException {
            StringBuffer stringBuffer;
            if (this.URLTemplate == null) {
                stringBuffer = new StringBuffer(tile.getLevel().getService());
                if (!stringBuffer.toString().toLowerCase().contains("service=wms")) {
                    stringBuffer.append("service=WMS");
                }
                stringBuffer.append("&request=GetMap");
                stringBuffer.append("&version=");
                stringBuffer.append(this.wmsVersion);
                stringBuffer.append(this.crs);
                stringBuffer.append("&layers=");
                stringBuffer.append(this.layerNames);
                stringBuffer.append("&styles=");
                stringBuffer.append(this.styleNames != null ? this.styleNames : "");
                stringBuffer.append("&width=");
                stringBuffer.append(tile.getLevel().getTileWidth());
                stringBuffer.append("&height=");
                stringBuffer.append(tile.getLevel().getTileHeight());
                stringBuffer.append("&format=");
                if (string == null) {
                    stringBuffer.append(this.imageFormat);
                } else {
                    stringBuffer.append(string);
                }
                this.URLTemplate = stringBuffer.toString();
            } else {
                stringBuffer = new StringBuffer(this.URLTemplate);
            }
            Sector sector = tile.getSector();
            stringBuffer.append("&bbox=");
            stringBuffer.append(sector.getMinLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMinLatitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLatitude().getDegrees());
            stringBuffer.append("&");
            return new URL(stringBuffer.toString().replace(" ", "%20"));
        }
    }
}

